/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.CompiledStatement;
import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.Select;
import com.insightful.miner.sql.Trace;

final class CompiledStatementExecutor {
    private Result updateResult = new Result(1);
    private Result emptyResult = new Result(1);

    CompiledStatementExecutor() {
    }

    Result execute(CompiledStatement cs) {
        Result result = null;
        try {
            result = this.executeImpl(cs);
        }
        catch (Throwable t) {
            result = new Result(t, cs.sql);
        }
        if (result == null) {
            result = this.emptyResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement cs) throws HsqlException {
        switch (cs.type) {
            case 5: {
                return this.executeSelectStatement(cs);
            }
            case 2: {
                return this.executeInsertSelectStatement(cs);
            }
            case 1: {
                return this.executeInsertValuesStatement(cs);
            }
            case 3: {
                return this.executeUpdateStatement(cs);
            }
            case 4: {
                return this.executeDeleteStatement(cs);
            }
            case 6: {
                return this.executeCallStatement(cs);
            }
            case 9: {
                return this.executeDDLStatement(cs);
            }
        }
        throw Trace.error(201);
    }

    private Result executeCallStatement(CompiledStatement cs) throws HsqlException {
        Expression e = cs.expression;
        Object o = e.getValue();
        if (o instanceof Result) {
            return (Result)o;
        }
        Result r = Result.newSingleColumnResult("@p0", e.getDataType());
        Object[] row = new Object[]{o};
        r.metaData.sClassName[0] = e.getValueClassName();
        r.add(row);
        return r;
    }

    private Result executeDeleteStatement(CompiledStatement cs) throws HsqlException {
        int count;
        this.updateResult.iUpdateCount = count = 0;
        return this.updateResult;
    }

    private Result executeInsertSelectStatement(CompiledStatement cs) throws HsqlException {
        int count;
        this.updateResult.iUpdateCount = count = 1;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement cs) throws HsqlException {
        this.updateResult.iUpdateCount = 1;
        return this.updateResult;
    }

    private Result executeSelectStatement(CompiledStatement cs) throws HsqlException {
        Select select = cs.select;
        Result result = null;
        return result;
    }

    private Result executeUpdateStatement(CompiledStatement cs) throws HsqlException {
        int count;
        this.updateResult.iUpdateCount = count = 0;
        return this.updateResult;
    }

    private Result executeDDLStatement(CompiledStatement cs) throws HsqlException {
        Result result = null;
        return result;
    }
}

