/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Record;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.lib.Iterator;
import java.util.NoSuchElementException;

public class Result {
    public Record rRoot;
    private Record rTail;
    private int iSize;
    private int significantColumns;
    public int iMode;
    int databaseID;
    int sessionID;
    String mainString;
    String subString;
    String subSubString;
    int statementID;
    int iUpdateCount;
    public ResultMetaData metaData;

    public Result(int type) {
        this.iMode = type;
        if (type == 3 || type == 5 || type == 65548 || type == 6) {
            this.metaData = new ResultMetaData();
        }
    }

    Result(ResultMetaData md) {
        this.iMode = 3;
        this.significantColumns = md.colType.length;
        this.metaData = md;
    }

    Result(String error, String state, int code) {
        this.iMode = 2;
        this.mainString = error;
        this.subString = state;
        this.statementID = code;
        this.subSubString = "";
    }

    Result(int type, int columns) {
        this.metaData = new ResultMetaData();
        this.metaData.prepareData(columns);
        if (type == 5) {
            this.metaData.isParameterDescription = true;
            this.metaData.paramMode = new int[columns];
        }
        this.iMode = type;
        this.significantColumns = columns;
    }

    public Result(int type, int[] types, int id) {
        this.iMode = type;
        this.metaData = new ResultMetaData();
        this.metaData.colType = types;
        this.significantColumns = types.length;
        this.statementID = id;
    }

    static Result newSingleColumnResult(String colName, int colType) {
        Result result = new Result(3, 1);
        result.metaData.sName[0] = colName;
        result.metaData.sLabel[0] = colName;
        result.metaData.sTable[0] = "";
        result.metaData.colType[0] = colType;
        return result;
    }

    static Result newPrepareResponse(int csid, Result rsmd, Result pmd) {
        Result out = new Result(0);
        Result pack = new Result(4);
        pack.statementID = csid;
        out.add(new Object[]{pack});
        out.add(new Object[]{rsmd});
        out.add(new Object[]{pmd});
        return out;
    }

    static Result newParameterDescriptionResult(int len) {
        Result r = new Result(5, len);
        r.metaData.isParameterDescription = true;
        r.metaData.paramMode = new int[len];
        return r;
    }

    public static Result newFreeStmtRequest(int statementID) {
        Result r = new Result(65552);
        r.statementID = statementID;
        return r;
    }

    static Result newExecuteDirectRequest(String sql) {
        Result out = new Result(65547);
        out.setMainString(sql);
        return out;
    }

    public static Result newReleaseSavepointRequest(String name) {
        Result out = new Result(66541);
        out.setMainString(name);
        out.setEndTranType(4);
        return out;
    }

    public static Result newRollbackToSavepointRequest(String name) {
        Result out = new Result(66541);
        out.setMainString(name);
        out.setEndTranType(2);
        return out;
    }

    public static Result newSetSavepointRequest(String name) {
        Result out = new Result(66552);
        out.setConnectionAttrType(10027);
        out.setMainString(name);
        return out;
    }

    public int getSize() {
        return this.iSize;
    }

    void setColumnCount(int columns) {
        this.significantColumns = columns;
    }

    public int getColumnCount() {
        return this.significantColumns;
    }

    void append(Result a) {
        if (this.rRoot == null) {
            this.rRoot = a.rRoot;
        } else {
            this.rTail.next = a.rRoot;
        }
        this.rTail = a.rTail;
        this.iSize += a.iSize;
    }

    void addAll(Result r) {
        if (r == null) {
            return;
        }
        Record from = r.rRoot;
        while (from != null) {
            this.add(from.data);
            from = from.next;
        }
    }

    public void clear() {
        this.rRoot = null;
        this.rTail = null;
        this.iSize = 0;
    }

    public boolean isEmpty() {
        return this.rRoot == null;
    }

    void setRows(Result a) {
        if (a == null) {
            this.rRoot = null;
            this.rTail = null;
            this.iSize = 0;
        } else {
            this.rRoot = a.rRoot;
            this.rTail = a.rTail;
            this.iSize = a.iSize;
        }
    }

    public void add(Object[] d) {
        Record r = new Record();
        r.data = d;
        if (this.rRoot == null) {
            this.rRoot = r;
        } else {
            this.rTail.next = r;
        }
        this.rTail = r;
        ++this.iSize;
    }

    void trimResult(int limitstart, int limitcount) {
        int i;
        Record n = this.rRoot;
        if (n == null) {
            return;
        }
        if (limitstart >= this.iSize) {
            this.iSize = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.iSize -= limitstart;
        for (i = 0; i < limitstart; ++i) {
            n = n.next;
            if (n != null) continue;
            this.iSize = 0;
            this.rRoot = this.rTail = n;
            return;
        }
        this.rRoot = n;
        if (limitcount == 0 || limitcount >= this.iSize) {
            return;
        }
        for (i = 1; i < limitcount; ++i) {
            n = n.next;
            if (n != null) continue;
            return;
        }
        this.iSize = limitcount;
        n.next = null;
        this.rTail = n;
    }

    void removeDuplicates() throws HsqlException {
        this.removeDuplicates(this.significantColumns);
    }

    void removeDuplicates(int columnCount) throws HsqlException {
        Record next;
        if (this.rRoot == null) {
            return;
        }
        int[] order = new int[columnCount];
        int[] way = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            order[i] = i;
            way[i] = 1;
        }
        this.sortResult(order, way);
        Record n = this.rRoot;
        while ((next = n.next) != null) {
            if (this.compareRecord(n.data, next.data, columnCount) == 0) {
                n.next = next.next;
                --this.iSize;
                continue;
            }
            n = next;
        }
        this.rTail = n;
    }

    void removeSecond(Result minus, int columnCount) throws HsqlException {
        this.removeDuplicates(columnCount);
        minus.removeDuplicates(columnCount);
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = minus.rRoot;
        int i = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(n.data, n2.data, columnCount);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = last = n.next;
                } else {
                    last.next = n.next;
                }
                n = n.next;
                --this.iSize;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            last = n;
            rootr = false;
            n = n.next;
        }
        while (n != null) {
            last = n;
            n = n.next;
        }
        this.rTail = last;
    }

    void removeDifferent(Result r2, int columnCount) throws HsqlException {
        this.removeDuplicates(columnCount);
        r2.removeDuplicates(columnCount);
        Record n = this.rRoot;
        Record last = this.rRoot;
        boolean rootr = true;
        Record n2 = r2.rRoot;
        int i = 0;
        this.iSize = 0;
        while (n != null && n2 != null) {
            i = this.compareRecord(n.data, n2.data, columnCount);
            if (i == 0) {
                if (rootr) {
                    this.rRoot = n;
                } else {
                    last.next = n;
                }
                rootr = false;
                last = n;
                n = n.next;
                n2 = n2.next;
                ++this.iSize;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            n = n.next;
        }
        if (rootr) {
            this.rRoot = null;
            last = null;
        } else {
            last.next = null;
        }
        this.rTail = last;
    }

    void sortResult(int[] order, int[] way) throws HsqlException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] target = new Record[2];
        Record[] targetlast = new Record[2];
        int dest = 0;
        Record n = this.rRoot;
        while (n != null) {
            Record next = n.next;
            n.next = target[dest];
            target[dest] = n;
            n = next;
            dest ^= 1;
        }
        int blocksize = 1;
        while (target[1] != null) {
            Record source0 = target[0];
            Record source1 = target[1];
            targetlast[1] = null;
            targetlast[0] = null;
            target[1] = null;
            target[0] = null;
            dest = 0;
            while (source0 != null) {
                int n0 = blocksize;
                int n1 = blocksize;
                while (true) {
                    if (n0 == 0 || source0 == null) {
                        if (n1 == 0 || source1 == null) break;
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else if (n1 == 0 || source1 == null) {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    } else if (this.compareRecord(source0.data, source1.data, order, way) > 0) {
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    }
                    if (target[dest] == null) {
                        target[dest] = n;
                    } else {
                        targetlast[dest].next = n;
                    }
                    targetlast[dest] = n;
                    n.next = null;
                }
                dest ^= 1;
            }
            blocksize <<= 1;
        }
        this.rRoot = target[0];
        this.rTail = targetlast[0];
    }

    private int compareRecord(Object[] a, Object[] b, int[] order, int[] way) throws HsqlException {
        int i = Column.compare(a[order[0]], b[order[0]], this.metaData.colType[order[0]]);
        if (i == 0) {
            for (int j = 1; j < order.length; ++j) {
                i = Column.compare(a[order[j]], b[order[j]], this.metaData.colType[order[j]]);
                if (i == 0) continue;
                return i * way[j];
            }
        }
        return i * way[0];
    }

    private int compareRecord(Object[] a, Object[] b, int len) throws HsqlException {
        for (int j = 0; j < len; ++j) {
            int i = Column.compare(a[j], b[j], this.metaData.colType[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public Result(Throwable t, String statement) {
        this.iMode = 2;
        if (t instanceof HsqlException) {
            HsqlException he = (HsqlException)t;
            this.subString = he.state;
            this.mainString = he.message;
            if (statement != null) {
                this.mainString = this.mainString + " in statement [" + statement + "]";
            }
            this.statementID = he.code;
        } else if (t instanceof Exception) {
            t.printStackTrace();
            this.subString = "S1000";
            this.mainString = Trace.getMessage(40) + " " + t;
            if (statement != null) {
                this.mainString = this.mainString + " in statement [" + statement + "]";
            }
            this.statementID = 40;
        } else if (t instanceof OutOfMemoryError) {
            System.gc();
            t.printStackTrace();
            this.subString = "S1000";
            this.mainString = "out of memory";
            this.statementID = 72;
        }
        this.subSubString = "";
    }

    public int getStatementID() {
        return this.statementID;
    }

    void setStatementID(int id) {
        this.statementID = id;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String sql) {
        this.mainString = sql;
    }

    public String getSubString() {
        return this.subString;
    }

    public void setMaxRows(int count) {
        this.iUpdateCount = count;
    }

    public int getUpdateCount() {
        return this.iUpdateCount;
    }

    int getConnectionAttrType() {
        return this.iUpdateCount;
    }

    void setConnectionAttrType(int type) {
        this.iUpdateCount = type;
    }

    int getEndTranType() {
        return this.iUpdateCount;
    }

    void setEndTranType(int type) {
        this.iUpdateCount = type;
    }

    public int[] getUpdateCounts() {
        return this.metaData.colType;
    }

    Object[] getParameterData() {
        return this.rRoot == null ? null : this.rRoot.data;
    }

    public void setParameterData(Object[] data) {
        if (this.rRoot == null) {
            this.rRoot = new Record();
        }
        this.rRoot.data = data;
        this.rRoot.next = null;
        this.rTail = this.rRoot;
        this.iSize = 1;
    }

    public void setResultType(int type) {
        this.iMode = type;
    }

    public void setStatementType(int type) {
        this.iUpdateCount = type;
    }

    public int getStatementType() {
        return this.iUpdateCount;
    }

    public Iterator iterator() {
        return new ResultIterator();
    }

    private class ResultIterator
    implements Iterator {
        boolean removed;
        int counter;
        Record current;
        Record last;

        private ResultIterator() {
            this.current = Result.this.rRoot;
        }

        public boolean hasNext() {
            return this.counter < Result.this.iSize;
        }

        public Object next() {
            if (this.hasNext()) {
                this.removed = false;
                if (this.counter != 0) {
                    this.last = this.current;
                    this.current = this.current.next;
                }
                ++this.counter;
                return this.current.data;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.counter <= Result.this.iSize && this.counter != 0 && !this.removed) {
                this.removed = true;
                if (this.current == Result.this.rTail) {
                    Result.this.rTail = this.last;
                }
                if (this.current == Result.this.rRoot) {
                    this.current = Result.this.rRoot = Result.this.rRoot.next;
                } else {
                    this.current = this.last;
                    this.last = null;
                    this.current.next = this.current.next.next;
                }
                Result.this.iSize--;
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static class ResultMetaData {
        public String[] sLabel;
        public String[] sTable;
        public String[] sName;
        public boolean[] isLabelQuoted;
        public int[] colType;
        public int[] colSize;
        public int[] colScale;
        public String[] sCatalog;
        public String[] sSchema;
        public int[] nullability;
        public boolean[] isIdentity;
        public boolean[] isWritable;
        public int[] paramMode;
        public String[] sClassName;
        boolean isParameterDescription;

        ResultMetaData() {
        }

        ResultMetaData(int n) {
            this.prepareData(n);
        }

        private void prepareData(int columns) {
            this.sLabel = new String[columns];
            this.sTable = new String[columns];
            this.sName = new String[columns];
            this.isLabelQuoted = new boolean[columns];
            this.colType = new int[columns];
            this.colSize = new int[columns];
            this.colScale = new int[columns];
            this.sCatalog = new String[columns];
            this.sSchema = new String[columns];
            this.nullability = new int[columns];
            this.isIdentity = new boolean[columns];
            this.isWritable = new boolean[columns];
            this.sClassName = new String[columns];
        }

        public int[] getParameterTypes() {
            return this.colType;
        }

        boolean isTableColumn(int i) {
            return this.sTable[i] != null && this.sTable[i].length() > 0 && this.sName[i] != null && this.sName[i].length() > 0;
        }

        private void decodeTableColumnAttrs(int in, int i) {
            this.nullability[i] = in & 0xF;
            this.isIdentity[i] = (in & 0x10) != 0;
            this.isWritable[i] = (in & 0x20) != 0;
        }

        private int encodeTableColumnAttrs(int i) {
            int out = this.nullability[i];
            if (this.isIdentity[i]) {
                out |= 0x10;
            }
            if (this.isWritable[i]) {
                out |= 0x20;
            }
            return out;
        }
    }
}

