/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.tree.gui.ClassificationTreeGUI;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.gui.InsVarDevianceChartPanel;
import com.insightful.miner.tree.model.TreeCollection;
import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.HorizontalCategoryPlot;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StackedHorizontalBarRenderer;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultCategoryDataset;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class TreeVariableDevianceFrame
extends ModifiableViewerFrame {
    private TreeCollection treeCollection = null;
    private String nodeName = null;
    private double maxDev = 0.0;
    public static final int FRAME_WIDTH = 650;
    public static final int FRAME_HEIGHT = 400;
    private int[] columnIndices = null;
    private InsVarDevianceChartPanel deviancePanel = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    private JMenuItem fileMenuSave = new JMenuItem();

    public TreeVariableDevianceFrame(String name, TreeCollection tc) {
        this.treeCollection = tc;
        this.nodeName = name == null ? "" : name;
        this.columnIndices = new int[this.treeCollection.getNumberColumns() - 1];
        int count = 0;
        for (int i = 0; i < this.columnIndices.length; ++i) {
            if (i == this.treeCollection.getDependentVarIndex()) {
                ++count;
            }
            this.columnIndices[i] = i + count;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Variable Comparison  -  " + this.nodeName);
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel backgroundPanel = new JPanel();
        backgroundPanel.setLayout(new BorderLayout());
        String filemenu = ClassificationTreeGUI.getText("treevis_gui_filemenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = ClassificationTreeGUI.getText("treevis_gui_fileclose");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(69);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeVariableDevianceFrame.this.setVisible(false);
            }
        });
        String fileprint = ClassificationTreeGUI.getText("treevisdevframe_gui_fileprint");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeVariableDevianceFrame.this.deviancePanel.print();
            }
        });
        String fileprintpreview = ClassificationTreeGUI.getText("treevis_gui_fileprintpreview");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeVariableDevianceFrame.this.deviancePanel.printPreview();
            }
        });
        String filesave = ClassificationTreeGUI.getText("treevisdevframe_gui_filesave");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeVariableDevianceFrame.this.deviancePanel.saveAs();
            }
        });
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuExit);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        double[][] devVals = this.orderByDev(this.treeCollection.getVarDevVals());
        this.getMaxDeviance(devVals);
        HashMap<Integer, Integer> mp = new HashMap<Integer, Integer>();
        for (int i = 0; i < devVals.length; ++i) {
            for (int j = 0; j < devVals[i].length; ++j) {
                Integer integer = new Integer(j);
                if (!(devVals[i][j] > 0.0) || mp.get(integer) != null) continue;
                mp.put(integer, integer);
            }
        }
        Double[][] chartData = new Double[devVals.length][mp.size()];
        for (int i = 0; i < devVals.length; ++i) {
            for (int j = 0; j < chartData[i].length; ++j) {
                chartData[i][j] = new Double(devVals[i][j]);
            }
        }
        this.deviancePanel = this.createStackedBarChart(chartData);
        JScrollPane devianceScrollPane = new JScrollPane((Component)((Object)this.deviancePanel));
        backgroundPanel.add((Component)devianceScrollPane, "Center");
        this.getContentPane().add((Component)backgroundPanel, "Center");
        double introGapPercent = Math.min(1.0 / (double)this.columnIndices.length, 0.1);
        ((HorizontalCategoryPlot)this.deviancePanel.getChart().getPlot()).setIntroGapPercent(introGapPercent);
        backgroundPanel.registerKeyboardAction(new EscapeListener(this), KeyStroke.getKeyStroke("ESCAPE"), 2);
    }

    private void getMaxDeviance(double[][] devArray) {
        double tempmax = 0.0;
        for (int i = 0; i < this.treeCollection.getNumberColumns() - 1; ++i) {
            for (int j = 0; j < this.treeCollection.getNumberTrees(); ++j) {
                tempmax += devArray[j][i];
            }
            if (this.maxDev < tempmax) {
                this.maxDev = tempmax;
            }
            tempmax = 0.0;
        }
    }

    private double[][] orderByDev(double[][] devVals) {
        int i;
        int a;
        double[][] resultArray = new double[devVals.length][devVals[0].length];
        for (a = 0; a < devVals.length; ++a) {
            for (i = 0; i < devVals[a].length; ++i) {
                resultArray[a][i] = devVals[a][i];
            }
        }
        for (a = 0; a < resultArray[0].length - 1; ++a) {
            for (i = 0; i < resultArray[0].length - 1; ++i) {
                double total = 0.0;
                double nextItemTotal = 0.0;
                for (int j = 0; j < resultArray.length; ++j) {
                    total += resultArray[j][i];
                    nextItemTotal += resultArray[j][i + 1];
                }
                if (!(nextItemTotal > total)) continue;
                double temp = 0.0;
                int tempIndex = 0;
                for (int j = 0; j < resultArray.length; ++j) {
                    temp = resultArray[j][i];
                    resultArray[j][i] = resultArray[j][i + 1];
                    resultArray[j][i + 1] = temp;
                }
                tempIndex = this.columnIndices[i];
                this.columnIndices[i] = this.columnIndices[i + 1];
                this.columnIndices[i + 1] = tempIndex;
            }
        }
        return resultArray;
    }

    private InsVarDevianceChartPanel createStackedBarChart(Double[][] data) {
        DefaultCategoryDataset chartData = new DefaultCategoryDataset((Number[][])data);
        String[] treeNames = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            treeNames[i] = "Tree " + (i + 1);
        }
        chartData.setSeriesNames(treeNames);
        int numColumnsOfImport = data.length > 0 ? data[0].length : 0;
        Object[] list = new String[numColumnsOfImport];
        for (int i = 0; i < numColumnsOfImport; ++i) {
            list[i] = this.treeCollection.getColumnName(this.columnIndices[i]);
        }
        chartData.setCategories(list);
        String title = ClassificationTreeGUI.getText("treevisdevframe_gui_comparecols");
        String deviance = "";
        String crit = this.treeCollection.getCriterion();
        if (this.treeCollection.isRegression()) {
            deviance = ClassificationTreeGUI.getText("treevisdevframe_gui_sumsquarederror");
        } else if (this.treeCollection.miningSchema_attribute_entropy_value.equals(crit)) {
            deviance = ClassificationTreeGUI.getText("treevisdevframe_gui_entropy");
        } else if (this.treeCollection.miningSchema_attribute_gini_value.equals(crit)) {
            deviance = ClassificationTreeGUI.getText("treevisdevframe_gui_gini");
        } else {
            System.out.println("Error: unsupported tree type (" + crit + ").");
            deviance = ClassificationTreeGUI.getText("treevisdevframe_gui_deviance");
        }
        JFreeChart chart = null;
        double maxVal = this.maxDev;
        maxVal += maxVal * 0.25;
        try {
            VerticalCategoryAxis verticalAxis = new VerticalCategoryAxis("");
            HorizontalNumberAxis horizontalAxis = new HorizontalNumberAxis(deviance);
            horizontalAxis.setAxisRange(0.0, maxVal);
            StackedHorizontalBarRenderer renderer = new StackedHorizontalBarRenderer();
            HorizontalCategoryPlot plot = new HorizontalCategoryPlot((Axis)horizontalAxis, (Axis)verticalAxis, (CategoryItemRenderer)renderer);
            horizontalAxis.setAutoRange(false);
            horizontalAxis.setGridLinesVisible(true);
            Paint[] paints = new Paint[10];
            for (int i = 0; i < 10; ++i) {
                paints[i] = ColorBroker.getSeriesColor(i);
            }
            plot.setSeriesPaint(paints);
            plot.setInsets(new Insets(5, 2, 5, 10));
            if (treeNames.length > 100) {
                chart = new JFreeChart((Dataset)chartData, (Plot)plot, title, JFreeChart.DEFAULT_TITLE_FONT, false);
                chart.addTitle((AbstractTitle)new TextTitle("(" + treeNames.length + " " + ClassificationTreeGUI.getText("treevisdevframe_gui_nolegend") + ")"));
            } else {
                chart = new JFreeChart((Dataset)chartData, (Plot)plot, title, JFreeChart.DEFAULT_TITLE_FONT, true);
            }
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("TreeVariableDevianceFrame.createBarChart(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("TreeVariableDevianceFrame.createBarChart(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartLabelBackgroundColor"));
        InsVarDevianceChartPanel chartpanel = new InsVarDevianceChartPanel(this, this.treeCollection, chart);
        return chartpanel;
    }

    private class EscapeListener
    implements ActionListener {
        private JFrame m_frame;

        public EscapeListener(JFrame frame) {
            this.m_frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_frame.dispose();
        }
    }
}

