/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.util;

import com.insightful.miner.util.MersenneTwister;
import java.io.Serializable;

public class MersenneTwisterFast
implements Serializable {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private static final long GOOD_SEED = 4357L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;

    public MersenneTwisterFast() {
        this.setSeed(4357L);
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public final void setSeedOld(long seed) {
        this.haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mt[0] = (int)seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final void setSeed(int[] array) {
        this.mt = new int[624];
        System.arraycopy(array, 0, this.mt, 0, 624);
        this.mti = 624;
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final void setSeed(long seed) {
        int _seed = (int)seed;
        this.haveNextNextGaussian = false;
        this.mt = new int[624];
        int i = 0;
        while (i < 624) {
            this.mt[i] = _seed & 0xFFFF0000;
            _seed = 69069 * _seed + 1;
            int n = i++;
            this.mt[n] = this.mt[n] | (_seed & 0xFFFF0000) >>> 16;
            _seed = 69069 * _seed + 1;
        }
        this.mti = 624;
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final int nextInt() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public final short nextShort() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (short)(y >>> 16);
    }

    public final char nextChar() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (char)(y >>> 16);
    }

    public final boolean nextBoolean() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        return (y ^= y >>> 18) >>> 31 != 0;
    }

    public final boolean nextBoolean(float probability) {
        int y;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        return (float)((y ^= y >>> 18) >>> 8) / 1.6777216E7f < probability;
    }

    public final boolean nextBoolean(double probability) {
        int z;
        int y;
        int kk;
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
            }
            while (kk < 623) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
            this.mti = 0;
        }
        z = this.mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        return (double)(((long)(y >>> 6) << 27) + (long)((z ^= z >>> 18) >>> 5)) / 9.007199254740992E15 < probability;
    }

    public final byte nextByte() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (byte)(y >>> 24);
    }

    public final void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            int y;
            if (this.mti >= 624) {
                int kk;
                for (kk = 0; kk < 227; ++kk) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                }
                while (kk < 623) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                    ++kk;
                }
                y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
                this.mti = 0;
            }
            y = this.mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            bytes[x] = (byte)(y >>> 24);
        }
    }

    public final long nextLong() {
        int z;
        int y;
        int kk;
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
            }
            while (kk < 623) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
            this.mti = 0;
        }
        z = this.mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return ((long)y << 32) + (long)z;
    }

    public final double nextDouble() {
        int z;
        int y;
        int kk;
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            for (kk = 0; kk < 227; ++kk) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
            }
            while (kk < 623) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
            this.mti = 0;
        }
        z = this.mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15;
    }

    public final double nextGaussian() {
        int b;
        int a;
        double v2;
        int z;
        int y;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        do {
            int kk;
            if (this.mti >= 624) {
                for (kk = 0; kk < 227; ++kk) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                }
                while (kk < 623) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                    ++kk;
                }
                y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
                this.mti = 0;
            }
            y = this.mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            if (this.mti >= 624) {
                for (kk = 0; kk < 227; ++kk) {
                    z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
                }
                while (kk < 623) {
                    z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                    ++kk;
                }
                z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
                this.mti = 0;
            }
            z = this.mt[this.mti++];
            z ^= z >>> 11;
            z ^= z << 7 & 0x9D2C5680;
            z ^= z << 15 & 0xEFC60000;
            z ^= z >>> 18;
            if (this.mti >= 624) {
                for (kk = 0; kk < 227; ++kk) {
                    a = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ a >>> 1 ^ this.mag01[a & 1];
                }
                while (kk < 623) {
                    a = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ a >>> 1 ^ this.mag01[a & 1];
                    ++kk;
                }
                a = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ a >>> 1 ^ this.mag01[a & 1];
                this.mti = 0;
            }
            a = this.mt[this.mti++];
            a ^= a >>> 11;
            a ^= a << 7 & 0x9D2C5680;
            a ^= a << 15 & 0xEFC60000;
            a ^= a >>> 18;
            if (this.mti >= 624) {
                for (kk = 0; kk < 227; ++kk) {
                    b = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ b >>> 1 ^ this.mag01[b & 1];
                }
                while (kk < 623) {
                    b = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ b >>> 1 ^ this.mag01[b & 1];
                    ++kk;
                }
                b = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ b >>> 1 ^ this.mag01[b & 1];
                this.mti = 0;
            }
            b = this.mt[this.mti++];
            b ^= b >>> 11;
            b ^= b << 7 & 0x9D2C5680;
            b ^= b << 15 & 0xEFC60000;
        } while ((s = (v1 = 2.0 * ((double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = 2.0 * ((double)(((long)(a >>> 6) << 27) + (long)((b ^= b >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public final float nextFloat() {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f;
    }

    public final int nextInt(int n) {
        int val;
        int y;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            int y2;
            if (this.mti >= 624) {
                int kk;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                    ++kk;
                }
                y2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y2 >>> 1 ^ this.mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            return (int)((long)n * (long)(y2 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int kk;
                for (kk = 0; kk < 227; ++kk) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                }
                while (kk < 623) {
                    y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                    this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                    ++kk;
                }
                y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
                this.mti = 0;
            }
            y = this.mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
        } while ((bits = (y ^= y >>> 18) >>> 1) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    public static void main(String[] args) {
        int j;
        System.out.println("\nGrab the first 1000 booleans");
        MersenneTwister r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(double)");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((double)j / 999.0) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(float)");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((float)j / 999.0f) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        byte[] bytes = new byte[1000];
        System.out.println("\nGrab the first 1000 bytes using nextBytes");
        r = new MersenneTwister();
        r.nextBytes(bytes);
        for (j = 0; j < 1000; ++j) {
            System.out.print(bytes[j] + " ");
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 bytes -- must be same as nextBytes");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            byte b = r.nextByte();
            System.out.print(b + " ");
            if (b != bytes[j]) {
                System.out.print("BAD ");
            }
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 shorts");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextShort() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints of different sizes");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt(j + 1) + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextLong() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 floats");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextFloat() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 doubles");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextDouble() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 gaussian doubles");
        r = new MersenneTwister();
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextGaussian() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
    }
}

