/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class BDLSampleEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private XTMetaData m_md = null;
    private boolean m_replacement = false;
    private long m_sampleSize = -1L;
    private double m_randomNum = 0.0;
    private long m_randomSeed = 0L;
    private double m_runningSampleCount = 0.0;
    private double m_runningProbCount = 1.0;
    private long m_leftoverRows = 0L;
    private boolean m_onlyOnce = true;
    private double m_equalProbs = Double.NaN;
    public static String REPLACEMENT_ATTRIBUTE_TAG = "repl";
    public static String SIZE_ATTRIBUTE_TAG = "size";
    public static String RANDOM_ATTRIBUTE_TAG = "random";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        XTProps props = this.getNodeProperties();
        this.m_replacement = props.getBoolean(REPLACEMENT_ATTRIBUTE_TAG, false);
        this.m_sampleSize = Long.parseLong(props.getValue(SIZE_ATTRIBUTE_TAG, "-1"));
        this.m_randomNum = props.getDouble(RANDOM_ATTRIBUTE_TAG, this.getRandomGenerator().nextDouble());
        if (this.m_sampleSize == -1L) {
            this.m_sampleSize = this.getInputMetaData(0).getNumRows();
        }
        this.m_randomSeed = this.getRandomGenerator().nextLong();
        this.m_onlyOnce = true;
        XTMetaData md = this.getInputMetaData(0);
        if (md.getNumColumns() == 1) {
            this.m_equalProbs = 1.0 / (double)md.getNumRows();
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        if (this.m_replacement) {
            if (this.m_onlyOnce) {
                String cnkmisc_file = CNKProc.getLibraryFileName("cnkmisc");
                Runtime.getRuntime().load(cnkmisc_file);
                this.m_onlyOnce = false;
            }
            this.executeReplacement(proc);
        } else {
            this.executeNonReplacement(proc);
        }
    }

    public void executeNonReplacement(CNKProcJavaTransform proc) {
        int outputSize = proc.getChunkOutputRows(0);
        int chunkSize = proc.getChunkInputRows(0);
        int inputRow = 0;
        int outputRow = 0;
        double[] p = Double.isNaN(this.m_equalProbs) ? proc.getChunkInputColumnDoubles(0, 1) : null;
        double runningTotal = 1.0 - this.m_runningProbCount;
        double sampleSize = this.m_sampleSize;
        for (inputRow = 0; inputRow < chunkSize; ++inputRow) {
            if (!((runningTotal += p == null ? this.m_equalProbs : p[inputRow]) > this.m_randomNum)) continue;
            proc.copyColumnData(0, 0, outputRow++, 0, 0, inputRow, 1);
            this.m_randomNum += 1.0 / sampleSize;
        }
        this.m_runningProbCount = 1.0 - runningTotal;
        proc.setChunkOutputReleaseRows(0, outputRow);
    }

    public void executeReplacement(CNKProcJavaTransform proc) {
        double[] p;
        int rowsPerBlock = this.getMaxRowsPerBlock();
        int outputSize = proc.getChunkOutputRows(0);
        int chunkSize = proc.getChunkInputRows(0);
        int inputRow = 0;
        int outputRow = 0;
        double[] dArray = p = Double.isNaN(this.m_equalProbs) ? proc.getChunkInputColumnDoubles(0, 1) : null;
        if (this.m_leftoverRows != 0L) {
            int j = 0;
            while (outputRow < outputSize && (long)j < this.m_leftoverRows) {
                proc.copyColumnData(0, 0, outputRow++, 0, 0, inputRow, 1);
                ++j;
            }
            this.m_leftoverRows -= (long)outputRow;
            this.m_runningSampleCount += (double)outputRow;
            if (this.m_leftoverRows > 0L) {
                proc.setChunkOutputReleaseRows(0, outputRow);
                proc.setChunkInputReleaseRows(0, 0);
                return;
            }
            inputRow = 1;
        }
        while (outputRow < outputSize && inputRow < chunkSize) {
            double prob = p == null ? this.m_equalProbs : p[inputRow];
            long select = (long)BDLSampleEngineNode.getRBinom((double)this.m_sampleSize - this.m_runningSampleCount, prob / this.m_runningProbCount, this.m_randomSeed);
            if (select + (long)outputRow > (long)outputSize) {
                this.m_leftoverRows = select + (long)outputRow - (long)outputSize;
                select = outputSize - outputRow;
            } else {
                this.m_leftoverRows = 0L;
            }
            int j = 0;
            while ((long)j < select) {
                proc.copyColumnData(0, 0, outputRow++, 0, 0, inputRow, 1);
                ++j;
            }
            this.m_runningProbCount -= prob;
            this.m_runningSampleCount += (double)select;
            if (this.m_leftoverRows != 0L) break;
            ++inputRow;
        }
        if (this.m_leftoverRows != 0L) {
            proc.setChunkOutputReleaseRows(0, outputRow);
            proc.setChunkInputReleaseRows(0, inputRow);
            return;
        }
        proc.setChunkOutputReleaseRows(0, outputRow);
        proc.setChunkInputReleaseRows(0, inputRow);
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = this.getInputMetaData(0);
        Vector<String> outputNames = new Vector<String>();
        outputNames.add(md.ordinalToName(0));
        return md.selectiveClone(outputNames);
    }

    private static native double getRBinom(double var0, double var2, long var4);
}

