/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ChartDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane groupbyScrollPane;
    private NodeDialog.SortingScrollPane displayScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDList groupbyList;
    private NodeDialog.DNDList displayList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDListModel groupbyListModel;
    private NodeDialog.DNDListModel displayListModel;
    private JRadioButton histogramRadioButton;
    private JRadioButton boxplotRadioButton;
    private JRadioButton dotchartRadioButton;
    private JRadioButton barchartRadioButton;
    private JRadioButton piechartRadioButton;
    private JRadioButton columnchartRadioButton;
    private JRadioButton showAbsoluteRadioButton;
    private JRadioButton showRelativeRadioButton;
    private JRadioButton showPercentsRadioButton;
    private JRadioButton showCountsRadioButton;
    private ActionListener catButtonListener;
    private JCheckBox statsCheckBox;
    private JTextField kValueTextField;
    private JTextField numBarsTextField;
    private XTMetaData metaData = null;
    private AbstractAction addGroupByAction;
    private AbstractAction removeGroupByAction;
    private AbstractAction addDisplayAction;
    private AbstractAction removeDisplayAction;
    private static ChartDialog instance = null;

    public static ChartDialog getInstance() {
        if (instance == null) {
            instance = new ChartDialog();
        }
        return instance;
    }

    private ChartDialog() {
        this.setResizable(true);
        this.setSize(500, 475);
        this.setMinimumSize(new Dimension(425, 400));
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.groupbyListModel.removeAllElements();
        this.displayListModel.removeAllElements();
        this.histogramRadioButton.setEnabled(false);
        this.boxplotRadioButton.setEnabled(false);
        this.dotchartRadioButton.setEnabled(false);
        this.barchartRadioButton.setEnabled(false);
        this.columnchartRadioButton.setEnabled(false);
        this.piechartRadioButton.setEnabled(false);
        this.showCountsRadioButton.setEnabled(false);
        this.showPercentsRadioButton.setEnabled(false);
        XTProps props = this.getNodeModel().getXTProps();
        try {
            this.metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = this.metaData.getColumnNames();
        Vector types = this.metaData.getColumnTypes();
        Vector roles = this.metaData.getColumnRoles();
        Vector propGroupby = props.getSubProperties(ChartEngineNode.GROUPBY_ATTRIBUTE_TAG);
        Vector propDisplay = props.getSubProperties(ChartEngineNode.DISPLAY_ATTRIBUTE_TAG);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (propGroupby.contains(name)) {
                this.groupbyListModel.addElement(info);
                propGroupby.remove(name);
                continue;
            }
            if (propDisplay.contains(name)) {
                this.displayListModel.addElement(info);
                propDisplay.remove(name);
                continue;
            }
            this.availableListModel.addElement(info);
        }
        this.enableRadioButtons(this.displayListModel);
        this.histogramRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.HISTOGRAM_POS], true));
        this.boxplotRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.BOXPLOT_POS], false));
        this.dotchartRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.DOTCHART_POS], false));
        this.barchartRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.BARCHART_POS], true));
        this.piechartRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.PIECHART_POS], false));
        this.columnchartRadioButton.setSelected(props.getBoolean(ChartEngineNode.m_chartTypes[ChartEngineNode.COLUMNCHART_POS], false));
        this.showPercentsRadioButton.setSelected(props.getBoolean(ChartEngineNode.SHOW_PERCENTS_TAG, false));
        this.statsCheckBox.setSelected(props.getBoolean(ChartEngineNode.SHOW_STATISTICS_TAG, false));
        this.showRelativeRadioButton.setSelected(props.getBoolean(ChartEngineNode.RELATIVE_TAG, true));
        this.kValueTextField.setText(props.getValue(ChartEngineNode.K_VALUE_ATTRIBUTE_TAG, ChartEngineNode.K_VALUE_DEFAULT));
        int bars = props.getInt(ChartEngineNode.NUM_BARS_ATTRIBUTE_TAG, ChartEngineNode.NUM_BARS_DEFAULT);
        this.numBarsTextField.setText(Integer.toString(bars));
        this.contChartTypeAction();
        this.enableShowPercentButtons();
    }

    private void enableRadioButtons(DefaultListModel model) {
        if (!model.isEmpty()) {
            boolean hasCont = false;
            boolean hasCat = false;
            for (int i = 0; !(hasCat && hasCont || i >= model.size()); ++i) {
                String s = ((NodeDialog.ColumnInformationObject)model.elementAt(i)).getType();
                if (XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG.equals(s)) {
                    hasCat = true;
                    continue;
                }
                hasCont = true;
            }
            this.barchartRadioButton.setEnabled(hasCat);
            this.dotchartRadioButton.setEnabled(hasCat);
            this.piechartRadioButton.setEnabled(hasCat);
            this.histogramRadioButton.setEnabled(hasCont);
            this.boxplotRadioButton.setEnabled(hasCont);
            this.columnchartRadioButton.setEnabled(hasCat);
            if (this.barchartRadioButton.isEnabled() && (this.barchartRadioButton.isSelected() || this.columnchartRadioButton.isSelected())) {
                this.showCountsRadioButton.setEnabled(true);
                this.showPercentsRadioButton.setEnabled(true);
            }
        } else {
            this.barchartRadioButton.setEnabled(false);
            this.dotchartRadioButton.setEnabled(false);
            this.piechartRadioButton.setEnabled(false);
            this.histogramRadioButton.setEnabled(false);
            this.boxplotRadioButton.setEnabled(false);
            this.columnchartRadioButton.setEnabled(false);
        }
        this.contChartTypeAction();
        this.enableShowPercentButtons();
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{ChartEngineNode.GROUPBY_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{ChartEngineNode.DISPLAY_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{ChartEngineNode.NUM_BARS_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration availables = this.displayListModel.elements();
        while (availables.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)availables.nextElement();
            props.set(ChartEngineNode.DISPLAY_ATTRIBUTE_TAG, object.getText(), "");
        }
        availables = null;
        Enumeration conditionedBys = this.groupbyListModel.elements();
        while (conditionedBys.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)conditionedBys.nextElement();
            props.set(ChartEngineNode.GROUPBY_ATTRIBUTE_TAG, object.getText(), "");
        }
        conditionedBys = null;
        props.set(ChartEngineNode.SHOW_STATISTICS_TAG, this.statsCheckBox.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.HISTOGRAM_POS], this.histogramRadioButton.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.BOXPLOT_POS], this.boxplotRadioButton.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.DOTCHART_POS], this.dotchartRadioButton.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.BARCHART_POS], this.barchartRadioButton.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.PIECHART_POS], this.piechartRadioButton.isSelected());
        props.set(ChartEngineNode.m_chartTypes[ChartEngineNode.COLUMNCHART_POS], this.columnchartRadioButton.isSelected());
        props.set(ChartEngineNode.SHOW_PERCENTS_TAG, this.showPercentsRadioButton.isSelected());
        props.set(ChartEngineNode.RELATIVE_TAG, this.showRelativeRadioButton.isSelected());
        String kVal = this.kValueTextField.getText();
        if (kVal.equals("") || kVal.equals("0")) {
            throw new NodeDialog.DialogException(MinerApp.getText("ChartDialog_kValueError"));
        }
        props.set(ChartEngineNode.K_VALUE_ATTRIBUTE_TAG, kVal);
        String numBars = this.numBarsTextField.getText();
        if (numBars.equals("")) {
            numBars = Integer.toString(ChartEngineNode.NUM_BARS_DEFAULT);
        }
        props.set(ChartEngineNode.NUM_BARS_ATTRIBUTE_TAG, numBars);
    }

    public void createActions() {
        super.createActions();
        this.addGroupByAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!ChartDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = ChartDialog.this.availableList.getSelectedValues();
                    int[] indices = ChartDialog.this.availableList.getSelectedIndices();
                    ChartDialog.this.availableListModel.removeListDataListeners();
                    ChartDialog.this.groupbyListModel.removeListDataListeners();
                    int dif = 0;
                    for (int i = 0; i < values.length; ++i) {
                        if (!((NodeDialog.ColumnInformationObject)values[i]).getType().equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                        ChartDialog.this.availableListModel.removeElementAt(indices[i] - dif++);
                        ChartDialog.this.groupbyListModel.addElement(values[i]);
                    }
                    ChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    ChartDialog.this.groupbyListModel.undoRemoveListDataListeners();
                    ChartDialog.this.groupbyScrollPane.sort();
                    ChartDialog.this.availableListModel.listContentsChanged();
                    ChartDialog.this.groupbyListModel.listContentsChanged();
                    ChartDialog.this.availableList.getSelectionModel().clearSelection();
                    values = null;
                    Object var3_3 = null;
                }
            }
        };
        this.removeGroupByAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!ChartDialog.this.groupbyList.isSelectionEmpty()) {
                    Object[] values = ChartDialog.this.groupbyList.getSelectedValues();
                    int[] indices = ChartDialog.this.groupbyList.getSelectedIndices();
                    ChartDialog.this.availableListModel.removeListDataListeners();
                    ChartDialog.this.groupbyListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        ChartDialog.this.groupbyListModel.removeElementAt(indices[i] - i);
                        ChartDialog.this.availableListModel.addElement(values[i]);
                    }
                    ChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    ChartDialog.this.groupbyListModel.undoRemoveListDataListeners();
                    ChartDialog.this.availableScrollPane.sort();
                    ChartDialog.this.availableListModel.listContentsChanged();
                    ChartDialog.this.groupbyListModel.listContentsChanged();
                    ChartDialog.this.groupbyList.getSelectionModel().clearSelection();
                    Object var2_2 = null;
                }
            }
        };
        this.addDisplayAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!ChartDialog.this.availableList.isSelectionEmpty()) {
                    boolean catAlreadySet = ChartDialog.this.barchartRadioButton.isEnabled();
                    boolean contAlreadySet = ChartDialog.this.histogramRadioButton.isEnabled();
                    Object[] values = ChartDialog.this.availableList.getSelectedValues();
                    int[] indices = ChartDialog.this.availableList.getSelectedIndices();
                    ChartDialog.this.availableListModel.removeListDataListeners();
                    ChartDialog.this.displayListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        ChartDialog.this.availableListModel.removeElementAt(indices[i] - i);
                        ChartDialog.this.displayListModel.addElement(values[i]);
                        if (catAlreadySet && contAlreadySet) continue;
                        if (XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG.equals(((NodeDialog.ColumnInformationObject)values[i]).getType())) {
                            ChartDialog.this.barchartRadioButton.setEnabled(true);
                            ChartDialog.this.dotchartRadioButton.setEnabled(true);
                            ChartDialog.this.piechartRadioButton.setEnabled(true);
                            ChartDialog.this.columnchartRadioButton.setEnabled(true);
                            catAlreadySet = true;
                            continue;
                        }
                        ChartDialog.this.histogramRadioButton.setEnabled(true);
                        ChartDialog.this.boxplotRadioButton.setEnabled(true);
                        contAlreadySet = true;
                    }
                    ChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    ChartDialog.this.displayListModel.undoRemoveListDataListeners();
                    ChartDialog.this.displayScrollPane.sort();
                    ChartDialog.this.availableListModel.listContentsChanged();
                    ChartDialog.this.displayListModel.listContentsChanged();
                    ChartDialog.this.availableList.getSelectionModel().clearSelection();
                    values = null;
                    indices = null;
                }
                ChartDialog.this.contChartTypeAction();
            }
        };
        this.removeDisplayAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!ChartDialog.this.displayList.isSelectionEmpty()) {
                    Object[] values = ChartDialog.this.displayList.getSelectedValues();
                    int[] indices = ChartDialog.this.displayList.getSelectedIndices();
                    ChartDialog.this.availableListModel.removeListDataListeners();
                    ChartDialog.this.displayListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        ChartDialog.this.displayListModel.removeElementAt(indices[i] - i);
                        ChartDialog.this.availableListModel.addElement(values[i]);
                    }
                    ChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    ChartDialog.this.displayListModel.undoRemoveListDataListeners();
                    ChartDialog.this.enableRadioButtons(ChartDialog.this.displayListModel);
                    ChartDialog.this.availableScrollPane.sort();
                    ChartDialog.this.availableListModel.listContentsChanged();
                    ChartDialog.this.displayListModel.listContentsChanged();
                    ChartDialog.this.displayList.getSelectionModel().clearSelection();
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ChartDialog_selectColumns")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        Dimension listDim = new Dimension(100, 200);
        JLabel availableLabel = new JLabel(MinerApp.getText("ChartDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.availableScrollPane.setPreferredSize(listDim);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 0.5;
        constraints.fill = 1;
        constraints.gridheight = 0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addDisplayButton = new JButton(this.addDisplayAction);
        JButton removeButton = new JButton(this.removeDisplayAction);
        JButton selectColumnsButton = new JButton(this.addGroupByAction);
        JButton removeGroupByButton = new JButton(this.removeGroupByAction);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 10, 5, 10);
        constraints.fill = 2;
        selectColumnsPanel.add((Component)addDisplayButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        constraints.gridy = 7;
        selectColumnsPanel.add((Component)selectColumnsButton, constraints);
        constraints.gridy = 8;
        selectColumnsPanel.add((Component)removeGroupByButton, constraints);
        JLabel displayLabel = new JLabel(MinerApp.getText("ChartDialog_display"));
        displayLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.displayListModel = new NodeDialog.DNDListModel();
        this.displayList = new NodeDialog.DNDList(this.displayListModel);
        this.displayList.setCellRenderer(renderer);
        this.displayScrollPane = new NodeDialog.SortingScrollPane(this.displayList);
        this.displayScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.displayScrollPane.setPreferredSize(listDim);
        JLabel groupbyLabel = new JLabel(MinerApp.getText("ChartDialog_groupby"));
        groupbyLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.groupbyListModel = new NodeDialog.DNDListModel();
        this.groupbyList = new NodeDialog.DNDList(this.groupbyListModel);
        this.groupbyList.setCellRenderer(renderer);
        this.groupbyScrollPane = new NodeDialog.SortingScrollPane(this.groupbyList);
        this.groupbyScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.groupbyScrollPane.setPreferredSize(listDim);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)displayLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 4;
        constraints.weightx = 0.5;
        constraints.weighty = 0.5;
        selectColumnsPanel.add((Component)this.displayScrollPane, constraints);
        constraints.gridy = 6;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 0, 0, 0);
        selectColumnsPanel.add((Component)groupbyLabel, constraints);
        constraints.gridy = 7;
        constraints.gridheight = 4;
        constraints.weightx = 0.5;
        constraints.weighty = 0.5;
        constraints.insets = new Insets(0, 0, 0, 0);
        selectColumnsPanel.add((Component)this.groupbyScrollPane, constraints);
        return selectColumnsPanel;
    }

    private JPanel getOptionsPanel() {
        JPanel statsPanel = new JPanel(new GridBagLayout());
        statsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ChartDialog_displayOptions")), BorderFactory.createEmptyBorder()));
        this.statsCheckBox = new JCheckBox(MinerApp.getText("ChartDialog_displayStatistics"), false);
        this.statsCheckBox.setMnemonic(MinerApp.getText("ChartDialog_displayStatisticsHotkey").charAt(0));
        GridBagConstraints statsConstraints = new GridBagConstraints();
        statsConstraints.anchor = 18;
        statsConstraints.weightx = 1.0;
        statsConstraints.weighty = 1.0;
        statsPanel.add((Component)this.statsCheckBox, statsConstraints);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setName(MinerApp.getText("ChartDialog_options"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        optionsPanel.add((Component)statsPanel, gbc);
        ++gbc.gridy;
        optionsPanel.add((Component)this.getShowOptionsPanel(), gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        optionsPanel.add((Component)this.getChartTypesPanel(), gbc);
        return optionsPanel;
    }

    private JPanel getShowOptionsPanel() {
        this.showRelativeRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_showRelative"), true);
        this.showRelativeRadioButton.setMnemonic(MinerApp.getText("ChartDialog_showRelativeHotkey").charAt(0));
        this.showAbsoluteRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_showAbsolute"), false);
        this.showAbsoluteRadioButton.setMnemonic(MinerApp.getText("ChartDialog_showAbsoluteHotkey").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.showRelativeRadioButton);
        bg.add(this.showAbsoluteRadioButton);
        this.showCountsRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_showCounts"), true);
        this.showCountsRadioButton.setMnemonic(MinerApp.getText("ChartDialog_showCountsHotkey").charAt(0));
        this.showPercentsRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_showPercents"), false);
        this.showPercentsRadioButton.setMnemonic(MinerApp.getText("ChartDialog_showPercentsHotkey").charAt(0));
        ButtonGroup countsOrPercents_rbs = new ButtonGroup();
        countsOrPercents_rbs.add(this.showCountsRadioButton);
        countsOrPercents_rbs.add(this.showPercentsRadioButton);
        JPanel showPercentPanel = new JPanel(new GridBagLayout());
        showPercentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ChartDialog_valueDisplayedLabel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        showPercentPanel.add((Component)this.showRelativeRadioButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        showPercentPanel.add((Component)this.showAbsoluteRadioButton, gbc);
        return showPercentPanel;
    }

    private JPanel getChartTypesPanel() {
        JPanel chartTypesPanel = new JPanel(new GridBagLayout());
        chartTypesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ChartDialog_chartTypes")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.histogramRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_histogram"), true);
        this.histogramRadioButton.setMnemonic(MinerApp.getText("ChartDialog_histogramHotkey").charAt(0));
        this.boxplotRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_boxplot"), false);
        this.boxplotRadioButton.setMnemonic(MinerApp.getText("ChartDialog_boxplotHotkey").charAt(0));
        this.dotchartRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_dotchart"), false);
        this.dotchartRadioButton.setMnemonic(MinerApp.getText("ChartDialog_dotchartHotkey").charAt(0));
        this.barchartRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_barchart"), false);
        this.barchartRadioButton.setMnemonic(MinerApp.getText("ChartDialog_barchartHotkey").charAt(0));
        this.piechartRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_piechart"), true);
        this.piechartRadioButton.setMnemonic(MinerApp.getText("ChartDialog_piechartHotkey").charAt(0));
        this.columnchartRadioButton = new JRadioButton(MinerApp.getText("ChartDialog_columnchart"), true);
        this.columnchartRadioButton.setMnemonic(MinerApp.getText("ChartDialog_columnchartHotkey").charAt(0));
        JLabel kValueLabel = new JLabel(MinerApp.getText("ChartDialog_kValue"));
        this.kValueTextField = new JTextField(10);
        kValueLabel.setDisplayedMnemonic(MinerApp.getText("ChartDialog_kValueHotkey").charAt(0));
        kValueLabel.setLabelFor(this.kValueTextField);
        this.kValueTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel barsLabel = new JLabel(MinerApp.getText("ChartDialog_numBars"));
        this.numBarsTextField = new JTextField(10);
        barsLabel.setLabelFor(this.numBarsTextField);
        barsLabel.setDisplayedMnemonic(MinerApp.getText("ChartDialog_numBarsHotkey").charAt(0));
        this.numBarsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.histogramRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChartDialog.this.contChartTypeAction();
            }
        });
        this.boxplotRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChartDialog.this.contChartTypeAction();
            }
        });
        ActionListener catButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChartDialog.this.enableShowPercentButtons();
            }
        };
        this.dotchartRadioButton.addActionListener(catButtonListener);
        this.barchartRadioButton.addActionListener(catButtonListener);
        this.piechartRadioButton.addActionListener(catButtonListener);
        this.columnchartRadioButton.addActionListener(catButtonListener);
        ButtonGroup categorical_rbs = new ButtonGroup();
        ButtonGroup continuous_rbs = new ButtonGroup();
        categorical_rbs.add(this.dotchartRadioButton);
        categorical_rbs.add(this.barchartRadioButton);
        categorical_rbs.add(this.columnchartRadioButton);
        categorical_rbs.add(this.piechartRadioButton);
        continuous_rbs.add(this.histogramRadioButton);
        continuous_rbs.add(this.boxplotRadioButton);
        Insets noIndent = new Insets(0, 0, 0, 0);
        Insets smallIndent = new Insets(0, 15, 0, 0);
        Insets largeIndent = new Insets(0, 30, 0, 0);
        GridBagConstraints chartTypesConstraints = new GridBagConstraints();
        chartTypesConstraints.anchor = 18;
        chartTypesConstraints.gridy = 0;
        chartTypesConstraints.gridx = 0;
        chartTypesConstraints.weightx = 0.5;
        chartTypesConstraints.fill = 2;
        chartTypesPanel.add((Component)new JLabel(MinerApp.getText("ChartDialog_categorical")), chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesConstraints.insets = smallIndent;
        chartTypesPanel.add((Component)this.piechartRadioButton, chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesPanel.add((Component)this.barchartRadioButton, chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesPanel.add((Component)this.columnchartRadioButton, chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesPanel.add((Component)this.dotchartRadioButton, chartTypesConstraints);
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new BoxLayout(showPanel, 0));
        showPanel.add(new JLabel(MinerApp.getText("ChartDialog_displayLabel")));
        showPanel.add(Box.createHorizontalStrut(5));
        showPanel.add(this.showCountsRadioButton);
        showPanel.add(this.showPercentsRadioButton);
        ++chartTypesConstraints.gridy;
        chartTypesConstraints.weighty = 1.0;
        chartTypesConstraints.insets = noIndent;
        chartTypesPanel.add((Component)showPanel, chartTypesConstraints);
        int gridheight = chartTypesConstraints.gridy + 1;
        ++chartTypesConstraints.gridx;
        chartTypesConstraints.gridy = 0;
        chartTypesConstraints.weighty = 0.0;
        chartTypesConstraints.gridheight = gridheight;
        chartTypesConstraints.fill = 3;
        chartTypesPanel.add((Component)new JSeparator(1), chartTypesConstraints);
        chartTypesConstraints.gridy = 0;
        ++chartTypesConstraints.gridx;
        chartTypesConstraints.weighty = 0.0;
        chartTypesConstraints.gridheight = 1;
        chartTypesConstraints.insets = noIndent;
        chartTypesConstraints.fill = 2;
        chartTypesPanel.add((Component)new JLabel(MinerApp.getText("ChartDialog_continuous")), chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesConstraints.insets = smallIndent;
        chartTypesPanel.add((Component)this.histogramRadioButton, chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesConstraints.insets = largeIndent;
        JPanel numBarsPanel = new JPanel();
        numBarsPanel.setLayout(new BoxLayout(numBarsPanel, 0));
        numBarsPanel.add(barsLabel);
        numBarsPanel.add(Box.createHorizontalStrut(5));
        numBarsPanel.add(this.numBarsTextField);
        chartTypesPanel.add((Component)numBarsPanel, chartTypesConstraints);
        ++chartTypesConstraints.gridy;
        chartTypesConstraints.insets = smallIndent;
        chartTypesPanel.add((Component)this.boxplotRadioButton, chartTypesConstraints);
        chartTypesConstraints.insets = largeIndent;
        ++chartTypesConstraints.gridy;
        JPanel kValPanel = new JPanel();
        kValPanel.setLayout(new BoxLayout(kValPanel, 0));
        kValPanel.add(kValueLabel);
        kValPanel.add(Box.createHorizontalStrut(5));
        kValPanel.add(this.kValueTextField);
        chartTypesPanel.add((Component)kValPanel, chartTypesConstraints);
        return chartTypesPanel;
    }

    private void contChartTypeAction() {
        boolean active = this.histogramRadioButton.isSelected() && this.histogramRadioButton.isEnabled();
        this.numBarsTextField.setEnabled(active);
        this.numBarsTextField.setEditable(active);
        active = this.boxplotRadioButton.isSelected() && this.boxplotRadioButton.isEnabled();
        this.kValueTextField.setEnabled(active);
        this.kValueTextField.setEditable(active);
    }

    private void enableShowPercentButtons() {
        if (this.barchartRadioButton.isSelected() || this.columnchartRadioButton.isSelected() || this.dotchartRadioButton.isSelected()) {
            this.showCountsRadioButton.setEnabled(true);
            this.showPercentsRadioButton.setEnabled(true);
        } else {
            this.showCountsRadioButton.setEnabled(false);
            this.showPercentsRadioButton.setEnabled(false);
        }
    }

    private JPanel getApproximationPanel() {
        JPanel quantileApproximationPanel = new JPanel(new GridBagLayout());
        quantileApproximationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ChartDialog_quantileApproximation")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel kValueLabel = new JLabel(MinerApp.getText("ChartDialog_kValue"));
        this.kValueTextField = new JTextField(10);
        kValueLabel.setDisplayedMnemonic(MinerApp.getText("ChartDialog_kValueHotkey").charAt(0));
        kValueLabel.setLabelFor(this.kValueTextField);
        this.kValueTextField.setDocument(new NodeDialog.InputIntegerDoc());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        quantileApproximationPanel.add((Component)kValueLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        quantileApproximationPanel.add((Component)this.kValueTextField, constraints);
        return quantileApproximationPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.add(this.getOptionsPanel());
        return panels;
    }
}

