/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import java.util.Arrays;
import java.util.Vector;

public class FilterColumnsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static final String EXCLUDE_COLUMNS_ATTRIBUTE_TAG = "excludeColumns";
    public static final String SQL_INCLUDE_COLUMNS_ATTRIBUTE_TAG = "sqlIncludeColumns";
    private int[] m_keepInds;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        Vector keepNames = this.getIncludeColumnNames();
        int n = keepNames.size();
        this.m_keepInds = new int[n];
        XTMetaData metaData = this.getInputMetaData(0);
        for (int i = 0; i < n; ++i) {
            this.m_keepInds[i] = metaData.nameToOrdinal((String)keepNames.elementAt(i));
        }
        Arrays.sort(this.m_keepInds);
    }

    public void execute(CNKProcJavaTransform proc) {
        int inputRows = proc.getChunkInputRows(0);
        if (inputRows < 1) {
            return;
        }
        int numOutputColumns = this.m_keepInds.length;
        for (int outCol = 0; outCol < numOutputColumns; ++outCol) {
            int inCol = this.m_keepInds[outCol];
            proc.copyColumnData(0, outCol, 0, 0, inCol, 0, inputRows);
        }
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        return this.getInputMetaData(0).selectiveClone(this.getIncludeColumnNames());
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }

    private Vector getIncludeColumnNames() {
        Vector includeColumns = this.getNodeProperties().getSubProperties(SQL_INCLUDE_COLUMNS_ATTRIBUTE_TAG);
        if (includeColumns.size() > 0) {
            return includeColumns;
        }
        Vector dropNames = this.getNodeProperties().getSubProperties(EXCLUDE_COLUMNS_ATTRIBUTE_TAG);
        Vector allNames = this.getInputMetaData(0).getColumnNames();
        Vector<String> keepNames = new Vector<String>();
        boolean keepFlag = true;
        String curName = "";
        for (int i = 0; i < allNames.size(); ++i) {
            keepFlag = true;
            curName = (String)allNames.elementAt(i);
            for (int j = 0; j < dropNames.size(); ++j) {
                if (!curName.equals((String)dropNames.elementAt(j))) continue;
                keepFlag = false;
                break;
            }
            if (!keepFlag) continue;
            keepNames.add(curName);
        }
        return keepNames;
    }
}

