/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class HelpActor {
    static HelpSet mainHS = null;
    static HelpBroker mainHB;
    public static Hashtable helpsetTable;
    static String host;
    static String link;
    private static ThreadGroup topicThread;

    public HelpActor(String hostname, String helplink) {
        host = hostname;
        if (helplink != null) {
            link = helplink;
        }
        helpsetTable = new Hashtable();
    }

    public HelpActor(String hostname) {
        this(hostname, null);
    }

    public HelpActor() {
        this(null, null);
    }

    public static void createJavaHelp(String name, String topic, boolean disply) throws ExceptionInInitializerError, HelpSetException, MalformedURLException {
        ClassLoader cl = HelpActor.class.getClassLoader();
        if (host != null) {
            String header = "http://" + host + "/" + link;
            URL url = new URL(header + "/splus/lib/javahelp/" + name);
            mainHS = new HelpSet(null, url);
        } else {
            String urlString = "file://";
            urlString = urlString + System.getProperty("sprime.home");
            urlString = urlString + "/help/iminer.hs";
            URL url = new URL(urlString);
            mainHS = new HelpSet(cl, url);
        }
        mainHB = new DefaultHelpBroker();
        mainHB.setHelpSet(mainHS);
        if (topic != null) {
            mainHB.setCurrentID(topic);
        }
        mainHB.setViewDisplayed(true);
        if (disply) {
            mainHB.setDisplayed(true);
        }
    }

    public static void createJhelp(String name) throws HelpSetException, MalformedURLException {
        HelpActor.createJavaHelp(name, null, false);
    }

    public static void createJhelp(String name, int width, int height) throws HelpSetException, MalformedURLException {
        HelpActor.createJavaHelp(name, null, false);
        Dimension dm = new Dimension();
        dm.width = width;
        dm.height = height;
        mainHB.setSize(dm);
    }

    public static void addHelpSet(String classpath, String name) throws HelpSetException, MalformedURLException {
        URL url;
        if (host != null) {
            URL url2;
            if (classpath.toLowerCase().startsWith("http://") || classpath.toLowerCase().startsWith("file:")) {
                url2 = new URL(classpath + name);
            } else {
                String header = "http://" + host + "/" + link + "/";
                url2 = new URL(header + classpath + name);
            }
            HelpSet hs = new HelpSet(null, url2);
            mainHS.add(hs);
            helpsetTable.put(name, hs);
            return;
        }
        if (helpsetTable.get(name) != null) {
            return;
        }
        File hsFile = new File(classpath + name);
        if (!hsFile.exists()) {
            System.err.println("Could not find " + classpath + name);
            return;
        }
        if (classpath == null) {
            ClassLoader cl = HelpActor.class.getClassLoader();
            url = HelpSet.findHelpSet((ClassLoader)cl, (String)name);
        } else {
            String u = "file:" + classpath + name;
            url = new URL(u);
            String classPaths = System.getProperty("java.class.path");
            classPaths = classPaths + ":" + classpath;
            System.setProperty("java.class.path", classPaths);
        }
        if (url != null) {
            HelpSet hs = new HelpSet(null, url);
            mainHS.add(hs);
            helpsetTable.put(name, hs);
        } else {
            System.err.println("Could not find " + classpath + name);
        }
    }

    public static void removeHelpSet(String hsname) {
        HelpSet hs1 = (HelpSet)helpsetTable.get(hsname);
        if (hs1 == null) {
            if (host == null) {
                System.err.println("Could not find HelpSet for " + hsname);
            }
            return;
        }
        if (!mainHS.remove(hs1) && host == null) {
            System.err.println("Warning: could not remove HelpSet " + hs1);
        }
        helpsetTable.remove(hsname);
    }

    public static void openJhelp() {
        mainHB.setDisplayed(true);
    }

    public static void openJhelp(String view) {
        mainHB.setSize(mainHB.getSize());
        if (view != null) {
            if (view.equals("TOC")) {
                mainHB.setCurrentView("TOC");
            } else if (view.equals("Index")) {
                mainHB.setCurrentView("Index");
            } else if (view.equals("Search")) {
                mainHB.setCurrentView("Search");
            }
        }
        mainHB.setDisplayed(true);
    }

    public static void displayJhelp(String topic) {
        mainHB.setSize(mainHB.getSize());
        mainHB.setDisplayed(true);
        if (topic != null) {
            mainHB.setCurrentID(topic);
        }
    }

    public static boolean hasFocus() {
        return mainHB.isDisplayed();
    }

    public static void closeJhelp() {
        mainHB.setDisplayed(false);
    }

    static {
        host = null;
        link = "shome";
        topicThread = new ThreadGroup("sprimeTopic");
    }
}

