/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class JoinEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String KEY_COLUMN_ATTRIBUTE_TAG = "keyColumn";
    public static String KEY_COLUMN_KEY_ATTRIBUTE_TAG = "inputKeys";
    public static String LEFT_KEY_COLUMN_ATTRIBUTE_TAG = "leftKeyColumn";
    public static String RIGHT_KEY_COLUMN_ATTRIBUTE_TAG = "rightKeyColumn";
    public static String JOIN_TYPE_ATTRIBUTE_TAG = "joinType";
    public static String JOIN_VALUES_ATTRIBUTE_TAG = "includeUnmatched";
    public static String FULL_TYPE_ATTRIBUTE_TAG = "full";
    public static String LEFT_TYPE_ATTRIBUTE_TAG = "left";
    public static String RIGHT_TYPE_ATTRIBUTE_TAG = "right";
    public static String INNER_TYPE_ATTRIBUTE_TAG = "inner";
    public static String LEFT_COLUMN_SUFFIX_ATTRIBUTE_TAG = "leftColumnSuffix";
    public static String RIGHT_COLUMN_SUFFIX_ATTRIBUTE_TAG = "rightColumnSuffix";
    public static String COLUMN_SUFFII_ATTRIBUTE_TAG = "columnSuffii";
    public static String SORT_ATTRIBUTE_TAG = "sort";
    public static String SQL_CROSS_ATTRIBUTE_TAG = "sqlCrossJoin";
    public static String ONLY_UNMATCHED_ATTRIBUTE_TAG = "onlyUnmatched";
    private HashMap[] m_inputKeyLevels = null;
    private Vector[] m_inputKeys = null;
    private boolean m_sqlCrossJoin = false;
    private boolean m_onlyUnmatched = false;
    boolean[] m_inputUnmatched = null;
    int[] m_inputNumColumns = null;
    int[] m_inputRowsAvailable = null;
    public int m_readRowCounter = 0;

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            XTProps props = this.getNodeProperties();
            md = (XTMetaData)this.initializeMultiOutputMetaData(props, true).clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    public boolean executeDataCacheProc() throws Exception {
        return this.multiJoin();
    }

    public boolean multiJoin() throws Exception {
        int i;
        XTProps props = this.getNodeProperties();
        this.m_sqlCrossJoin = props.getBoolean(SQL_CROSS_ATTRIBUTE_TAG, false);
        this.m_onlyUnmatched = props.getBoolean(ONLY_UNMATCHED_ATTRIBUTE_TAG, false);
        boolean byKey = JoinEngineNode.useKeys(props);
        boolean sortRequired = props.getBoolean(SORT_ATTRIBUTE_TAG, true) && byKey && !this.m_sqlCrossJoin;
        int rowChunkSize = this.getMaxRowsPerBlock();
        int numInputs = this.getNumInputs();
        File[] sortedFiles = new File[numInputs];
        if (sortRequired) {
            for (i = 0; i < numInputs; ++i) {
                sortedFiles[i] = this.createWorkspaceTempFile("join", "tmp");
                sortedFiles[i].deleteOnExit();
            }
        } else {
            for (i = 0; i < numInputs; ++i) {
                sortedFiles[i] = new File(this.getInputDataCacheFileName(i));
            }
        }
        XTMetaData[] metaData = new XTMetaData[numInputs];
        for (int i2 = 0; i2 < numInputs; ++i2) {
            metaData[i2] = this.getInputMetaData(i2);
        }
        Vector[] inputKeys = JoinEngineNode.getMultiColumnKeys(props, numInputs);
        if (numInputs > 0) {
            int numKeys = inputKeys[0].size();
            for (int k = 0; k < numKeys; ++k) {
                String keyName = (String)inputKeys[0].get(k);
                String type = metaData[0].getColumnType(keyName);
                for (int i3 = 1; i3 < numInputs; ++i3) {
                    String testKeyName = (String)inputKeys[i3].get(k);
                    String testType = metaData[i3].getColumnType(testKeyName);
                    if (type.equals(testType)) continue;
                    String errorMsg = "mismatched key types: " + keyName + "(" + type + ") & " + testKeyName + "(" + testType + ")";
                    throw new RuntimeException(errorMsg);
                }
            }
        }
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        if (sortRequired) {
            for (int i4 = 0; i4 < numInputs; ++i4) {
                File unsortedFile = new File(this.getInputDataCacheFileName(i4));
                Object[] keys = inputKeys[i4].toArray();
                String[] sortColumnOrder = new String[keys.length];
                boolean[] sortAscend = new boolean[keys.length];
                boolean[] sortNAsTop = new boolean[keys.length];
                boolean[] sortAlpha = new boolean[keys.length];
                for (int k = 0; k < keys.length; ++k) {
                    sortColumnOrder[k] = (String)keys[k];
                    sortAlpha[k] = true;
                    sortAscend[k] = true;
                    sortNAsTop[k] = false;
                }
                String str = origText + " Input File " + Integer.toString(i4);
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
                boolean success = SortAndShuffle.sort(unsortedFile, sortedFiles[i4], metaData[i4], (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscend, sortNAsTop, sortAlpha[0], true);
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
                this.resetProgressIndicator();
                if (success) continue;
                return false;
            }
        }
        String str = origText + ": Joining Files...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        this.resetProgressIndicator();
        File joinedFile = new File(this.getOutputDataCacheFileName(0));
        XTMetaData outputMD = this.initializeMultiOutputMetaData(props, true);
        boolean[] joinUnmatched = JoinEngineNode.getMultiUnmatched(props, numInputs);
        boolean success = true;
        success = byKey || this.m_sqlCrossJoin ? this.multiJoinByKey(sortedFiles, joinedFile, inputKeys, metaData, joinUnmatched, outputMD) : this.multiJoinByRow(sortedFiles, joinedFile, metaData, joinUnmatched, outputMD);
        this.setOutputMetaData(0, outputMD);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        this.resetProgressIndicator();
        if (sortRequired) {
            for (int i5 = 0; i5 < numInputs; ++i5) {
                sortedFiles[i5].delete();
            }
        }
        return success;
    }

    public static Vector[] getMultiColumnKeys(XTProps props, int numInputs) throws Exception {
        Vector[] inputKeys = new Vector[numInputs];
        String[] keyPath = new String[]{KEY_COLUMN_KEY_ATTRIBUTE_TAG, ""};
        for (int i = 0; i < numInputs; ++i) {
            String oldKey;
            keyPath[1] = Integer.toString(i);
            String string = oldKey = i == 0 ? props.getValue(LEFT_KEY_COLUMN_ATTRIBUTE_TAG) : props.getValue(RIGHT_KEY_COLUMN_ATTRIBUTE_TAG);
            if (oldKey.length() == 0) {
                inputKeys[i] = props.getSubPropertyValues(keyPath);
                continue;
            }
            inputKeys[i] = new Vector();
            inputKeys[i].add(oldKey);
        }
        return inputKeys;
    }

    public static boolean[] getMultiUnmatched(XTProps props, int numInputs) {
        boolean[] inputKeys = new boolean[numInputs];
        String joinType = props.getValue(JOIN_TYPE_ATTRIBUTE_TAG, "");
        if (joinType.equals(FULL_TYPE_ATTRIBUTE_TAG)) {
            return new boolean[]{true, true};
        }
        if (joinType.equals(LEFT_TYPE_ATTRIBUTE_TAG)) {
            return new boolean[]{true, false};
        }
        if (joinType.equals(RIGHT_TYPE_ATTRIBUTE_TAG)) {
            return new boolean[]{false, true};
        }
        if (joinType.equals(INNER_TYPE_ATTRIBUTE_TAG)) {
            return new boolean[]{false, false};
        }
        Vector joinVals = props.getSubPropertyValues(JOIN_VALUES_ATTRIBUTE_TAG);
        if (joinVals.size() != numInputs) {
            for (int i = 0; i < numInputs; ++i) {
                inputKeys[i] = true;
            }
        } else {
            for (int i = 0; i < numInputs; ++i) {
                inputKeys[i] = joinVals.get(i).equals("true");
            }
        }
        return inputKeys;
    }

    public static String[] getMultiSuffii(XTProps props, int numInputs) {
        Vector columnSuffii = props.getSubPropertyValues(COLUMN_SUFFII_ATTRIBUTE_TAG);
        if (columnSuffii.size() == 0) {
            columnSuffii.add(props.getValue(LEFT_COLUMN_SUFFIX_ATTRIBUTE_TAG, "1"));
            columnSuffii.add(props.getValue(RIGHT_COLUMN_SUFFIX_ATTRIBUTE_TAG, "2"));
        }
        if (columnSuffii.size() != numInputs) {
            columnSuffii.removeAllElements();
            for (int i = 0; i < numInputs; ++i) {
                columnSuffii.add(Integer.toString(i + 1));
            }
        }
        String[] suffii = new String[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            suffii[i] = (String)columnSuffii.get(i);
        }
        return suffii;
    }

    private XTMetaData initializeMultiOutputMetaData(XTProps props, boolean calcLevels) throws Exception {
        Object cn;
        int i;
        int numInputs = this.getNumInputs();
        boolean useKeys = JoinEngineNode.useKeys(props);
        String[] columnSuffii = JoinEngineNode.getMultiSuffii(props, numInputs);
        XTMetaData[] md = new XTMetaData[numInputs];
        Vector[] columnNames = new Vector[numInputs];
        Vector[] columnRoles = new Vector[numInputs];
        HashMap[] colNamesMap = new HashMap[numInputs];
        int maxColumnCount = 0;
        for (int i2 = 0; i2 < numInputs; ++i2) {
            md[i2] = this.getInputMetaData(i2);
            columnNames[i2] = md[i2].getColumnNames();
            columnRoles[i2] = md[i2].getColumnRoles();
            maxColumnCount += md[i2].getNumColumns();
            colNamesMap[i2] = new HashMap(md[i2].getNumColumns());
            for (int col = 0; col < md[i2].getNumColumns(); ++col) {
                Object cn2 = columnNames[i2].get(col);
                colNamesMap[i2].put(cn2, cn2);
            }
        }
        XTMetaData outputMD = new XTMetaData();
        this.m_inputKeys = JoinEngineNode.getMultiColumnKeys(props, numInputs);
        Vector[] inputKeyLevelVector = null;
        for (int i3 = 0; useKeys && i3 < numInputs; ++i3) {
            if (i3 == 0) {
                this.m_inputKeyLevels = new HashMap[this.m_inputKeys[0].size()];
                inputKeyLevelVector = new Vector[this.m_inputKeyLevels.length];
            }
            for (int j = 0; j < this.m_inputKeys[i3].size(); ++j) {
                String inputKey = (String)this.m_inputKeys[i3].get(j);
                if (i3 == 0) {
                    this.m_inputKeyLevels[j] = new HashMap();
                    inputKeyLevelVector[j] = new Vector();
                }
                if (!md[i3].isCategoricalColumn(inputKey)) continue;
                Vector levels = md[i3].getCategoricalDataFieldLevels(inputKey);
                for (int level = 0; level < levels.size(); ++level) {
                    String strLevel = (String)levels.get(level);
                    if (this.m_inputKeyLevels[j].get(strLevel) != null) continue;
                    this.m_inputKeyLevels[j].put(strLevel, new Integer(this.m_inputKeyLevels[j].size()));
                    inputKeyLevelVector[j].add(strLevel);
                }
            }
        }
        HashMap columnNameResolution = new HashMap(maxColumnCount);
        for (i = 0; i < numInputs; ++i) {
            for (int col = 0; col < md[i].getNumColumns(); ++col) {
                cn = columnNames[i].get(col);
                Vector<Integer> vec = (Vector<Integer>)columnNameResolution.get(cn);
                if (vec == null) {
                    vec = new Vector<Integer>();
                    vec.add(new Integer(i));
                    columnNameResolution.put(cn, vec);
                }
                for (int input = i; input < numInputs; ++input) {
                    Object val;
                    if (input == i || (val = colNamesMap[input].get(cn)) == null) continue;
                    vec.add(new Integer(input));
                }
            }
        }
        for (i = 0; i < numInputs; ++i) {
            for (int col = 0; col < md[i].getNumColumns(); ++col) {
                cn = (String)columnNames[i].get(col);
                String role = (String)columnRoles[i].get(col);
                Vector vec = (Vector)columnNameResolution.get(cn);
                int keyNum = this.m_inputKeys[i].indexOf(cn);
                boolean isKey = useKeys && keyNum != -1;
                Object uniqueName = cn;
                if (!(vec == null || vec.size() == 1 || i == 0 && isKey)) {
                    String suffix = columnSuffii[i];
                    while (columnNameResolution.get(uniqueName + suffix) != null) {
                        suffix = "." + suffix;
                    }
                    uniqueName = uniqueName + suffix;
                }
                if (i == 0 || !isKey) {
                    if (md[i].isCategoricalColumn((String)cn)) {
                        Vector newLevels = !calcLevels ? new Vector() : (isKey ? inputKeyLevelVector[keyNum] : md[i].getCategoricalDataFieldLevels((String)cn));
                        outputMD.appendCategoricalDataField((String)uniqueName, newLevels);
                    } else if (md[i].isStringColumn((String)cn)) {
                        int stringWidth = md[i].getStringDataFieldWidth((String)cn);
                        outputMD.appendStringDataField((String)uniqueName, stringWidth);
                    } else if (md[i].isDateTimeColumn((String)cn)) {
                        outputMD.appendDateTimeDataField((String)uniqueName);
                    } else if (md[i].isBlobColumn((String)cn)) {
                        String blobClass = md[i].getBlobDataFieldClassName((String)cn);
                        outputMD.appendBlobDataField((String)uniqueName, blobClass);
                    } else {
                        outputMD.appendContinousDataField((String)uniqueName);
                    }
                }
                if (isKey) continue;
                outputMD.setDataFieldRole((String)uniqueName, role);
            }
        }
        return outputMD;
    }

    private boolean multiJoinByKey(File[] sortedFiles, File joinedFile, Vector[] inputKeys, XTMetaData[] metaData, boolean[] joinUnmatched, XTMetaData outputMD) throws Exception {
        int i;
        int numInputs = sortedFiles.length;
        RowComparison[] rowData = new RowComparison[numInputs];
        Object[] sortData = new RowComparison[numInputs];
        for (int i2 = 0; i2 < numInputs; ++i2) {
            RandomAccessFile ra = new RandomAccessFile(sortedFiles[i2], "r");
            rowData[i2] = new RowComparison(ra, metaData[i2], i2, joinUnmatched[i2], this.getNodeID(), inputKeys[i2]);
            sortData[i2] = rowData[i2];
            rowData[i2].init();
        }
        FileOutputStream joinedStream = new FileOutputStream(joinedFile);
        BufferedOutputStream joinedBuffer = new BufferedOutputStream(joinedStream);
        DataOutputStream joinedOutputStream = new DataOutputStream(joinedBuffer);
        DataCacheRowBuf outbuf = new DataCacheRowBuf(outputMD);
        BufferedOutputStream outBlobFile = null;
        if (outbuf.containsBlobs()) {
            try {
                String outBlobFileName = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
                outBlobFile = new BufferedOutputStream(new FileOutputStream(outBlobFileName, false));
                outbuf.setWriteBlobFile(outBlobFile);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean ok = true;
        long numRows = 0L;
        boolean someData = true;
        while (someData) {
            Arrays.sort(sortData);
            numRows += this.outputRows(rowData, (RowComparison[])sortData, outbuf, joinedOutputStream);
            if (this.isInterruptRequested()) {
                ok = false;
                break;
            }
            if (this.m_readRowCounter < 0) {
                double totalRowsAvailable = 0.0;
                double totalRowsRead = 0.0;
                for (int i3 = 0; i3 < numInputs; ++i3) {
                    totalRowsAvailable += (double)metaData[i3].getNumRows();
                    totalRowsRead += (double)rowData[i3].getCurrentRowNum();
                }
                if (totalRowsAvailable > 0.0) {
                    this.updateProgressIndicator((int)(100.0 * totalRowsRead / totalRowsAvailable));
                }
                this.m_readRowCounter = 500;
            }
            someData = false;
            for (i = 0; !someData && i < numInputs; ++i) {
                if (rowData[i].isDone()) continue;
                someData = true;
            }
        }
        outputMD.setNumRows(numRows);
        if (outBlobFile != null) {
            outBlobFile.flush();
            outBlobFile.close();
        }
        for (i = 0; i < numInputs; ++i) {
            rowData[i].close();
        }
        joinedOutputStream.flush();
        joinedOutputStream.close();
        return ok;
    }

    private boolean multiJoinByRow(File[] sortedFiles, File joinedFile, XTMetaData[] metaData, boolean[] joinUnmatched, XTMetaData outputMD) throws Exception {
        int numInputs = sortedFiles.length;
        RowComparison[] rowData = new RowComparison[numInputs];
        long maxUnmatchedRows = -1L;
        for (int i = 0; i < numInputs; ++i) {
            RandomAccessFile ra = new RandomAccessFile(sortedFiles[i], "r");
            rowData[i] = new RowComparison(ra, metaData[i], i, joinUnmatched[i], this.getNodeID(), new Vector());
            rowData[i].init();
            if (!joinUnmatched[i] || metaData[i].getNumRows() <= maxUnmatchedRows) continue;
            maxUnmatchedRows = metaData[i].getNumRows();
        }
        FileOutputStream joinedStream = new FileOutputStream(joinedFile);
        BufferedOutputStream joinedBuffer = new BufferedOutputStream(joinedStream);
        DataOutputStream joinedOutputStream = new DataOutputStream(joinedBuffer);
        DataCacheRowBuf outbuf = new DataCacheRowBuf(outputMD);
        BufferedOutputStream outBlobFile = null;
        if (outbuf.containsBlobs()) {
            try {
                String outBlobFileName = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
                outBlobFile = new BufferedOutputStream(new FileOutputStream(outBlobFileName, false));
                outbuf.setWriteBlobFile(outBlobFile);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean anyleft = false;
        boolean[] someData = new boolean[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            boolean bl = someData[i] = !rowData[i].isDone();
            if (!someData[i]) continue;
            anyleft = true;
        }
        long numRows = 0L;
        boolean anyDone = false;
        while (anyleft) {
            boolean lastWriteFinishedAnInput = anyDone;
            anyDone = false;
            anyleft = false;
            int outputCol = 0;
            for (int i = 0; i < numInputs; ++i) {
                outputCol = rowData[i].outputRow(outbuf, rowData[i], outputCol, !someData[i], true);
                rowData[i].update();
                boolean bl = someData[i] = !rowData[i].isDone();
                if (someData[i]) {
                    anyleft = true;
                    continue;
                }
                anyDone = true;
            }
            if (!this.m_onlyUnmatched || lastWriteFinishedAnInput) {
                outbuf.writeRow(joinedOutputStream);
                ++numRows;
            }
            if ((maxUnmatchedRows <= 0L || numRows != maxUnmatchedRows) && (maxUnmatchedRows != -1L || !anyDone)) continue;
            break;
        }
        outputMD.setNumRows(numRows);
        if (outBlobFile != null) {
            outBlobFile.flush();
            outBlobFile.close();
        }
        for (int i = 0; i < numInputs; ++i) {
            rowData[i].close();
        }
        joinedOutputStream.flush();
        joinedOutputStream.close();
        return true;
    }

    private long outputRows(RowComparison[] origOrder, RowComparison[] sortOrder, DataCacheRowBuf outbuf, DataOutputStream outs) throws Exception {
        int numInputs = sortOrder.length;
        int numRows = 0;
        int equalInputs = 1;
        boolean[] naRow = new boolean[numInputs];
        for (int i = 1; i < numInputs; ++i) {
            boolean bl = naRow[sortOrder[i].getInputNum()] = sortOrder[0].compareTo(sortOrder[i]) != 0;
            if (naRow[sortOrder[i].getInputNum()]) continue;
            ++equalInputs;
        }
        int outputCol = 0;
        if (equalInputs < numInputs) {
            if (sortOrder[0].includeUnmatchedRows() || this.m_onlyUnmatched) {
                int outputInput = sortOrder[0].getInputNum();
                for (int i = 0; i < numInputs; ++i) {
                    boolean includeKeys = i == 0;
                    outputCol = origOrder[i].outputRow(outbuf, sortOrder[0], outputCol, outputInput != i, includeKeys);
                }
                outbuf.writeRow(outs);
                ++numRows;
            }
            sortOrder[0].update();
        } else if (equalInputs == numInputs) {
            int[] equalCols = new int[equalInputs];
            long[] firstEqualRow = new long[equalInputs];
            int j = 0;
            for (int i = 0; i < numInputs; ++i) {
                if (!naRow[i]) {
                    equalCols[j++] = sortOrder[i].getInputNum();
                }
                firstEqualRow[i] = origOrder[i].getCurrentRowNum();
            }
            Arrays.sort(equalCols);
            boolean notDone = true;
            while (notDone) {
                int eCol;
                for (int i = 0; i < numInputs; ++i) {
                    boolean includeKeys = i == 0;
                    int sortOrderIndex = 0;
                    if (this.m_sqlCrossJoin) {
                        sortOrderIndex = i;
                        includeKeys = true;
                    }
                    outputCol = origOrder[i].outputRow(outbuf, sortOrder[sortOrderIndex], outputCol, naRow[i], includeKeys);
                }
                if (!this.m_onlyUnmatched) {
                    outbuf.writeRow(outs);
                    ++numRows;
                }
                outputCol = 0;
                for (eCol = equalInputs - 1; eCol >= 0 && !origOrder[equalCols[eCol]].readNextEqualRow(firstEqualRow[eCol]); --eCol) {
                    notDone = eCol != 0;
                }
                if (!notDone) {
                    for (eCol = 0; eCol < equalInputs; ++eCol) {
                        origOrder[equalCols[eCol]].readNextUnequalRow();
                    }
                    break;
                }
                if (!this.isInterruptRequested()) continue;
                return 0L;
            }
        }
        return numRows;
    }

    public static boolean useKeys(XTProps props) {
        return props.getBoolean(KEY_COLUMN_ATTRIBUTE_TAG, false);
    }

    private boolean useFastRowWiseJoin() {
        XTProps props = this.getNodeProperties();
        return !props.getBoolean(KEY_COLUMN_ATTRIBUTE_TAG, false) && !props.getBoolean(SQL_CROSS_ATTRIBUTE_TAG, false) && !props.getBoolean(ONLY_UNMATCHED_ATTRIBUTE_TAG, false);
    }

    public boolean hasCNKProc() {
        return this.useFastRowWiseJoin();
    }

    public boolean hasDataCacheProc() {
        return !this.useFastRowWiseJoin();
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        if (this.useFastRowWiseJoin()) {
            return EngineNode.InputRequirements.getMinRequirements();
        }
        return EngineNode.InputRequirements.getDefaultRequirements();
    }

    public CNKProc procCreate() throws Exception {
        int numInputs = this.getNumInputs();
        this.m_inputUnmatched = JoinEngineNode.getMultiUnmatched(this.getNodeProperties(), numInputs);
        this.m_inputNumColumns = new int[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            this.m_inputNumColumns[i] = this.getInputMetaData(i).getNumColumns();
        }
        this.m_inputRowsAvailable = new int[numInputs];
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void execute(CNKProcJavaTransform proc) {
        int i;
        int numInputs = this.getNumInputs();
        int minRowsAvailable = -1;
        for (i = 0; i < numInputs; ++i) {
            this.m_inputRowsAvailable[i] = proc.getChunkInputRows(i);
            if (minRowsAvailable >= 0 && this.m_inputRowsAvailable[i] >= minRowsAvailable) continue;
            minRowsAvailable = this.m_inputRowsAvailable[i];
        }
        if (minRowsAvailable < 1) {
            minRowsAvailable = -1;
            for (i = 0; i < numInputs; ++i) {
                if (!this.m_inputUnmatched[i]) {
                    if (this.m_inputRowsAvailable[i] <= 0) continue;
                    proc.setChunkInputReleaseAll(i);
                    this.m_inputRowsAvailable[i] = 0;
                    continue;
                }
                if (this.m_inputRowsAvailable[i] <= 0 || minRowsAvailable >= 0 && this.m_inputRowsAvailable[i] >= minRowsAvailable) continue;
                minRowsAvailable = this.m_inputRowsAvailable[i];
            }
        }
        if (minRowsAvailable < 1) {
            proc.setChunkOutputReleaseRows(0, 0);
            proc.setChunkDone(true);
            return;
        }
        int outputColumn = 0;
        for (int i2 = 0; i2 < numInputs; ++i2) {
            int rows = Math.min(minRowsAvailable, this.m_inputRowsAvailable[i2]);
            if (rows > 0) {
                proc.copyData(0, outputColumn, 0, i2, 0, 0, rows, this.m_inputNumColumns[i2]);
                proc.setChunkInputReleaseRows(i2, rows);
            }
            outputColumn += this.m_inputNumColumns[i2];
        }
        proc.setChunkOutputReleaseRows(0, minRowsAvailable);
    }

    private class RowComparison
    implements Comparable {
        private int inputNum;
        private boolean includeUnmatched;
        private DataCacheRowBuf buf;
        private long rowNum;
        private int rowSize;
        private RandomAccessFile raf = null;
        private long m_rafPosition = -1L;
        private RandomAccessFile blob = null;
        private boolean[] keys;
        private int[] keyNums;
        private int numKeys;
        private XTMetaData md;
        private Vector keyStrings;

        public RowComparison(RandomAccessFile raFile, XTMetaData metaData, int input, boolean unmatched, String nodeID, Vector strKeys) throws Exception {
            int i;
            this.inputNum = input;
            this.includeUnmatched = unmatched;
            this.md = metaData;
            this.raf = raFile;
            this.m_rafPosition = -1L;
            this.rowNum = 0L;
            this.buf = new DataCacheRowBuf(this.md);
            this.rowSize = this.buf.getBytesPerRow();
            if (this.buf.containsBlobs()) {
                String leftBlobFileName = JoinEngineNode.this.getNetworkManager().getInputDataBlobFileName(nodeID, this.inputNum);
                this.blob = new RandomAccessFile(leftBlobFileName, "r");
                this.buf.setReadBlobFile(this.blob);
            }
            this.numKeys = strKeys.size();
            this.keyNums = new int[this.numKeys];
            this.keys = new boolean[this.md.getNumColumns()];
            for (i = 0; i < this.keys.length; ++i) {
                this.keys[i] = false;
            }
            for (i = 0; i < this.numKeys; ++i) {
                String keyName = (String)strKeys.get(i);
                this.keyNums[i] = this.md.nameToOrdinal(keyName);
                this.keys[this.keyNums[i]] = true;
            }
            this.keyStrings = strKeys;
        }

        public int getInputNum() {
            return this.inputNum;
        }

        public boolean includeUnmatchedRows() {
            return this.includeUnmatched;
        }

        public long getCurrentRowNum() {
            return this.rowNum;
        }

        public void close() throws Exception {
            if (this.raf != null) {
                this.raf.close();
            }
            if (this.blob != null) {
                this.blob.close();
            }
        }

        public int compareTo(Object obj) {
            if (obj instanceof RowComparison) {
                if (JoinEngineNode.this.m_sqlCrossJoin) {
                    return 0;
                }
                RowComparison comp = (RowComparison)obj;
                if (comp.isDone()) {
                    if (this.isDone()) {
                        return 0;
                    }
                    return -1;
                }
                if (this.isDone()) {
                    return 1;
                }
                return this.internalCompareTo(comp.getKeyValues());
            }
            return 1;
        }

        public boolean hasNext() {
            return this.rowNum < this.md.getNumRows() - 1L;
        }

        public boolean isDone() {
            return this.rowNum >= this.md.getNumRows();
        }

        public void init() throws Exception {
            this.readNewRow(0L);
        }

        public void update() throws Exception {
            this.readNewRow(this.rowNum + 1L);
        }

        public void readNewRow(long setRowNum) throws Exception {
            this.rowNum = setRowNum;
            --JoinEngineNode.this.m_readRowCounter;
            long currentPos = this.m_rafPosition;
            long newPos = this.rowNum * (long)this.rowSize;
            this.m_rafPosition = -1L;
            if (newPos != currentPos) {
                this.raf.seek(newPos);
            }
            this.buf.readRow(this.raf);
            this.m_rafPosition = newPos + (long)this.buf.getBytesPerRow();
        }

        public boolean readNextEqualRow(long firstEqualRow) throws Exception {
            Object[] currentKeyVals = this.getKeyValues();
            if (!this.hasNext()) {
                this.readNewRow(firstEqualRow);
                return false;
            }
            this.update();
            if (this.internalCompareTo(currentKeyVals) != 0) {
                this.readNewRow(firstEqualRow);
                return false;
            }
            return true;
        }

        public boolean readNextUnequalRow() throws Exception {
            Object[] currentKeyVals = this.getKeyValues();
            if (this.isDone()) {
                return false;
            }
            this.update();
            while (this.internalCompareTo(currentKeyVals) == 0) {
                if (this.isDone()) {
                    return false;
                }
                this.update();
                if (!JoinEngineNode.this.isInterruptRequested()) continue;
                return false;
            }
            return true;
        }

        public int outputRow(DataCacheRowBuf outbuf, RowComparison comp, int startOutputCol, boolean NArow, boolean includeKeys) {
            int outputCol = startOutputCol;
            int keyNum = 0;
            int keyNumsLength = this.keyNums.length;
            for (int c = 0; c < this.buf.getNumColumns(); ++c) {
                if (this.keys[c] && !includeKeys) continue;
                if (NArow && !this.keys[c]) {
                    outbuf.setNA(outputCol++);
                    continue;
                }
                if (this.keys[c]) {
                    int compKeyColumnNum = c;
                    for (keyNum = 0; keyNum < keyNumsLength; ++keyNum) {
                        if (this.keyNums[keyNum] != c) continue;
                        compKeyColumnNum = comp.keyNums[keyNum];
                        break;
                    }
                    if (comp.buf.isFactor(compKeyColumnNum)) {
                        double levNum = comp.buf.getDouble(compKeyColumnNum);
                        String levelString = comp.md.getCategoricalDataFieldLevel(compKeyColumnNum, (int)levNum);
                        Integer levelInteger = (Integer)JoinEngineNode.this.m_inputKeyLevels[keyNum].get(levelString);
                        if (levelInteger == null) {
                            outbuf.setNA(outputCol++);
                            continue;
                        }
                        outbuf.setDouble(outputCol++, levelInteger.doubleValue());
                        continue;
                    }
                    outbuf.copyColumn(outputCol++, compKeyColumnNum, comp.buf);
                    continue;
                }
                outbuf.copyColumn(outputCol++, c, this.buf);
            }
            return outputCol;
        }

        private Object[] getKeyValues() {
            Object[] values = new Object[this.numKeys];
            for (int i = 0; i < this.numKeys; ++i) {
                int colNum = this.keyNums[i];
                double val = this.buf.getDouble(colNum);
                values[i] = this.buf.isFactor(colNum) ? (Double.isNaN(val) ? "" : this.md.getCategoricalDataFieldLevel(colNum, (int)val)) : (this.buf.isString(colNum) ? this.buf.getString(colNum) : (this.buf.isTimeDate(colNum) ? (Number)new Long(this.buf.getTimeDate(colNum)) : (Number)new Double(val)));
            }
            return values;
        }

        private int internalCompareTo(Object[] thatVals) {
            if (JoinEngineNode.this.m_sqlCrossJoin) {
                return 0;
            }
            Object[] thisVals = this.getKeyValues();
            for (int i = 0; i < thisVals.length; ++i) {
                double thatVal;
                if (thisVals[i] instanceof String) {
                    int comparison = ((String)thisVals[i]).compareTo((String)thatVals[i]);
                    if (comparison == 0) continue;
                    return comparison;
                }
                if (thisVals[i] instanceof Long) {
                    int comparison = ((Long)thisVals[i]).compareTo((Long)thatVals[i]);
                    if (comparison == 0) continue;
                    return comparison;
                }
                if (!(thisVals[i] instanceof Double)) continue;
                Double d1 = (Double)thisVals[i];
                Double d2 = (Double)thatVals[i];
                if (d1.isNaN() || d2.isNaN()) {
                    return d1.compareTo(d2);
                }
                double thisVal = d1;
                if (thisVal == (thatVal = d2.doubleValue())) continue;
                return thisVal < thatVal ? -1 : 1;
            }
            return 0;
        }
    }
}

