/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsLiftChartPanel;
import com.insightful.miner.LiftChartBuilder;
import com.insightful.miner.LiftChartFrame_AboutBox;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.tree.gui.ColorBroker;
import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.TickUnit;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class LiftChartFrame
extends ModifiableViewerFrame
implements ActionListener {
    private ColorBroker colorBroker = null;
    private Color frameBackgroundColor;
    private Color chartBackgroundColor;
    private Color chartBorderColor;
    private Color liftChartMenuColor;
    private Color frameLabelColor;
    private Color liftChartUpdateColor;
    private LiftChartBuilder liftChartBuilder;
    private JTextField costMatrixYYTextField;
    private JTextField costMatrixYNTextField;
    private JTextField costMatrixNYTextField;
    private JTextField costMatrixNNTextField;
    private JButton applyButton;
    public static final int LIFT_CHART_WIDTH = 300;
    public static final int LIFT_CHART_HEIGHT = 300;
    public static final int CUM_GAIN_TYPE = 0;
    public static final int LIFT_TYPE = 1;
    public static final int ROC_TYPE = 2;
    private int currentChartType = 0;
    private InsLiftChartPanel liftChartPanel;
    private ButtonGroup bg;
    private JRadioButton cumGainRadButton;
    private JRadioButton liftRadButton;
    private JRadioButton rocRadButton;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    private JMenuItem fileMenuSave = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuUserGuide = new JMenuItem();
    private JMenuItem helpMenuAbout = new JMenuItem();
    public static Font labelFont = MinerApp.getFont(1, 12);
    public static Font tinyFont = MinerApp.getFont(1, 9);

    public LiftChartFrame(LiftChartBuilder lcb) {
        this.frameBackgroundColor = ColorBroker.getColor("liftChartLabelBackgroundColor");
        this.chartBackgroundColor = ColorBroker.getColor("liftChartBackgroundColor");
        this.chartBorderColor = ColorBroker.getColor("liftChartBorderColor");
        this.liftChartMenuColor = ColorBroker.getColor("liftChartMenuColor");
        this.frameLabelColor = ColorBroker.getColor("liftChartLabelForegroundColor");
        this.liftChartUpdateColor = ColorBroker.getColor("liftChartUpdateColor");
        this.liftChartBuilder = lcb;
        this.setTitle(LiftChartBuilder.getText("liftChartFrame_frame_title"));
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(600, 500);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.dispose();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
    }

    private void jbInit() throws Exception {
        String filemenu = LiftChartBuilder.getText("liftChartFrame_filemenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = LiftChartBuilder.getText("liftChartFrame_fileexit");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(69);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.setVisible(false);
            }
        });
        String fileprint = LiftChartBuilder.getText("liftChartFrame_fileprint");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.liftChartPanel.actionPerformed(new ActionEvent(this, 1001, "PRINT"));
            }
        });
        String fileprintpreview = LiftChartBuilder.getText("liftChartFrame_fileprintpreview");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.liftChartPanel.printPreview();
            }
        });
        String filesave = LiftChartBuilder.getText("liftChartFrame_filesave");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.liftChartPanel.actionPerformed(new ActionEvent(this, 1001, "SAVE"));
            }
        });
        String help = LiftChartBuilder.getText("liftChartFrame_help");
        this.helpMenu.setText(help);
        this.helpMenu.setMnemonic(72);
        String helpsystem = LiftChartBuilder.getText("liftChartFrame_helpsystem");
        this.helpMenuUserGuide.setText(helpsystem);
        this.helpMenuUserGuide.setMnemonic(76);
        this.helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.handleHelp();
            }
        });
        String helpabout = LiftChartBuilder.getText("liftChartFrame_helpabout");
        this.helpMenuAbout.setText(helpabout);
        this.helpMenuAbout.setMnemonic(65);
        this.helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiftChartFrame.this.handleAboutBox();
            }
        });
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuExit);
        this.fileMenu.setBackground(this.liftChartMenuColor);
        this.helpMenu.add(this.helpMenuUserGuide);
        this.helpMenu.add(this.helpMenuAbout);
        this.helpMenu.setBackground(this.liftChartMenuColor);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.helpMenu);
        this.menuBar.setBackground(this.liftChartMenuColor);
        this.setJMenuBar(this.menuBar);
        JPanel backgroundPanel = new JPanel();
        backgroundPanel.setBackground(this.frameBackgroundColor);
        backgroundPanel.setRequestFocusEnabled(true);
        backgroundPanel.setLayout(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.insets = new Insets(5, 5, 5, 5);
        JPanel configurePanel = new JPanel();
        configurePanel.setBackground(this.frameBackgroundColor);
        configurePanel.setLayout(new GridBagLayout());
        configurePanel.setRequestFocusEnabled(true);
        GridBagConstraints cc = new GridBagConstraints();
        JPanel radButtonPanel = this.createRadioButtonPanel();
        cc.insets = new Insets(10, 10, 10, 10);
        cc.anchor = 11;
        cc.fill = 1;
        cc.gridx = 0;
        cc.gridy = 0;
        cc.gridheight = 1;
        cc.gridwidth = 1;
        cc.weightx = 0.0;
        cc.weighty = 0.0;
        configurePanel.add((Component)radButtonPanel, cc);
        bc.fill = 0;
        bc.anchor = 11;
        bc.gridx = 0;
        bc.gridy = 0;
        bc.gridheight = 1;
        bc.gridwidth = 1;
        bc.weightx = 0.0;
        bc.weighty = 1.0;
        backgroundPanel.add((Component)configurePanel, bc);
        this.liftChartPanel = this.createLiftChartPanel(0);
        bc.fill = 1;
        cc.insets = new Insets(2, 2, 2, 2);
        bc.gridx = 1;
        bc.gridy = 0;
        bc.gridheight = 1;
        bc.gridwidth = 3;
        bc.weightx = 1.0;
        bc.weighty = 1.0;
        backgroundPanel.add((Component)((Object)this.liftChartPanel), bc);
        this.getContentPane().add((Component)backgroundPanel, "Center");
    }

    protected void handleAboutBox() {
        LiftChartFrame_AboutBox lcfab = new LiftChartFrame_AboutBox();
        Dimension lcfabSize = lcfab.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        lcfab.setLocation((frmSize.width - lcfabSize.width) / 2 + loc.x, (frmSize.height - lcfabSize.height) / 2 + loc.y);
        lcfab.setModal(true);
        lcfab.show();
    }

    protected void handleHelp() {
    }

    private JPanel createRadioButtonPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(this.frameBackgroundColor);
        panel.setRequestFocusEnabled(true);
        GridLayout rbgl = new GridLayout(4, 1);
        panel.setLayout(rbgl);
        rbgl.setHgap(2);
        JLabel buttonTitle = new JLabel(LiftChartBuilder.getText("liftChartFrame_rad_button_title"));
        buttonTitle.setBackground(this.frameBackgroundColor);
        buttonTitle.setForeground(this.frameLabelColor);
        buttonTitle.setFont(labelFont);
        this.cumGainRadButton = new JRadioButton();
        this.cumGainRadButton.setActionCommand(Integer.toString(0));
        this.cumGainRadButton.addActionListener(this);
        this.cumGainRadButton.setText(LiftChartBuilder.getText("liftChartFrame_cum_gain"));
        this.cumGainRadButton.setBackground(this.frameBackgroundColor);
        this.cumGainRadButton.setSelected(true);
        this.cumGainRadButton.setRequestFocusEnabled(true);
        this.liftRadButton = new JRadioButton();
        this.liftRadButton.setActionCommand(Integer.toString(1));
        this.liftRadButton.addActionListener(this);
        this.liftRadButton.setText(LiftChartBuilder.getText("liftChartFrame_lift"));
        this.liftRadButton.setBackground(this.frameBackgroundColor);
        this.liftRadButton.setRequestFocusEnabled(true);
        this.rocRadButton = new JRadioButton();
        this.rocRadButton.setActionCommand(Integer.toString(2));
        this.rocRadButton.addActionListener(this);
        this.rocRadButton.setText(LiftChartBuilder.getText("liftChartFrame_roc"));
        this.rocRadButton.setBackground(this.frameBackgroundColor);
        this.rocRadButton.setRequestFocusEnabled(true);
        this.bg = new ButtonGroup();
        this.bg.add(this.cumGainRadButton);
        this.bg.add(this.liftRadButton);
        this.bg.add(this.rocRadButton);
        panel.add((Component)buttonTitle, null);
        panel.add((Component)this.cumGainRadButton, null);
        panel.add((Component)this.liftRadButton, null);
        panel.add((Component)this.rocRadButton, null);
        return panel;
    }

    private JPanel createCostMatrixPanel() {
        JPanel outerpanel = new JPanel();
        outerpanel.setBackground(this.frameBackgroundColor);
        outerpanel.setLayout(new GridBagLayout());
        GridBagConstraints oc = new GridBagConstraints();
        oc.insets = new Insets(5, 0, 5, 0);
        JLabel conMatLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_confusion_matrix_title"));
        conMatLabel.setBackground(this.frameBackgroundColor);
        conMatLabel.setForeground(this.frameLabelColor);
        conMatLabel.setFont(labelFont);
        oc.anchor = 13;
        oc.fill = 1;
        oc.gridx = 0;
        oc.gridy = 0;
        oc.gridheight = 1;
        oc.gridwidth = 1;
        oc.weightx = 1.0;
        oc.weighty = 0.0;
        outerpanel.add((Component)conMatLabel, oc);
        JLabel predictedLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_confusion_matrix_pred"));
        predictedLabel.setBackground(this.frameBackgroundColor);
        predictedLabel.setForeground(this.frameLabelColor);
        predictedLabel.setFont(tinyFont);
        oc.insets = new Insets(0, 0, 0, 0);
        oc.anchor = 13;
        oc.fill = 0;
        oc.gridx = 0;
        oc.gridy = 1;
        oc.gridheight = 1;
        oc.gridwidth = 1;
        oc.weightx = 1.0;
        oc.weighty = 0.0;
        outerpanel.add((Component)predictedLabel, oc);
        JPanel panel = new JPanel();
        panel.setBackground(this.frameBackgroundColor);
        panel.setBorder(BorderFactory.createLineBorder(this.frameLabelColor));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JPanel cornerPanel = new JPanel();
        cornerPanel.setBackground(this.frameBackgroundColor);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)cornerPanel, c);
        JLabel topYesLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_yes"));
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add((Component)topYesLabel, c);
        JLabel topNoLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_no"));
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add((Component)topNoLabel, c);
        JLabel sideYesLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_yes"));
        c.insets = new Insets(2, 0, 2, 0);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add((Component)sideYesLabel, c);
        JLabel sideNoLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_no"));
        c.insets = new Insets(2, 0, 5, 0);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        panel.add((Component)sideNoLabel, c);
        JPanel costMatrixPanel = this.createCostMatrix();
        costMatrixPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        c.fill = 1;
        c.insets = new Insets(2, 2, 5, 5);
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)costMatrixPanel, c);
        oc.fill = 1;
        oc.gridx = 0;
        oc.gridy = 2;
        oc.gridheight = 1;
        oc.gridwidth = 1;
        oc.weightx = 0.0;
        oc.weighty = 0.0;
        outerpanel.add((Component)panel, oc);
        JLabel actualLabel = new JLabel(LiftChartBuilder.getText("liftChartFrame_confusion_matrix_act"));
        actualLabel.setBackground(this.frameBackgroundColor);
        actualLabel.setForeground(this.frameLabelColor);
        actualLabel.setFont(tinyFont);
        oc.insets = new Insets(0, 0, 0, 0);
        oc.anchor = 17;
        oc.fill = 0;
        oc.gridx = 0;
        oc.gridy = 3;
        oc.gridheight = 1;
        oc.gridwidth = 1;
        oc.weightx = 1.0;
        oc.weighty = 0.0;
        outerpanel.add((Component)actualLabel, oc);
        return outerpanel;
    }

    public void actionPerformed(ActionEvent e) {
        ButtonModel bm = this.bg.getSelection();
        if (e.getActionCommand().equals("apply")) {
            this.switchChart(Integer.parseInt(bm.getActionCommand()));
            this.applyButton.setEnabled(false);
            this.costMatrixYYTextField.setBackground(Color.white);
            this.costMatrixYNTextField.setBackground(Color.white);
            this.costMatrixNYTextField.setBackground(Color.white);
            this.costMatrixNNTextField.setBackground(Color.white);
            this.repaint();
        } else if (e.getActionCommand().equals("0") || e.getActionCommand().equals("1") || e.getActionCommand().equals("2")) {
            if (e.getActionCommand().equals(Integer.toString(this.currentChartType))) {
                return;
            }
            this.switchChart(Integer.parseInt(bm.getActionCommand()));
            this.repaint();
        }
    }

    public JPanel createCostMatrix() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        this.costMatrixYYTextField = new JTextField("1.0");
        this.costMatrixYNTextField = new JTextField("0.0");
        this.costMatrixNYTextField = new JTextField("0.0");
        this.costMatrixNNTextField = new JTextField("1.0");
        this.costMatrixYYTextField.setEditable(false);
        this.costMatrixYNTextField.setEditable(false);
        this.costMatrixNYTextField.setEditable(false);
        this.costMatrixNNTextField.setEditable(false);
        this.costMatrixYYTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                ActionEvent ae = new ActionEvent(this, 1001, "yyfield");
                LiftChartFrame.this.costMatrixYYTextField.setBackground(LiftChartFrame.this.liftChartUpdateColor);
                LiftChartFrame.this.actionPerformed(ae);
                LiftChartFrame.this.applyButton.setEnabled(true);
            }
        });
        this.costMatrixYNTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                ActionEvent ae = new ActionEvent(this, 1001, "ynfield");
                LiftChartFrame.this.costMatrixYNTextField.setBackground(LiftChartFrame.this.liftChartUpdateColor);
                LiftChartFrame.this.actionPerformed(ae);
                LiftChartFrame.this.applyButton.setEnabled(true);
            }
        });
        this.costMatrixNYTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                ActionEvent ae = new ActionEvent(this, 1001, "nyfield");
                LiftChartFrame.this.costMatrixNYTextField.setBackground(LiftChartFrame.this.liftChartUpdateColor);
                LiftChartFrame.this.actionPerformed(ae);
                LiftChartFrame.this.applyButton.setEnabled(true);
            }
        });
        this.costMatrixNNTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                ActionEvent ae = new ActionEvent(this, 1001, "nnfield");
                LiftChartFrame.this.costMatrixNNTextField.setBackground(LiftChartFrame.this.liftChartUpdateColor);
                LiftChartFrame.this.actionPerformed(ae);
                LiftChartFrame.this.applyButton.setEnabled(true);
            }
        });
        panel.add(this.costMatrixYYTextField);
        panel.add(this.costMatrixYNTextField);
        panel.add(this.costMatrixNYTextField);
        panel.add(this.costMatrixNNTextField);
        return panel;
    }

    public double[] getCostValues() {
        double[] array = new double[4];
        boolean numsOK = true;
        try {
            array[0] = Double.parseDouble(this.costMatrixYYTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.costMatrixYYTextField.setText("1.0");
            numsOK = false;
        }
        try {
            array[1] = Double.parseDouble(this.costMatrixYNTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.costMatrixYNTextField.setText("1.0");
            numsOK = false;
        }
        try {
            array[2] = Double.parseDouble(this.costMatrixNYTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.costMatrixNYTextField.setText("1.0");
            numsOK = false;
        }
        try {
            array[3] = Double.parseDouble(this.costMatrixNNTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.costMatrixNNTextField.setText("1.0");
            numsOK = false;
        }
        this.costMatrixYYTextField.requestFocus();
        if (!numsOK) {
            return this.getCostValues();
        }
        return array;
    }

    private InsLiftChartPanel createLiftChartPanel(int chartType) {
        JFreeChart chart = this.createChart(chartType);
        InsLiftChartPanel panel = new InsLiftChartPanel(this, chart, 300, 300, 300.0, 300.0, true, true, true, true, true, true);
        panel.setPreferredSize(new Dimension(300, 300));
        panel.setMinimumSize(new Dimension(300, 300));
        panel.setBackground(this.chartBackgroundColor);
        panel.setBorder(BorderFactory.createLineBorder(this.chartBorderColor));
        return panel;
    }

    private JFreeChart createChart(int chartType) {
        this.currentChartType = chartType;
        String[] labels = this.getChartLabels(chartType);
        String xAxisLabel = labels[0];
        String yAxisLabel = labels[1];
        String title = labels[2];
        XYDataset[] datasets = this.liftChartBuilder.createDatasets(chartType);
        int numGraphs = datasets.length;
        CombinedDataset data = new CombinedDataset();
        XYDataset refLineDataset = this.liftChartBuilder.buildRefDataset(chartType);
        ((DefaultXYDataset)refLineDataset).setSeriesNames(new String[]{"Reference Line"});
        data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)refLineDataset, 0));
        for (int i = 0; i < numGraphs; ++i) {
            XYDataset dataset = datasets[i];
            ((DefaultXYDataset)dataset).setSeriesNames(this.getDatasetName(i));
            data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)dataset, 0));
        }
        JFreeChart chart = null;
        double verticalMin = 0.0;
        if (this.liftChartBuilder.getMaxLiftChartVal() < 2.0) {
            verticalMin = 0.5;
        }
        try {
            HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
            VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
            if (chartType == 0) {
                yAxis.setAxisRange(0.01, 100.0);
                xAxis.setAxisRange(0.01, 100.0);
                xAxis.setStandardTickUnits(this.createCumGainTickUnits());
                yAxis.setStandardTickUnits(this.createCumGainTickUnits());
            } else if (chartType == 1) {
                yAxis.setAxisRange(verticalMin, 1.0);
                xAxis.setAxisRange(0.0, 100.0);
                xAxis.setStandardTickUnits(this.createCumGainTickUnits());
                yAxis.setStandardTickUnits(this.createLiftTickUnits());
            } else if (chartType == 2) {
                yAxis.setAxisRange(0.0, 100.0);
                xAxis.setAxisRange(0.0, 100.0);
                xAxis.setStandardTickUnits(this.createROCTickUnits());
                yAxis.setStandardTickUnits(this.createROCTickUnits());
            }
            xAxis.setGridPaint((Paint)ColorBroker.getColor("chartBorderColor"));
            yAxis.setGridPaint((Paint)ColorBroker.getColor("chartBorderColor"));
            yAxis.setLabelInsets(new Insets(0, 0, 0, 10));
            CombinedPlot overlaidPlot = new CombinedPlot((Axis)xAxis, (Axis)yAxis);
            overlaidPlot.setInsets(new Insets(2, 2, 5, 15));
            for (int i = 0; i < numGraphs + 1; ++i) {
                CombinedChart cc = ChartFactory.createCombinableXYChart((ValueAxis)xAxis, (ValueAxis)yAxis, (Dataset)new SubSeriesDataset((SeriesDataset)data, i));
                overlaidPlot.add(cc);
            }
            overlaidPlot.adjustPlots();
            overlaidPlot.setSeriesPaint(this.getChartColors());
            chart = new JFreeChart((Dataset)data, (Plot)overlaidPlot, title, JFreeChart.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        TextTitle subtitle = new TextTitle("Overlaid Charts", new Font("SansSerif", 1, 12));
        chart.addTitle((AbstractTitle)subtitle);
        chart.setBackgroundPaint((Paint)this.chartBackgroundColor);
        return chart;
    }

    private String[] getDatasetName(int i) {
        String[] s = new String[]{this.liftChartBuilder.getInputName(i)};
        return s;
    }

    private Paint[] getChartColors() {
        Paint[] paints = new Paint[11];
        paints[0] = ColorBroker.getColor("liftChartReferenceLineColor");
        for (int i = 1; i < 11; ++i) {
            paints[i] = ColorBroker.getSeriesColor(i - 1);
        }
        return paints;
    }

    private String[] getChartLabels(int chartType) {
        String[] s = new String[3];
        switch (chartType) {
            case 0: {
                s[0] = LiftChartBuilder.getText("liftChartFrame_cum_gain_xlabel");
                s[1] = LiftChartBuilder.getText("liftChartFrame_cum_gain_ylabel");
                s[2] = LiftChartBuilder.getText("liftChartFrame_cum_gain");
                break;
            }
            case 1: {
                s[0] = LiftChartBuilder.getText("liftChartFrame_lift_xlabel");
                s[1] = LiftChartBuilder.getText("liftChartFrame_lift_ylabel");
                s[2] = LiftChartBuilder.getText("liftChartFrame_lift");
                break;
            }
            case 2: {
                s[0] = LiftChartBuilder.getText("liftChartFrame_roc_xlabel");
                s[1] = LiftChartBuilder.getText("liftChartFrame_roc_ylabel");
                s[2] = LiftChartBuilder.getText("liftChartFrame_roc");
                break;
            }
            default: {
                s[0] = "";
                s[1] = "";
                s[2] = "";
            }
        }
        return s;
    }

    private void switchChart(int chartType) {
        JFreeChart chart = this.createChart(chartType);
        this.liftChartPanel.setChart(chart);
        this.liftChartPanel.repaint();
    }

    private TickUnits createROCTickUnits() {
        TickUnits units = new TickUnits();
        units.add((TickUnit)new NumberTickUnit((Number)new Double(0.1), (NumberFormat)new DecimalFormat("0.0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1L), (NumberFormat)new DecimalFormat("0.0")));
        return units;
    }

    private TickUnits createCumGainTickUnits() {
        TickUnits units = new TickUnits();
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100L), (NumberFormat)new DecimalFormat("0")));
        return units;
    }

    private TickUnits createLiftTickUnits() {
        TickUnits units = new TickUnits();
        units.add((TickUnit)new NumberTickUnit((Number)new Double(0.1), (NumberFormat)new DecimalFormat("0.0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Double(0.5), (NumberFormat)new DecimalFormat("0.0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1000L), (NumberFormat)new DecimalFormat("0")));
        return units;
    }
}

