/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

public class MessagePaneTransferHandler
extends TransferHandler {
    public MessagePaneTransferHandler(String property) {
        super(property);
    }

    public MessagePaneTransferHandler() {
    }

    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTextPane) {
            return new TextTransferable((JTextPane)c);
        }
        return super.createTransferable(c);
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    class TextTransferable
    implements Transferable,
    UIResource {
        private DataFlavor[] plainFlavors = this.createPlainFlavors();
        private JTextPane m_c;

        public TextTransferable(JTextPane c) {
            this.m_c = c;
        }

        private DataFlavor[] createPlainFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor("text/plain;class=java.lang.String")};
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.plainFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(data);
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = this.plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected String getPlainData() {
            if (this.m_c == null) {
                return "";
            }
            String text = this.m_c.getSelectedText();
            if (text == null) {
                return "";
            }
            StringBuffer result = new StringBuffer(text);
            return result.toString();
        }
    }
}

