/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MissingValuesEngineNode;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.PlainDocument;

public class MissingValuesDialog
extends NodeDialog {
    public static String EMPTY_STRING = "";
    private static int NAME_COLUMN = 0;
    private static int METHOD_COLUMN = 1;
    private static int NANSTR_COLUMN = 2;
    private static int KEY_COLUMN = 3;
    private HashMap m_hashMap;
    private NodeDialog.DialogTable m_table;
    private MVTableModel m_tableModel;
    private NodeDialog.TableSorter m_sortingModel;
    private JButton m_selectAllTableRows;
    private JComboBox m_selectMethod;
    private JTextField m_missingString;
    private JButton m_setMethod;
    private JButton m_setKey;
    private JButton m_setMissingString;
    private JComboBox m_selectKey;
    private static String[] m_guiTypes = MissingValuesDialog.getGuiTypes(MissingValuesEngineNode.m_methodTypes);
    private Vector m_categoricalColumns = new Vector();
    private static MissingValuesDialog instance = null;

    public static MissingValuesDialog getInstance() {
        if (instance == null) {
            instance = new MissingValuesDialog();
        }
        return instance;
    }

    private MissingValuesDialog() {
        Dimension min = new Dimension(525, 400);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.restoreOptionsPanel(props);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.saveOptionsPanel(props);
    }

    public JPanel createOptionsPanel() {
        return this.newCreateOptionsPanel();
    }

    public static String[] getGuiTypes(String[] array) {
        String[] output = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = MinerApp.getText("MissingValuesDialog_" + array[i]);
        }
        return output;
    }

    public String convertArrayToArray(String val, String[] from, String[] to) {
        int index = -1;
        for (int i = 0; index < 0 && i < from.length; ++i) {
            if (!val.equals(from[i])) continue;
            index = i;
        }
        if (index < 0 || index >= to.length) {
            return "";
        }
        return to[index];
    }

    protected void restoreOptionsPanel(XTProps props) {
        this.m_tableModel.clearTable();
        this.m_categoricalColumns.removeAllElements();
        this.m_selectKey.removeAllItems();
        XTMetaData md = null;
        try {
            md = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector allColumns = md.getColumnNames();
        this.m_categoricalColumns.add(EMPTY_STRING);
        Object[] row = new Object[4];
        String[] path = new String[]{"columns", "", ""};
        for (int i = 0; i < md.getNumColumns(); ++i) {
            path[1] = (String)allColumns.get(i);
            row[0] = new NodeDialog.ColumnInformationObject(path[1], md.getColumnType(path[1]), md.getColumnRole(path[1]), false, i);
            path[2] = "methodType";
            row[1] = props.getValue(path, MissingValuesEngineNode.m_methodTypes[0]);
            row[1] = this.convertArrayToArray((String)row[1], MissingValuesEngineNode.m_methodTypes, m_guiTypes);
            path[2] = "nanString";
            row[2] = props.getValue(path, "");
            path[2] = "key";
            row[3] = props.getValue(path, "");
            this.m_tableModel.addRow(row);
            if (!md.isCategoricalColumn(i)) continue;
            this.m_categoricalColumns.add(path[1]);
        }
        Vector oldProperties = props.getSubProperties("outgoingColumns");
        String oldType = props.getValue("method");
        String[] constants = new String[]{props.getValue("numericConstant", ""), props.getValue("categoricalConstant", ""), props.getValue("dateConstant", ""), props.getValue("stringConstant", "")};
        for (int i = 0; i < oldProperties.size(); ++i) {
            String colName = (String)oldProperties.get(i);
            int colNum = md.nameToOrdinal(colName);
            if (colNum <= -1) continue;
            String newType = this.convertArrayToArray(oldType, MissingValuesEngineNode.m_methodTypes, m_guiTypes);
            this.m_table.setValueAt(newType, colNum, 1);
            int type = 0;
            if (md.isCategoricalColumn(colNum)) {
                type = 1;
            } else if (md.isDateTimeColumn(colNum)) {
                type = 2;
            } else if (md.isStringColumn(colNum)) {
                type = 3;
            }
            this.m_table.setValueAt(constants[type], colNum, 2);
        }
        Object[] array = this.m_categoricalColumns.toArray();
        JComboBox<Object> cb = new JComboBox<Object>(array);
        this.m_table.getColumnModel().getColumn(KEY_COLUMN).setCellEditor(new DefaultCellEditor(cb));
        for (int i = 0; i < array.length; ++i) {
            this.m_selectKey.addItem(array[i]);
        }
    }

    protected void saveOptionsPanel(XTProps props) {
        String[] delProp = new String[]{"columns"};
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        props.removeProperty(delProp);
        delProp[0] = "outgoingColumns";
        props.removeProperty(delProp);
        delProp[0] = "method";
        props.removeProperty(delProp);
        delProp[0] = "numericConstant";
        props.removeProperty(delProp);
        delProp[0] = "categoricalConstant";
        props.removeProperty(delProp);
        delProp[0] = "dateConstant";
        props.removeProperty(delProp);
        delProp[0] = "stringConstant";
        props.removeProperty(delProp);
        String[] path = new String[]{"columns", "", ""};
        int numRows = this.m_table.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            path[1] = ((NodeDialog.ColumnInformationObject)this.m_table.getValueAt(i, NAME_COLUMN)).getText();
            String method = (String)this.m_table.getValueAt(i, METHOD_COLUMN);
            method = this.convertArrayToArray(method, m_guiTypes, MissingValuesEngineNode.m_methodTypes);
            path[2] = "methodType";
            props.set(path, method);
            String missingString = (String)this.m_table.getValueAt(i, NANSTR_COLUMN);
            path[2] = "nanString";
            props.set(path, missingString);
            String keyColumn = (String)this.m_table.getValueAt(i, KEY_COLUMN);
            if (keyColumn.equals(EMPTY_STRING)) continue;
            path[2] = "key";
            props.set(path, keyColumn);
        }
    }

    protected JPanel newCreateOptionsPanel() {
        this.m_selectAllTableRows = new JButton(new AbstractAction(MinerApp.getText("MissingValuesDialog_selectAll")){

            public void actionPerformed(ActionEvent e) {
                MissingValuesDialog.this.m_table.selectAll();
            }
        });
        this.m_selectAllTableRows.setMnemonic(MinerApp.getText("MissingValuesDialog_selectAllHotkey").charAt(0));
        this.m_hashMap = new HashMap();
        this.m_tableModel = new MVTableModel();
        this.m_tableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("MissingValuesDialog_columnName"), MinerApp.getText("MissingValuesDialog_method"), MinerApp.getText("MissingValuesDialog_replacement"), MinerApp.getText("MissingValuesDialog_keyColumn")});
        this.m_sortingModel = new NodeDialog.TableSorter(this.m_tableModel){

            public int compareRowsByColumn(int row1, int row2, int column) {
                TableModel data = this.tableModel;
                Object o1 = data.getValueAt(row1, column);
                Object o2 = data.getValueAt(row2, column);
                if (column == NAME_COLUMN) {
                    String str1 = ((NodeDialog.ColumnInformationObject)o1).getText();
                    String str2 = ((NodeDialog.ColumnInformationObject)o2).getText();
                    return str1.compareTo(str2);
                }
                String str1 = o1.toString();
                String str2 = o2.toString();
                return str1.compareTo(str2);
            }
        };
        this.m_table = new NodeDialog.DialogTable(this.m_sortingModel);
        JScrollPane sp = new JScrollPane(this.m_table);
        this.m_sortingModel.addMouseListenerToHeaderInTable(this.m_table);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setRowHeight(25);
        JComboBox<String> cb = new JComboBox<String>(m_guiTypes);
        DefaultCellEditor dce = new DefaultCellEditor(cb){
            String[] fullList;
            {
                this.fullList = m_guiTypes;
            }

            public Component getTableCellEditorComponent(JTable table, Object val, boolean sel, int row, int col) {
                String type = ((NodeDialog.ColumnInformationObject)table.getValueAt(row, NAME_COLUMN)).getType();
                JComboBox cb = (JComboBox)this.editorComponent;
                int numElements = cb.getItemCount();
                if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    if (numElements == this.fullList.length) {
                        cb.removeItemAt(MissingValuesEngineNode.REPL_MEANS);
                        cb.removeItemAt(MissingValuesEngineNode.REPL_DISTR);
                    }
                } else if (numElements != this.fullList.length) {
                    cb.removeAllItems();
                    for (int i = 0; i < this.fullList.length; ++i) {
                        cb.addItem(this.fullList[i]);
                    }
                }
                return super.getTableCellEditorComponent(table, val, sel, row, col);
            }
        };
        this.m_table.getColumnModel().getColumn(NAME_COLUMN).setCellRenderer(new TableColumnInformationRenderer());
        this.m_table.getColumnModel().getColumn(METHOD_COLUMN).setCellEditor(dce);
        this.m_table.getColumnModel().getColumn(NANSTR_COLUMN).setCellEditor(new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable table, Object val, boolean sel, int row, int col) {
                JTextField tf = (JTextField)super.getTableCellEditorComponent(table, val, sel, row, col);
                NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)table.getValueAt(row, NAME_COLUMN);
                String type = obj.getType();
                PlainDocument doc = null;
                doc = type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) ? new NodeDialog.InputAllDoubleDoc() : new PlainDocument();
                tf.setDocument(doc);
                tf.setText(val.toString());
                return tf;
            }
        });
        this.m_table.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
        this.m_missingString = new JTextField(10);
        this.m_selectMethod = new JComboBox<String>(m_guiTypes);
        this.m_selectKey = new JComboBox();
        JLabel methodLabel = new JLabel(MinerApp.getText("MissingValuesDialog_selectMethod"));
        methodLabel.setLabelFor(this.m_selectMethod);
        methodLabel.setDisplayedMnemonic(MinerApp.getText("MissingValuesDialog_selectMethodHotkey").charAt(0));
        JLabel nanStrLabel = new JLabel(MinerApp.getText("MissingValuesDialog_replaceMissingValue"));
        nanStrLabel.setLabelFor(this.m_missingString);
        nanStrLabel.setDisplayedMnemonic(MinerApp.getText("MissingValuesDialog_replaceMissingValueHotkey").charAt(0));
        JLabel keyLabel = new JLabel(MinerApp.getText("MissingValuesDialog_selectKey"));
        keyLabel.setLabelFor(this.m_selectKey);
        keyLabel.setDisplayedMnemonic(MinerApp.getText("MissingValuesDialog_selectKeyHotkey").charAt(0));
        this.m_setMethod = new JButton(new AbstractAction(MinerApp.getText("MissingValuesDialog_setMethod")){

            public void actionPerformed(ActionEvent e) {
                int[] rows = MissingValuesDialog.this.m_table.getSelectedRows();
                String val = (String)MissingValuesDialog.this.m_selectMethod.getSelectedItem();
                StringBuffer errCols = new StringBuffer();
                for (int i = 0; i < rows.length; ++i) {
                    NodeDialog.ColumnInformationObject ci = (NodeDialog.ColumnInformationObject)MissingValuesDialog.this.m_table.getValueAt(rows[i], NAME_COLUMN);
                    String type = ci.getType();
                    if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) && (val.equals(m_guiTypes[MissingValuesEngineNode.REPL_DISTR]) || val.equals(m_guiTypes[MissingValuesEngineNode.REPL_MEANS]))) {
                        if (errCols.length() != 0) {
                            errCols.append(", ");
                        }
                        errCols.append(ci.getText());
                        continue;
                    }
                    MissingValuesDialog.this.m_table.setValueAt(val, rows[i], METHOD_COLUMN);
                }
                if (errCols.length() != 0) {
                    String msg = "String columns (" + errCols.toString() + ") cannot use certain methods:\n\t" + m_guiTypes[MissingValuesEngineNode.REPL_MEANS] + "\n\t" + m_guiTypes[MissingValuesEngineNode.REPL_DISTR];
                    AcceleratorOptionPane.showOKDialog(MissingValuesDialog.this, msg);
                }
            }
        });
        this.m_setMethod.setMnemonic(MinerApp.getText("MissingValuesDialog_setMethodHotkey").charAt(0));
        this.m_setMissingString = new JButton(new AbstractAction(MinerApp.getText("MissingValuesDialog_setReplacement")){

            public void actionPerformed(ActionEvent e) {
                int[] rows = MissingValuesDialog.this.m_table.getSelectedRows();
                String val = MissingValuesDialog.this.m_missingString.getText();
                for (int i = 0; i < rows.length; ++i) {
                    MissingValuesDialog.this.m_table.setValueAt(val, rows[i], NANSTR_COLUMN);
                }
            }
        });
        this.m_setMissingString.setMnemonic(MinerApp.getText("MissingValuesDialog_setReplacementHotkey").charAt(0));
        this.m_setKey = new JButton(new AbstractAction(MinerApp.getText("MissingValuesDialog_setKey")){

            public void actionPerformed(ActionEvent e) {
                int[] rows = MissingValuesDialog.this.m_table.getSelectedRows();
                String val = (String)MissingValuesDialog.this.m_selectKey.getSelectedItem();
                for (int i = 0; i < rows.length; ++i) {
                    MissingValuesDialog.this.m_table.setValueAt(val, rows[i], KEY_COLUMN);
                }
            }
        });
        this.m_setKey.setMnemonic(MinerApp.getText("MissingValuesDialog_setKeyHotkey").charAt(0));
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(this.m_selectAllTableRows);
        gbc.gridwidth = 0;
        optionsPanel.add((Component)p, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)sp, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        optionsPanel.add((Component)methodLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.m_selectMethod, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)this.m_setMethod, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        optionsPanel.add((Component)nanStrLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.m_missingString, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)this.m_setMissingString, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        optionsPanel.add((Component)keyLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.m_selectKey, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)this.m_setKey, gbc);
        return optionsPanel;
    }

    private class TableColumnInformationRenderer
    extends NodeDialog.ColumnInformationRenderer
    implements TableCellRenderer {
        private JList list = new JList();

        private TableColumnInformationRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.getListCellRendererComponent(this.list, value, row, isSelected, hasFocus);
            return comp;
        }
    }

    private class MVTableModel
    extends DefaultTableModel {
        private MVTableModel() {
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int row, int col) {
            return col != NAME_COLUMN;
        }
    }
}

