/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.NaiveBayesPredictor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class NaiveBayesEngineNode
extends EngineNode {
    public static String NAIVE_BAYES_NODE_TAG = "NaiveBayesModel";
    public static String COLUMN_ROLES_ATTRIBUTE_TAG = "columnRoles";
    public static String DEPENDENT_COLUMN_ATTRIBUTE_TAG = "dependentColumn";
    public static String COUNTS_ATTRIBUTE_TAG = "counts";
    public static String TOTAL_ATTRIBUTE_TAG = "total";
    public static String NAN_STRING = "NaN";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVar, indepVars);
        return outputSpecs;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }

    public boolean executeDataCacheProc() throws Exception {
        boolean propsValid;
        XTMetaData metaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        String inputFilename = this.getInputDataCacheFileName(0);
        XTProps nodeCache = new XTProps();
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        Vector<String> indepColumns = new Vector<String>();
        String depColumn = "";
        Vector columnNames = props.getSubProperties(COLUMN_ROLES_ATTRIBUTE_TAG);
        Vector columnRoles = props.getSubPropertyValues(COLUMN_ROLES_ATTRIBUTE_TAG);
        boolean bl = propsValid = columnRoles.indexOf(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) != -1 && columnRoles.indexOf(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) != -1;
        if (!propsValid) {
            int totalColumnCount = metaData.getNumColumns();
            for (int i = 0; i < totalColumnCount; ++i) {
                if (!metaData.isCategoricalColumn(i)) continue;
                String colName = metaData.ordinalToName(i);
                String role = metaData.getColumnRole(i);
                if (depColumn.equals("") && role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    depColumn = colName;
                }
                if (!role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
                indepColumns.add(colName);
            }
        } else {
            for (int i = 0; i < columnNames.size(); ++i) {
                if (columnRoles.get(i).equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    String colName = (String)columnNames.get(i);
                    if (metaData.isCategoricalColumn(colName)) {
                        indepColumns.add(colName);
                        continue;
                    }
                    this.printlnWarning(colName + " was ignored.  Naive Bayes does not support continuous independent variables.");
                    continue;
                }
                if (!columnRoles.get(i).equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
                depColumn = (String)columnNames.get(i);
            }
        }
        if (depColumn.equals("")) {
            throw new RuntimeException("The dependent column was not found.");
        }
        int depColumnNum = metaData.nameToOrdinal(depColumn);
        int numIndepColumns = indepColumns.size();
        Vector depLevels = metaData.getCategoricalDataFieldLevels(depColumn);
        depLevels.add(NAN_STRING);
        int numDepLevels = depLevels.size();
        int[] indepColumnNums = new int[numIndepColumns];
        long[][][] counts = new long[numDepLevels][numIndepColumns][];
        long[] dep_counts = new long[numDepLevels];
        Vector[] indepLevels = new Vector[numIndepColumns];
        for (int i = 0; i < numIndepColumns; ++i) {
            String columnName = (String)indepColumns.get(i);
            indepColumnNums[i] = metaData.nameToOrdinal(columnName);
            indepLevels[i] = metaData.getCategoricalDataFieldLevels(columnName);
            if (indepLevels[i].size() == 0) {
                if (metaData.getColumnMissingCount(columnName) == (double)metaData.getNumRows()) {
                    throw new RuntimeException("No valid data for column: " + columnName);
                }
                throw new RuntimeException("Continuous columns (" + columnName + ") are not currently supported for Naive Bayes.");
            }
            indepLevels[i].add(NAN_STRING);
            int numIndepLevels = indepLevels[i].size();
            for (int j = 0; j < numDepLevels; ++j) {
                counts[j][i] = new long[numIndepLevels];
            }
        }
        FileInputStream iStream = new FileInputStream(inputFilename);
        BufferedInputStream iBuffer = new BufferedInputStream(iStream);
        DataInputStream iInputStream = new DataInputStream(iBuffer);
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(metaData);
        long rowCount = metaData.getNumRows();
        for (long curRow = 0L; curRow < rowCount; ++curRow) {
            rowBuf.readRow(iInputStream);
            double depLevel = rowBuf.getDouble(depColumnNum);
            if (Double.isNaN(depLevel)) {
                depLevel = counts.length - 1;
            }
            int n = (int)depLevel;
            dep_counts[n] = dep_counts[n] + 1L;
            for (int i = 0; i < numIndepColumns; ++i) {
                double indepLevel = rowBuf.getDouble(indepColumnNums[i]);
                if (Double.isNaN(indepLevel)) {
                    indepLevel = counts[(int)depLevel][i].length - 1;
                }
                long[] lArray = counts[(int)depLevel][i];
                int n2 = (int)indepLevel;
                lArray[n2] = lArray[n2] + 1L;
            }
            int tempPercentDone = (int)(50.0 * ((double)curRow / (double)rowCount));
            if (this.updateProgressIndicator(tempPercentDone)) continue;
            return false;
        }
        iInputStream.close();
        nodeCache.set(DEPENDENT_COLUMN_ATTRIBUTE_TAG, depColumn);
        String[] dep_path = new String[]{DEPENDENT_COLUMN_ATTRIBUTE_TAG, ""};
        long total = 0L;
        for (int i = 0; i < numDepLevels; ++i) {
            dep_path[1] = (String)depLevels.get(i);
            total += dep_counts[i];
            nodeCache.set(dep_path, Long.toString(dep_counts[i]));
        }
        dep_path[1] = TOTAL_ATTRIBUTE_TAG;
        nodeCache.set(dep_path, Long.toString(total));
        String[] path = new String[4];
        path[0] = COUNTS_ATTRIBUTE_TAG;
        for (int i = 0; i < numIndepColumns; ++i) {
            path[1] = (String)indepColumns.get(i);
            for (int j = 0; j < counts[0][i].length; ++j) {
                path[2] = (String)indepLevels[i].get(j);
                for (int k = 0; k < numDepLevels; ++k) {
                    path[3] = (String)depLevels.get(k);
                    if (counts[k][i][j] <= 0L) continue;
                    nodeCache.set(path, Long.toString(counts[k][i][j]));
                }
            }
            int tempPercentDone = 50 + (int)(49.0 * ((double)i / (double)numIndepColumns));
            if (this.updateProgressIndicator(tempPercentDone)) continue;
            return false;
        }
        XMLTree fullCache = null;
        Element mainElt = null;
        try {
            Element levElt;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            mainElt = doc.createElement(XTNetwork.IMML_NODE_TAG);
            mainElt.setAttribute(XTNetwork.VERSION_ATTRIBUTE_TAG, XTNetwork.CURRENT_VERSION_ATTRIBUTE_TAG);
            fullCache = new XMLTree(mainElt);
            Element headerElt = doc.createElement(XMLTree.HEADER_NODE_TAG);
            mainElt.appendChild(headerElt);
            headerElt.setAttribute(XMLTree.HEADER_COPYRIGHT_ATTRIBUTE_TAG, "Insightful");
            headerElt.setAttribute(XMLTree.HEADER_NAME_ATTRIBUTE_TAG, depColumn);
            Element appElt = doc.createElement(XMLTree.APPLICATION_NODE_TAG);
            headerElt.appendChild(appElt);
            appElt.setAttribute(XMLTree.APPLICATION_NAME_ATTRIBUTE_TAG, "Insightful Miner");
            appElt.setAttribute(XMLTree.APPLICATION_VERSION_ATTRIBUTE_TAG, XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG);
            Element tsElt = doc.createElement(XMLTree.TIMESTAMP_NODE_TAG);
            headerElt.appendChild(tsElt);
            GregorianCalendar now = new GregorianCalendar();
            String nowString = now.get(1) + "/" + this.twoChar(1 + now.get(2)) + "/" + this.twoChar(now.get(5)) + " " + this.twoChar(now.get(11)) + ":" + this.twoChar(now.get(12)) + ":" + this.twoChar(now.get(13));
            Text txtElt = doc.createTextNode(nowString);
            tsElt.appendChild(txtElt);
            Element mdElt = doc.createElement(XTMetaData.META_DATA_NODE_TAG);
            mainElt.appendChild(mdElt);
            Element cdElt = doc.createElement(XTMetaData.DATA_DICTIONARY_NODE_TAG);
            mdElt.appendChild(cdElt);
            cdElt.setAttribute(XTMetaData.FIELD_COUNT_ATTRIBUTE_TAG, Integer.toString(1 + numIndepColumns));
            Element depElt = doc.createElement(XTMetaData.DATA_FIELD_NODE_TAG);
            cdElt.appendChild(depElt);
            depElt.setAttribute(XTMetaData.NAME_ATTRIBUTE_TAG, depColumn);
            depElt.setAttribute(XTMetaData.TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            depElt.setAttribute(XTMetaData.ROLE_ATTRIBUTE_TAG, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
            for (int i = 0; i < numDepLevels - 1; ++i) {
                levElt = doc.createElement(XTMetaData.LEVEL_NODE_TAG);
                depElt.appendChild(levElt);
                levElt.setAttribute(XTMetaData.VALUE_ATTRIBUTE_TAG, depLevels.get(i).toString());
            }
            for (int i = 0; i < numIndepColumns; ++i) {
                Element indepElt = doc.createElement(XTMetaData.DATA_FIELD_NODE_TAG);
                cdElt.appendChild(indepElt);
                indepElt.setAttribute(XTMetaData.NAME_ATTRIBUTE_TAG, indepColumns.get(i).toString());
                indepElt.setAttribute(XTMetaData.TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                indepElt.setAttribute(XTMetaData.ROLE_ATTRIBUTE_TAG, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
                for (int j = 0; j < indepLevels[i].size(); ++j) {
                    levElt = doc.createElement(XTMetaData.LEVEL_NODE_TAG);
                    indepElt.appendChild(levElt);
                    levElt.setAttribute(XTMetaData.VALUE_ATTRIBUTE_TAG, indepLevels[i].get(j).toString());
                }
            }
            Element nbElt = doc.createElement(NAIVE_BAYES_NODE_TAG);
            mainElt.appendChild(nbElt);
            nbElt.appendChild(doc.importNode(nodeCache.getXML(), true));
        }
        catch (Exception e) {
            e.printStackTrace();
            fullCache = null;
        }
        this.setNodeCache("model", fullCache);
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return true;
        }
        this.resetProgressIndicator();
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        NaiveBayesPredictor nbPredictor = new NaiveBayesPredictor(nodeCache, metaData, this);
        nbPredictor.setOutputSpecs(outputSpecs);
        CNKProcJavaTransform proc2 = new CNKProcJavaTransform();
        proc2.setExecObject(nbPredictor);
        this.printlnVerbose("generating prediction from training data.");
        boolean ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    private String twoChar(int val) {
        if (val < 0) {
            return "00";
        }
        if (val < 10) {
            return "0" + val;
        }
        if (val < 100) {
            return "" + val;
        }
        return "00";
    }
}

