/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.SplusCreateColumnsEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.splus.util.StringUtilities;

public class SplusFilterRowsEngineNode
extends EngineNode {
    public static final String INCLUDE_ROWS_ATTRIBUTE_TAG = "includeRows";
    public static final String TEST_EXPRESSION_ATTRIBUTE_TAG = "testExpression";

    public CNKProc procCreate() throws Exception {
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        CNKProcSplusTransform xform = (CNKProcSplusTransform)proc;
        XTProps props = this.getNodeProperties();
        String includeRows = props.getBoolean(INCLUDE_ROWS_ATTRIBUTE_TAG) ? "T" : "F";
        String testExpression = StringUtilities.escapeSpecialCharacters((String)props.getValue(TEST_EXPRESSION_ATTRIBUTE_TAG, "").replace('\n', ' '));
        String splusExpr = "function(x){" + SplusCreateColumnsEngineNode.getEvalDataExpr("evalData", "x", this.getNumInputs()) + "flag <- F;" + "flag <- eval(parse(text=\"" + testExpression + "\"), local=evalData);" + "flag <- as.logical(flag);" + "flag <- rep(flag,len=nrow(x$in1));" + "if (!" + includeRows + ") flag <- !flag;" + "flag[is.na(flag)] <- F;" + "return(list(out1=x$in1[flag, , drop=F]))}";
        xform.setUseComplexTransform(true);
        xform.setTransform(splusExpr);
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            XTMetaData inMD = this.getInputMetaData(0);
            int numColumns = inMD.getNumColumns();
            md = new XTMetaData();
            for (int i = 0; i < numColumns; ++i) {
                String colName = inMD.ordinalToName(i);
                if (inMD.isCategoricalColumn(i)) {
                    md.appendCategoricalDataField(colName, new String[0]);
                } else if (inMD.isStringColumn(i)) {
                    md.appendStringDataField(colName, inMD.getStringDataFieldWidth(i));
                } else if (inMD.isDateTimeColumn(i)) {
                    md.appendDateTimeDataField(colName);
                } else {
                    md.appendContinousDataField(colName);
                }
                md.setDataFieldRole(colName, inMD.getColumnRole(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public String getParseErrors(XTProps props) {
        if (!this.getNetworkManager().isSplusLicensed()) {
            return "S-PLUS Library not installed.  Cannot parse expression.";
        }
        String testExpression = props.getValue(TEST_EXPRESSION_ATTRIBUTE_TAG, "");
        String parseResult = MinerApp.splusParseTest(testExpression);
        if (!parseResult.equals("complete")) {
            if (parseResult.equals("partial")) {
                return "Expression is incomplete.";
            }
            return parseResult;
        }
        return "";
    }
}

