/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ExtensionManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SplusGraphEngineNode;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XTProps;
import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import com.insightful.miner.graphdlg.controls.MinerDataColumnListProvider;
import com.insightful.miner.graphdlg.controls.MinerFunctionInfo;
import com.nwoods.jgo.JGoObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SplusGraphNodeDialog
extends NodeDialog {
    private MinerFunctionInfo m_funcInfo;
    private LocalDataColumnListProvider m_columnListProvider;
    private boolean m_checkRequiredFields = false;
    private boolean m_launchedFromTableView = false;
    private Vector m_deleteOnCloseVector = null;
    private JRadioButton m_allRowsRadioButton;
    private JRadioButton m_maxRowsRadioButton;
    private JTextField m_maxRowsTextField;

    protected SplusGraphNodeDialog() {
        this.chunkTextField.setEnabled(false);
        this.chunkButtons[0].setEnabled(false);
        this.chunkButtons[1].setEnabled(false);
        this.getApplyButton().setVisible(true);
        this.getAddButton().setVisible(true);
        this.pack();
        Dimension rootSize = this.getRootPane().getMinimumSize();
        int paddedHeight = rootSize.height + MinerControlMetrics.getLabelDimension().height * 2;
        int paddedWidth = rootSize.width + 30;
        Dimension paddedSize = new Dimension(paddedWidth, paddedHeight);
        this.setMinimumSize(paddedSize);
        this.setSize(paddedSize);
        this.pack();
    }

    protected MinerFunctionInfo getFunctionInfo() {
        if (this.m_funcInfo == null) {
            this.m_funcInfo = new MinerFunctionInfo();
        }
        return this.m_funcInfo;
    }

    protected MinerDataColumnListProvider getColumnListProvider() {
        if (this.m_columnListProvider == null) {
            this.m_columnListProvider = new LocalDataColumnListProvider(this);
        }
        return this.m_columnListProvider;
    }

    public static SplusGraphNodeDialog getInstance(String dialogClassName) {
        SplusGraphNodeDialog dlg = null;
        try {
            Class cls = ExtensionManager.getClassForName(dialogClassName);
            Method mthd = cls.getMethod("getInstance", new Class[0]);
            dlg = (SplusGraphNodeDialog)mthd.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dlg;
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.m_columnListProvider.refreshColumnList();
        XTProps props = this.getNodeModel().getXTProps();
        this.getFunctionInfo().setValues(props);
        boolean mustSample = false;
        for (int i = 0; i < SplusGraphEngineNode.NODES_REQUIRE_SAMPLING.length; ++i) {
            if (!props.getValue("dialogClass").endsWith(SplusGraphEngineNode.NODES_REQUIRE_SAMPLING[i])) continue;
            mustSample = true;
            break;
        }
        if (mustSample || props.getBoolean("doSample", true)) {
            this.m_maxRowsRadioButton.setSelected(true);
        } else {
            this.m_allRowsRadioButton.setSelected(true);
        }
        if (mustSample) {
            this.m_allRowsRadioButton.setEnabled(false);
        }
        String str = props.getValue("sampleSize", Long.toString(10000L));
        this.m_maxRowsTextField.setText(str);
        this.m_maxRowsTextField.setEnabled(this.m_maxRowsRadioButton.isSelected());
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.getFunctionInfo().updateXTProps(props);
        props.set("doSample", this.m_maxRowsRadioButton.isSelected());
        props.set("sampleSize", this.m_maxRowsTextField.getText());
        this.getNodeModel().setXTProps(props);
    }

    public JPanel getSampleGroup() {
        JPanel blockPanel = new JPanel(new GridBagLayout());
        blockPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_blockPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ActionListener requirementsListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SplusGraphNodeDialog.this.m_maxRowsTextField.setEnabled(SplusGraphNodeDialog.this.m_maxRowsRadioButton.isSelected());
            }
        };
        this.m_allRowsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_allRows"));
        this.m_allRowsRadioButton.setSelected(true);
        this.m_allRowsRadioButton.addActionListener(requirementsListener);
        this.m_maxRowsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_maxRows"));
        this.m_maxRowsRadioButton.setMnemonic('x');
        this.m_maxRowsRadioButton.addActionListener(requirementsListener);
        this.m_maxRowsTextField = new JTextField(10);
        this.m_maxRowsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        ButtonGroup rowHandlingButtons = new ButtonGroup();
        rowHandlingButtons.add(this.m_allRowsRadioButton);
        rowHandlingButtons.add(this.m_maxRowsRadioButton);
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 15, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = none;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        blockPanel.add((Component)this.m_maxRowsRadioButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        blockPanel.add((Component)this.m_allRowsRadioButton, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        blockPanel.add((Component)this.m_maxRowsTextField, constraints);
        return blockPanel;
    }

    public void onOk() {
        if (!this.checkRequiredFields() || this.isComplete()) {
            super.onOk();
        }
        if (this.m_deleteOnCloseVector != null && this.m_deleteOnCloseVector.size() > 0) {
            this.deleteNodes(this.m_deleteOnCloseVector);
        }
    }

    public void onCancel() {
        super.onCancel();
        if (this.m_deleteOnCloseVector != null && this.m_deleteOnCloseVector.size() > 0) {
            this.deleteNodes(this.m_deleteOnCloseVector);
        }
    }

    public void deleteNodes(Vector vec) {
        while (MinerApp.isRunning()) {
            try {
                Thread.yield();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        for (int i = 0; i < vec.size(); ++i) {
            if (!(vec.get(i) instanceof ActivityNodeModel)) continue;
            ActivityNodeModel model = (ActivityNodeModel)vec.get(i);
            BaseNodeArea area = doc.findNodeByID(model.getID());
            for (int j = 0; j < model.getNumInputs(); ++j) {
                BaseNodeArea inputArea = doc.findNodeByID(model.getAParentModel(j).getID());
                doc.removeObject((JGoObject)doc.findLinkByNodes(inputArea, area));
            }
            doc.removeObject((JGoObject)area);
            vec.remove(i);
        }
    }

    public void setDeleteOnClose(ActivityNodeModel nodeModel) {
        if (this.m_deleteOnCloseVector == null) {
            this.m_deleteOnCloseVector = new Vector();
        }
        this.m_deleteOnCloseVector.add(nodeModel);
    }

    public boolean checkRequiredFields() {
        return this.m_checkRequiredFields;
    }

    public void setCheckRequiredFields(boolean doCheck) {
        this.m_checkRequiredFields = doCheck;
    }

    public boolean isComplete() {
        return true;
    }

    public boolean warnIfEmpty(MinerControlMethods field) {
        if (field.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, field.getText() + " " + MinerApp.getText("GraphDialog_msg_fieldRequiresaValue"), MinerApp.getText("GraphDialog_msg_requiredFieldEmpty"), 2);
            return false;
        }
        return true;
    }

    private String[] getMappedColumnNames(String[] origNames) {
        if (origNames == null) {
            return null;
        }
        String[] splusNames = new String[origNames.length];
        for (int i = 0; i < splusNames.length; ++i) {
            splusNames[i] = this.getMappedColumnName(origNames[i]);
        }
        return splusNames;
    }

    private String getMappedColumnName(String str) {
        return str;
    }

    public String[] getColumnList(String type) {
        String[] namesArray;
        if (this.getNodeModel() == null) {
            return new String[]{"<ERROR>"};
        }
        try {
            Vector namesVec = this.getNodeModel().getInputMetaData(0).getDataFieldsWithType(type);
            namesArray = new String[namesVec.size()];
            for (int i = 0; i < namesVec.size(); ++i) {
                namesArray[i] = (String)namesVec.get(i);
            }
        }
        catch (Exception e) {
            namesArray = new String[]{"<ERROR>"};
            e.printStackTrace();
        }
        return this.getMappedColumnNames(namesArray);
    }

    private class LocalDataColumnListProvider
    implements MinerDataColumnListProvider {
        Vector m_controls = new Vector();
        NodeDialog m_nodeDialog = null;
        String[] m_columnList = new String[0];

        public LocalDataColumnListProvider(NodeDialog nodeDialog) {
            this.m_nodeDialog = nodeDialog;
            this.refreshColumnList();
        }

        public String[] getColumnList() {
            return this.m_columnList;
        }

        public void registerColumnControl(MinerControlMethods control) {
            this.m_controls.add(control);
        }

        public void registerColumnControl(MinerControlMethods control, String type) {
            this.m_controls.add(control);
        }

        public void refreshColumnList() {
            if (this.m_nodeDialog.getNodeModel() == null) {
                this.m_columnList = new String[]{"<ERROR>"};
                return;
            }
            try {
                Vector namesVec = this.m_nodeDialog.getNodeModel().getInputMetaData(0).getColumnNames();
                this.m_columnList = new String[namesVec.size()];
                for (int i = 0; i < namesVec.size(); ++i) {
                    this.m_columnList[i] = (String)namesVec.get(i);
                }
            }
            catch (Exception e) {
                this.m_columnList = new String[]{"<ERROR>"};
                e.printStackTrace();
            }
            this.m_columnList = SplusGraphNodeDialog.this.getMappedColumnNames(this.m_columnList);
            for (MinerControlMethods control : this.m_controls) {
                control.setOptionList(this.m_columnList);
            }
        }
    }
}

