/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKSplusDateFormat;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XTProps;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WorksheetPropertiesManager {
    private XTProps m_worksheetProperties;
    private XTProps m_globalProperties;
    private DecimalFormat m_decimalFormat = null;
    private DecimalFormat m_scientificFormat = null;
    private DecimalFormat m_freeDecimalFormat = null;
    private DecimalFormat m_freeScientificDecimalFormat = null;
    private DecimalFormatSymbols m_decimalFormatSymbols = null;
    private CNKSplusDateFormat m_dateFormatter = null;
    private CNKSplusDateFormat m_dateParser = null;
    private static String m_zeroFormat = null;
    public static final String MAX_STRING_SIZE_PROPERTY = "maxStringSize";
    public static final String MAX_CATEGORICAL_LEVELS_PROPERTY = "maxCategoricalLevels";
    public static final String NUM_DIGITS_PROPERTY = "numDigits";
    public static final String STRING_LEFT_ALIGN_PROPERTY = "stringLeftAlign";
    public static final String DATE_PARSE_STRING_PROPERTY = "dateParseString";
    public static final String DATE_FORMAT_STRING_PROPERTY = "dateFormatString";
    public static final String CENTURY_CUTOFF_PROPERTY = "dateCenturyCutoff";
    public static final String OLD_DECIMAL_SEPARATOR_PROPERTY = "decimalSeparator";
    public static final String OLD_THOUSANDS_SEPARATOR_PROPERTY = "thousandsSeparator";
    public static final String DECIMAL_SYMBOLS_PROPERTY = "decimalSymbols";
    public static final String DEFAULT_FILE_DIR_PROPERTY = "defaultFileDir";
    public static final String WSD_DIR_PROPERTY = "wsdDir";
    public static final String MAX_BUFFER_MB_PROPERTY = "maxBufferMB";
    public static final String SPLUS_WORKING_CHAPTER_PROPERTY = "splusWorkingChapter";
    public static final int DEFAULT_NUM_DIGITS_INT = 2;
    public static final boolean DEFAULT_STRING_LEFT_ALIGN = false;
    public static final String DEFAULT_NUM_DIGITS_STRING = "2";
    public static final String DEFAULT_DECIMAL_SEPARATOR = ".";
    public static final String DEFAULT_THOUSANDS_SEPARATOR = ",";
    public static final String DEFAULT_DECIMAL_SYMBOLS = ".,";

    protected WorksheetPropertiesManager() {
        try {
            this.m_worksheetProperties = new XTProps();
            this.m_globalProperties = new XTProps();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static WorksheetPropertiesManager createWPMForDecimalFormat(String decimalSymbols, int decimalPlaces) {
        WorksheetPropertiesManager wpm = new WorksheetPropertiesManager();
        XTProps newProps = null;
        try {
            newProps = new XTProps();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (decimalSymbols == null) {
            decimalSymbols = DEFAULT_DECIMAL_SYMBOLS;
        }
        newProps.set(DECIMAL_SYMBOLS_PROPERTY, decimalSymbols);
        newProps.set(NUM_DIGITS_PROPERTY, decimalPlaces);
        wpm.setWorksheetProperties(newProps);
        return wpm;
    }

    protected WorksheetPropertiesManager copy() {
        WorksheetPropertiesManager wpm = new WorksheetPropertiesManager();
        wpm.setWorksheetProperties(this.m_worksheetProperties);
        wpm.setGlobalProperties(this.m_globalProperties);
        return wpm;
    }

    protected void setWorksheetProperties(XTProps newProps) {
        try {
            if (newProps == null || newProps.equals(this.m_worksheetProperties)) {
                return;
            }
            this.m_worksheetProperties = new XTProps(newProps);
            this.clearFormatObjects();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setGlobalProperties(XTProps newProps) {
        try {
            if (newProps == null || newProps.equals(this.m_globalProperties)) {
                return;
            }
            this.m_globalProperties = new XTProps(newProps);
            this.clearFormatObjects();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getDefaultInt(String propName, int defaultVal) {
        int globalVal = this.m_globalProperties.getInt(propName, defaultVal);
        if (this.m_worksheetProperties.getValue(propName, "").equals("")) {
            return globalVal;
        }
        int localVal = this.m_worksheetProperties.getInt(propName, globalVal);
        return localVal;
    }

    private String getDefaultString(String propName, String defaultVal) {
        String localVal = this.m_worksheetProperties.getValue(propName, "");
        if (localVal.equals("")) {
            String globalVal = this.m_globalProperties.getValue(propName, defaultVal);
            return globalVal;
        }
        return localVal;
    }

    private boolean getDefaultBoolean(String propName, boolean defaultVal) {
        boolean globalVal = this.m_globalProperties.getBoolean(propName, defaultVal);
        if (this.m_worksheetProperties.getValue(propName, "").equals("")) {
            return globalVal;
        }
        boolean localVal = this.m_worksheetProperties.getBoolean(propName, globalVal);
        return localVal;
    }

    public int getDefaultStringSize() {
        int val = this.getDefaultInt(MAX_STRING_SIZE_PROPERTY, 33);
        if (val < 4) {
            val = 4;
        }
        return val;
    }

    public int getMaxCategoricalLevels() {
        int val = this.getDefaultInt(MAX_CATEGORICAL_LEVELS_PROPERTY, 500);
        if (val < 500) {
            val = 500;
        } else if (val > 65534) {
            val = 65534;
        }
        return val;
    }

    public int getNumDigitsInViewers() {
        int val = this.getDefaultInt(NUM_DIGITS_PROPERTY, 2);
        return val;
    }

    public boolean getStringLeftAlignment() {
        boolean val = this.getDefaultBoolean(STRING_LEFT_ALIGN_PROPERTY, false);
        return val;
    }

    public String getDateParseString() {
        String val = this.getDefaultString(DATE_PARSE_STRING_PROPERTY, "%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]");
        return val;
    }

    public String getDateFormatString() {
        String val = this.getDefaultString(DATE_FORMAT_STRING_PROPERTY, "%02m/%02d/%Y %02H:%02M:%02S");
        return val;
    }

    public int getCenturyCutoff() {
        int val = this.getDefaultInt(CENTURY_CUTOFF_PROPERTY, 1950);
        return val;
    }

    private static String getGlobalDecimalSymbols(XTProps props) {
        String globalVal = props.getValue(DECIMAL_SYMBOLS_PROPERTY, "");
        if (globalVal.equals("")) {
            String decimal = props.getValue(OLD_DECIMAL_SEPARATOR_PROPERTY, DEFAULT_DECIMAL_SEPARATOR);
            String comma = props.getValue(OLD_THOUSANDS_SEPARATOR_PROPERTY, DEFAULT_THOUSANDS_SEPARATOR);
            if (decimal.equals("")) {
                decimal = DEFAULT_DECIMAL_SEPARATOR;
            }
            globalVal = decimal.substring(0, 1) + (comma.equals("") ? "" : comma.substring(0, 1));
        }
        return globalVal;
    }

    public String getDecimalSymbols() {
        String localVal = this.m_worksheetProperties.getValue(DECIMAL_SYMBOLS_PROPERTY, "");
        if (localVal.equals("")) {
            String globalVal = WorksheetPropertiesManager.getGlobalDecimalSymbols(this.m_globalProperties);
            return globalVal;
        }
        return localVal;
    }

    public char getDecimalSeparator() {
        String symbols = this.getDecimalSymbols();
        return symbols.charAt(0);
    }

    public char getThousandsSeparator() {
        String symbols = this.getDecimalSymbols();
        return symbols.length() < 2 ? (char)'\u0000' : symbols.charAt(1);
    }

    public boolean getUseThousandsSeparator() {
        return this.getThousandsSeparator() != '\u0000';
    }

    public int getMaxMBPerBlock() {
        int val = this.getDefaultInt(MAX_BUFFER_MB_PROPERTY, 10);
        if (val < 1) {
            val = 1;
        } else if (val > 2147) {
            val = 2147;
        }
        return val;
    }

    public int getMaxRowsPerBlock() {
        int val = this.getDefaultInt("rowsToChunk", 10000);
        return val;
    }

    public boolean getUseCache() {
        String localVal = this.m_worksheetProperties.getValue("useCache", "global");
        if (localVal.equals("yes")) {
            return true;
        }
        if (localVal.equals("no")) {
            return false;
        }
        String globalVal = this.m_globalProperties.getValue("useCache", "yes");
        return !globalVal.equals("no");
    }

    public boolean getFixRandomSeed() {
        String localVal = this.m_worksheetProperties.getValue("randomSeed", "newSeedEveryTime");
        boolean fixSeed = localVal.equals("enterSeed");
        return fixSeed;
    }

    public String getDefaultFileDirectory() {
        String val = this.m_worksheetProperties.getValue(DEFAULT_FILE_DIR_PROPERTY, "");
        return val;
    }

    public String getWSDDirectory() {
        String val = WorksheetPropertiesManager.getWSDDirectoryFromProps(this.m_worksheetProperties);
        return val;
    }

    protected static String getWSDDirectoryFromProps(XTProps props) {
        String val = props.getValue(WSD_DIR_PROPERTY, "");
        return val;
    }

    public String getSplusWorkingChapter() {
        String val = WorksheetPropertiesManager.getSplusWorkingChapterFromProps(this.m_worksheetProperties);
        return val;
    }

    protected static String getSplusWorkingChapterFromProps(XTProps props) {
        String val = props.getValue(SPLUS_WORKING_CHAPTER_PROPERTY, "");
        return val;
    }

    protected void clearFormatObjects() {
        this.m_decimalFormat = null;
        this.m_scientificFormat = null;
        this.m_freeDecimalFormat = null;
        this.m_freeScientificDecimalFormat = null;
        this.m_decimalFormatSymbols = null;
        this.m_dateFormatter = null;
        this.m_dateParser = null;
    }

    public CNKSplusDateFormat getDateFormatter() {
        if (this.m_dateFormatter == null) {
            String dateString = this.getDateFormatString();
            this.m_dateFormatter = new CNKSplusDateFormat(dateString);
            this.m_dateFormatter.setCenturyCutoff(this.getCenturyCutoff());
        }
        return this.m_dateFormatter;
    }

    public CNKSplusDateFormat getDateParser() {
        if (this.m_dateParser == null) {
            String dateString = this.getDateParseString();
            this.m_dateParser = new CNKSplusDateFormat(dateString);
            this.m_dateParser.setCenturyCutoff(this.getCenturyCutoff());
        }
        return this.m_dateParser;
    }

    public String getViewerRoundingPattern() {
        return this.getViewerRoundingObject().toPattern();
    }

    public String getViewerScientificRoundingPattern() {
        return this.getViewerScientificRoundingObject().toPattern();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        if (this.m_decimalFormatSymbols == null) {
            this.m_decimalFormatSymbols = new DecimalFormatSymbols();
            this.m_decimalFormatSymbols.setDecimalSeparator(this.getDecimalSeparator());
            if (this.getUseThousandsSeparator()) {
                this.m_decimalFormatSymbols.setGroupingSeparator(this.getThousandsSeparator());
            }
        }
        return this.m_decimalFormatSymbols;
    }

    public DecimalFormat getViewerRoundingObject() {
        if (this.m_decimalFormat == null) {
            this.m_decimalFormat = new DecimalFormat();
            this.initViewerRoundingObject(this.m_decimalFormat);
        }
        return this.m_decimalFormat;
    }

    protected void initViewerRoundingObject(DecimalFormat rounder) {
        this.initViewerRoundingObject(rounder, this.getNumDigitsInViewers());
    }

    protected void initViewerRoundingObject(DecimalFormat rounder, int decimalPlaces) {
        rounder.setDecimalFormatSymbols(this.getDecimalFormatSymbols());
        if (decimalPlaces < 0) {
            rounder.applyPattern("");
            rounder.setGroupingSize(3);
            rounder.setGroupingUsed(this.getUseThousandsSeparator());
            rounder.setMaximumFractionDigits(16);
        } else {
            StringBuffer pattern = new StringBuffer("#");
            if (this.getUseThousandsSeparator()) {
                pattern.append(",##0");
            } else {
                pattern.append("0");
            }
            if (decimalPlaces > 0) {
                pattern.append(DEFAULT_DECIMAL_SEPARATOR);
            }
            for (int i = 0; i < decimalPlaces; ++i) {
                pattern.append("0");
            }
            rounder.applyPattern(pattern.toString());
        }
    }

    public DecimalFormat getViewerScientificRoundingObject() {
        if (this.m_scientificFormat == null) {
            this.m_scientificFormat = new DecimalFormat();
            this.initViewerScientificRoundingObject(this.m_scientificFormat);
        }
        return this.m_scientificFormat;
    }

    protected void initViewerScientificRoundingObject(DecimalFormat rounder) {
        this.initViewerScientificRoundingObject(rounder, this.getNumDigitsInViewers());
    }

    protected void initViewerScientificRoundingObject(DecimalFormat rounder, int decimalPlaces) {
        rounder.setDecimalFormatSymbols(this.getDecimalFormatSymbols());
        if (decimalPlaces < 0) {
            rounder.applyPattern("");
            rounder.setMaximumFractionDigits(16);
        } else if (decimalPlaces == 0) {
            rounder.applyPattern("0E0");
        } else {
            StringBuffer pattern = null;
            pattern = new StringBuffer("0.");
            for (int i = 0; i < decimalPlaces; ++i) {
                pattern.append("0");
            }
            pattern.append("E0");
            rounder.applyPattern(pattern.toString());
        }
    }

    public DecimalFormat getFreeRoundingObject() {
        if (this.m_freeDecimalFormat == null) {
            this.m_freeDecimalFormat = new DecimalFormat();
            this.initFreeRoundingObject(this.m_freeDecimalFormat);
        }
        return this.m_freeDecimalFormat;
    }

    protected void initFreeRoundingObject(DecimalFormat rounder) {
        rounder.setDecimalFormatSymbols(this.getDecimalFormatSymbols());
        rounder.applyPattern("");
        rounder.setMaximumFractionDigits(16);
        rounder.setMinimumIntegerDigits(1);
        rounder.setGroupingSize(3);
        rounder.setGroupingUsed(this.getUseThousandsSeparator());
    }

    public DecimalFormat getFreeScientificRoundingObject() {
        if (this.m_freeScientificDecimalFormat == null) {
            this.m_freeScientificDecimalFormat = new DecimalFormat();
            this.initFreeScientificRoundingObject(this.m_freeScientificDecimalFormat);
        }
        return this.m_freeScientificDecimalFormat;
    }

    protected void initFreeScientificRoundingObject(DecimalFormat rounder) {
        rounder.setDecimalFormatSymbols(this.getDecimalFormatSymbols());
        rounder.applyPattern("0.########E0");
        rounder.setMaximumFractionDigits(16);
    }

    public double parseDouble(String val) {
        if (val == null || CNKObj.isStringNA(val) || val.equals("")) {
            return CNKObj.getDoubleNA();
        }
        try {
            String val2 = this.getCanonicalDoubleExponent(val);
            Number newVal = this.getViewerRoundingObject().parse(val2);
            return newVal.doubleValue();
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public String formatDouble(double val) {
        String newVal;
        if (CNKObj.isDoubleNA(val)) {
            return CNKObj.getStringNA();
        }
        if (m_zeroFormat == null) {
            m_zeroFormat = this.getViewerRoundingObject().format(0L);
        }
        if (!(newVal = this.getViewerRoundingObject().format(val)).equals(m_zeroFormat) || val == 0.0) {
            return newVal;
        }
        return this.getViewerScientificRoundingObject().format(val);
    }

    public String formatFreeDouble(double val) {
        if (CNKObj.isDoubleNA(val)) {
            return CNKObj.getStringNA();
        }
        double absVal = Math.abs(val);
        if (absVal > 1000000.0 || absVal > 0.0 && absVal < 1.0E-6) {
            return this.getFreeScientificRoundingObject().format(val);
        }
        return this.getFreeRoundingObject().format(val);
    }

    public double parseFreeDouble(String val) {
        if (val == null || CNKObj.isStringNA(val) || val.equals("")) {
            return CNKObj.getDoubleNA();
        }
        try {
            String val2 = this.getCanonicalDoubleExponent(val);
            return this.getFreeRoundingObject().parse(val2).doubleValue();
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private String getCanonicalDoubleExponent(String val) {
        if (val.indexOf(101) < 0 && val.indexOf(43) < 0) {
            return val;
        }
        int eplusIndex = (val = val.toUpperCase()).indexOf("E+");
        if (eplusIndex >= 0) {
            val = val.substring(0, eplusIndex) + "E" + val.substring(eplusIndex + 2);
        }
        if (val.startsWith("+") && !val.startsWith("+-")) {
            val = val.substring(1);
        }
        return val;
    }

    protected static void copyBlankWorksheetPropsFromFactoryDefaults(XTProps props) {
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, MAX_STRING_SIZE_PROPERTY, Integer.toString(33));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, MAX_CATEGORICAL_LEVELS_PROPERTY, Integer.toString(500));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, NUM_DIGITS_PROPERTY, Integer.toString(2));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, STRING_LEFT_ALIGN_PROPERTY, Boolean.toString(false));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, DATE_PARSE_STRING_PROPERTY, "%m[/][.]%d[/][,]%y [%H[:%M[:%S[.%N]]]] [%p]");
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, DATE_FORMAT_STRING_PROPERTY, "%02m/%02d/%Y %02H:%02M:%02S");
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, CENTURY_CUTOFF_PROPERTY, Integer.toString(1950));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, DECIMAL_SYMBOLS_PROPERTY, DEFAULT_DECIMAL_SYMBOLS);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, MAX_BUFFER_MB_PROPERTY, Integer.toString(10));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, "rowsToChunk", Integer.toString(10000));
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props, "useCache", "yes");
    }

    protected static void copyBlankWorksheetPropsFromFactoryDefaults(XTProps props, String propName, String newVal) {
        String oldVal = props.getValue(propName, "");
        if (oldVal == null || oldVal.equals("")) {
            props.set(propName, newVal);
        }
    }

    protected static void copyBlankWorksheetPropsFromGlobalProps(XTProps props, XTProps globalProps) {
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, MAX_STRING_SIZE_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, MAX_CATEGORICAL_LEVELS_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, NUM_DIGITS_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, STRING_LEFT_ALIGN_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, DATE_PARSE_STRING_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, DATE_FORMAT_STRING_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, CENTURY_CUTOFF_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, DECIMAL_SYMBOLS_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, MAX_BUFFER_MB_PROPERTY);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, "rowsToChunk");
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps, "useCache");
    }

    protected static void copyBlankWorksheetPropsFromGlobalProps(XTProps props, XTProps globalProps, String propName) {
        String oldVal = props.getValue(propName, "");
        if (oldVal == null || oldVal.equals("")) {
            String newVal = globalProps.getValue(propName, "");
            props.set(propName, newVal);
        }
    }

    protected static void setWorksheetPropsToBlank(XTProps props) {
        props.set(MAX_STRING_SIZE_PROPERTY, "");
        props.set(MAX_CATEGORICAL_LEVELS_PROPERTY, "");
        props.set(NUM_DIGITS_PROPERTY, "");
        props.set(STRING_LEFT_ALIGN_PROPERTY, "");
        props.set(DATE_PARSE_STRING_PROPERTY, "");
        props.set(DATE_FORMAT_STRING_PROPERTY, "");
        props.set(CENTURY_CUTOFF_PROPERTY, "");
        props.set(DECIMAL_SYMBOLS_PROPERTY, "");
        props.set(MAX_BUFFER_MB_PROPERTY, "");
        props.set("rowsToChunk", "");
        props.set("useCache", "");
    }

    public static boolean isInteractive() {
        return MinerApp.isInteractive();
    }

    public static boolean isSolarisOS() {
        return MinerApp.isSolarisOS();
    }

    public static boolean isWindowsOS() {
        return MinerApp.isWindowsOS();
    }

    public static String getUserHome() {
        return MinerApp.getUserHome();
    }

    public static String getUserName() {
        return MinerApp.getUserName();
    }

    public static String getMinerHome() {
        return MinerApp.getSprimeHome();
    }

    public static String getWorkDir() {
        return MinerApp.getWorkDir();
    }

    public static String getSettingsDir() {
        return MinerApp.getSettingsDir();
    }

    public static String getTempDir() {
        return MinerApp.getTempDir();
    }
}

