/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ReadPMMLFileNodeModel;
import com.insightful.miner.WritePMMLFileEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTProps;
import java.io.File;
import java.io.FileOutputStream;

public class WriteHTMLFileEngineNode
extends WritePMMLFileEngineNode {
    public static String REPORT_TYPE = "type";
    public static String SPECIFY_TAG = "specify";
    public static String XSL_FILENAME_TAG = "xslFilename";
    public static String[] m_typeDescriptionList = new String[]{"HTML files (*.htm*)", "PDF files (*.pdf)", "PS files (*.ps)", "RTF files (*.rtf)"};
    protected static String[][] m_extensionList = new String[][]{{".html", ".htm"}, {".pdf"}, {".ps"}, {".rtf"}};

    public boolean executeDataCacheProc() throws Exception {
        XMLTree fittedModel;
        XTProps props = this.getNodeProperties();
        String filename = this.getNetworkManager().getAbsolutePath(props.getValue("filePath"));
        filename = new File(filename).getAbsolutePath();
        String type = props.getValue(REPORT_TYPE, m_typeDescriptionList[0]);
        String xslFile = props.getValue(XSL_FILENAME_TAG, null);
        if (!props.getBoolean(SPECIFY_TAG, false)) {
            xslFile = null;
        }
        if ((fittedModel = this.getModel()) != null) {
            String title = this.getNodeName() + ":" + "Model";
            File outputFile = new File(filename);
            File parentDir = outputFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileOutputStream outs = new FileOutputStream(filename);
            ReadPMMLFileNodeModel.transformModel(outs, title, fittedModel, type, xslFile);
            outs.flush();
            outs.close();
        } else {
            this.printlnError("Model is null.  Cannot create HTML.");
        }
        return true;
    }
}

