/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XMLTree;
import com.insightful.miner.XTProps;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTreeNetwork
extends XMLTree {
    protected Element networkRootNode = null;
    protected Element lastFoundNode = null;
    protected String lastFoundNodeID = "";
    public static String NETWORK_NODE_TAG = "Worksheet";
    public static String FILE_INFO_NODE_TAG = "FileInfo";
    public static String COMPONENT_COMMENTS_NODE_TAG = "ComponentComments";
    public static String FILE_AUTHOR_NODE_TAG = "FileAuthor";
    public static String FILE_VERSION_NODE_TAG = "FileVersion";
    public static String FILE_NAME_NODE_TAG = "FileName";
    public static String FILE_DATE_CREATED_NODE_TAG = "FileDateCreated";
    public static String ACTIVITY_NODE_LIST_NODE_TAG = "ActivityNodeList";
    public static String ACTIVITY_NODE_NODE_TAG = "ActivityNode";
    public static String TEXT_NODE_LIST_NODE_TAG = "TextNodeList";
    public static String TEXT_NODE_NODE_TAG = "TextNode";
    public static String DISPLAY_INFO_NODE_TAG = "DisplayInfo";
    public static String ARGUMENT_LIST_NODE_TAG = "ArgumentList";
    public static String MODEL_PROPERTIES_NODE_TAG = "ModelProperties";
    public static String EXECUTE_AFTER_NODE_TAG = "ExecuteAfter";
    public static String INPUT_PORT_TOOL_TIPS_NODE_TAG = "InputPortToolTips";
    public static String OUTPUT_PORT_TOOL_TIPS_NODE_TAG = "OutputPortToolTips";
    public static String MODEL_PARENT_NODE_TAG = "ModelParent";
    public static String LINK_LIST_NODE_TAG = "LinkList";
    public static String LINK_NODE_TAG = "Link";
    public static String LINK_HISTORY_NODE_TAG = "LinkHistory";
    public static String COLLAPSED_NODE_LIST_NODE_TAG = "CollapsedNodeList";
    public static String COLLAPSED_NODE_NODE_TAG = "CollapsedNode";
    public static String INPUT_PORT_LIST_NODE_TAG = "InputPortList";
    public static String OUTPUT_PORT_LIST_NODE_TAG = "OutputPortList";
    public static String PORT_INFO_NODE_TAG = "PortInfo";
    public static String WORKSHEET_PROPERTIES_NODE_TAG = "WorksheetProperties";
    public static String WORKSHEET_PARAMETERS_NODE_TAG = "WorksheetParameters";
    public static String MODEL_LINK_NODE_TAG = "ModelLink";
    public static String VERSION_ATTRIBUTE_TAG = "version";
    public static String LAST_NODE_ID_ATTRIBUTE_TAG = "lastNodeID";
    public static String LINK_TYPE_ATTRIBUTE_TAG = "linkType";
    public static String DIAGONAL_LINK_ATTRIBUTE_TAG = "diagonal";
    public static String ORTHOGONAL_LINK_ATTRIBUTE_TAG = "orthogonal";
    public static String FROM_NODE_ATTRIBUTE_TAG = "fromNode";
    public static String FROM_PORT_ATTRIBUTE_TAG = "fromPort";
    public static String TO_NODE_ATTRIBUTE_TAG = "toNode";
    public static String TO_PORT_ATTRIBUTE_TAG = "toPort";
    public static String ID_ATTRIBUTE_TAG = "id";
    public static String CLASS_ATTRIBUTE_TAG = "class";
    public static String GUI_CLASS_ATTRIBUTE_TAG = "guiClass";
    public static String ENGINE_CLASS_ATTRIBUTE_TAG = "engineClass";
    public static String NUM_INPUTS_ATTRIBUTE_TAG = "numInputs";
    public static String NUM_MULTI_INPUTS_ATTRIBUTE_TAG = "numMultiInputs";
    public static String NUM_OUTPUTS_ATTRIBUTE_TAG = "numOutputs";
    public static String X_ATTRIBUTE_TAG = "x";
    public static String Y_ATTRIBUTE_TAG = "y";
    public static String DEFAULT_LABEL_TEXT_ATTRIBUTE_TAG = "defaultLabelText";
    public static String LABEL_TEXT_ATTRIBUTE_TAG = "labelText";
    public static String HELP_FILE_ATTRIBUTE_TAG = "helpFile";
    public static String SMALL_ICON_ATTRIBUTE_TAG = "smallIcon";
    public static String LARGE_ICON_ATTRIBUTE_TAG = "largeIcon";
    public static String TYPE_ATTRIBUTE_TAG = "type";
    public static String INPUT_TYPE_ATTRIBUTE_TAG = "input";
    public static String OUTPUT_TYPE_ATTRIBUTE_TAG = "output";
    public static String VISIBLE_ATTRIBUTE_TAG = "visible";
    public static String TOOLTIP_ATTRIBUTE_TAG = "toolTip";
    public static String FONT_NAME_ATTRIBUTE_TAG = "fontName";
    public static String FONT_SIZE_ATTRIBUTE_TAG = "fontSize";
    public static String ITALIC_ATTRIBUTE_TAG = "italic";
    public static String BOLD_ATTRIBUTE_TAG = "bold";
    public static String FONT_COLOR_ATTRIBUTE_TAG = "fontColor";
    public static String BACKGROUND_COLOR_ATTRIBUTE_TAG = "backgroundColor";
    public static String PARAMETER_DELIMITER = "%";

    public XMLTreeNetwork() throws Exception {
        this.networkRootNode = this.m_document.createElement(NETWORK_NODE_TAG);
        this.m_xml.appendChild(this.networkRootNode);
    }

    public XMLTreeNetwork(Element elt) throws Exception {
        super(elt);
        this.networkRootNode = this.m_xml.getNodeName().equals(XMLTree.IMML_NODE_TAG) ? (Element)this.m_xml.getFirstChild() : this.m_xml;
        if (this.networkRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.networkRootNode.getNodeName().equals(NETWORK_NODE_TAG)) {
            throw new Exception("Malformed XML: " + NETWORK_NODE_TAG + " tag was missing.");
        }
    }

    public XMLTreeNetwork(XMLTree md) throws Exception {
        super(md);
        this.networkRootNode = this.m_xml.getNodeName().equals(IMML_NODE_TAG) ? (Element)this.m_xml.getFirstChild() : this.m_xml;
        if (this.networkRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.networkRootNode.getNodeName().equals(NETWORK_NODE_TAG)) {
            throw new Exception("Malformed XML: " + NETWORK_NODE_TAG + " tag was missing.");
        }
    }

    public Vector getFlatNodes() {
        Vector ret = new Vector();
        this.getNextLevelNodeIDs(this.networkRootNode, ret);
        return ret;
    }

    public Vector getFlatLinks() {
        Vector ret = new Vector();
        this.getNextLevelLinks(this.networkRootNode, ret, this.getFlatNodes());
        return ret;
    }

    public String getEngineNodeClassName(String nodeID) {
        String ret;
        if (this.findActivityNode(nodeID) && (ret = this.lastFoundNode.getAttribute(ENGINE_CLASS_ATTRIBUTE_TAG)) != null) {
            return ret;
        }
        return "";
    }

    public String getNodeName(String nodeID) {
        Element displayInfo;
        String ret;
        if (this.findActivityNode(nodeID) && (ret = (displayInfo = (Element)this.lastFoundNode.getFirstChild()).getAttribute(LABEL_TEXT_ATTRIBUTE_TAG)) != null) {
            return ret;
        }
        return "";
    }

    public boolean setModelProperties(String nodeID, XMLTree modelProperties) {
        if (this.findActivityNode(nodeID)) {
            Element node;
            for (node = (Element)this.lastFoundNode.getFirstChild(); node != null && !node.getNodeName().equals(MODEL_PROPERTIES_NODE_TAG); node = (Element)node.getNextSibling()) {
            }
            if (node == null) {
                node = this.getDocument().createElement(MODEL_PROPERTIES_NODE_TAG);
                this.lastFoundNode.appendChild(node);
            } else {
                Node child = node.getFirstChild();
                if (node != null) {
                    node.removeChild(child);
                }
            }
            try {
                modelProperties.appendCopyToElement(node);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public Element getWorksheetComments() {
        return this.getComponenetComments(null);
    }

    public Element getComponenetComments(String nodeID) {
        Element node = null;
        if (nodeID == null) {
            node = (Element)this.networkRootNode.getFirstChild();
        } else if (this.findNode(nodeID)) {
            node = (Element)this.lastFoundNode.getFirstChild();
        }
        while (node != null && !node.getNodeName().equals(COMPONENT_COMMENTS_NODE_TAG)) {
            node = (Element)node.getNextSibling();
        }
        return node;
    }

    public XMLTree getModelProperties(String nodeID) {
        if (this.findActivityNode(nodeID)) {
            Element node;
            for (node = (Element)this.lastFoundNode.getFirstChild(); node != null && !node.getNodeName().equals(MODEL_PROPERTIES_NODE_TAG); node = (Element)node.getNextSibling()) {
            }
            try {
                return new XMLTree((Element)node.getFirstChild());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public XTProps getNodeProperties(String nodeID) {
        if (this.findActivityNode(nodeID)) {
            Element node;
            for (node = (Element)this.lastFoundNode.getFirstChild(); node != null && !node.getNodeName().equals(ARGUMENT_LIST_NODE_TAG); node = (Element)node.getNextSibling()) {
            }
            try {
                return new XTProps((Element)node.getFirstChild());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getNodeNumInputs(String nodeID) {
        if (this.findActivityNode(nodeID)) {
            try {
                int ret = Integer.parseInt(this.lastFoundNode.getAttribute(NUM_INPUTS_ATTRIBUTE_TAG));
                if (ret != -1) {
                    return ret;
                }
                return this.countNumInputs(this.networkRootNode, nodeID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getNodeNumOutputs(String nodeID) {
        if (this.findActivityNode(nodeID)) {
            try {
                return Integer.parseInt(this.lastFoundNode.getAttribute(NUM_OUTPUTS_ATTRIBUTE_TAG));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public XMLTree copy() {
        try {
            XMLTreeNetwork network = (XMLTreeNetwork)this.clone();
            return network;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object clone() {
        try {
            return new XMLTreeNetwork(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void test() {
    }

    protected void getNextLevelNodeIDs(Element level, Vector total) {
        for (Element node = (Element)level.getFirstChild(); node != null; node = (Element)node.getNextSibling()) {
            int i;
            if (node.getNodeName().equals(ACTIVITY_NODE_LIST_NODE_TAG)) {
                NodeList activityNodeList = node.getChildNodes();
                for (i = 0; i < activityNodeList.getLength(); ++i) {
                    Element activityNode = (Element)activityNodeList.item(i);
                    total.addElement(activityNode.getAttribute(ID_ATTRIBUTE_TAG));
                }
                continue;
            }
            if (!node.getNodeName().equals(COLLAPSED_NODE_LIST_NODE_TAG)) continue;
            NodeList collapsedNodeList = node.getChildNodes();
            for (i = 0; i < collapsedNodeList.getLength(); ++i) {
                Element collapsedNode = (Element)collapsedNodeList.item(i);
                if (collapsedNode == null) continue;
                this.getNextLevelNodeIDs(collapsedNode, total);
            }
        }
    }

    protected int countNumInputs(Element level, String nodeID) {
        NodeList collapsedNodeList = null;
        NodeList linkHistoryList = null;
        Element collapsedNode = null;
        Element linkHistory = null;
        NodeList linkList = null;
        Element link = null;
        String testToNode = "";
        int ret = 0;
        for (Element node = (Element)level.getFirstChild(); node != null; node = (Element)node.getNextSibling()) {
            int i;
            if (node.getNodeName().equals(LINK_LIST_NODE_TAG)) {
                linkList = node.getChildNodes();
                for (i = 0; i < linkList.getLength(); ++i) {
                    link = (Element)linkList.item(i);
                    if (link.hasChildNodes()) {
                        linkHistoryList = link.getChildNodes();
                        for (int j = linkHistoryList.getLength() - 1; j >= 0; --j) {
                            linkHistory = (Element)linkHistoryList.item(j);
                            testToNode = linkHistory.getAttribute(TO_NODE_ATTRIBUTE_TAG);
                            if (!testToNode.equals(nodeID)) continue;
                            ++ret;
                        }
                        continue;
                    }
                    testToNode = link.getAttribute(TO_NODE_ATTRIBUTE_TAG);
                    if (!testToNode.equals(nodeID)) continue;
                    ++ret;
                }
                continue;
            }
            if (!node.getNodeName().equals(COLLAPSED_NODE_LIST_NODE_TAG)) continue;
            collapsedNodeList = node.getChildNodes();
            for (i = 0; i < collapsedNodeList.getLength(); ++i) {
                collapsedNode = (Element)collapsedNodeList.item(i);
                ret += this.countNumInputs(collapsedNode, nodeID);
            }
        }
        return ret;
    }

    protected void getNextLevelLinks(Element level, Vector total, Vector unCollapsedNodeList) {
        NodeList collapsedNodeList = null;
        NodeList linkHistoryList = null;
        Element collapsedNode = null;
        Element linkHistory = null;
        NodeList linkList = null;
        Element linkNode = null;
        Link link = null;
        for (Element node = (Element)level.getFirstChild(); node != null; node = (Element)node.getNextSibling()) {
            int i;
            if (node.getNodeName().equals(LINK_LIST_NODE_TAG)) {
                linkList = node.getChildNodes();
                for (i = 0; i < linkList.getLength(); ++i) {
                    linkNode = (Element)linkList.item(i);
                    if (linkNode.hasChildNodes()) {
                        linkHistoryList = linkNode.getChildNodes();
                        for (int j = linkHistoryList.getLength() - 1; j >= 0; --j) {
                            linkHistory = (Element)linkHistoryList.item(j);
                            link = new Link(linkHistory.getAttribute(FROM_NODE_ATTRIBUTE_TAG), linkHistory.getAttribute(FROM_PORT_ATTRIBUTE_TAG), linkHistory.getAttribute(TO_NODE_ATTRIBUTE_TAG), linkHistory.getAttribute(TO_PORT_ATTRIBUTE_TAG));
                            this.addLinkToVector(total, link);
                        }
                        continue;
                    }
                    link = new Link(linkNode.getAttribute(FROM_NODE_ATTRIBUTE_TAG), linkNode.getAttribute(FROM_PORT_ATTRIBUTE_TAG), linkNode.getAttribute(TO_NODE_ATTRIBUTE_TAG), linkNode.getAttribute(TO_PORT_ATTRIBUTE_TAG));
                    this.addLinkToVector(total, link);
                }
                continue;
            }
            if (!node.getNodeName().equals(COLLAPSED_NODE_LIST_NODE_TAG)) continue;
            collapsedNodeList = node.getChildNodes();
            for (i = 0; i < collapsedNodeList.getLength(); ++i) {
                collapsedNode = (Element)collapsedNodeList.item(i);
                if (collapsedNode == null) continue;
                this.getNextLevelLinks(collapsedNode, total, unCollapsedNodeList);
            }
        }
    }

    protected void addLinkToVector(Vector linkList, Link link) {
        int toPort = link.getToInputPort();
        String toNode = link.getToNodeID();
        int linkListLength = linkList.size();
        int portNum = 0;
        for (int i = 0; i < linkListLength; ++i) {
            Link item = (Link)linkList.get(i);
            if (!item.getToNodeID().equals(toNode) || item.getToInputPort() != toPort && portNum == 0) continue;
            item.setToPort(portNum++);
        }
        if (portNum != 0) {
            link.setToPort(portNum);
        }
        linkList.add(link);
    }

    protected boolean findActivityNode(String nodeID) {
        if (nodeID.equals(this.lastFoundNodeID)) {
            return true;
        }
        if (this.recursiveSearch(this.networkRootNode, nodeID)) {
            return this.lastFoundNode.getNodeName().equals(ACTIVITY_NODE_NODE_TAG);
        }
        return false;
    }

    protected boolean findNode(String nodeID) {
        if (nodeID.equals(this.lastFoundNodeID)) {
            return true;
        }
        return this.recursiveSearch(this.networkRootNode, nodeID);
    }

    protected boolean recursiveSearch(Element element, String nodeID) {
        boolean result = false;
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            int j;
            Element child = (Element)childList.item(i);
            if (child.getNodeName().equals(ACTIVITY_NODE_LIST_NODE_TAG)) {
                NodeList activityNodeList = child.getChildNodes();
                for (j = 0; j < activityNodeList.getLength(); ++j) {
                    Element activityNode = (Element)activityNodeList.item(j);
                    if (!activityNode.getAttribute(ID_ATTRIBUTE_TAG).equals(nodeID)) continue;
                    this.lastFoundNode = activityNode;
                    this.lastFoundNodeID = nodeID;
                    return true;
                }
                continue;
            }
            if (!child.getNodeName().equals(COLLAPSED_NODE_LIST_NODE_TAG)) continue;
            NodeList collapsedNodeList = child.getChildNodes();
            for (j = 0; j < collapsedNodeList.getLength(); ++j) {
                Element collapsedNode = (Element)collapsedNodeList.item(j);
                if (collapsedNode.getAttribute(ID_ATTRIBUTE_TAG).equals(nodeID)) {
                    this.lastFoundNode = collapsedNode;
                    this.lastFoundNodeID = nodeID;
                    return true;
                }
                if (collapsedNode != null) {
                    result = this.recursiveSearch(collapsedNode, nodeID);
                }
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    public static class Link
    implements Comparable,
    Serializable {
        protected String m_fromNode;
        protected String m_toNode;
        protected int m_fromPort;
        protected int m_toPort;

        public String toString() {
            return "From Node - " + this.m_fromNode + " (Port #" + String.valueOf(this.m_fromPort) + "), To Node - " + this.m_toNode + " (Port #" + String.valueOf(this.m_toPort) + ")";
        }

        public Link(String fromNodeID, int fromOutputPort, String toNodeID, int toInputPort) {
            this.m_fromNode = fromNodeID;
            this.m_toNode = toNodeID;
            this.m_fromPort = fromOutputPort;
            this.m_toPort = toInputPort;
        }

        public Link(String fromNode, String fromPort, String toNode, String toPort) {
            this.m_fromNode = fromNode;
            this.m_toNode = toNode;
            this.m_fromPort = Integer.parseInt(fromPort);
            this.m_toPort = Integer.parseInt(toPort);
        }

        public void setToPort(int toPort) {
            this.m_toPort = toPort;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Link)) {
                return false;
            }
            Link lk = (Link)obj;
            return this.m_fromPort == lk.m_fromPort && this.m_toPort == lk.m_toPort && this.m_fromNode.equals(lk.m_fromNode) && this.m_toNode.equals(lk.m_toNode);
        }

        public int compareTo(Object obj) {
            if (obj == null || !(obj instanceof Link)) {
                return 0;
            }
            Link lk = (Link)obj;
            int c = this.m_fromNode.compareTo(lk.m_fromNode);
            if (c != 0) {
                return c;
            }
            c = this.m_toNode.compareTo(lk.m_toNode);
            if (c != 0) {
                return c;
            }
            if (this.m_fromPort < lk.m_fromPort) {
                return -1;
            }
            if (this.m_fromPort > lk.m_fromPort) {
                return 1;
            }
            if (this.m_toPort < lk.m_toPort) {
                return -1;
            }
            if (this.m_toPort > lk.m_toPort) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return (this.m_fromNode.hashCode() ^ this.m_toNode.hashCode()) + this.m_fromPort + 10 * this.m_toPort;
        }

        public String getFromNodeID() {
            return this.m_fromNode;
        }

        public String getToNodeID() {
            return this.m_toNode;
        }

        public int getFromOutputPort() {
            return this.m_fromPort;
        }

        public int getToInputPort() {
            return this.m_toPort;
        }
    }
}

