/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeProps;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XTProps
extends XMLTreeProps
implements Serializable {
    private Props m_xtProps = null;
    private int m_numProps = 0;

    public XTProps() throws Exception {
        this.m_xtProps = new Props();
    }

    public XTProps(XTProps ep) throws Exception {
        this.m_xtProps = ep.m_xtProps.copy();
        this.m_numProps = ep.m_numProps;
    }

    public XTProps(XMLTree tree) throws Exception {
        if (tree instanceof XTProps) {
            this.init((XTProps)tree);
        } else {
            this.init(tree);
        }
    }

    public XTProps(Element el) throws Exception {
        this.init(new XMLTree(el));
    }

    private void init(XMLTree tree) throws Exception {
        XTProps props = new XTProps();
        StringReader reader = new StringReader(tree.writeToString());
        InputSource ins = new InputSource(reader);
        PropsSaxHandler customHandler = new PropsSaxHandler(props);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(ins, (DefaultHandler)customHandler);
        this.m_numProps = props.m_numProps;
        this.m_xtProps = props.m_xtProps;
    }

    private void init(XTProps props) throws Exception {
        this.m_xtProps = props.m_xtProps.copy();
        this.m_numProps = props.m_numProps;
    }

    private static String getTempFile() {
        try {
            File xmlFile = File.createTempFile("conversion", "tmp");
            String path = xmlFile.getAbsolutePath();
            xmlFile.delete();
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "conversion___0000.tmp";
        }
    }

    public String writeToString() {
        try {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "UTF-8");
            this.outputXML(writer);
            return outs.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    void outputXML(Writer writer) throws IOException {
        this.outputXML(writer, true, "");
    }

    void outputXML(Writer writer, boolean full, String indent) throws IOException {
        if (full) {
            writer.write(indent + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            writer.write(indent + "<" + XMLTree.IMML_NODE_TAG + " " + XMLTree.IMML_VERSION_ATTRIBUTE_TAG + "=\"" + XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG + "\">\n");
            if (this.m_xtProps.m_keysVec.size() == 0) {
                writer.write(indent + "\t<" + XT_PROPERTY_NODE_TAG + " />\n");
            } else {
                writer.write(indent + "\t<" + XT_PROPERTY_NODE_TAG + ">\n");
                this.m_xtProps.write(writer, indent + "\t\t");
                writer.write(indent + "\t</" + XT_PROPERTY_NODE_TAG + ">\n");
            }
            writer.write(indent + "</" + XMLTree.IMML_NODE_TAG + ">\n");
        } else if (this.m_xtProps.m_keysVec.size() == 0) {
            writer.write(indent + "<" + XT_PROPERTY_NODE_TAG + " />\n");
        } else {
            writer.write(indent + "<" + XT_PROPERTY_NODE_TAG + ">\n");
            this.m_xtProps.write(writer, indent + "\t");
            writer.write(indent + "</" + XT_PROPERTY_NODE_TAG + ">\n");
        }
        writer.flush();
    }

    public OutputStream getHtmlOutputStream(String xslFilename, String title) {
        ByteArrayOutputStream htmlByteStream = new ByteArrayOutputStream();
        try {
            StringReader strRead = new StringReader(this.writeToString());
            InputSource is = new InputSource(strRead);
            SAXSource xmlSource = new SAXSource(is);
            StreamResult htmlResult = new StreamResult(htmlByteStream);
            Transformer xslTransformer = null;
            if (xslTransformerMap == null) {
                xslTransformerMap = new HashMap();
                transformerFactory = TransformerFactory.newInstance();
            } else {
                xslTransformer = (Transformer)xslTransformerMap.get(xslFilename);
            }
            if (xslTransformer == null) {
                StreamSource xslStream = new StreamSource(xslFilename);
                xslTransformer = transformerFactory.newTransformer(xslStream);
                xslTransformerMap.put(xslFilename, xslTransformer);
            }
            xslTransformer.transform(xmlSource, htmlResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            htmlByteStream = null;
        }
        return htmlByteStream;
    }

    public static XTProps readXTPropsFromFile(String filename) {
        try {
            FileInputStream ins = new FileInputStream(filename);
            return XTProps.readXTPropsFromFile(ins);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static XTProps readXTPropsFromFile(InputStream ins) {
        try {
            XTProps props = new XTProps();
            PropsSaxHandler customHandler = new PropsSaxHandler(props);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(ins, (DefaultHandler)customHandler);
            ins.close();
            return props;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveToFile(String filename) {
        try {
            FileOutputStream outs = new FileOutputStream(filename);
            this.saveToFile(outs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(OutputStream outs) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outs, "UTF-8");
            this.outputXML(writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XMLTreeProps getXMLTreeProps() {
        XMLTreeProps ret = null;
        try {
            if (this.m_numProps < 100) {
                ret = this.convertToXMLTreeProps();
            } else {
                String tempFilename = XTProps.getTempFile();
                File xmlFile = new File(tempFilename);
                this.saveToFile(tempFilename);
                ret = new XMLTreeProps(XMLTree.readFromFile(tempFilename));
                xmlFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Element getXML() {
        return this.getXMLTreeProps().propertyRootNode;
    }

    public Document getDocument() {
        return this.getXMLTreeProps().getDocument();
    }

    private XMLTreeProps convertToXMLTreeProps() {
        try {
            XMLTreeProps converted = new XMLTreeProps();
            this.m_xtProps.convertToXMLTreeProps(converted);
            return converted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void set(String prop, String value) {
        if (!this.m_xtProps.setValue(prop, value)) {
            ++this.m_numProps;
        }
    }

    public void set(String prop, boolean value) {
        this.set(prop, String.valueOf(value));
    }

    public void set(String prop, int value) {
        this.set(prop, String.valueOf(value));
    }

    public void set(String prop, double value) {
        this.set(prop, String.valueOf(value));
    }

    public void set(String prop1, String prop2, boolean value) {
        this.set(prop1, prop2, String.valueOf(value));
    }

    public void set(String prop1, String prop2, String value) {
        Props prop = this.m_xtProps;
        if ((prop = prop.getChild(prop1)) == null) {
            prop = this.m_xtProps.setChild(prop1);
        }
        if (!prop.setValue(prop2, value)) {
            ++this.m_numProps;
        }
    }

    public void set(String[] path, boolean value) {
        this.set(path, String.valueOf(value));
    }

    public void set(String[] path, String value) {
        Props prop = this.m_xtProps;
        int lastKey = path.length - 1;
        for (int i = 0; i < lastKey; ++i) {
            Props lastProp = prop;
            if ((prop = prop.getChild(path[i])) != null) continue;
            prop = lastProp.setChild(path[i]);
        }
        if (!prop.setValue(path[lastKey], value)) {
            ++this.m_numProps;
        }
    }

    public boolean removeProperty(String[] path) {
        Props prop = this.m_xtProps;
        int lastKey = path.length - 1;
        for (int i = 0; i < lastKey; ++i) {
            if ((prop = prop.getChild(path[i])) != null) continue;
            return false;
        }
        boolean ret = prop.remove(path[lastKey]);
        if (ret) {
            --this.m_numProps;
        }
        return ret;
    }

    public int getInt(String prop, int defaultValue) {
        try {
            String str = this.m_xtProps.getValue(prop);
            if (str != null && str.length() > 0) {
                return Integer.parseInt(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public int getInt(String[] path, int defaultValue) {
        try {
            String str = this.getValue(path);
            if (str != null && str.length() > 0) {
                return Integer.parseInt(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public long getLong(String prop, long defaultValue) {
        try {
            String str = this.m_xtProps.getValue(prop);
            if (str != null && str.length() > 0) {
                return Long.parseLong(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public long getLong(String[] path, long defaultValue) {
        try {
            String str = this.getValue(path);
            if (str != null && str.length() > 0) {
                return Long.parseLong(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public double getDouble(String prop, double defaultValue) {
        try {
            String str = this.getValue(prop);
            if (str != null && str.length() > 0) {
                return Double.parseDouble(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public double getDouble(String[] path, double defaultValue) {
        try {
            String str = this.getValue(path);
            if (str != null && str.length() > 0) {
                return Double.parseDouble(str);
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public boolean getBoolean(String prop) {
        return this.getBoolean(prop, false);
    }

    public boolean getBoolean(String prop, boolean defaultValue) {
        try {
            String str = this.m_xtProps.getValue(prop);
            if (str != null) {
                boolean ret = str.compareToIgnoreCase("true") == 0;
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public boolean getBoolean(String[] path, boolean defaultValue) {
        try {
            String str = this.getValue(path, Boolean.toString(defaultValue));
            if (str != null) {
                boolean ret = str.compareToIgnoreCase("true") == 0;
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public String getValue(String prop) {
        return this.getValue(prop, "");
    }

    public String getValue(String prop, String defaultValue) {
        try {
            String ret = this.m_xtProps.getValue(prop);
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public String getValue(String[] path) {
        return this.getValue(path, "");
    }

    public String getValue(String[] path, String defaultValue) {
        try {
            String ret;
            Props props = this.m_xtProps;
            int lastKey = path.length - 1;
            for (int i = 0; i < lastKey && (props = props.getChild(path[i])) != null; ++i) {
            }
            String string = ret = props == null ? null : props.getValue(path[lastKey]);
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public Vector getFirstLevelProperties() {
        String[] path = new String[]{};
        return this.getSubProperties(path);
    }

    public Vector getSubProperties(String prop) {
        return this.getSubProperties(new String[]{prop});
    }

    public Vector getSubProperties(String[] path) {
        try {
            Props props = this.m_xtProps;
            int lastKey = path.length;
            for (int i = 0; i < lastKey && (props = props.getChild(path[i])) != null; ++i) {
            }
            if (props != null) {
                return (Vector)props.m_keysVec.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Vector();
    }

    public Vector getSubPropertyValues(String prop) {
        return this.getSubPropertyValues(new String[]{prop});
    }

    public Vector getSubPropertyValues(String[] path) {
        try {
            Props props = this.m_xtProps;
            int lastKey = path.length;
            for (int i = 0; i < lastKey && (props = props.getChild(path[i])) != null; ++i) {
            }
            if (props != null) {
                return (Vector)props.m_valueVec.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Vector();
    }

    public boolean isPathValid(String[] path) {
        Props props = this.m_xtProps;
        for (int i = 0; i < path.length; ++i) {
            if ((props = props.getChild(path[i])) != null) continue;
            return false;
        }
        return true;
    }

    public XMLTree copy() {
        try {
            return new XTProps(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object clone() {
        try {
            return this.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XTProps) {
            return this.equals((XTProps)obj);
        }
        return false;
    }

    public boolean equals(XTProps props) {
        return props != null && this.m_xtProps.equals(props.m_xtProps);
    }

    void forcedWriteObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_xtProps);
        out.writeObject(new Integer(this.m_numProps));
    }

    static void forcedReadObject(ObjectInputStream in, XTProps ret) throws Exception {
        if (ret != null) {
            ret.m_xtProps = (Props)in.readObject();
            ret.m_numProps = (Integer)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_xtProps);
        out.writeObject(new Integer(this.m_numProps));
    }

    private void readObject(ObjectInputStream in) throws Exception {
        this.m_xtProps = (Props)in.readObject();
        this.m_numProps = (Integer)in.readObject();
    }

    void paramaterize(Vector paramNames, Vector paramValues) {
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = ((String)paramNames.get(i)).trim();
            String paramValue = ((String)paramValues.get(i)).trim();
            if (!paramName.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                paramName = XTNetwork.PARAMETER_DELIMITER + paramName;
            }
            if (!paramName.endsWith(XTNetwork.PARAMETER_DELIMITER)) {
                paramName = paramName + XTNetwork.PARAMETER_DELIMITER;
            }
            this.m_xtProps.paramaterize(paramName, paramValue);
        }
    }

    private static void testXTProps() {
    }

    static class PropsSaxHandler
    extends DefaultHandler {
        private XTProps m_props = null;
        private Props m_workingProps = null;
        private Stack m_stack = new Stack();
        private Stack m_names = new Stack();
        private boolean m_gettingComplex = false;
        private StringBuffer m_complexString = null;

        public PropsSaxHandler(XTProps p) {
            this.m_props = p;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals(PROPERTY_NODE_TAG)) {
                String name = attributes.getValue(NAME_ATTRIBUTE_TAG);
                String value = attributes.getValue(VALUE_ATTRIBUTE_TAG);
                if (this.m_stack.isEmpty()) {
                    this.m_workingProps = this.m_props.m_xtProps;
                } else {
                    this.m_workingProps = (Props)this.m_stack.lastElement();
                    this.m_workingProps = this.m_workingProps.setChild((String)this.m_names.lastElement());
                }
                this.m_workingProps.setValue(name, value);
                this.m_props.m_numProps++;
                this.m_stack.push(this.m_workingProps);
                this.m_names.push(name);
            } else if (qName.equals(COMPLEX_NODE_TAG)) {
                this.m_gettingComplex = true;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.m_gettingComplex) {
                if (this.m_complexString == null) {
                    this.m_complexString = new StringBuffer();
                }
                this.m_complexString.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(PROPERTY_NODE_TAG)) {
                this.m_names.pop();
                this.m_stack.pop();
            } else if (qName.equals(COMPLEX_NODE_TAG) && this.m_gettingComplex) {
                this.m_gettingComplex = false;
                this.m_workingProps = (Props)this.m_stack.lastElement();
                String name = (String)this.m_names.lastElement();
                String value = this.m_complexString.toString();
                this.m_workingProps.setValue(name, value);
                this.m_complexString = null;
            }
        }
    }

    private static class Props
    implements Serializable {
        private HashMap m_children = null;
        private HashMap m_values = null;
        private Vector m_valueVec = null;
        private Vector m_keysVec = null;

        public Props() {
            this(true);
        }

        public boolean setValue(String key, String value) {
            Object obj = this.m_values.get(key);
            if (obj == null) {
                this.m_valueVec.add(value);
                this.m_keysVec.add(key);
                Value val = new Value(value, this.m_keysVec.size() - 1);
                this.m_values.put(key, val);
                return false;
            }
            try {
                int pos = ((Value)obj).position;
                this.m_valueVec.set(pos, value);
                ((Value)obj).value = value;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Props setChild(String key) {
            Props props;
            if (this.m_children == null) {
                this.m_children = new HashMap();
            }
            if ((props = (Props)this.m_children.get(key)) == null) {
                props = new Props();
                this.m_children.put(key, props);
                Object val = this.m_values.get(key);
                if (val == null) {
                    this.m_valueVec.add(null);
                    this.m_keysVec.add(key);
                    Value newVal = new Value(null, this.m_keysVec.size() - 1);
                    this.m_values.put(key, newVal);
                }
            }
            return props;
        }

        public String getValue(String key) {
            String ret = null;
            try {
                Value v = (Value)this.m_values.get(key);
                if (v != null) {
                    ret = v.value;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }

        public Props getChild(String key) {
            Props ret = null;
            if (this.m_children != null) {
                try {
                    ret = (Props)this.m_children.get(key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }

        public boolean remove(String key) {
            try {
                int pos;
                Object val = this.m_values.get(key);
                if (val == null) {
                    return false;
                }
                for (int i = pos = ((Value)val).position; i < this.m_keysVec.size(); ++i) {
                    --((Value)this.m_values.get(this.m_keysVec.get((int)i))).position;
                }
                this.m_values.remove(key);
                this.m_keysVec.remove(pos);
                this.m_valueVec.remove(pos);
                if (this.m_children != null && this.m_children.get(key) != null) {
                    this.m_children.remove(key);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Vector getValues() {
            return (Vector)this.m_valueVec.clone();
        }

        public Vector getNames() {
            return (Vector)this.m_keysVec.clone();
        }

        public void paramaterize(String paramName, String paramValue) {
            for (int index = 0; index < this.m_valueVec.size(); ++index) {
                String valueVecValue = (String)this.m_valueVec.get(index);
                if (valueVecValue == null || valueVecValue.indexOf(paramName) <= -1) continue;
                String newValue = valueVecValue.replaceAll(paramName, paramValue);
                this.m_valueVec.set(index, newValue);
                Value value = (Value)this.m_values.get(this.m_keysVec.get(index));
                value.value = newValue;
            }
            if (this.m_children != null) {
                for (Props props : this.m_children.values()) {
                    props.paramaterize(paramName, paramValue);
                }
            }
        }

        public void convertToXMLTreeProps(XMLTreeProps xtProps) {
            this.convertToXMLTreeProps(xtProps, new String[0]);
        }

        private void convertToXMLTreeProps(XMLTreeProps xtProps, String[] path) {
            int pathLength = path.length + 1;
            String[] newPath = new String[pathLength];
            if (path.length > 0) {
                System.arraycopy(path, 0, newPath, 0, path.length);
            }
            for (int i = 0; i < this.m_keysVec.size(); ++i) {
                Object obj;
                String key;
                newPath[path.length] = key = (String)this.m_keysVec.get(i);
                Value val = (Value)this.m_values.get(key);
                if (val.value != null) {
                    xtProps.set(newPath, val.value);
                }
                if (this.m_children == null || (obj = this.m_children.get(key)) == null) continue;
                ((Props)obj).convertToXMLTreeProps(xtProps, newPath);
            }
        }

        public void write(Writer writer, String indent) throws IOException {
            for (int i = 0; i < this.m_keysVec.size(); ++i) {
                String name = (String)this.m_keysVec.get(i);
                Value val = (Value)this.m_values.get(name);
                Object obj = this.m_children == null ? null : this.m_children.get(name);
                Props child = obj != null ? (Props)obj : null;
                boolean complex = false;
                writer.write(indent + "<" + PROPERTY_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + this.convertToXML(name, true) + "\"");
                if (val != null && val.value != null) {
                    int newLineIndex = val.value.indexOf("\n");
                    int tabIndex = val.value.indexOf("\t");
                    if (newLineIndex != -1 || tabIndex != -1) {
                        writer.write(" " + COMPLEX_ATTRIBUTE_TAG + "=\"true\">\n");
                        writer.write(indent + "\t<" + COMPLEX_NODE_TAG + ">");
                        writer.write(this.convertToXML(val.value, false));
                        writer.write("</" + COMPLEX_NODE_TAG + ">\n");
                        complex = true;
                    } else {
                        writer.write(" " + VALUE_ATTRIBUTE_TAG + "=\"" + this.convertToXML(val.value, true) + "\"");
                    }
                }
                if (child != null) {
                    writer.write(">\n");
                    child.write(writer, indent + "\t");
                    writer.write(indent + "</" + PROPERTY_NODE_TAG + ">\n");
                    continue;
                }
                if (complex) {
                    writer.write(indent + "</" + PROPERTY_NODE_TAG + ">\n");
                    continue;
                }
                writer.write(" />\n");
            }
        }

        private String convertToXML(String s, boolean attribute) {
            StringBuffer sb = new StringBuffer();
            block7: for (int i = 0; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case '\"': {
                        if (attribute) {
                            sb.append("&quot;");
                            continue block7;
                        }
                        sb.append(s.charAt(i));
                        continue block7;
                    }
                    case '\'': {
                        if (attribute) {
                            sb.append("&apos;");
                            continue block7;
                        }
                        sb.append(s.charAt(i));
                        continue block7;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    default: {
                        sb.append(s.charAt(i));
                    }
                }
            }
            return sb.toString();
        }

        public Props copy() {
            Props newProps = new Props(false);
            newProps.m_valueVec = (Vector)this.m_valueVec.clone();
            newProps.m_keysVec = (Vector)this.m_keysVec.clone();
            if (this.m_children != null) {
                newProps.m_children = this.copyChildHashMap(this.m_children, true);
            }
            newProps.m_values = this.copyValueHashMap(this.m_values, true);
            return newProps;
        }

        private HashMap copyChildHashMap(HashMap orig, boolean deep) {
            if (!deep) {
                return new HashMap(orig);
            }
            HashMap<String, Props> copy = new HashMap<String, Props>();
            Set keys = orig.keySet();
            for (String key : keys) {
                Props props = (Props)orig.get(key);
                copy.put(key, props.copy());
            }
            return copy;
        }

        private HashMap copyValueHashMap(HashMap orig, boolean deep) {
            if (!deep) {
                return new HashMap(orig);
            }
            HashMap<String, Value> copy = new HashMap<String, Value>();
            Set keys = orig.keySet();
            for (String key : keys) {
                Value val = (Value)orig.get(key);
                Value vCopy = new Value(val.value, val.position);
                copy.put(key, vCopy);
                vCopy = null;
            }
            return copy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Props) {
                return this.equals((Props)obj);
            }
            return false;
        }

        public boolean equals(Props props) {
            if (props == this) {
                return true;
            }
            return XTMetaData.nullCognizantCompare(props.m_keysVec, this.m_keysVec) && XTMetaData.nullCognizantCompare(props.m_valueVec, this.m_valueVec) && XTMetaData.nullCognizantCompare(props.m_children, this.m_children) && XTMetaData.nullCognizantCompare(props.m_values, this.m_values);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.m_keysVec);
            out.writeObject(this.m_valueVec);
            out.writeObject(this.m_children);
            out.writeObject(this.m_values);
        }

        private void readObject(ObjectInputStream in) throws Exception {
            Object obj = in.readObject();
            if (obj != null) {
                this.m_keysVec = (Vector)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.m_valueVec = (Vector)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.m_children = (HashMap)obj;
            }
            if ((obj = in.readObject()) != null) {
                this.m_values = (HashMap)obj;
            }
        }

        private Props(boolean init) {
            if (init) {
                this.m_children = null;
                this.m_values = new HashMap();
                this.m_valueVec = new Vector();
                this.m_keysVec = new Vector();
            }
        }

        private class Value
        implements Serializable {
            public String value = null;
            public int position = -1;

            public Value(String val, int pos) {
                this.value = val;
                this.position = pos;
            }

            public String toString() {
                return new String("[" + this.value + ", " + this.position + "]");
            }

            public boolean equals(Object obj) {
                if (obj instanceof Value) {
                    return this.position == ((Value)obj).position && XTMetaData.nullCognizantCompare(this.value, ((Value)obj).value);
                }
                return false;
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeObject(this.value);
                out.writeObject(new Integer(this.position));
            }

            private void readObject(ObjectInputStream in) throws Exception {
                Object obj = in.readObject();
                if (obj != null) {
                    this.value = (String)obj;
                }
                this.position = (Integer)in.readObject();
            }
        }
    }
}

