/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.NodeInfo;
import com.insightful.miner.dndtree.SubTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;

public class UndoableInfoEdit
extends AbstractUndoableEdit {
    public static final short TYPE_ADD = 1;
    public static final short TYPE_DELETE = 2;
    public static final short TYPE_MOVE = 3;
    protected int[] m_arrSourcePath;
    protected int[] m_arrDestPath;
    protected short m_nType;
    protected SubTreeNode m_tree;
    protected DefaultTreeModel m_model;

    public UndoableInfoEdit(DefaultTreeModel model, short type, DefaultMutableTreeNode sourceNode, int sourceIndex, DefaultMutableTreeNode destNode, int destIndex, DefaultMutableTreeNode node, boolean include_subtree) {
        if (sourceNode != null) {
            this.m_arrSourcePath = this.makePath((DefaultMutableTreeNode)sourceNode.getRoot(), sourceNode, sourceIndex);
        }
        if (destNode != null) {
            this.m_arrDestPath = this.makePath((DefaultMutableTreeNode)destNode.getRoot(), destNode, destIndex);
        }
        this.m_model = model;
        this.m_nType = type;
        this.makeTree(node, include_subtree);
    }

    public void die() {
        super.die();
        this.m_tree = null;
        this.m_arrSourcePath = null;
        this.m_arrDestPath = null;
        this.m_model = null;
    }

    public String getPresentationName() {
        String title = this.m_tree != null && this.m_tree.getContents() != null && this.m_tree.getContents() instanceof NodeInfo && ((NodeInfo)this.m_tree.getContents()).getTitle() != null && ((NodeInfo)this.m_tree.getContents()).getTitle().length() > 0 ? " " + ((NodeInfo)this.m_tree.getContents()).getTitle() : "";
        switch (this.getType()) {
            case 1: {
                return "Add Node" + title;
            }
            case 2: {
                return "Delete Node" + title;
            }
            case 3: {
                return "Move Node" + title;
            }
        }
        return "";
    }

    public short getType() {
        return this.m_nType;
    }

    public Object getContents() {
        return this.m_tree.getContents();
    }

    private void setContents(Object ob) {
        this.m_tree.setContents(ob);
    }

    protected int[] makePath(DefaultMutableTreeNode root, DefaultMutableTreeNode parent, int index) {
        if (parent == null) {
            return null;
        }
        int[] retval = new int[parent.getLevel() - root.getLevel() + 2];
        retval[retval.length - 1] = index;
        int i = retval.length - 2;
        TreeNode iter_node = parent;
        do {
            retval[i] = iter_node.getParent() == null ? 0 : iter_node.getParent().getIndex(iter_node);
            iter_node = iter_node.getParent();
        } while (i-- > 0);
        return retval;
    }

    protected void makeTree(DefaultMutableTreeNode node, boolean include_subtree) {
        this.m_tree = new SubTreeNode(node, include_subtree);
    }

    protected void moveNode(int[] from, int[] to) {
        int i;
        DefaultMutableTreeNode node_to_move = (DefaultMutableTreeNode)this.m_model.getRoot();
        for (int i2 = 1; i2 < from.length; ++i2) {
            node_to_move = (DefaultMutableTreeNode)node_to_move.getChildAt(from[i2]);
        }
        DefaultMutableTreeNode new_parent = (DefaultMutableTreeNode)this.m_model.getRoot();
        for (i = 1; i < to.length - 1; ++i) {
            new_parent = (DefaultMutableTreeNode)new_parent.getChildAt(to[i]);
        }
        this.m_model.removeNodeFromParent(node_to_move);
        this.m_model.insertNodeInto(node_to_move, new_parent, to[i]);
    }

    protected void removeNode(int[] path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_model.getRoot();
        for (int i = 1; i < path.length; ++i) {
            node = (DefaultMutableTreeNode)node.getChildAt(path[i]);
        }
        this.m_model.removeNodeFromParent(node);
    }

    protected void insertNode(int[] path) {
        int i;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_model.getRoot();
        for (i = 1; i < path.length - 1; ++i) {
            node = (DefaultMutableTreeNode)node.getChildAt(path[i]);
        }
        DefaultMutableTreeNode newnode = this.m_tree.createNode();
        this.m_model.insertNodeInto(newnode, node, path[i]);
    }

    protected void saveNodeInfo(int[] path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_model.getRoot();
        for (int i = 1; i < path.length; ++i) {
            node = (DefaultMutableTreeNode)node.getChildAt(path[i]);
        }
        this.setContents(node.getUserObject());
    }

    public void undo() throws CannotUndoException {
        super.undo();
        switch (this.getType()) {
            case 3: {
                this.moveNode(this.m_arrDestPath, this.m_arrSourcePath);
                break;
            }
            case 1: {
                this.saveNodeInfo(this.m_arrDestPath);
                this.removeNode(this.m_arrDestPath);
                break;
            }
            case 2: {
                this.insertNode(this.m_arrSourcePath);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        switch (this.getType()) {
            case 3: {
                this.moveNode(this.m_arrSourcePath, this.m_arrDestPath);
                break;
            }
            case 2: {
                this.removeNode(this.m_arrSourcePath);
                break;
            }
            case 1: {
                this.insertNode(this.m_arrDestPath);
            }
        }
    }
}

