/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.PNGRed;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.fop.image.BatikImage;
import org.apache.fop.image.FopImage;

public class PNGImage
extends BatikImage {
    public PNGImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
        this.loaded = 0;
    }

    protected CachableRed decodeImage(SeekableStream stream) throws IOException {
        PNGDecodeParam param = new PNGDecodeParam();
        param.setPerformGammaCorrection(true);
        param.setDisplayExponent(2.2f);
        PNGRed red = new PNGRed((InputStream)stream, param);
        String unit = (String)red.getProperty("pixel_units");
        if ("Meters".equals(unit)) {
            this.dpiHorizontal = (float)((Integer)red.getProperty("x_pixels_per_unit")).intValue() * 25.4f / 1000.0f;
            this.dpiVertical = (float)((Integer)red.getProperty("y_pixels_per_unit")).intValue() * 25.4f / 1000.0f;
        }
        return red;
    }
}

