/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.traits.MinOptMax;

public class LayoutContext {
    public static final int LINEBREAK_AT_LF_ONLY = 1;
    public static final int NEW_AREA = 2;
    public static final int IPD_UNKNOWN = 4;
    public static final int CHECK_REF_AREA = 8;
    public static final int SUPPRESS_LEADING_SPACE = 16;
    public static final int FIRST_AREA = 32;
    public static final int TRY_HYPHENATE = 64;
    public static final int LAST_AREA = 128;
    public static final int RESOLVE_LEADING_SPACE = 256;
    public static final int KEEP_WITH_NEXT_PENDING = 512;
    public static final int KEEP_WITH_PREVIOUS_PENDING = 1024;
    public int flags;
    MinOptMax stackLimit;
    private int nextSpan = 0;
    int refIPD;
    SpaceSpecifier trailingSpace;
    SpaceSpecifier leadingSpace;
    private HyphContext hyphContext = null;
    private int bpAlignment = 135;
    private double ipdAdjust = 0.0;
    private double dSpaceAdjust = 0.0;
    private int iLineHeight;
    private int iBaseline;
    private int iMiddleShift;
    private int iTopShift;
    private int iBottomShift;
    private int iSpaceBefore;
    private int iSpaceAfter;

    public LayoutContext(LayoutContext parentLC) {
        this.flags = parentLC.flags;
        this.refIPD = parentLC.refIPD;
        this.stackLimit = null;
        this.leadingSpace = parentLC.leadingSpace;
        this.trailingSpace = parentLC.trailingSpace;
        this.hyphContext = parentLC.hyphContext;
        this.bpAlignment = parentLC.bpAlignment;
        this.dSpaceAdjust = parentLC.dSpaceAdjust;
        this.ipdAdjust = parentLC.ipdAdjust;
        this.iLineHeight = parentLC.iLineHeight;
        this.iBaseline = parentLC.iBaseline;
        this.iMiddleShift = parentLC.iMiddleShift;
        this.iTopShift = parentLC.iTopShift;
        this.iBottomShift = parentLC.iBottomShift;
        this.iSpaceBefore = parentLC.iSpaceBefore;
        this.iSpaceAfter = parentLC.iSpaceAfter;
    }

    public LayoutContext(int flags) {
        this.flags = flags;
        this.refIPD = 0;
        this.stackLimit = new MinOptMax(0);
        this.leadingSpace = null;
        this.trailingSpace = null;
    }

    public void setFlags(int flags) {
        this.setFlags(flags, true);
    }

    public void setFlags(int flags, boolean bSet) {
        this.flags = bSet ? (this.flags |= flags) : (this.flags &= ~flags);
    }

    public void unsetFlags(int flags) {
        this.setFlags(flags, false);
    }

    public boolean isStart() {
        return (this.flags & 2) != 0;
    }

    public boolean startsNewArea() {
        return (this.flags & 2) != 0 && this.leadingSpace != null;
    }

    public boolean isFirstArea() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLastArea() {
        return (this.flags & 0x80) != 0;
    }

    public boolean suppressLeadingSpace() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isKeepWithNextPending() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isKeepWithPreviousPending() {
        return (this.flags & 0x400) != 0;
    }

    public void setLeadingSpace(SpaceSpecifier space) {
        this.leadingSpace = space;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.leadingSpace;
    }

    public boolean resolveLeadingSpace() {
        return (this.flags & 0x100) != 0;
    }

    public void setTrailingSpace(SpaceSpecifier space) {
        this.trailingSpace = space;
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.trailingSpace;
    }

    public void setStackLimit(MinOptMax limit) {
        this.stackLimit = limit;
    }

    public MinOptMax getStackLimit() {
        return this.stackLimit;
    }

    public void setRefIPD(int ipd) {
        this.refIPD = ipd;
    }

    public int getRefIPD() {
        return this.refIPD;
    }

    public void setHyphContext(HyphContext hyph) {
        this.hyphContext = hyph;
    }

    public HyphContext getHyphContext() {
        return this.hyphContext;
    }

    public boolean tryHyphenate() {
        return (this.flags & 0x40) != 0;
    }

    public void setBPAlignment(int alignment) {
        this.bpAlignment = alignment;
    }

    public int getBPAlignment() {
        return this.bpAlignment;
    }

    public void setSpaceAdjust(double adjust) {
        this.dSpaceAdjust = adjust;
    }

    public double getSpaceAdjust() {
        return this.dSpaceAdjust;
    }

    public void setIPDAdjust(double ipdA) {
        this.ipdAdjust = ipdA;
    }

    public double getIPDAdjust() {
        return this.ipdAdjust;
    }

    public void setLineHeight(int lh) {
        this.iLineHeight = lh;
    }

    public int getLineHeight() {
        return this.iLineHeight;
    }

    public void setBaseline(int bl) {
        this.iBaseline = bl;
    }

    public int getBaseline() {
        return this.iBaseline;
    }

    public void setMiddleShift(int ms) {
        this.iMiddleShift = ms;
    }

    public int getMiddleBaseline() {
        return this.iBaseline + this.iMiddleShift;
    }

    public void setTopShift(int ts) {
        this.iTopShift = ts;
    }

    public int getTopBaseline() {
        return this.iBaseline + this.iTopShift;
    }

    public void setBottomShift(int bs) {
        this.iBottomShift = bs;
    }

    public int getBottomBaseline() {
        return this.iBaseline + this.iBottomShift;
    }

    public int getSpaceBefore() {
        return this.iSpaceBefore;
    }

    public void setSpaceBefore(int sp) {
        this.iSpaceBefore = sp;
    }

    public int getSpaceAfter() {
        return this.iSpaceAfter;
    }

    public void setSpaceAfter(int sp) {
        this.iSpaceAfter = sp;
    }

    public int getNextSpan() {
        return this.nextSpan;
    }

    public void signalSpanChange(int span) {
        if (span != 0 && span != 95 && span != 5) {
            throw new IllegalArgumentException("Illegal value on signalSpanChange() for span: " + span);
        }
        this.nextSpan = span;
    }

    public String toString() {
        return "Layout Context:\nStack Limit: \t" + (this.getStackLimit() == null ? "null" : this.getStackLimit().toString()) + "\nTrailing Space: \t" + (this.getTrailingSpace() == null ? "null" : this.getTrailingSpace().toString()) + "\nLeading Space: \t" + (this.getLeadingSpace() == null ? "null" : this.getLeadingSpace().toString()) + "\nReference IPD: \t" + this.getRefIPD() + "\nSpace Adjust: \t" + this.getSpaceAdjust() + "\nIPD Adjust: \t" + this.getIPDAdjust() + "\nLine Height: \t" + this.getLineHeight() + "\nBaseline: \t" + this.getBaseline() + "\nMiddle Baseline: \t" + this.getMiddleBaseline() + "\nResolve Leading Space: \t" + this.resolveLeadingSpace() + "\nSuppress Leading Space: \t" + this.suppressLeadingSpace() + "\nIs First Area: \t" + this.isFirstArea() + "\nStarts New Area: \t" + this.startsNewArea() + "\nIs Last Area: \t" + this.isLastArea() + "\nTry Hyphenate: \t" + this.tryHyphenate() + "\nKeeps: \t[" + (this.isKeepWithNextPending() ? "keep-with-next" : "") + "][" + (this.isKeepWithPreviousPending() ? "keep-with-previous" : "") + "] pending";
    }
}

