/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class SpaceSpecifier
implements Cloneable {
    private boolean bStartsReferenceArea;
    private boolean bHasForcing = false;
    private List vecSpaceVals = new ArrayList();

    public SpaceSpecifier(boolean bStarts) {
        this.bStartsReferenceArea = bStarts;
    }

    public Object clone() {
        try {
            SpaceSpecifier ss = (SpaceSpecifier)super.clone();
            ss.bStartsReferenceArea = this.bStartsReferenceArea;
            ss.bHasForcing = this.bHasForcing;
            ss.vecSpaceVals = new ArrayList();
            ss.vecSpaceVals.addAll(this.vecSpaceVals);
            return ss;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void clear() {
        this.bHasForcing = false;
        this.vecSpaceVals.clear();
    }

    public boolean hasSpaces() {
        return this.vecSpaceVals.size() > 0;
    }

    public void addSpace(SpaceVal moreSpace) {
        if (!(this.bStartsReferenceArea && moreSpace.isConditional() && this.vecSpaceVals.isEmpty())) {
            if (moreSpace.isForcing()) {
                if (!this.bHasForcing) {
                    this.vecSpaceVals.clear();
                    this.bHasForcing = true;
                }
                this.vecSpaceVals.add(moreSpace);
            } else if (!(this.bHasForcing || moreSpace.getSpace().min == 0 && moreSpace.getSpace().opt == 0 && moreSpace.getSpace().max == 0)) {
                this.vecSpaceVals.add(moreSpace);
            }
        }
    }

    public MinOptMax resolve(boolean bEndsReferenceArea) {
        int lastIndex;
        if (bEndsReferenceArea) {
            SpaceVal sval;
            for (lastIndex = this.vecSpaceVals.size(); lastIndex > 0 && (sval = (SpaceVal)this.vecSpaceVals.get(lastIndex - 1)).isConditional(); --lastIndex) {
            }
        }
        MinOptMax resSpace = new MinOptMax(0);
        int iMaxPrec = -1;
        for (int index = 0; index < lastIndex; ++index) {
            SpaceVal sval = (SpaceVal)this.vecSpaceVals.get(index);
            if (this.bHasForcing) {
                resSpace.add(sval.getSpace());
                continue;
            }
            if (sval.getPrecedence() > iMaxPrec) {
                iMaxPrec = sval.getPrecedence();
                resSpace = sval.getSpace();
                continue;
            }
            if (sval.getPrecedence() != iMaxPrec) continue;
            if (sval.getSpace().opt > resSpace.opt) {
                resSpace = sval.getSpace();
                continue;
            }
            if (sval.getSpace().opt != resSpace.opt) continue;
            if (resSpace.min < sval.getSpace().min) {
                resSpace.min = sval.getSpace().min;
            }
            if (resSpace.max <= sval.getSpace().max) continue;
            resSpace.max = sval.getSpace().max;
        }
        return resSpace;
    }

    public String toString() {
        return "Space Specifier (resolved at begin/end of ref. area:):\n" + this.resolve(false).toString() + "\n" + this.resolve(true).toString();
    }
}

