/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.traits.MinOptMax;

public class TableCellLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private TableCell fobj;
    private PrimaryGridUnit gridUnit;
    private Block curBlockArea;
    private int inRowIPDOffset;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int rowHeight;
    private int usedBPD;
    private int startBorderWidth;
    private int endBorderWidth;
    private int borderAndPaddingBPD;
    private boolean emptyCell = true;

    public TableCellLayoutManager(TableCell node, PrimaryGridUnit pgu) {
        super(node);
        this.fobj = node;
        this.gridUnit = pgu;
        this.initialize();
    }

    public TableCell getFObj() {
        return this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.fobj.isSeparateBorderModel();
    }

    private void initialize() {
        this.borderAndPaddingBPD = 0;
        this.borderAndPaddingBPD += this.fobj.getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        this.borderAndPaddingBPD += this.fobj.getCommonBorderPaddingBackground().getBorderAfterWidth(false);
        if (!this.isSeparateBorderModel()) {
            this.borderAndPaddingBPD /= 2;
        }
        this.borderAndPaddingBPD += this.fobj.getCommonBorderPaddingBackground().getPaddingBefore(false);
        this.borderAndPaddingBPD += this.fobj.getCommonBorderPaddingBackground().getPaddingAfter(false);
    }

    public Table getTable() {
        FONode node = this.fobj.getParent();
        while (!(node instanceof Table)) {
            node = node.getParent();
        }
        return (Table)node;
    }

    private int getIPIndents() {
        int iIndents = 0;
        int[] startEndBorderWidths = this.gridUnit.getStartEndBorderWidths();
        this.startBorderWidth += startEndBorderWidths[0];
        this.endBorderWidth += startEndBorderWidths[1];
        iIndents += this.startBorderWidth;
        iIndents += this.endBorderWidth;
        if (!this.isSeparateBorderModel()) {
            iIndents /= 2;
        }
        iIndents += this.fobj.getCommonBorderPaddingBackground().getPaddingStart(false);
        return iIndents += this.fobj.getCommonBorderPaddingBackground().getPaddingEnd(false);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        MinOptMax stackLimit = new MinOptMax(context.getStackLimit());
        this.cellIPD = this.referenceIPD = context.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        if (this.isSeparateBorderModel()) {
            int borderSep = this.fobj.getBorderSeparation().getLengthPair().getIPD().getLength().getValue();
            this.cellIPD -= borderSep;
        }
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LinkedList returnList = new LinkedList();
        BlockLevelLayoutManager prevLM = null;
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackLimit));
            childLC.setRefIPD(this.cellIPD);
            returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (childLC.isKeepWithNextPending()) {
                log.debug("child LM signals pending keep with next");
            }
            if (contentList.size() == 0 && childLC.isKeepWithPreviousPending()) {
                context.setFlags(1024);
                childLC.setFlags(1024, false);
            }
            if (returnedList.size() == 1 && ((KnuthElement)returnedList.getFirst()).isPenalty() && ((KnuthPenalty)returnedList.getFirst()).getP() == -1000) {
                if (returnList.size() == 0) {
                    // empty if block
                }
                contentList.addAll(returnedList);
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                return returnList;
            }
            if (prevLM != null) {
                if (this.mustKeepTogether() || context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
                    context.setFlags(512, false);
                    childLC.setFlags(1024, false);
                    contentList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)contentList.getLast()).isGlue()) {
                    contentList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            contentList.addAll(returnedList);
            if (returnedList.size() == 0) continue;
            if (((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
                if (curLM.isFinished()) {
                    this.setFinished(true);
                }
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                return returnList;
            }
            if (childLC.isKeepWithNextPending()) {
                childLC.setFlags(512, false);
                context.setFlags(512);
            }
            prevLM = curLM;
        }
        returnedList = new LinkedList();
        this.wrapPositionElements(contentList, returnList);
        this.setFinished(true);
        return returnList;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public void setInRowIPDOffset(int off) {
        this.inRowIPDOffset = off;
    }

    public void setContentHeight(int h) {
        this.usedBPD = h;
    }

    public void setRowHeight(int h) {
        this.rowHeight = h;
    }

    private int getContentHeight(int rowHeight, GridUnit gu) {
        int bpd = rowHeight;
        if (this.isSeparateBorderModel()) {
            bpd -= gu.getPrimary().getBorders().getBorderBeforeWidth(false);
            bpd -= gu.getPrimary().getBorders().getBorderAfterWidth(false);
        } else {
            bpd -= gu.getPrimary().getHalfMaxBorderWidth();
        }
        CommonBorderPaddingBackground cbpb = gu.getCell().getCommonBorderPaddingBackground();
        bpd -= cbpb.getPaddingBefore(false);
        return bpd -= cbpb.getPaddingAfter(false);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        int contentBPD;
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.fobj.getId());
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.fobj.showEmptyCells()) {
                TraitSetter.addBorders(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground());
                TraitSetter.addBackground(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground());
            }
        } else {
            TraitSetter.addBackground(this.curBlockArea, this.fobj.getCommonBorderPaddingBackground());
            boolean[] outer = new boolean[]{this.gridUnit.getFlag(2), this.gridUnit.getFlag(5), this.gridUnit.getFlag(0), this.gridUnit.getFlag(1)};
            if (!this.gridUnit.hasSpanning()) {
                TraitSetter.addCollapsingBorders(this.curBlockArea, this.gridUnit.getBorders(), outer);
            } else {
                int dy = this.yoffset;
                for (int y = 0; y < this.gridUnit.getRows().size(); ++y) {
                    GridUnit[] gridUnits = (GridUnit[])this.gridUnit.getRows().get(y);
                    int dx = this.xoffset;
                    int lastRowHeight = 0;
                    for (int x = 0; x < gridUnits.length; ++x) {
                        GridUnit gu = gridUnits[x];
                        if (!gu.hasBorders()) continue;
                        Block block = new Block();
                        block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
                        block.setPositioning(2);
                        int bpd = this.getContentHeight(this.rowHeight, gu);
                        if (this.isSeparateBorderModel()) {
                            bpd += gu.getBorders().getBorderBeforeWidth(false);
                            bpd += gu.getBorders().getBorderAfterWidth(false);
                        } else {
                            bpd += this.gridUnit.getHalfMaxBeforeBorderWidth() - gu.getBorders().getBorderBeforeWidth(false) / 2;
                            bpd += this.gridUnit.getHalfMaxAfterBorderWidth() - gu.getBorders().getBorderAfterWidth(false) / 2;
                        }
                        block.setBPD(bpd);
                        lastRowHeight = this.rowHeight;
                        int ipd = gu.getColumn().getColumnWidth().getValue();
                        int borderStartWidth = gu.getBorders().getBorderStartWidth(false) / 2;
                        ipd -= borderStartWidth;
                        block.setIPD(ipd -= gu.getBorders().getBorderEndWidth(false) / 2);
                        block.setXOffset(dx + borderStartWidth);
                        int halfCollapsingBorderHeight = 0;
                        if (!this.isSeparateBorderModel()) {
                            halfCollapsingBorderHeight += gu.getBorders().getBorderBeforeWidth(false) / 2;
                        }
                        block.setYOffset(dy - halfCollapsingBorderHeight);
                        TraitSetter.addCollapsingBorders(block, gu.getBorders(), outer);
                        this.parentLM.addChildArea(block);
                        dx += gu.getColumn().getColumnWidth().getValue();
                    }
                    dy += lastRowHeight;
                }
                log.warn("TODO Add collapsed border painting for spanned cells");
            }
        }
        if (this.usedBPD < (contentBPD = this.getContentHeight(this.rowHeight, this.gridUnit))) {
            if (this.fobj.getDisplayAlign() == 23) {
                Block space = new Block();
                space.setBPD((contentBPD - this.usedBPD) / 2);
                this.curBlockArea.addBlock(space);
            } else if (this.fobj.getDisplayAlign() == 3) {
                Block space = new Block();
                space.setBPD(contentBPD - this.usedBPD);
                this.curBlockArea.addBlock(space);
            }
        }
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.curBlockArea.setBPD(contentBPD);
        this.flush();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.fobj.getId());
            this.curBlockArea.setPositioning(2);
            int indent = 0;
            indent += this.startBorderWidth;
            if (!this.isSeparateBorderModel()) {
                indent /= 2;
            }
            indent += this.fobj.getCommonBorderPaddingBackground().getPaddingStart(false);
            int halfBorderSep = 0;
            if (this.isSeparateBorderModel()) {
                halfBorderSep = this.fobj.getBorderSeparation().getLengthPair().getIPD().getLength().getValue() / 2;
            }
            int borderAdjust = 0;
            if (!this.isSeparateBorderModel()) {
                borderAdjust = this.gridUnit.hasSpanning() ? (borderAdjust -= this.gridUnit.getHalfMaxBeforeBorderWidth()) : (borderAdjust += this.gridUnit.getHalfMaxBeforeBorderWidth());
            }
            this.curBlockArea.setXOffset(this.xoffset + this.inRowIPDOffset + halfBorderSep + indent);
            this.curBlockArea.setYOffset(this.yoffset - borderAdjust);
            this.curBlockArea.setIPD(this.cellIPD);
            this.parentLM.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        boolean keep = ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
        if (this.gridUnit.getRow() != null) {
            keep |= this.gridUnit.getRow().mustKeepTogether();
        }
        return keep;
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }
}

