/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class TableStepper {
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$TableStepper == null ? (class$org$apache$fop$layoutmgr$table$TableStepper = TableStepper.class$("org.apache.fop.layoutmgr.table.TableStepper")) : class$org$apache$fop$layoutmgr$table$TableStepper);
    private TableContentLayoutManager tclm;
    private EffRow[] rowGroup;
    private int totalHeight;
    private int activeRow;
    private List[] elementLists;
    private int[] startRow;
    private int[] start;
    private int[] end;
    private int[] widths;
    private int[] baseWidth;
    private int[] borderBefore;
    private int[] paddingBefore;
    private int[] borderAfter;
    private int[] paddingAfter;
    private boolean rowBacktrackForLastStep;
    private boolean[] keepWithNextSignals;
    private boolean[] forcedBreaks;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableStepper;

    public TableStepper(TableContentLayoutManager tclm) {
        this.tclm = tclm;
        this.activeRow = 0;
    }

    private void setup(int columnCount) {
        this.elementLists = new List[columnCount];
        this.startRow = new int[columnCount];
        this.start = new int[columnCount];
        this.end = new int[columnCount];
        this.widths = new int[columnCount];
        this.baseWidth = new int[columnCount];
        this.borderBefore = new int[columnCount];
        this.paddingBefore = new int[columnCount];
        this.borderAfter = new int[columnCount];
        this.paddingAfter = new int[columnCount];
        this.keepWithNextSignals = new boolean[columnCount];
        this.forcedBreaks = new boolean[columnCount];
        Arrays.fill(this.end, -1);
    }

    private void clearBreakCondition() {
        Arrays.fill(this.forcedBreaks, false);
    }

    private boolean isBreakCondition() {
        for (int i = 0; i < this.forcedBreaks.length; ++i) {
            if (!this.forcedBreaks[i]) continue;
            return true;
        }
        return false;
    }

    private EffRow getActiveRow() {
        return this.rowGroup[this.activeRow];
    }

    private GridUnit getActiveGridUnit(int column) {
        return this.getActiveRow().getGridUnit(column);
    }

    private PrimaryGridUnit getActivePrimaryGridUnit(int column) {
        return this.getActiveGridUnit(column).getPrimary();
    }

    private void calcTotalHeight() {
        this.totalHeight = 0;
        for (int i = 0; i < this.rowGroup.length; ++i) {
            this.totalHeight += this.rowGroup[i].getHeight().opt;
        }
        log.debug("totalHeight=" + this.totalHeight);
    }

    private int getMaxRemainingHeight() {
        int i;
        int maxW = 0;
        if (!this.rowBacktrackForLastStep) {
            for (i = 0; i < this.widths.length; ++i) {
                GridUnit gu;
                if (this.elementLists[i] == null || this.end[i] == this.elementLists[i].size() - 1 || !(gu = this.getActiveGridUnit(i)).isLastGridUnitRowSpan()) continue;
                int len = this.widths[i];
                if (len > 0) {
                    len += this.borderBefore[i] + this.borderAfter[i];
                    len += this.paddingBefore[i] + this.paddingAfter[i];
                }
                int nominalHeight = this.rowGroup[this.activeRow].getHeight().opt;
                for (int r = 0; r < gu.getRowSpanIndex(); ++r) {
                    nominalHeight += this.rowGroup[this.activeRow - r - 1].getHeight().opt;
                }
                if (len == nominalHeight) {
                    maxW = 0;
                    break;
                }
                maxW = Math.max(maxW, nominalHeight - len);
            }
        }
        for (i = this.activeRow + 1; i < this.rowGroup.length; ++i) {
            maxW += this.rowGroup[i].getHeight().opt;
        }
        return maxW;
    }

    private void setupElementList(int column) {
        GridUnit gu = this.getActiveGridUnit(column);
        EffRow row = this.getActiveRow();
        if (gu.isEmpty()) {
            this.elementLists[column] = null;
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRow;
            this.keepWithNextSignals[column] = false;
            this.forcedBreaks[column] = false;
        } else if (gu.isPrimary()) {
            boolean contentsSmaller;
            PrimaryGridUnit pgu = (PrimaryGridUnit)gu;
            boolean makeBoxForWholeRow = false;
            if (row.getExplicitHeight().min > 0 && (contentsSmaller = ElementListUtils.removeLegalBreaks(pgu.getElements(), row.getExplicitHeight()))) {
                makeBoxForWholeRow = true;
            }
            if (pgu.isLastGridUnitRowSpan() && pgu.getRow() != null) {
                makeBoxForWholeRow |= pgu.getRow().mustKeepTogether();
                makeBoxForWholeRow |= pgu.getTable().mustKeepTogether();
            }
            if (makeBoxForWholeRow) {
                ArrayList<KnuthBoxCellWithBPD> list = new ArrayList<KnuthBoxCellWithBPD>(1);
                int height = row.getExplicitHeight().opt;
                if (height == 0) {
                    height = row.getHeight().opt;
                }
                list.add(new KnuthBoxCellWithBPD(height, pgu));
                this.elementLists[column] = list;
            } else {
                this.elementLists[column] = new ArrayList(pgu.getElements());
            }
            this.borderBefore[column] = this.isSeparateBorderModel() ? pgu.getBorders().getBorderBeforeWidth(false) : pgu.getBorders().getBorderBeforeWidth(false) / 2;
            this.paddingBefore[column] = pgu.getBorders().getPaddingBefore(false);
            this.paddingAfter[column] = pgu.getBorders().getPaddingAfter(false);
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRow;
            this.keepWithNextSignals[column] = false;
            this.forcedBreaks[column] = false;
        }
    }

    private void initializeElementLists() {
        for (int i = 0; i < this.start.length; ++i) {
            this.setupElementList(i);
        }
    }

    public LinkedList getCombinedKnuthElementsForRowGroup(LayoutContext context, EffRow[] rowGroup, int maxColumnCount, int bodyType) {
        int step;
        this.rowGroup = rowGroup;
        this.setup(maxColumnCount);
        this.initializeElementLists();
        this.calcTotalHeight();
        boolean signalKeepWithNext = false;
        int laststep = 0;
        int addedBoxLen = 0;
        TableContentLayoutManager.TableContentPosition lastTCPos = null;
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        while ((step = this.getNextStep(laststep)) >= 0) {
            if (this.rowBacktrackForLastStep) {
                --this.activeRow;
            }
            int increase = step - laststep;
            int penaltyLen = step + this.getMaxRemainingHeight() - this.totalHeight;
            int boxLen = step - addedBoxLen - penaltyLen;
            addedBoxLen += boxLen;
            ArrayList<TableContentLayoutManager.GridUnitPart> gridUnitParts = new ArrayList<TableContentLayoutManager.GridUnitPart>(maxColumnCount);
            for (int i = 0; i < this.start.length; ++i) {
                if (this.end[i] < this.start[i]) continue;
                PrimaryGridUnit pgu = this.getActivePrimaryGridUnit(i);
                if (this.start[i] == 0 && this.end[i] == 0 && this.elementLists[i].size() == 1 && this.elementLists[i].get(0) instanceof KnuthBoxCellWithBPD) {
                    gridUnitParts.add(new TableContentLayoutManager.GridUnitPart(pgu, 0, pgu.getElements().size() - 1));
                } else {
                    gridUnitParts.add(new TableContentLayoutManager.GridUnitPart(pgu, this.start[i], this.end[i]));
                }
                if (this.end[i] + 1 == this.elementLists[i].size()) {
                    if (pgu.getFlag(6)) {
                        log.debug("PGU has pending keep-with-next");
                        this.keepWithNextSignals[i] = true;
                    }
                    if (pgu.getRow() != null && pgu.getRow().mustKeepWithNext()) {
                        log.debug("table-row causes keep-with-next");
                        this.keepWithNextSignals[i] = true;
                    }
                }
                if (this.start[i] != 0 || this.end[i] < 0) continue;
                if (pgu.getFlag(7)) {
                    log.debug("PGU has pending keep-with-previous");
                    if (returnList.size() == 0) {
                        context.setFlags(1024);
                    }
                }
                if (pgu.getRow() == null || !pgu.getRow().mustKeepWithPrevious()) continue;
                log.debug("table-row causes keep-with-previous");
                if (returnList.size() != 0) continue;
                context.setFlags(1024);
            }
            int effPenaltyLen = penaltyLen;
            if (this.isSeparateBorderModel()) {
                CommonBorderPaddingBackground borders = this.getTableLM().getTable().getCommonBorderPaddingBackground();
                effPenaltyLen += borders.getBorderBeforeWidth(false);
                effPenaltyLen += borders.getBorderAfterWidth(false);
                effPenaltyLen += borders.getPaddingBefore(false);
                effPenaltyLen += borders.getPaddingAfter(false);
            }
            TableContentLayoutManager.TableContentPosition tcpos = new TableContentLayoutManager.TableContentPosition(this.getTableLM(), gridUnitParts, this.getActiveRow());
            if (returnList.size() == 0) {
                tcpos.setFlag(1, true);
            }
            lastTCPos = tcpos;
            log.debug(" - " + this.rowBacktrackForLastStep + " - " + this.activeRow + " - " + tcpos);
            returnList.add(new KnuthBox(boxLen, tcpos, false));
            TableContentLayoutManager.TableHFPenaltyPosition penaltyPos = new TableContentLayoutManager.TableHFPenaltyPosition(this.getTableLM());
            if (bodyType == 0) {
                if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                    effPenaltyLen += this.tclm.getHeaderNetHeight();
                    penaltyPos.headerElements = this.tclm.getHeaderElements();
                }
                if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                    effPenaltyLen += this.tclm.getFooterNetHeight();
                    penaltyPos.footerElements = this.tclm.getFooterElements();
                }
            }
            int p = 0;
            boolean allCellsHaveContributed = true;
            signalKeepWithNext = false;
            for (int i = 0; i < this.start.length; ++i) {
                if (this.start[i] == 0 && this.end[i] < 0 && this.elementLists[i] != null) {
                    allCellsHaveContributed = false;
                }
                signalKeepWithNext |= this.keepWithNextSignals[i];
            }
            if (!allCellsHaveContributed) {
                p = 900;
            }
            if (signalKeepWithNext || this.getTableLM().mustKeepTogether()) {
                p = 1000;
            }
            if (this.isBreakCondition()) {
                p = -1000;
                this.clearBreakCondition();
            }
            returnList.add(new KnuthPenalty(effPenaltyLen, p, false, penaltyPos, false));
            log.debug("step=" + step + " (+" + increase + ")" + " box=" + boxLen + " penalty=" + penaltyLen + " effPenalty=" + effPenaltyLen);
            laststep = step;
            if (!this.rowBacktrackForLastStep) continue;
            ++this.activeRow;
        }
        if (signalKeepWithNext) {
            context.setFlags(512);
        }
        if (this.isBreakCondition()) {
            ((KnuthPenalty)returnList.getLast()).setP(-1000);
        }
        lastTCPos.setFlag(2, true);
        return returnList;
    }

    private int getNextStep(int lastStep) {
        int len;
        int i;
        int i2;
        int[] backupWidths = new int[this.start.length];
        System.arraycopy(this.widths, 0, backupWidths, 0, backupWidths.length);
        int rowPendingIndicator = 0;
        for (int i3 = 0; i3 < this.start.length; ++i3) {
            if (this.elementLists[i3] == null) continue;
            if (this.end[i3] < this.elementLists[i3].size()) {
                this.start[i3] = this.end[i3] + 1;
                if (this.end[i3] + 1 >= this.elementLists[i3].size() || !this.getActivePrimaryGridUnit(i3).isLastGridUnitRowSpan()) continue;
                ++rowPendingIndicator;
                continue;
            }
            this.start[i3] = -1;
            this.end[i3] = -1;
        }
        if (rowPendingIndicator == 0 && this.activeRow < this.rowGroup.length - 1) {
            TableRow rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakAfter() != 9) {
                log.warn("break-after ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.1)");
            }
            ++this.activeRow;
            log.debug("===> new row: " + this.activeRow);
            this.initializeElementLists();
            for (i2 = 0; i2 < backupWidths.length; ++i2) {
                if (this.end[i2] >= 0) continue;
                backupWidths[i2] = 0;
            }
            rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakBefore() != 9) {
                log.warn("break-before ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.2)");
            }
        }
        int seqCount = 0;
        for (i2 = 0; i2 < this.start.length; ++i2) {
            if (this.elementLists[i2] == null) continue;
            while (this.end[i2] + 1 < this.elementLists[i2].size()) {
                int n = i2;
                this.end[n] = this.end[n] + 1;
                KnuthElement el = (KnuthElement)this.elementLists[i2].get(this.end[i2]);
                if (el.isPenalty()) {
                    if (el.getP() <= -1000) {
                        log.warn("FORCED break encountered!");
                        this.forcedBreaks[i2] = true;
                        break;
                    }
                    if (el.getP() >= 1000) continue;
                    break;
                }
                if (el.isGlue()) {
                    KnuthElement prev;
                    if (this.end[i2] > 0 && (prev = (KnuthElement)this.elementLists[i2].get(this.end[i2] - 1)).isBox()) break;
                    int n2 = i2;
                    this.widths[n2] = this.widths[n2] + el.getW();
                    continue;
                }
                int n3 = i2;
                this.widths[n3] = this.widths[n3] + el.getW();
            }
            if (this.end[i2] < this.start[i2]) {
                this.widths[i2] = backupWidths[i2];
            } else {
                ++seqCount;
            }
            this.borderAfter[i2] = this.end[i2] + 1 >= this.elementLists[i2].size() ? (this.isSeparateBorderModel() ? this.getActivePrimaryGridUnit(i2).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i2).getHalfMaxAfterBorderWidth()) : (this.isSeparateBorderModel() ? this.getActivePrimaryGridUnit(i2).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i2).getHalfMaxAfterBorderWidth());
            log.debug("borders before=" + this.borderBefore[i2] + " after=" + this.borderAfter[i2]);
            log.debug("padding before=" + this.paddingBefore[i2] + " after=" + this.paddingAfter[i2]);
        }
        if (seqCount == 0) {
            return -1;
        }
        int minStep = Integer.MAX_VALUE;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.widths.length; ++i) {
            this.baseWidth[i] = 0;
            for (int prevRow = 0; prevRow < this.startRow[i]; ++prevRow) {
                int n = i;
                this.baseWidth[n] = this.baseWidth[n] + this.rowGroup[prevRow].getHeight().opt;
            }
            int n = i;
            this.baseWidth[n] = this.baseWidth[n] + (this.borderBefore[i] + this.borderAfter[i]);
            int n4 = i;
            this.baseWidth[n4] = this.baseWidth[n4] + (this.paddingBefore[i] + this.paddingAfter[i]);
            if (this.end[i] < this.start[i]) continue;
            len = this.baseWidth[i] + this.widths[i];
            sb.append(len + " ");
            minStep = Math.min(len, minStep);
        }
        log.debug("candidate steps: " + sb);
        this.rowBacktrackForLastStep = false;
        for (i = 0; i < this.widths.length; ++i) {
            len = this.baseWidth[i] + this.widths[i];
            if (len <= minStep) continue;
            this.widths[i] = backupWidths[i];
            this.end[i] = this.start[i] - 1;
            if (this.baseWidth[i] + this.widths[i] <= minStep) continue;
            log.debug("Meeeeep!");
            this.rowBacktrackForLastStep = true;
        }
        if (log.isDebugEnabled()) {
            sb = new StringBuffer();
            for (i = 0; i < this.widths.length; ++i) {
                if (this.end[i] >= this.start[i]) {
                    sb.append(i + ": " + this.start[i] + "-" + this.end[i] + "(" + this.widths[i] + "), ");
                    continue;
                }
                sb.append(i + ": skip, ");
            }
            log.debug(sb.toString());
        }
        return minStep;
    }

    private boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    private TableLayoutManager getTableLM() {
        return this.tclm.getTableLM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KnuthBoxCellWithBPD
    extends KnuthBox {
        private PrimaryGridUnit pgu;

        public KnuthBoxCellWithBPD(int w, PrimaryGridUnit pgu) {
            super(w, null, true);
            this.pgu = pgu;
        }
    }
}

