/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.properties.ColorTypeProperty;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFontManager;

class TextAttributesConverter {
    private static Log log = new SimpleLog("FOP/RTF");

    TextAttributesConverter() {
    }

    public static RtfAttributes convertAttributes(Block fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        TextAttributesConverter.attrBlockMargin(fobj.getCommonMarginBlock(), attrib);
        TextAttributesConverter.attrBlockTextAlign(fobj.getTextAlign(), attrib);
        return attrib;
    }

    public static RtfAttributes convertBlockContainerAttributes(BlockContainer fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        TextAttributesConverter.attrBlockMargin(fobj.getCommonMarginBlock(), attrib);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(Character fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(PageNumber fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(Inline fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        return attrib;
    }

    private static void attrFont(CommonFont font, FOPRtfAttributes rtfAttr) {
        rtfAttr.set("f", RtfFontManager.getInstance().getFontNumber(font.fontFamily));
        rtfAttr.setHalfPoints("fs", font.fontSize);
        if (font.fontWeight.equals("bold") || font.fontWeight.equals("700")) {
            rtfAttr.set("b", 1);
        } else {
            rtfAttr.set("b", 0);
        }
        if (font.fontStyle.equals("italic")) {
            rtfAttr.set("i", 1);
        } else {
            rtfAttr.set("i", 0);
        }
    }

    private static void attrFontColor(ColorType colorType, RtfAttributes rtfAttr) {
        if (colorType != null && (colorType.getAlpha() != 0.0f || colorType.getRed() != 0.0f || colorType.getGreen() != 0.0f || colorType.getBlue() != 0.0f)) {
            rtfAttr.set("cf", TextAttributesConverter.convertFOPColorToRTF(colorType));
        }
    }

    private static void attrTextDecoration(int textDecoration, RtfAttributes rtfAttr) {
        if (textDecoration == 153) {
            rtfAttr.set("ul", 1);
        } else {
            rtfAttr.set("ul", 0);
        }
    }

    private static void attrBlockMargin(CommonMarginBlock cmb, FOPRtfAttributes rtfAttr) {
        rtfAttr.setTwips("sb", cmb.spaceBefore.getOptimum().getLength());
        rtfAttr.setTwips("sa", cmb.spaceAfter.getOptimum().getLength());
        rtfAttr.setTwips("li", cmb.marginLeft);
        rtfAttr.setTwips("ri", cmb.marginRight);
    }

    private static void attrBlockTextAlign(int alignment, RtfAttributes rtfAttr) {
        String rtfValue = null;
        switch (alignment) {
            case 23: {
                rtfValue = "qc";
                break;
            }
            case 39: {
                rtfValue = "qr";
                break;
            }
            case 70: {
                rtfValue = "qj";
                break;
            }
            default: {
                rtfValue = "ql";
            }
        }
        rtfAttr.set(rtfValue);
    }

    private static void attrBackgroundColor(CommonBorderPaddingBackground bpb, RtfAttributes rtfAttr) {
        ColorType fopValue = bpb.backgroundColor;
        int rtfColor = 0;
        if (fopValue == null || fopValue.getRed() == 0.0f && fopValue.getGreen() == 0.0f && fopValue.getBlue() == 0.0f && fopValue.getAlpha() == 0.0f) {
            return;
        }
        rtfColor = TextAttributesConverter.convertFOPColorToRTF(fopValue);
        rtfAttr.set("chcbpat", rtfColor);
    }

    public static int convertFOPColorToRTF(ColorType fopColor) {
        int redComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getRed());
        int greenComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getGreen());
        int blueComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getBlue());
        return RtfColorTable.getInstance().getColorNumber(redComponent, greenComponent, blueComponent);
    }
}

