/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;

public class RtfTextrun
extends RtfContainer {
    private boolean bSuppressLastPar = false;
    private RtfListItem rtfListItem;

    RtfTextrun(RtfContainer parent, Writer w, RtfAttributes attrs) throws IOException {
        super(parent, w, attrs);
    }

    public void pushAttributes(RtfAttributes attrs) throws IOException {
        RtfOpenGroupMark r = new RtfOpenGroupMark(this, this.writer, attrs);
    }

    public void popAttributes() throws IOException {
        RtfCloseGroupMark r = new RtfCloseGroupMark(this, this.writer);
    }

    public void addString(String s) throws IOException {
        RtfString r = new RtfString((RtfContainer)this, this.writer, s);
    }

    public RtfFootnote addFootnote() throws IOException {
        return new RtfFootnote(this, this.writer);
    }

    public void addParagraphBreak() throws IOException {
        RtfParagraphBreak r = new RtfParagraphBreak(this, this.writer);
    }

    public void addPageNumber(RtfAttributes attr) throws IOException {
        RtfPageNumber r = new RtfPageNumber(this, this.writer, attr);
    }

    public RtfHyperLink addHyperlink(RtfAttributes attr) throws IOException {
        return new RtfHyperLink(this, this.writer, attr);
    }

    public RtfExternalGraphic newImage() throws IOException {
        return new RtfExternalGraphic(this, this.writer);
    }

    public static RtfTextrun getTextrun(RtfContainer container, Writer writer, RtfAttributes attrs) throws IOException {
        List list = container.getChildren();
        if (list.size() == 0) {
            RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
            list.add(textrun);
            return textrun;
        }
        Object obj = list.get(list.size() - 1);
        if (obj instanceof RtfTextrun) {
            return (RtfTextrun)obj;
        }
        RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
        list.add(textrun);
        return textrun;
    }

    public void setSuppressLastPar(boolean bSuppress) {
        this.bSuppressLastPar = bSuppress;
    }

    protected void writeRtfContent() throws IOException {
        boolean bLast = false;
        Iterator it = this.parent.getChildren().iterator();
        while (it.hasNext()) {
            if (it.next() != this) continue;
            bLast = !it.hasNext();
            break;
        }
        RtfParagraphBreak lastParagraphBreak = null;
        if (bLast) {
            Iterator it2 = this.getChildren().iterator();
            while (it2.hasNext()) {
                RtfElement e = (RtfElement)it2.next();
                if (e instanceof RtfParagraphBreak) {
                    lastParagraphBreak = (RtfParagraphBreak)e;
                    continue;
                }
                if (e instanceof RtfOpenGroupMark || e instanceof RtfCloseGroupMark || !e.isEmpty()) continue;
                lastParagraphBreak = null;
            }
        }
        this.writeAttributes(this.attrib, null);
        if (this.rtfListItem != null) {
            this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
        }
        boolean bPrevPar = false;
        boolean bFirst = true;
        Iterator it3 = this.getChildren().iterator();
        while (it3.hasNext()) {
            RtfElement e = (RtfElement)it3.next();
            boolean bRtfParagraphBreak = e instanceof RtfParagraphBreak;
            boolean bHide = false;
            bHide = bRtfParagraphBreak;
            boolean bl = bHide = bHide && (bPrevPar || bFirst || this.bSuppressLastPar && bLast && lastParagraphBreak != null && e == lastParagraphBreak);
            if (!bHide) {
                this.newLine();
                e.writeRtf();
                if (this.rtfListItem != null && e instanceof RtfParagraphBreak) {
                    this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
                }
            }
            if (e instanceof RtfParagraphBreak) {
                bPrevPar = true;
                continue;
            }
            if (e instanceof RtfCloseGroupMark || e instanceof RtfOpenGroupMark) continue;
            bPrevPar = bPrevPar && e.isEmpty();
            bFirst = bFirst && e.isEmpty();
        }
    }

    public void setRtfListItem(RtfListItem listItem) {
        this.rtfListItem = listItem;
    }

    public RtfListItem getRtfListItem() {
        return this.rtfListItem;
    }

    private class RtfParagraphBreak
    extends RtfElement {
        RtfParagraphBreak(RtfContainer parent, Writer w) throws IOException {
            super(parent, w);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeControlWord("par");
        }
    }

    private class RtfCloseGroupMark
    extends RtfElement {
        RtfCloseGroupMark(RtfContainer parent, Writer w) throws IOException {
            super(parent, w);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(false);
        }
    }

    private class RtfOpenGroupMark
    extends RtfElement {
        RtfOpenGroupMark(RtfContainer parent, Writer w, RtfAttributes attr) throws IOException {
            super(parent, w, attr);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(true);
            this.writeAttributes(this.getRtfAttributes(), null);
        }
    }
}

