/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class DefaultMetadataURLValidator
extends URLValidator {
    protected int repoFlag = 0;

    public void setKnownRepositoriesFlag(int flag) {
        this.repoFlag = flag;
    }

    protected IStatus validateRepositoryURL(URL location, boolean contactRepositories, IProgressMonitor monitor) {
        URL[] knownRepositories;
        IStatus duplicateStatus = Status.OK_STATUS;
        try {
            knownRepositories = ProvisioningUtil.getMetadataRepositories(this.repoFlag);
        }
        catch (ProvisionException provisionException) {
            knownRepositories = new URL[]{};
        }
        int i = 0;
        while (i < knownRepositories.length) {
            if (knownRepositories[i].toExternalForm().equalsIgnoreCase(location.toExternalForm())) {
                duplicateStatus = new Status(4, "org.eclipse.equinox.p2.ui", 3000, ProvUIMessages.AddRepositoryDialog_DuplicateURL, null);
                break;
            }
            ++i;
        }
        if (!duplicateStatus.isOK()) {
            return duplicateStatus;
        }
        if (contactRepositories) {
            return ProvisioningUtil.validateMetadataRepositoryLocation(location, monitor);
        }
        return duplicateStatus;
    }
}

