/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class RemoveProfilesOperation
extends ProfileOperation {
    private boolean removed = false;

    public RemoveProfilesOperation(String label, IProfile[] profiles) {
        super(label, profiles);
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws ProvisionException {
        int i = 0;
        while (i < this.profileIds.length) {
            ProvisioningUtil.removeProfile(this.profileIds[i], monitor);
            ++i;
        }
        this.removed = true;
        return this.okStatus();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws ProvisionException {
        int i = 0;
        while (i < this.cachedProfiles.length) {
            IProfile cachedProfile = this.cachedProfiles[i];
            ProvisioningUtil.addProfile(cachedProfile.getProfileId(), cachedProfile.getLocalProperties(), monitor);
            ++i;
        }
        this.removed = false;
        return this.okStatus();
    }

    public boolean canExecute() {
        return this.profileIds != null && !this.removed;
    }

    public boolean canUndo() {
        return this.cachedProfiles != null && this.removed;
    }
}

