/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

public class Statistics {
    public static double getAverage(Number[] numberArray) {
        double d = 0.0;
        int n = 0;
        while (n < numberArray.length) {
            d += numberArray[n].doubleValue();
            ++n;
        }
        return d / (double)n;
    }

    public static double getStdDev(Number[] numberArray) {
        double d = Statistics.getAverage(numberArray);
        double d2 = 0.0;
        int n = 0;
        double d3 = 0.0;
        while (n < numberArray.length) {
            d3 = numberArray[n].doubleValue() - d;
            d2 += d3 * d3;
            ++n;
        }
        return Math.sqrt(d2 / (double)(n - 1));
    }

    public static double[] getLinearFit(Number[] numberArray, Number[] numberArray2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getLinearFit(...): array lengths must be equal.");
        }
        double[] dArray = new double[2];
        dArray[1] = Statistics.getSlope(numberArray, numberArray2);
        dArray[0] = Statistics.getAverage(numberArray2) - dArray[1] * Statistics.getAverage(numberArray);
        return dArray;
    }

    public static double getSlope(Number[] numberArray, Number[] numberArray2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getSlope(...): array lengths must be equal.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        while (n < numberArray.length) {
            d += numberArray[n].doubleValue();
            d2 += Math.pow(numberArray[n].doubleValue(), 2.0);
            d3 += numberArray2[n].doubleValue() * numberArray[n].doubleValue();
            d4 += numberArray2[n].doubleValue();
            ++n;
        }
        return (d3 - d * d4 / (double)n) / (d2 - d * d / (double)n);
    }

    public static double getCorrelation(Number[] numberArray, Number[] numberArray2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getCorrelation(...): array lengths must be equal.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        Number[] numberArray3 = new Double[numberArray.length];
        Number[] numberArray4 = new Double[numberArray2.length];
        int n2 = 0;
        while (n2 < numberArray.length) {
            numberArray3[n2] = new Double(numberArray[n2].doubleValue());
            ++n2;
        }
        int n3 = 0;
        while (n3 < numberArray2.length) {
            numberArray4[n3] = new Double(numberArray2[n3].doubleValue());
            ++n3;
        }
        d = Statistics.getAverage(numberArray3);
        d2 = Statistics.getAverage(numberArray4);
        d3 = Statistics.getStdDev(numberArray3);
        d4 = Statistics.getStdDev(numberArray4);
        while (n < numberArray3.length) {
            numberArray3[n] = new Double((numberArray3[n].doubleValue() - d) / d3);
            numberArray4[n] = new Double((numberArray4[n].doubleValue() - d2) / d4);
            ++n;
        }
        n = 0;
        while (n < numberArray3.length) {
            numberArray3[n] = new Double(numberArray3[n].doubleValue() * numberArray4[n].doubleValue());
            ++n;
        }
        return Statistics.getAverage(numberArray3);
    }

    public static double[][] getMovingAverage(Number[] numberArray, Number[] numberArray2, int n) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): array lengths must be equal.");
        }
        if (n > numberArray.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): period can't be longer than dataset.");
        }
        double[][] dArray = new double[numberArray.length - n][2];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2][0] = numberArray[n2 + n].doubleValue();
            double d = 0.0;
            int n3 = 0;
            while (n3 < n) {
                d += numberArray2[n2 + n3].doubleValue();
                ++n3;
            }
            dArray[n2][1] = d /= (double)n;
            ++n2;
        }
        return dArray;
    }
}

