/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;
import org.w3c.dom.Node;

public class TemplateList
implements Serializable {
    static boolean DEBUG = false;
    private Hashtable m_namedTemplates = new Hashtable(89);
    private Hashtable m_patternTable = new Hashtable(89);
    private TemplateSubPatternAssociation m_wildCardPatterns = null;
    private TemplateSubPatternAssociation m_textPatterns = null;
    private TemplateSubPatternAssociation m_docPatterns = null;
    private TemplateSubPatternAssociation m_commentPatterns = null;

    private void addObjectIfNotFound(Object obj, Vector v) {
        int n = v.size();
        boolean addIt = true;
        int i = 0;
        while (i < n) {
            if (v.elementAt(i) == obj) {
                addIt = false;
                break;
            }
            ++i;
        }
        if (addIt) {
            v.addElement(obj);
        }
    }

    private void checkConflicts(TemplateSubPatternAssociation head, XPathContext xctxt, Node targetNode, QName mode) {
    }

    public void compose() {
        if (DEBUG) {
            System.out.println("Before wildcard insert...");
            this.dumpAssociationTables();
        }
        if (this.m_wildCardPatterns != null) {
            Enumeration associations = this.m_patternTable.elements();
            while (associations.hasMoreElements()) {
                TemplateSubPatternAssociation head = (TemplateSubPatternAssociation)associations.nextElement();
                TemplateSubPatternAssociation wild = this.m_wildCardPatterns;
                while (wild != null) {
                    try {
                        head = this.insertAssociationIntoList(head, (TemplateSubPatternAssociation)wild.clone(), true);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    wild = wild.getNext();
                }
            }
        }
        if (DEBUG) {
            System.out.println("After wildcard insert...");
            this.dumpAssociationTables();
        }
    }

    void dumpAssociationTables() {
        TemplateSubPatternAssociation head;
        Enumeration associations = this.m_patternTable.elements();
        while (associations.hasMoreElements()) {
            head = (TemplateSubPatternAssociation)associations.nextElement();
            while (head != null) {
                System.out.print("(" + head.getTargetString() + ", " + head.getPattern() + ")");
                head = head.getNext();
            }
            System.out.println("\n.....");
        }
        head = this.m_wildCardPatterns;
        System.out.print("wild card list: ");
        while (head != null) {
            System.out.print("(" + head.getTargetString() + ", " + head.getPattern() + ")");
            head = head.getNext();
        }
        System.out.println("\n.....");
    }

    private TemplateSubPatternAssociation getHead(String key) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(key);
    }

    public TemplateSubPatternAssociation getHead(XPathContext xctxt, Node targetNode) {
        TemplateSubPatternAssociation head;
        short targetNodeType = targetNode.getNodeType();
        switch (targetNodeType) {
            case 1: 
            case 2: {
                head = (TemplateSubPatternAssociation)this.m_patternTable.get(xctxt.getDOMHelper().getLocalNameOfNode(targetNode));
                break;
            }
            case 3: 
            case 4: {
                head = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                head = (TemplateSubPatternAssociation)this.m_patternTable.get(targetNode.getNodeName());
                break;
            }
            case 7: {
                head = (TemplateSubPatternAssociation)this.m_patternTable.get(xctxt.getDOMHelper().getLocalNameOfNode(targetNode));
                break;
            }
            case 8: {
                head = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                head = this.m_docPatterns;
                break;
            }
            default: {
                head = (TemplateSubPatternAssociation)this.m_patternTable.get(targetNode.getNodeName());
            }
        }
        return head == null ? this.m_wildCardPatterns : head;
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation matchPat) {
        StepPattern ex;
        double priority = matchPat.getTemplate().getPriority();
        if (priority == Double.NEGATIVE_INFINITY && (ex = matchPat.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)ex).getDefaultScore();
        }
        return priority;
    }

    public ElemTemplate getTemplate(QName qname) {
        return (ElemTemplate)this.m_namedTemplates.get(qname);
    }

    public ElemTemplate getTemplate(XPathContext xctxt, Node targetNode, QName mode, int maxImportLevel, boolean quietConflictWarnings) throws TransformerException {
        TemplateSubPatternAssociation head = this.getHead(xctxt, targetNode);
        if (head != null) {
            PrefixResolver savedPR = xctxt.getNamespaceContext();
            try {
                xctxt.pushCurrentNodeAndExpression(targetNode, targetNode);
                do {
                    if (maxImportLevel > -1 && head.getImportLevel() > maxImportLevel) continue;
                    ElemTemplate template = head.getTemplate();
                    xctxt.setNamespaceContext(template);
                    if (head.m_stepPattern.execute(xctxt) == NodeTest.SCORE_NONE || !head.matchMode(mode)) continue;
                    if (quietConflictWarnings) {
                        this.checkConflicts(head, xctxt, targetNode, mode);
                    }
                    ElemTemplate elemTemplate = template;
                    Object var10_10 = null;
                    xctxt.popCurrentNodeAndExpression();
                    xctxt.setNamespaceContext(savedPR);
                    return elemTemplate;
                } while ((head = head.getNext()) != null);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                xctxt.popCurrentNodeAndExpression();
                xctxt.setNamespaceContext(savedPR);
                throw throwable;
            }
            Object var10_11 = null;
            xctxt.popCurrentNodeAndExpression();
            xctxt.setNamespaceContext(savedPR);
        }
        return null;
    }

    public TemplateWalker getWalker() {
        class Org_apache_xalan_templates_TemplateList$1 {
            /* synthetic */ Org_apache_xalan_templates_TemplateList$1() {
            }
        }
        return new TemplateWalker();
    }

    private TemplateSubPatternAssociation insertAssociationIntoList(TemplateSubPatternAssociation head, TemplateSubPatternAssociation item, boolean isWildCardInsert) {
        boolean insertBefore;
        double workPriority;
        TemplateSubPatternAssociation next;
        double priority = this.getPriorityOrScore(item);
        int importLevel = item.getImportLevel();
        int docOrder = item.getDocOrderPos();
        TemplateSubPatternAssociation insertPoint = head;
        while ((next = insertPoint.getNext()) != null) {
            workPriority = this.getPriorityOrScore(next);
            if (importLevel > next.getImportLevel()) break;
            if (importLevel < next.getImportLevel()) {
                insertPoint = next;
                continue;
            }
            if (priority > workPriority) break;
            if (priority < workPriority) {
                insertPoint = next;
                continue;
            }
            if (docOrder >= next.getDocOrderPos()) break;
            insertPoint = next;
        }
        if (next == null || insertPoint == head) {
            workPriority = this.getPriorityOrScore(insertPoint);
            insertBefore = importLevel > insertPoint.getImportLevel() ? true : (importLevel < insertPoint.getImportLevel() ? false : (priority > workPriority ? true : (priority < workPriority ? false : docOrder >= insertPoint.getDocOrderPos())));
        } else {
            insertBefore = false;
        }
        if (isWildCardInsert) {
            if (insertBefore) {
                item.setNext(insertPoint);
                String key = insertPoint.getTargetString();
                item.setTargetString(key);
                this.putHead(key, item);
                return item;
            }
            item.setNext(next);
            insertPoint.setNext(item);
            return head;
        }
        if (insertBefore) {
            item.setNext(insertPoint);
            if (insertPoint.isWild() || item.isWild()) {
                this.m_wildCardPatterns = item;
            } else {
                this.putHead(item.getTargetString(), item);
            }
            return item;
        }
        item.setNext(next);
        insertPoint.setNext(item);
        return head;
    }

    private void insertPatternInTable(StepPattern pattern, ElemTemplate template) {
        String target = pattern.getTargetString();
        if (target != null) {
            TemplateSubPatternAssociation head;
            String pstring = template.getMatch().getPatternString();
            TemplateSubPatternAssociation association = new TemplateSubPatternAssociation(template, pattern, pstring);
            boolean isWildCard = association.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation = head = isWildCard ? this.m_wildCardPatterns : this.getHead(target);
            if (head == null) {
                if (isWildCard) {
                    this.m_wildCardPatterns = association;
                } else {
                    this.putHead(target, association);
                }
            } else {
                this.insertAssociationIntoList(head, association, false);
            }
        }
    }

    private void putHead(String key, TemplateSubPatternAssociation assoc) {
        if (key.equals("#text")) {
            this.m_textPatterns = assoc;
        } else if (key.equals("/")) {
            this.m_docPatterns = assoc;
        } else if (key.equals("#comment")) {
            this.m_commentPatterns = assoc;
        }
        this.m_patternTable.put(key, assoc);
    }

    private void setNamedTemplates(Hashtable v) {
        this.m_namedTemplates = v;
    }

    public void setTemplate(ElemTemplate template) {
        XPath matchXPath;
        if (template.getName() != null) {
            ElemTemplate existingTemplate = (ElemTemplate)this.m_namedTemplates.get(template.getName());
            if (existingTemplate == null) {
                this.m_namedTemplates.put(template.getName(), template);
            } else {
                int existingPrecedence = existingTemplate.getStylesheetComposed().getImportCountComposed();
                int newPrecedence = template.getStylesheetComposed().getImportCountComposed();
                if (newPrecedence > existingPrecedence) {
                    this.m_namedTemplates.put(template.getName(), template);
                } else if (newPrecedence == existingPrecedence) {
                    template.error(105, new Object[]{template.getName()});
                }
            }
        }
        if ((matchXPath = template.getMatch()) != null) {
            Expression matchExpr = matchXPath.getExpression();
            if (matchExpr instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)matchExpr, template);
            } else if (matchExpr instanceof UnionPattern) {
                UnionPattern upat = (UnionPattern)matchExpr;
                StepPattern[] pats = upat.getPatterns();
                int n = pats.length;
                int i = 0;
                while (i < n) {
                    this.insertPatternInTable(pats[i], template);
                    ++i;
                }
            }
        }
    }

    public class TemplateWalker {
        private Enumeration hashIterator;
        private boolean inPatterns;
        private TemplateSubPatternAssociation curPattern;
        private Hashtable m_compilerCache = new Hashtable();

        private TemplateWalker() {
            this.hashIterator = TemplateList.this.m_patternTable.elements();
            this.inPatterns = true;
            this.curPattern = null;
        }

        public ElemTemplate next() {
            ElemTemplate ct;
            ElemTemplateElement retValue = null;
            do {
                if (this.inPatterns) {
                    if (this.curPattern != null) {
                        this.curPattern = this.curPattern.getNext();
                    }
                    if (this.curPattern != null) {
                        retValue = this.curPattern.getTemplate();
                    } else if (this.hashIterator.hasMoreElements()) {
                        this.curPattern = (TemplateSubPatternAssociation)this.hashIterator.nextElement();
                        retValue = this.curPattern.getTemplate();
                    } else {
                        this.inPatterns = false;
                        this.hashIterator = TemplateList.this.m_namedTemplates.elements();
                    }
                }
                if (this.inPatterns) continue;
                if (this.hashIterator.hasMoreElements()) {
                    retValue = (ElemTemplate)this.hashIterator.nextElement();
                    continue;
                }
                return null;
            } while ((ct = (ElemTemplate)this.m_compilerCache.get(new Integer(retValue.getUid()))) != null);
            this.m_compilerCache.put(new Integer(retValue.getUid()), retValue);
            return retValue;
        }
    }
}

