/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeWalker
extends AxesWalker {
    transient NamedNodeMap m_attributeList;
    transient int m_attrListPos;
    transient int m_nAttrs;

    public AttributeWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Node firstChild() {
        if (this.m_currentNode.getNodeType() == 1) {
            this.m_attrListPos = -1;
            this.m_attributeList = this.m_currentNode.getAttributes();
            this.m_nAttrs = this.m_attributeList != null ? this.m_attributeList.getLength() : -2;
        }
        this.m_nextLevelAmount = 0;
        return this.nextSibling();
    }

    protected int getLevelMax() {
        return this.m_lpi.getDOMHelper().getLevel(this.m_root);
    }

    public Node nextSibling() {
        if (this.m_attributeList != null) {
            ++this.m_attrListPos;
            if (this.m_attrListPos < this.m_nAttrs) {
                return this.setCurrentIfNotNull(this.m_attributeList.item(this.m_attrListPos));
            }
            this.m_attributeList = null;
        }
        return null;
    }

    public void setRoot(Node root) {
        this.m_attrListPos = -1;
        this.m_attributeList = null;
        this.m_nAttrs = -2;
        this.m_nextLevelAmount = 1;
        super.setRoot(root);
    }
}

