/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.Node;

public class FollowingWalker
extends AxesWalker {
    protected transient Stack m_ancestors = new Stack();
    transient Node m_currentAncestor;

    public FollowingWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Node firstChild() {
        Node n = this.m_currentAncestor == this.m_currentNode ? this.m_currentNode.getNextSibling() : this.m_currentNode.getFirstChild();
        this.m_nextLevelAmount = n == null ? 0 : (n.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(n);
    }

    protected int getLevelMax() {
        return Short.MAX_VALUE;
    }

    public Node nextSibling() {
        Node n = this.m_currentNode.getNextSibling();
        this.m_nextLevelAmount = n == null ? 0 : (n.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(n);
    }

    public Node parentNode() {
        Node n;
        Node nextAncestor = this.m_currentAncestor != null ? this.m_currentAncestor.getParentNode() : null;
        Node nextParent = this.m_currentNode.getParentNode();
        if (nextParent == nextAncestor) {
            n = null;
            Node ancestor = this.m_currentAncestor;
            while (ancestor != null && (ancestor = ancestor.getParentNode()) != null) {
                n = ancestor.getNextSibling();
                if (n != null || ancestor == null) break;
            }
            this.m_currentAncestor = ancestor;
        } else {
            n = nextParent;
        }
        return this.setCurrentIfNotNull(n);
    }

    public void setRoot(Node root) {
        super.setRoot(root);
        if (root.getNodeType() == 2) {
            Node e;
            this.m_currentNode = e = this.m_lpi.getDOMHelper().getParentOfNode(root);
            this.m_currentAncestor = e.getOwnerDocument();
        } else {
            this.m_currentAncestor = root;
        }
        this.m_nextLevelAmount = 0;
    }
}

