/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceLocks {
    private static Log log = LogFactory.getLog(ResourceLocks.class);
    private final int fCleanupLimit = 100000;
    private int fCleanupCounter = 0;
    private Hashtable fLocks = new Hashtable();
    private LockObject fRoot = new LockObject("/");

    public synchronized boolean lock(String path, String owner, boolean exclusive, int depth) {
        LockObject lo = this.generateLockObjects(path);
        if (lo.checkLocks(exclusive, depth)) {
            if (lo.addLockObjectOwner(owner)) {
                lo.fExclusive = exclusive;
                return true;
            }
            log.warn((Object)("Cannot lock, lo.addLockObjectOwner() failed for owner " + owner + " and path:" + path));
            return false;
        }
        log.warn((Object)("Cannot lock, lo.checkLocks() failed for path: " + path));
        return false;
    }

    public synchronized void unlock(String path, String owner) {
        if (this.fLocks.containsKey(path)) {
            LockObject lo = (LockObject)this.fLocks.get(path);
            lo.removeLockObjectOwner(owner);
            if (log.isDebugEnabled()) {
                log.debug((Object)("number of LockObjects in the hashtable: " + this.fLocks.size()));
            }
        } else {
            log.warn((Object)("net.sf.webdav.ResourceLocks.unlock(): no lock for path " + path));
        }
        if (this.fCleanupCounter > 100000) {
            this.fCleanupCounter = 0;
            this.cleanLockObjects(this.fRoot);
        }
    }

    public LockObject generateLockObjects(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateLockObjects path: " + path + "<end>"));
        }
        if (!this.fLocks.containsKey(path)) {
            LockObject parentLockObject = this.generateLockObjects(this.getParentPath(path));
            LockObject returnObject = new LockObject(path);
            parentLockObject.addChild(returnObject);
            returnObject.fParent = parentLockObject;
            return returnObject;
        }
        return (LockObject)this.fLocks.get(path);
    }

    private boolean cleanLockObjects(LockObject lo) {
        if (lo.fChildren == null) {
            if (lo.fOwner == null) {
                lo.removeLockObject();
                return true;
            }
            return false;
        }
        boolean canDelete = true;
        int limit = lo.fChildren.length;
        for (int i = 0; i < limit; ++i) {
            if (!this.cleanLockObjects(lo.fChildren[i])) {
                canDelete = false;
                continue;
            }
            --i;
            --limit;
        }
        if (canDelete) {
            if (lo.fOwner == null) {
                lo.removeLockObject();
                return true;
            }
            return false;
        }
        return false;
    }

    private String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        if (slash == 0) {
            return "/";
        }
        return path.substring(0, slash);
    }

    private class LockObject {
        String fPath;
        String[] fOwner = null;
        LockObject[] fChildren = null;
        LockObject fParent = null;
        boolean fExclusive = false;

        LockObject(String path) {
            this.fPath = path;
            ResourceLocks.this.fLocks.put(path, this);
            ResourceLocks.this.fCleanupCounter++;
        }

        boolean addLockObjectOwner(String owner) {
            if (this.fOwner == null) {
                this.fOwner = new String[1];
            } else {
                int i;
                int size = this.fOwner.length;
                String[] newLockObjectOwner = new String[size + 1];
                for (i = 0; i < size; ++i) {
                    if (!this.fOwner[i].equals(owner)) continue;
                    return !this.fExclusive;
                }
                for (i = 0; i < size; ++i) {
                    newLockObjectOwner[i] = this.fOwner[i];
                }
                this.fOwner = newLockObjectOwner;
            }
            this.fOwner[this.fOwner.length - 1] = owner;
            return true;
        }

        void removeLockObjectOwner(String owner) {
            if (this.fOwner != null) {
                int size = this.fOwner.length;
                for (int i = 0; i < this.fOwner.length; ++i) {
                    if (!this.fOwner[i].equals(owner)) continue;
                    String[] newLockObjectOwner = new String[size - 1];
                    for (int i2 = 0; i2 < size - 1; ++i2) {
                        newLockObjectOwner[i2] = i2 < i ? this.fOwner[i2] : this.fOwner[i2 + 1];
                    }
                    this.fOwner = newLockObjectOwner;
                }
                if (this.fOwner.length == 0) {
                    this.fOwner = null;
                }
            }
        }

        void addChild(LockObject newChild) {
            if (this.fChildren == null) {
                this.fChildren = new LockObject[0];
            }
            int size = this.fChildren.length;
            LockObject[] newChildren = new LockObject[size + 1];
            for (int i = 0; i < size; ++i) {
                newChildren[i] = this.fChildren[i];
            }
            newChildren[size] = newChild;
            this.fChildren = newChildren;
        }

        void removeLockObject() {
            if (this != ResourceLocks.this.fRoot) {
                int size = this.fParent.fChildren.length;
                for (int i = 0; i < size; ++i) {
                    if (!this.fParent.fChildren[i].equals(this)) continue;
                    LockObject[] newChildren = new LockObject[size - 1];
                    for (int i2 = 0; i2 < size - 1; ++i2) {
                        newChildren[i2] = i2 < i ? this.fParent.fChildren[i2] : this.fParent.fChildren[i2 + 1];
                    }
                    if (newChildren.length != 0) {
                        this.fParent.fChildren = newChildren;
                        break;
                    }
                    this.fParent.fChildren = null;
                    break;
                }
                ResourceLocks.this.fLocks.remove(this.fPath);
            }
        }

        boolean checkLocks(boolean exclusive, int depth) {
            return this.checkParents(exclusive) && this.checkChildren(exclusive, depth);
        }

        private boolean checkParents(boolean exclusive) {
            if (this.fPath.equals("/")) {
                return true;
            }
            if (this.fOwner == null) {
                return this.fParent.checkParents(exclusive);
            }
            if (this.fExclusive || exclusive) {
                return false;
            }
            return this.fParent.checkParents(exclusive);
        }

        private boolean checkChildren(boolean exclusive, int depth) {
            if (this.fChildren == null) {
                if (this.fOwner == null) {
                    return true;
                }
                return !this.fExclusive && !exclusive;
            }
            if (this.fOwner == null) {
                if (depth != 0) {
                    boolean canLock = true;
                    int limit = this.fChildren.length;
                    for (int i = 0; i < limit; ++i) {
                        if (this.fChildren[i].checkChildren(exclusive, depth - 1)) continue;
                        canLock = false;
                    }
                    return canLock;
                }
                return true;
            }
            return !this.fExclusive && !exclusive;
        }
    }
}

