/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorImpl;
import org.osgi.framework.Version;

public class SourceManipulator {
    private List sourceBundles;
    private IProfile profile;
    boolean changed = false;

    public SourceManipulator(IProfile profile) {
        this.profile = profile;
    }

    public void addBundle(File bundleFile) throws IOException {
        if (this.sourceBundles == null) {
            this.load();
        }
        this.sourceBundles.add(new BundleInfo(bundleFile.toURL().toString()));
    }

    public void addBundle(File bundleFile, String bundleId, Version bundleVersion) throws IOException {
        if (this.sourceBundles == null) {
            this.load();
        }
        BundleInfo sourceInfo = new BundleInfo(bundleFile.toURL().toString());
        sourceInfo.setSymbolicName(bundleId);
        sourceInfo.setVersion(bundleVersion.toString());
        this.sourceBundles.add(sourceInfo);
    }

    public void removeBundle(File bundleFile, String bundleId, Version bundleVersion) throws MalformedURLException, IOException {
        if (this.sourceBundles == null) {
            this.load();
        }
        BundleInfo sourceInfo = new BundleInfo();
        if (bundleFile != null) {
            sourceInfo.setLocation(bundleFile.toURL().toString());
        }
        sourceInfo.setSymbolicName(bundleId);
        sourceInfo.setVersion(bundleVersion.toString());
        this.sourceBundles.remove(sourceInfo);
    }

    public void save() throws IOException {
        if (this.sourceBundles != null) {
            SimpleConfiguratorManipulatorImpl.saveConfiguration((List)this.sourceBundles, (File)this.getFileLocation(), (File)this.getLauncherLocation(), (boolean)false);
        }
    }

    private void load() throws MalformedURLException, IOException {
        this.sourceBundles = this.getFileLocation().exists() ? SimpleConfiguratorManipulatorImpl.readConfiguration((URL)this.getFileLocation().toURL(), (File)this.getLauncherLocation()) : new ArrayList();
    }

    private File getFileLocation() {
        return new File(Util.getConfigurationFolder(this.profile), "org.eclipse.equinox.source/source.info");
    }

    private File getLauncherLocation() {
        return Util.getInstallFolder(this.profile);
    }
}

