/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util.dialogs;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.RemoteResults;
import com.insightful.splus.eclipse.server.util.RemoteUtils;
import com.insightful.splus.eclipse.server.util.SplusDialog;
import com.insightful.splus.eclipse.server.util.dialogs.MonitorOutputDialog;
import com.insightful.splus.eclipse.server.util.dialogs.TransferFilesDialog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MonitorJobsDialog
extends SplusDialog {
    private static String MONITOR_JOB_DIALOG_TITLE = UiProperties.getString("MonitorJobsDialog.DialogTitle");
    private Combo m_ip = null;
    private Text m_userName = null;
    private Text m_password = null;
    private Text m_saveAsName = null;
    private Button m_update = null;
    private Button m_view = null;
    private Button m_saveAs = null;
    private Button m_transfer = null;
    private Button m_cancel = null;
    private Table m_jobs = null;
    private TableColumn m_jobIdColumn = null;
    private TableColumn m_dateColumn = null;
    private TableColumn m_statusColumn = null;
    private RemoteResults[] m_data = null;

    public MonitorJobsDialog(Shell shell) {
        super(shell, MONITOR_JOB_DIALOG_TITLE, new String[]{UiProperties.getString("MonitorJobsDialog.SplusServerLibraryName")});
    }

    protected boolean hasFocus() {
        return this.m_ip.isFocusControl() || this.m_userName.isFocusControl() || this.m_password.isFocusControl() || this.m_saveAsName.isFocusControl() || this.m_update.isFocusControl() || this.m_saveAs.isFocusControl() || this.m_transfer.isFocusControl() || this.m_cancel.isFocusControl() || this.m_jobs.isFocusControl() || this.m_view.isFocusControl();
    }

    private void setData(RemoteResults[] remoteResultsArray) {
        this.m_data = remoteResultsArray;
    }

    private RemoteResults[] getData() {
        return this.m_data;
    }

    private void createTable(Composite composite) {
        this.m_jobs = new Table(composite, 268503044);
        this.m_jobs.setLayoutData((Object)new GridData(1808));
        this.m_jobs.setHeaderVisible(true);
        this.m_jobs.setLinesVisible(true);
        this.m_jobIdColumn = new TableColumn(this.m_jobs, 0);
        this.m_jobIdColumn.setText(UiProperties.getString("MonitorJobsDialog.JobId_ColumnName"));
        this.m_dateColumn = new TableColumn(this.m_jobs, 0);
        this.m_dateColumn.setText(UiProperties.getString("MonitorJobsDialog.Date_ColumnName"));
        this.m_statusColumn = new TableColumn(this.m_jobs, 0);
        this.m_statusColumn.setText(UiProperties.getString("MonitorJobsDialog.Status_ColumnName"));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 65, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 225, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 75, true));
        this.m_jobs.setLayout((Layout)tableLayout);
        this.m_jobs.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                RemoteResults[] remoteResultsArray = MonitorJobsDialog.this.getData();
                if (remoteResultsArray != null) {
                    TableItem tableItem = (TableItem)event.item;
                    int n = MonitorJobsDialog.this.m_jobs.indexOf(tableItem);
                    RemoteResults remoteResults = remoteResultsArray[n];
                    tableItem.setText(new String[]{remoteResults.jobId, remoteResults.created, remoteResults.status});
                    tableItem.setData((Object)remoteResults);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = MonitorJobsDialog.this.m_jobs.getSortColumn();
                final TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = MonitorJobsDialog.this.m_jobs.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    MonitorJobsDialog.this.m_jobs.setSortColumn(tableColumn2);
                    n = 128;
                }
                final int n2 = n;
                RemoteResults[] remoteResultsArray = MonitorJobsDialog.this.getData();
                Arrays.sort(remoteResultsArray, new Comparator<RemoteResults>(){

                    @Override
                    public int compare(RemoteResults remoteResults, RemoteResults remoteResults2) {
                        int n;
                        block13: {
                            n = 0;
                            if (tableColumn2 == MonitorJobsDialog.this.m_jobIdColumn) {
                                try {
                                    double d = Double.parseDouble(remoteResults.jobId);
                                    double d2 = Double.parseDouble(remoteResults2.jobId);
                                    double d3 = d - d2;
                                    if (d3 == 0.0) {
                                        n = 0;
                                        break block13;
                                    }
                                    if (d3 < 0.0) {
                                        n = -1;
                                        break block13;
                                    }
                                    n = 1;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n = remoteResults.jobId.compareTo(remoteResults2.jobId);
                                }
                            } else if (tableColumn2 == MonitorJobsDialog.this.m_statusColumn) {
                                n = remoteResults.status.compareTo(remoteResults2.status);
                            } else if (tableColumn2 == MonitorJobsDialog.this.m_dateColumn) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UiProperties.getString("MonitorJobsDialog.SplusDateFormat"));
                                    Date date = simpleDateFormat.parse(remoteResults.created);
                                    Date date2 = simpleDateFormat.parse(remoteResults2.created);
                                    n = date.compareTo(date2);
                                }
                                catch (ParseException parseException) {
                                    n = remoteResults.created.compareTo(remoteResults2.created);
                                }
                            }
                        }
                        if (n == 0) {
                            return 0;
                        }
                        if (n2 == 128) {
                            return n < 0 ? -1 : 1;
                        }
                        return n < 0 ? 1 : -1;
                    }
                });
                MonitorJobsDialog.this.setData(remoteResultsArray);
                MonitorJobsDialog.this.m_jobs.setSortDirection(n);
                MonitorJobsDialog.this.m_jobs.clearAll();
            }
        };
        this.m_jobIdColumn.addListener(13, listener);
        this.m_dateColumn.addListener(13, listener);
        this.m_statusColumn.addListener(13, listener);
    }

    protected void createContents(Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(UiProperties.getString("MonitorJobsDialog.ServerLocation"));
        this.m_ip = new Combo(composite, 0);
        this.m_ip.setLayoutData((Object)new GridData(768));
        Label label2 = new Label(composite, 0);
        label2.setText(UiProperties.getString("MonitorJobsDialog.UserName"));
        this.m_userName = new Text(composite, 2048);
        this.m_userName.setLayoutData((Object)new GridData(768));
        Label label3 = new Label(composite, 0);
        label3.setText(UiProperties.getString("MonitorJobsDialog.Password"));
        this.m_password = new Text(composite, 0x400800);
        this.m_password.setLayoutData((Object)new GridData(768));
        this.m_password.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    MonitorJobsDialog.this.updateJobList();
                }
            }
        });
        Label label4 = new Label(composite, 0);
        this.m_update = new Button(composite, 0);
        this.m_update.setText(UiProperties.getString("MonitorJobsDialog.Update"));
        this.m_update.setLayoutData((Object)new GridData(128));
        this.m_update.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MonitorJobsDialog.this.updateJobList();
            }
        });
        Composite composite2 = new Composite((Composite)shell, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.createTable(composite2);
        this.m_view = new Button(composite2, 0);
        this.m_view.setText(UiProperties.getString("MonitorJobsDialog.View"));
        this.m_view.setLayoutData((Object)new GridData(128));
        this.m_view.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RemoteResults remoteResults = MonitorJobsDialog.this.getSelectedResultSubset();
                String string = remoteResults.jobId;
                RemoteResults remoteResults2 = RemoteUtils.queryServer(MonitorJobsDialog.this.m_ip.getText(), MonitorJobsDialog.this.m_userName.getText(), MonitorJobsDialog.this.m_password.getText(), string, MonitorJobsDialog.this);
                MonitorOutputDialog monitorOutputDialog = new MonitorOutputDialog(MonitorJobsDialog.this.m_view.getShell(), remoteResults2.constructInput(), remoteResults2.constructOutput());
                monitorOutputDialog.open();
            }
        });
        Composite composite3 = new Composite((Composite)shell, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        this.m_saveAs = new Button(composite3, 32);
        this.m_saveAs.setText(UiProperties.getString("MonitorJobsDialog.SaveAs"));
        this.m_saveAsName = new Text(composite3, 2048);
        this.m_saveAsName.setLayoutData((Object)new GridData(768));
    }

    protected void createButtons(final Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        this.m_transfer = new Button(composite, 0);
        this.m_transfer.setText(UiProperties.getString("MonitorJobsDialog.OK"));
        this.m_cancel = new Button(composite, 0);
        this.m_cancel.setText(UiProperties.getString("MonitorJobsDialog.Cancel"));
        this.m_transfer.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (MonitorJobsDialog.this.doOk()) {
                    shell.close();
                }
            }
        });
        this.m_cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.close();
            }
        });
    }

    protected void initializeContents() {
        RemoteUtils.loadServerLocations(this.m_ip);
        RemoteUtils.loadUserName(this.m_userName);
    }

    protected void addDialogStateListener(Listener listener) {
        this.m_ip.addListener(24, listener);
        this.m_userName.addListener(24, listener);
        this.m_password.addListener(24, listener);
        this.m_jobs.addListener(13, listener);
        this.m_saveAsName.addListener(24, listener);
        this.m_saveAs.addListener(13, listener);
        this.m_view.addListener(13, listener);
    }

    protected void updateDialogState() {
        boolean bl = this.m_ip.getText().length() != 0;
        boolean bl2 = true;
        boolean bl3 = true;
        this.m_update.setEnabled(bl && bl2 && bl3);
        boolean bl4 = this.m_jobs.getSelectionCount() != 0;
        this.m_view.setEnabled(bl4);
        this.m_transfer.setEnabled(bl4);
        boolean bl5 = bl4 && this.getSelectedResultSubset().status.equals(UiProperties.getString("MonitorJobsDialog.SplusStatus_Done"));
        boolean bl6 = this.m_saveAs.getSelection();
        this.m_saveAsName.setEnabled(bl5 && bl6);
        boolean bl7 = !bl6 || bl6 && this.m_saveAsName.getText().length() != 0;
        this.m_saveAs.setEnabled(bl5 && bl7);
    }

    private void updateJobList() {
        try {
            String string = this.m_ip.getText();
            String string2 = this.m_userName.getText();
            String string3 = this.m_password.getText();
            List<RemoteResults> list = RemoteUtils.queryServer(string, string2, string3, this);
            RemoteResults[] remoteResultsArray = new RemoteResults[list.size()];
            int n = 0;
            for (RemoteResults remoteResults : list) {
                if (remoteResults.error != null && remoteResults.error.length() != 0) {
                    MessageDialog.openError((Shell)this.m_ip.getShell(), (String)UiProperties.getString("MonitorJobsDialog.SplusError"), (String)remoteResults.error);
                    return;
                }
                remoteResultsArray[n++] = remoteResults;
            }
            this.setData(remoteResultsArray);
            this.m_jobs.clearAll();
            this.m_jobs.setItemCount(remoteResultsArray.length);
        }
        catch (SplusBadDataException splusBadDataException) {
            MessageDialog.openError((Shell)this.m_ip.getShell(), (String)UiProperties.getString("MonitorJobsDialog.SplusError"), (String)splusBadDataException.getMessage());
            splusBadDataException.printStackTrace();
        }
    }

    private RemoteResults getSelectedResultSubset() {
        TableItem tableItem = this.m_jobs.getItem(this.m_jobs.getSelectionIndex());
        return (RemoteResults)tableItem.getData();
    }

    private RemoteResults getFullSelectedResult() {
        RemoteResults remoteResults = this.getSelectedResultSubset();
        return RemoteUtils.queryServer(this.m_ip.getText(), this.m_userName.getText(), this.m_password.getText(), remoteResults.jobId, this);
    }

    private boolean doOk() {
        RemoteUtils.saveServerLocations(this.m_ip);
        RemoteUtils.saveUserName(this.m_userName);
        String string = this.m_ip.getText();
        String string2 = this.m_userName.getText();
        String string3 = this.m_password.getText();
        RemoteResults remoteResults = this.getFullSelectedResult();
        boolean bl = true;
        if (remoteResults != null) {
            String string4 = this.getFullSelectedResult().resultsDir;
            TransferFilesDialog transferFilesDialog = new TransferFilesDialog(this.m_transfer.getShell(), string, string2, string3, string4);
            transferFilesDialog.open();
            if (transferFilesDialog.getCancel()) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            if (this.m_saveAs.getSelection() && !this.doSaveAs()) {
                bl = false;
            }
            RemoteUtils.sendOutputToWorkbench(remoteResults.constructOutput());
        }
        return bl;
    }

    private boolean doSaveAs() {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            RemoteResults remoteResults = this.getFullSelectedResult();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\n");
            stringBuffer.append(UiProperties.getString("MonitorJobsDialog.SplusFunction_Library_SPXML"));
            stringBuffer.append("\n");
            stringBuffer.append(this.m_saveAsName.getText());
            stringBuffer.append(" <- ");
            stringBuffer.append(UiProperties.getString("MonitorJobsDialog.SplusFunction_ParseXmlString_Call"));
            stringBuffer.append(defaultConnection.escapeSpecialCharacters(remoteResults.resultSpxml));
            stringBuffer.append(UiProperties.getString("MonitorJobsDialog.SplusFunction_ParseXmlString_Suffix"));
            stringBuffer.append("\n}");
            SplusDataResult splusDataResult = defaultConnection.processDataQuery(stringBuffer.toString());
            if (this.handleSplusDataResultIssues(splusDataResult, UiProperties.getString("MonitorJobsDialog.SaveAs"))) {
                return false;
            }
        }
        return true;
    }

    public void open() {
        this.doVoidOpen();
    }
}

