/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class LineAndShapeRenderer
implements CategoryItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected double shapeScale = 6.0;

    public LineAndShapeRenderer() {
        this(3);
    }

    public LineAndShapeRenderer(int n) {
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
    }

    public boolean isStacked() {
        return false;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryDataset categoryDataset) {
    }

    public Shape drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Object object3 = null;
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object4;
            double d = categoryPlot.getCategoryCoordinate(n2, rectangle2D);
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            if (this.plotShapes) {
                object4 = categoryPlot.getShape(n, object, d, d2, this.shapeScale);
                graphics2D.fill((Shape)object4);
                object3 = object4;
            }
            if (this.plotLines && object2 != null && (object4 = categoryDataset.getValue(n, object2)) != null) {
                double d3 = categoryPlot.getCategoryCoordinate(n2 - 1, rectangle2D);
                double d4 = valueAxis.translateValueToJava2D(((Number)object4).doubleValue(), rectangle2D);
                graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                Line2D.Double double_ = new Line2D.Double(d3, d4, d, d2);
                graphics2D.draw(double_);
            }
        }
        return object3;
    }
}

