/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.ToolTipsCollection;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class XYPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
PropertyChangeListener {
    protected XYItemRenderer renderer;
    protected List verticalLines = null;
    protected List verticalColors = null;
    protected List horizontalLines = null;
    protected List horizontalColors = null;
    protected XYToolTipGenerator toolTipGenerator;

    public XYPlot(ValueAxis valueAxis, ValueAxis valueAxis2) {
        this(valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, new StandardXYItemRenderer(), new StandardXYToolTipGenerator());
    }

    public XYPlot(ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this(valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, xYItemRenderer, new StandardXYToolTipGenerator());
    }

    public XYPlot(ValueAxis valueAxis, ValueAxis valueAxis2, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, XYItemRenderer xYItemRenderer, XYToolTipGenerator xYToolTipGenerator) {
        super(valueAxis, valueAxis2, insets, paint, image, f, stroke, paint2, f2);
        this.renderer = xYItemRenderer;
        this.renderer.addPropertyChangeListener(this);
        this.toolTipGenerator = xYToolTipGenerator;
    }

    public XYItemRenderer getItemRenderer() {
        return this.renderer;
    }

    public void setXYItemRenderer(XYItemRenderer xYItemRenderer) {
        boolean bl = false;
        if (this.renderer != null) {
            if (!this.renderer.equals(xYItemRenderer)) {
                this.renderer.removePropertyChangeListener(this);
                this.renderer = xYItemRenderer;
                bl = true;
            }
        } else if (xYItemRenderer != null) {
            this.renderer = xYItemRenderer;
            bl = true;
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
    }

    public XYDataset getDataset() {
        return (XYDataset)this.chart.getDataset();
    }

    public void addVerticalLine(Number number) {
        this.addVerticalLine(number, Color.blue);
    }

    public void addVerticalLine(Number number, Paint paint) {
        if (this.verticalLines == null) {
            this.verticalLines = new ArrayList();
            this.verticalColors = new ArrayList();
        }
        this.verticalColors.add(paint);
        this.verticalLines.add(number);
    }

    public void addHorizontalLine(Number number) {
        this.addHorizontalLine(number, Color.red);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addHorizontalLine(Number number, Paint paint) {
        if (this.horizontalLines == null) {
            this.horizontalLines = new ArrayList();
            this.horizontalColors = new ArrayList();
        }
        this.horizontalColors.add(paint);
        this.horizontalLines.add(number);
    }

    public ValueAxis getDomainAxis() {
        return (ValueAxis)this.horizontalAxis;
    }

    public ValueAxis getRangeAxis() {
        return (ValueAxis)this.verticalAxis;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        if (axis instanceof HorizontalNumberAxis) {
            return true;
        }
        return axis instanceof HorizontalDateAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo) {
        ToolTipsCollection toolTipsCollection = null;
        if (drawInfo != null) {
            drawInfo.setPlotArea(rectangle2D);
            toolTipsCollection = drawInfo.getToolTipsCollection();
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        HorizontalAxis horizontalAxis = this.getHorizontalAxis();
        VerticalAxis verticalAxis = this.getVerticalAxis();
        double d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D);
        Rectangle2D rectangle2D2 = verticalAxis.reserveAxisArea(graphics2D, this, rectangle2D, d);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D2.getWidth(), rectangle2D.getY(), rectangle2D.getWidth() - rectangle2D2.getWidth(), rectangle2D.getHeight() - d);
        if (drawInfo != null) {
            drawInfo.setDataArea(double_);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawOutlineAndBackground(graphics2D, double_);
        this.horizontalAxis.draw(graphics2D, rectangle2D, double_);
        this.verticalAxis.draw(graphics2D, rectangle2D, double_);
        XYDataset xYDataset = this.getDataset();
        if (xYDataset != null) {
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip(double_);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawVerticalLines(graphics2D, double_);
            this.drawHorizontalLines(graphics2D, double_);
            double d2 = this.getRangeAxis().translateValueToJava2D(0.0, double_);
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    Shape shape2 = this.renderer.drawItem(graphics2D, double_, drawInfo, this, (ValueAxis)this.horizontalAxis, (ValueAxis)this.verticalAxis, xYDataset, n2, n4, d2, crosshairInfo);
                    if (toolTipsCollection != null) {
                        if (this.toolTipGenerator == null) {
                            this.toolTipGenerator = new StandardXYToolTipGenerator();
                        }
                        String string = this.toolTipGenerator.generateToolTip(xYDataset, n2, n4);
                        if (shape2 != null) {
                            toolTipsCollection.addToolTip(string, shape2);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            ValueAxis valueAxis = (ValueAxis)this.horizontalAxis;
            valueAxis.setCrosshairValue(crosshairInfo.getCrosshairX());
            if (valueAxis.isCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, double_, valueAxis.getCrosshairValue(), valueAxis.getCrosshairStroke(), valueAxis.getCrosshairPaint());
            }
            ValueAxis valueAxis2 = (ValueAxis)this.verticalAxis;
            valueAxis2.setCrosshairValue(crosshairInfo.getCrosshairY());
            if (valueAxis2.isCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, double_, valueAxis2.getCrosshairValue(), valueAxis2.getCrosshairStroke(), valueAxis2.getCrosshairPaint());
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
    }

    private void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    private void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    private void drawVerticalLines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.verticalLines != null) {
            int n = 0;
            while (n < this.verticalLines.size()) {
                graphics2D.setPaint((Paint)this.verticalColors.get(n));
                graphics2D.setStroke(new BasicStroke(1.0f));
                Number number = (Number)this.verticalLines.get(n);
                int n2 = (int)this.getDomainAxis().translateValueToJava2D(number.doubleValue(), rectangle2D);
                graphics2D.drawLine(n2, 0, n2, (int)rectangle2D.getHeight());
                ++n;
            }
        }
    }

    private void drawHorizontalLines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.horizontalLines != null) {
            int n = 0;
            while (n < this.horizontalLines.size()) {
                graphics2D.setPaint((Paint)this.horizontalColors.get(n));
                graphics2D.setStroke(new BasicStroke(1.0f));
                Number number = (Number)this.horizontalLines.get(n);
                int n2 = (int)this.getRangeAxis().translateValueToJava2D(number.doubleValue(), rectangle2D);
                graphics2D.drawLine(0, n2, (int)rectangle2D.getWidth(), n2);
                ++n;
            }
        }
    }

    public void handleClick(int n, int n2, DrawInfo drawInfo) {
        ValueAxis valueAxis = this.getDomainAxis();
        double d = valueAxis.translateJava2DtoValue(n, drawInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        valueAxis.setCrosshairValue(d);
        ValueAxis valueAxis2 = this.getRangeAxis();
        double d2 = valueAxis2.translateJava2DtoValue(n2, drawInfo.getDataArea());
        valueAxis2.setAnchorValue(d2);
        valueAxis2.setCrosshairValue(d2);
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getMaximumAxisValue() - valueAxis2.getMinimumAxisValue();
            d3 = d2 * d;
            valueAxis2.setAnchoredRange(d3);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "XY Plot";
    }

    public Number getMinimumHorizontalDataValue() {
        Dataset dataset;
        Number number = null;
        if (this.chart != null && (dataset = this.getChart().getDataset()) != null) {
            number = DatasetUtilities.getMinimumDomainValue((Dataset)dataset);
        }
        return number;
    }

    public Number getMaximumHorizontalDataValue() {
        Dataset dataset;
        Number number = null;
        if (this.chart != null && (dataset = this.chart.getDataset()) != null) {
            number = DatasetUtilities.getMaximumDomainValue((Dataset)dataset);
        }
        return number;
    }

    public Number getMinimumVerticalDataValue() {
        Dataset dataset;
        Number number = null;
        if (this.chart != null && (dataset = this.chart.getDataset()) != null) {
            number = DatasetUtilities.getMinimumRangeValue((Dataset)dataset);
        }
        return number;
    }

    public Number getMaximumVerticalDataValue() {
        Dataset dataset;
        Number number = null;
        if (this.chart != null && (dataset = this.getChart().getDataset()) != null) {
            number = DatasetUtilities.getMaximumRangeValue((Dataset)dataset);
        }
        return number;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }
}

