/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.data.LinearPlotFitAlgorithm;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.chart.data.PlotFit;
import com.jrefinery.chart.demo.DemoDatasetFactory;
import com.jrefinery.chart.demo.SampleXYDataset;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.GradientPaint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JFreeChartServletDemo
extends HttpServlet {
    ServletContext context = null;

    protected Color getColor(int n) {
        switch (n % 11) {
            case 0: {
                return Color.white;
            }
            case 1: {
                return Color.black;
            }
            case 2: {
                return Color.blue;
            }
            case 3: {
                return Color.green;
            }
            case 4: {
                return Color.red;
            }
            case 5: {
                return Color.yellow;
            }
            case 6: {
                return Color.gray;
            }
            case 7: {
                return Color.orange;
            }
            case 8: {
                return Color.cyan;
            }
            case 9: {
                return Color.magenta;
            }
            case 10: {
                return Color.pink;
            }
        }
        return Color.white;
    }

    public CategoryDataset createCategoryDataset() {
        Number[][] numberArray = new Integer[][]{{new Integer(10), new Integer(4), new Integer(15), new Integer(14)}, {new Integer(5), new Integer(7), new Integer(14), new Integer(3)}, {new Integer(6), new Integer(17), new Integer(12), new Integer(7)}, {new Integer(7), new Integer(15), new Integer(11), new Integer(0)}, {new Integer(8), new Integer(6), new Integer(10), new Integer(9)}, {new Integer(9), new Integer(8), new Integer(8), new Integer(6)}, {new Integer(10), new Integer(9), new Integer(7), new Integer(7)}, {new Integer(11), new Integer(13), new Integer(9), new Integer(9)}, {new Integer(3), new Integer(7), new Integer(11), new Integer(10)}};
        return new DefaultCategoryDataset(numberArray);
    }

    private Date createDate(int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
        return gregorianCalendar.getTime();
    }

    private Date createDateTime(int n, int n2, int n3, int n4, int n5) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5);
        return gregorianCalendar.getTime();
    }

    public XYDataset createTestXYDataset() {
        Object[][][] objectArray = new Object[][][]{{{this.createDateTime(2000, 9, 18, 9, 5), new Double(10921.0)}, {this.createDateTime(2000, 9, 18, 10, 6), new Double(10886.7)}, {this.createDateTime(2000, 9, 18, 11, 6), new Double(10846.6)}, {this.createDateTime(2000, 9, 18, 12, 6), new Double(10843.7)}, {this.createDateTime(2000, 9, 18, 13, 6), new Double(10841.2)}, {this.createDateTime(2000, 9, 18, 14, 6), new Double(10830.7)}, {this.createDateTime(2000, 9, 18, 15, 6), new Double(10795.8)}, {this.createDateTime(2000, 9, 18, 16, 7), new Double(10733.8)}}};
        return new DefaultXYDataset(objectArray);
    }

    public HighLowDataset createHighLowDataset() {
        Object[][][] objectArrayArray = new Object[][][]{{{this.createDate(1999, 0, 4), new Double(47.0)}, {this.createDate(1999, 0, 4), new Double(33.0)}, {this.createDate(1999, 0, 4), new Double(35.0)}, {this.createDate(1999, 0, 4), new Double(33.0)}, {this.createDate(1999, 0, 5), new Double(47.0)}, {this.createDate(1999, 0, 5), new Double(32.0)}, {this.createDate(1999, 0, 5), new Double(41.0)}, {this.createDate(1999, 0, 5), new Double(37.0)}, {this.createDate(1999, 0, 6), new Double(49.0)}, {this.createDate(1999, 0, 6), new Double(43.0)}, {this.createDate(1999, 0, 6), new Double(46.0)}, {this.createDate(1999, 0, 6), new Double(48.0)}, {this.createDate(1999, 0, 7), new Double(51.0)}, {this.createDate(1999, 0, 7), new Double(39.0)}, {this.createDate(1999, 0, 7), new Double(40.0)}, {this.createDate(1999, 0, 7), new Double(47.0)}, {this.createDate(1999, 0, 8), new Double(60.0)}, {this.createDate(1999, 0, 8), new Double(40.0)}, {this.createDate(1999, 0, 8), new Double(46.0)}, {this.createDate(1999, 0, 8), new Double(53.0)}, {this.createDate(1999, 0, 9), new Double(62.0)}, {this.createDate(1999, 0, 9), new Double(55.0)}, {this.createDate(1999, 0, 9), new Double(57.0)}, {this.createDate(1999, 0, 9), new Double(61.0)}, {this.createDate(1999, 0, 10), new Double(65.0)}, {this.createDate(1999, 0, 10), new Double(56.0)}, {this.createDate(1999, 0, 10), new Double(62.0)}, {this.createDate(1999, 0, 10), new Double(59.0)}, {this.createDate(1999, 0, 11), new Double(55.0)}, {this.createDate(1999, 0, 11), new Double(43.0)}, {this.createDate(1999, 0, 11), new Double(45.0)}, {this.createDate(1999, 0, 11), new Double(47.0)}, {this.createDate(1999, 0, 12), new Double(54.0)}, {this.createDate(1999, 0, 12), new Double(33.0)}, {this.createDate(1999, 0, 12), new Double(40.0)}, {this.createDate(1999, 0, 12), new Double(51.0)}, {this.createDate(1999, 0, 13), new Double(58.0)}, {this.createDate(1999, 0, 13), new Double(42.0)}, {this.createDate(1999, 0, 13), new Double(44.0)}, {this.createDate(1999, 0, 13), new Double(57.0)}, {this.createDate(1999, 0, 14), new Double(54.0)}, {this.createDate(1999, 0, 14), new Double(38.0)}, {this.createDate(1999, 0, 14), new Double(43.0)}, {this.createDate(1999, 0, 14), new Double(52.0)}, {this.createDate(1999, 0, 15), new Double(48.0)}, {this.createDate(1999, 0, 15), new Double(41.0)}, {this.createDate(1999, 0, 15), new Double(44.0)}, {this.createDate(1999, 0, 15), new Double(41.0)}, {this.createDate(1999, 0, 17), new Double(60.0)}, {this.createDate(1999, 0, 17), new Double(30.0)}, {this.createDate(1999, 0, 17), new Double(34.0)}, {this.createDate(1999, 0, 17), new Double(44.0)}, {this.createDate(1999, 0, 18), new Double(58.0)}, {this.createDate(1999, 0, 18), new Double(44.0)}, {this.createDate(1999, 0, 18), new Double(54.0)}, {this.createDate(1999, 0, 18), new Double(56.0)}, {this.createDate(1999, 0, 19), new Double(54.0)}, {this.createDate(1999, 0, 19), new Double(32.0)}, {this.createDate(1999, 0, 19), new Double(42.0)}, {this.createDate(1999, 0, 19), new Double(53.0)}, {this.createDate(1999, 0, 20), new Double(53.0)}, {this.createDate(1999, 0, 20), new Double(39.0)}, {this.createDate(1999, 0, 20), new Double(50.0)}, {this.createDate(1999, 0, 20), new Double(49.0)}, {this.createDate(1999, 0, 21), new Double(47.0)}, {this.createDate(1999, 0, 21), new Double(38.0)}, {this.createDate(1999, 0, 21), new Double(41.0)}, {this.createDate(1999, 0, 21), new Double(40.0)}, {this.createDate(1999, 0, 22), new Double(55.0)}, {this.createDate(1999, 0, 22), new Double(37.0)}, {this.createDate(1999, 0, 22), new Double(43.0)}, {this.createDate(1999, 0, 22), new Double(45.0)}, {this.createDate(1999, 0, 23), new Double(54.0)}, {this.createDate(1999, 0, 23), new Double(42.0)}, {this.createDate(1999, 0, 23), new Double(50.0)}, {this.createDate(1999, 0, 23), new Double(42.0)}, {this.createDate(1999, 0, 24), new Double(48.0)}, {this.createDate(1999, 0, 24), new Double(37.0)}, {this.createDate(1999, 0, 24), new Double(37.0)}, {this.createDate(1999, 0, 24), new Double(47.0)}, {this.createDate(1999, 0, 25), new Double(58.0)}, {this.createDate(1999, 0, 25), new Double(33.0)}, {this.createDate(1999, 0, 25), new Double(39.0)}, {this.createDate(1999, 0, 25), new Double(41.0)}, {this.createDate(1999, 0, 26), new Double(47.0)}, {this.createDate(1999, 0, 26), new Double(31.0)}, {this.createDate(1999, 0, 26), new Double(36.0)}, {this.createDate(1999, 0, 26), new Double(41.0)}, {this.createDate(1999, 0, 27), new Double(58.0)}, {this.createDate(1999, 0, 27), new Double(44.0)}, {this.createDate(1999, 0, 27), new Double(49.0)}, {this.createDate(1999, 0, 27), new Double(44.0)}, {this.createDate(1999, 0, 28), new Double(46.0)}, {this.createDate(1999, 0, 28), new Double(41.0)}, {this.createDate(1999, 0, 28), new Double(43.0)}, {this.createDate(1999, 0, 28), new Double(44.0)}, {this.createDate(1999, 0, 29), new Double(56.0)}, {this.createDate(1999, 0, 29), new Double(39.0)}, {this.createDate(1999, 0, 29), new Double(39.0)}, {this.createDate(1999, 0, 29), new Double(51.0)}, {this.createDate(1999, 0, 30), new Double(56.0)}, {this.createDate(1999, 0, 30), new Double(39.0)}, {this.createDate(1999, 0, 30), new Double(47.0)}, {this.createDate(1999, 0, 30), new Double(49.0)}, {this.createDate(1999, 0, 31), new Double(53.0)}, {this.createDate(1999, 0, 31), new Double(39.0)}, {this.createDate(1999, 0, 31), new Double(52.0)}, {this.createDate(1999, 0, 31), new Double(47.0)}, {this.createDate(1999, 1, 1), new Double(51.0)}, {this.createDate(1999, 1, 1), new Double(30.0)}, {this.createDate(1999, 1, 1), new Double(45.0)}, {this.createDate(1999, 1, 1), new Double(47.0)}, {this.createDate(1999, 1, 2), new Double(47.0)}, {this.createDate(1999, 1, 2), new Double(30.0)}, {this.createDate(1999, 1, 2), new Double(34.0)}, {this.createDate(1999, 1, 2), new Double(46.0)}, {this.createDate(1999, 1, 3), new Double(57.0)}, {this.createDate(1999, 1, 3), new Double(37.0)}, {this.createDate(1999, 1, 3), new Double(44.0)}, {this.createDate(1999, 1, 3), new Double(56.0)}, {this.createDate(1999, 1, 4), new Double(49.0)}, {this.createDate(1999, 1, 4), new Double(40.0)}, {this.createDate(1999, 1, 4), new Double(47.0)}, {this.createDate(1999, 1, 4), new Double(44.0)}, {this.createDate(1999, 1, 5), new Double(46.0)}, {this.createDate(1999, 1, 5), new Double(38.0)}, {this.createDate(1999, 1, 5), new Double(43.0)}, {this.createDate(1999, 1, 5), new Double(40.0)}, {this.createDate(1999, 1, 6), new Double(55.0)}, {this.createDate(1999, 1, 6), new Double(38.0)}, {this.createDate(1999, 1, 6), new Double(39.0)}, {this.createDate(1999, 1, 6), new Double(53.0)}, {this.createDate(1999, 1, 7), new Double(50.0)}, {this.createDate(1999, 1, 7), new Double(33.0)}, {this.createDate(1999, 1, 7), new Double(37.0)}, {this.createDate(1999, 1, 7), new Double(37.0)}, {this.createDate(1999, 1, 8), new Double(59.0)}, {this.createDate(1999, 1, 8), new Double(34.0)}, {this.createDate(1999, 1, 8), new Double(57.0)}, {this.createDate(1999, 1, 8), new Double(43.0)}, {this.createDate(1999, 1, 9), new Double(48.0)}, {this.createDate(1999, 1, 9), new Double(39.0)}, {this.createDate(1999, 1, 9), new Double(46.0)}, {this.createDate(1999, 1, 9), new Double(47.0)}, {this.createDate(1999, 1, 10), new Double(55.0)}, {this.createDate(1999, 1, 10), new Double(30.0)}, {this.createDate(1999, 1, 10), new Double(37.0)}, {this.createDate(1999, 1, 10), new Double(30.0)}, {this.createDate(1999, 1, 11), new Double(60.0)}, {this.createDate(1999, 1, 11), new Double(32.0)}, {this.createDate(1999, 1, 11), new Double(56.0)}, {this.createDate(1999, 1, 11), new Double(36.0)}, {this.createDate(1999, 1, 12), new Double(56.0)}, {this.createDate(1999, 1, 12), new Double(42.0)}, {this.createDate(1999, 1, 12), new Double(53.0)}, {this.createDate(1999, 1, 12), new Double(54.0)}, {this.createDate(1999, 1, 13), new Double(49.0)}, {this.createDate(1999, 1, 13), new Double(42.0)}, {this.createDate(1999, 1, 13), new Double(45.0)}, {this.createDate(1999, 1, 13), new Double(42.0)}, {this.createDate(1999, 1, 14), new Double(55.0)}, {this.createDate(1999, 1, 14), new Double(42.0)}, {this.createDate(1999, 1, 14), new Double(47.0)}, {this.createDate(1999, 1, 14), new Double(54.0)}, {this.createDate(1999, 1, 15), new Double(49.0)}, {this.createDate(1999, 1, 15), new Double(35.0)}, {this.createDate(1999, 1, 15), new Double(38.0)}, {this.createDate(1999, 1, 15), new Double(35.0)}, {this.createDate(1999, 1, 16), new Double(47.0)}, {this.createDate(1999, 1, 16), new Double(38.0)}, {this.createDate(1999, 1, 16), new Double(43.0)}, {this.createDate(1999, 1, 16), new Double(42.0)}, {this.createDate(1999, 1, 17), new Double(53.0)}, {this.createDate(1999, 1, 17), new Double(42.0)}, {this.createDate(1999, 1, 17), new Double(47.0)}, {this.createDate(1999, 1, 17), new Double(48.0)}, {this.createDate(1999, 1, 18), new Double(47.0)}, {this.createDate(1999, 1, 18), new Double(44.0)}, {this.createDate(1999, 1, 18), new Double(46.0)}, {this.createDate(1999, 1, 18), new Double(44.0)}, {this.createDate(1999, 1, 19), new Double(46.0)}, {this.createDate(1999, 1, 19), new Double(40.0)}, {this.createDate(1999, 1, 19), new Double(43.0)}, {this.createDate(1999, 1, 19), new Double(44.0)}, {this.createDate(1999, 1, 20), new Double(48.0)}, {this.createDate(1999, 1, 20), new Double(41.0)}, {this.createDate(1999, 1, 20), new Double(46.0)}, {this.createDate(1999, 1, 20), new Double(41.0)}}};
        return null;
    }

    protected JFreeChart createChart(int n, int n2, int n3) {
        CategoryDataset categoryDataset = this.createCategoryDataset();
        try {
            switch (n) {
                case 1: {
                    JFreeChart jFreeChart = ChartFactory.createVerticalBarChart("Vertical Bar Chart", "Categories", "Values", categoryDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    Plot plot = jFreeChart.getPlot();
                    HorizontalCategoryAxis horizontalCategoryAxis = (HorizontalCategoryAxis)plot.getAxis(0);
                    horizontalCategoryAxis.setVerticalCategoryLabels(true);
                    return jFreeChart;
                }
                case 2: {
                    JFreeChart jFreeChart = ChartFactory.createHorizontalBarChart("Horizontal Bar Chart", "Categories", "Values", categoryDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    return jFreeChart;
                }
                case 3: {
                    JFreeChart jFreeChart = ChartFactory.createLineChart("Line Chart", "Categories", "Values", categoryDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    return jFreeChart;
                }
                case 4: {
                    SampleXYDataset sampleXYDataset = new SampleXYDataset();
                    JFreeChart jFreeChart = ChartFactory.createXYChart("XY Plot", "X", "Y", sampleXYDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    Plot plot = jFreeChart.getPlot();
                    return jFreeChart;
                }
                case 5: {
                    TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection3();
                    JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Time Series Chart", "Date", "USD per GBP", (XYDataset)timeSeriesCollection, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)jFreeChart.getPlot().getAxis(1);
                    verticalNumberAxis.setAutoRangeIncludesZero(false);
                    jFreeChart.setDataset((Dataset)timeSeriesCollection);
                    return jFreeChart;
                }
                case 6: {
                    categoryDataset = this.createCategoryDataset();
                    PieDataset pieDataset = DatasetUtilities.createPieDataset((CategoryDataset)categoryDataset, (int)0);
                    JFreeChart jFreeChart = ChartFactory.createPieChart("Pie Chart", pieDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    return jFreeChart;
                }
                case 7: {
                    HighLowDataset highLowDataset = this.createHighLowDataset();
                    JFreeChart jFreeChart = ChartFactory.createHighLowChart("High-Low-Open-Close IBM", "Date", "Price", highLowDataset, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    Plot plot = jFreeChart.getPlot();
                    Axis axis = plot.getAxis(1);
                    axis.setLabel("Price in ($) per share");
                    return jFreeChart;
                }
                case 8: {
                    TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection3();
                    MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
                    movingAveragePlotFitAlgorithm.setPeriod(30);
                    PlotFit plotFit = new PlotFit((XYDataset)timeSeriesCollection, movingAveragePlotFitAlgorithm);
                    timeSeriesCollection = plotFit.getFit();
                    JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Moving Average", "Date", "Value", (XYDataset)timeSeriesCollection, true);
                    jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(n2), 1000.0f, 0.0f, this.getColor(n3)));
                    Plot plot = jFreeChart.getPlot();
                    Axis axis = plot.getAxis(1);
                    axis.setLabel("USD per GBP");
                    VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)jFreeChart.getPlot().getAxis(1);
                    verticalNumberAxis.setAutoRangeIncludesZero(false);
                    jFreeChart.setDataset((Dataset)timeSeriesCollection);
                    return jFreeChart;
                }
                case 9: {
                    TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection2();
                    PlotFit plotFit = new PlotFit((XYDataset)timeSeriesCollection, new LinearPlotFitAlgorithm());
                    timeSeriesCollection = plotFit.getFit();
                    JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Linear Fit", "Date", "Value", (XYDataset)timeSeriesCollection, true);
                    Plot plot = jFreeChart.getPlot();
                    Axis axis = plot.getAxis(1);
                    axis.setLabel("USD per GBP");
                    VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)jFreeChart.getPlot().getAxis(1);
                    verticalNumberAxis.setAutoRangeIncludesZero(false);
                    jFreeChart.setDataset((Dataset)timeSeriesCollection);
                    return jFreeChart;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("image/jpeg");
        int n = 1;
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(httpServletRequest.getParameter("initGradColor"));
            n3 = Integer.parseInt(httpServletRequest.getParameter("finalGradColor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFreeChart jFreeChart = this.createChart(n, n2, n3);
        int n4 = 400;
        int n5 = 300;
        try {
            n4 = Integer.parseInt(httpServletRequest.getParameter("width"));
            n5 = Integer.parseInt(httpServletRequest.getParameter("height"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ChartUtilities.writeChartAsJPEG((OutputStream)servletOutputStream, jFreeChart, n4, n5);
        servletOutputStream.close();
    }
}

