/*
 * Decompiled with CFR 0.152.
 */
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusUserApp;
import com.insightful.splus.util.ResultSetUtilities;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ResultSetExample {
    public void splusExample() {
        LocalResultSet localResultSet = new LocalResultSet();
        ResultSetUtilities.register((String)"mySetId", (ResultSet)localResultSet);
        System.out.println("Transferring the ResultSet to test.df in S-PLUS.");
        String string = "assign(\"test.df\", javaGetResultSet(\"mySetId\", client = T), where = 1)\n";
        SplusDataResult splusDataResult = SplusUserApp.eval((String)string);
        if (splusDataResult.hasError()) {
            System.out.println(splusDataResult.getError());
        }
        if (splusDataResult.hasWarning()) {
            String[] stringArray = splusDataResult.getWarning();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
        System.out.println("Printing test.df in S-PLUS.");
        string = "if (exists(\"test.df\")) print(test.df) else print(\"test.df does not exist\")\n";
        splusDataResult = SplusUserApp.eval((String)string, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        System.out.println(splusDataResult.getOutput());
    }

    public void nosplusExample() {
        LocalResultSet localResultSet = new LocalResultSet();
        ResultSetUtilities.register((String)"mySetId", (ResultSet)localResultSet);
        try {
            Object[] objectArray = ResultSetUtilities.getData((String)"mySetId");
            String[] stringArray = (String[])objectArray[0];
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("colnames[" + i + "]=" + stringArray[i]);
            }
            String[] stringArray2 = (String[])objectArray[1];
            int n = -1;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals("String")) continue;
                n = i;
                break;
            }
            System.out.println("stringCol=" + n);
            if (n != -1) {
                Object[] objectArray2 = (Object[])objectArray[3];
                String[] stringArray3 = (String[])objectArray2[n];
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println("arrStr[" + i + "]=" + stringArray3[i]);
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        ResultSetExample resultSetExample = new ResultSetExample();
        if (stringArray.length > 0 && stringArray[0].equals("nosplus")) {
            resultSetExample.nosplusExample();
        } else {
            resultSetExample.splusExample();
        }
        System.exit(0);
    }

    public class LocalResultSetMetaData
    implements ResultSetMetaData {
        String[] colNames;
        int[] colTypes;
        String[] colTypeNames;

        public LocalResultSetMetaData(String[] stringArray, int[] nArray, String[] stringArray2) {
            if (stringArray.length != nArray.length || stringArray.length != stringArray2.length) {
                throw new RuntimeException("All argument arrays must have the same length");
            }
            this.colNames = stringArray;
            this.colTypes = nArray;
            this.colTypeNames = stringArray2;
        }

        public int getColumnCount() throws SQLException {
            return this.colNames.length;
        }

        public String getColumnName(int n) throws SQLException {
            return this.colNames[n - 1];
        }

        public int getColumnType(int n) throws SQLException {
            return this.colTypes[n - 1];
        }

        public String getColumnTypeName(int n) throws SQLException {
            return this.colTypeNames[n - 1];
        }

        public String getCatalogName(int n) throws SQLException {
            return null;
        }

        public String getColumnClassName(int n) throws SQLException {
            return null;
        }

        public int getColumnDisplaySize(int n) throws SQLException {
            return 0;
        }

        public String getColumnLabel(int n) throws SQLException {
            return null;
        }

        public int getPrecision(int n) throws SQLException {
            return 0;
        }

        public int getScale(int n) throws SQLException {
            return 0;
        }

        public String getSchemaName(int n) throws SQLException {
            return null;
        }

        public String getTableName(int n) throws SQLException {
            return null;
        }

        public boolean isAutoIncrement(int n) throws SQLException {
            return false;
        }

        public boolean isCaseSensitive(int n) throws SQLException {
            return false;
        }

        public boolean isCurrency(int n) throws SQLException {
            return false;
        }

        public boolean isDefinitelyWritable(int n) throws SQLException {
            return false;
        }

        public int isNullable(int n) throws SQLException {
            return 0;
        }

        public boolean isReadOnly(int n) throws SQLException {
            return false;
        }

        public boolean isSearchable(int n) throws SQLException {
            return false;
        }

        public boolean isSigned(int n) throws SQLException {
            return false;
        }

        public boolean isWritable(int n) throws SQLException {
            return false;
        }
    }

    public class LocalResultSet
    implements ResultSet {
        int scrollType = 1004;
        int curRow = 0;
        int lastRow = 3;
        String[] colNames;
        int[] colTypes;
        String[] colTypeNames;
        ResultSetMetaData metaData;
        Object[][] dataVals = new Object[][]{{new Double(1.1), new Double(2.2), new Double(3.3)}, {new Integer(1), new Integer(2), new Integer(3)}, {"a1", "b2", "c3"}, {new Boolean(true), new Boolean(false), new Boolean(true)}, {new Timestamp(10000L), new Timestamp(20000L), new Timestamp(30000L)}};

        public LocalResultSet() {
            this.colNames = new String[]{"DoubleCol", "IntegerCol", "StringCol", "BooleanCol", "TimestampCol"};
            this.colTypes = new int[]{8, 4, 1, -7, 93};
            this.colTypeNames = new String[]{"Double", "Integer", "String", "Boolean", "Timestamp"};
            this.metaData = new LocalResultSetMetaData(this.colNames, this.colTypes, this.colTypeNames);
        }

        public boolean next() throws SQLException {
            if (this.curRow == this.lastRow) {
                return false;
            }
            ++this.curRow;
            return true;
        }

        public Object getObject(int n) throws SQLException {
            return this.dataVals[n - 1][this.curRow - 1];
        }

        public void beforeFirst() throws SQLException {
            this.curRow = 0;
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            return this.metaData;
        }

        public int getRow() throws SQLException {
            return this.curRow;
        }

        public int getType() throws SQLException {
            return this.scrollType;
        }

        public boolean last() throws SQLException {
            if (this.lastRow == 0) {
                return false;
            }
            this.curRow = this.lastRow;
            return true;
        }

        public boolean absolute(int n) throws SQLException {
            this.curRow = n > 0 ? n : this.lastRow + n;
            if (this.curRow <= 0) {
                this.curRow = 0;
                return false;
            }
            if (this.curRow > this.lastRow) {
                this.curRow = this.lastRow + 1;
                return false;
            }
            return true;
        }

        public void afterLast() throws SQLException {
            this.curRow = this.lastRow + 1;
        }

        public void cancelRowUpdates() throws SQLException {
        }

        public void clearWarnings() throws SQLException {
        }

        public void close() throws SQLException {
        }

        public void deleteRow() throws SQLException {
        }

        public int findColumn(String string) throws SQLException {
            for (int i = 0; i < this.colNames.length; ++i) {
                if (!this.colNames[i].equals(string)) continue;
                return i + 1;
            }
            return 0;
        }

        public boolean first() throws SQLException {
            if (this.lastRow == 0) {
                return false;
            }
            this.curRow = 1;
            return true;
        }

        public Array getArray(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getArray(n);
            }
            return null;
        }

        public Array getArray(int n) throws SQLException {
            return (Array)this.dataVals[n - 1][this.curRow - 1];
        }

        public InputStream getAsciiStream(String string) throws SQLException {
            return null;
        }

        public InputStream getAsciiStream(int n) throws SQLException {
            return null;
        }

        public BigDecimal getBigDecimal(String string) throws SQLException {
            return null;
        }

        public BigDecimal getBigDecimal(int n) throws SQLException {
            return null;
        }

        public InputStream getBinaryStream(String string) throws SQLException {
            return null;
        }

        public InputStream getBinaryStream(int n) throws SQLException {
            return null;
        }

        public Blob getBlob(String string) throws SQLException {
            return null;
        }

        public Blob getBlob(int n) throws SQLException {
            return null;
        }

        public boolean getBoolean(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getBoolean(n);
            }
            return false;
        }

        public boolean getBoolean(int n) throws SQLException {
            return (Boolean)this.dataVals[n - 1][this.curRow - 1];
        }

        public byte getByte(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getByte(n);
            }
            return 0;
        }

        public byte getByte(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).byteValue();
        }

        public byte[] getBytes(String string) throws SQLException {
            return new byte[0];
        }

        public byte[] getBytes(int n) throws SQLException {
            return new byte[0];
        }

        public Reader getCharacterStream(String string) throws SQLException {
            return null;
        }

        public Reader getCharacterStream(int n) throws SQLException {
            return null;
        }

        public Clob getClob(String string) throws SQLException {
            return null;
        }

        public Clob getClob(int n) throws SQLException {
            return null;
        }

        public int getConcurrency() throws SQLException {
            return 0;
        }

        public String getCursorName() throws SQLException {
            return null;
        }

        public Date getDate(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getDate(n);
            }
            return null;
        }

        public Date getDate(int n) throws SQLException {
            return (Date)this.dataVals[n - 1][this.curRow - 1];
        }

        public Date getDate(String string, Calendar calendar) throws SQLException {
            return null;
        }

        public Date getDate(int n, Calendar calendar) throws SQLException {
            return null;
        }

        public double getDouble(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getDouble(n);
            }
            return 0.0;
        }

        public double getDouble(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).doubleValue();
        }

        public int getFetchDirection() throws SQLException {
            return 0;
        }

        public int getFetchSize() throws SQLException {
            return 0;
        }

        public float getFloat(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getFloat(n);
            }
            return 0.0f;
        }

        public float getFloat(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).floatValue();
        }

        public int getInt(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getInt(n);
            }
            return 0;
        }

        public int getInt(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).intValue();
        }

        public long getLong(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getLong(n);
            }
            return 0L;
        }

        public long getLong(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).longValue();
        }

        public Object getObject(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getObject(n);
            }
            return null;
        }

        public Object getObject(String string, Map map) throws SQLException {
            return null;
        }

        public Object getObject(int n, Map map) throws SQLException {
            return null;
        }

        public Ref getRef(String string) throws SQLException {
            return null;
        }

        public Ref getRef(int n) throws SQLException {
            return null;
        }

        public short getShort(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getShort(n);
            }
            return 0;
        }

        public short getShort(int n) throws SQLException {
            return ((Number)this.dataVals[n - 1][this.curRow - 1]).shortValue();
        }

        public Statement getStatement() throws SQLException {
            return null;
        }

        public String getString(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getString(n);
            }
            return null;
        }

        public String getString(int n) throws SQLException {
            return (String)this.dataVals[n - 1][this.curRow - 1];
        }

        public Time getTime(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getTime(n);
            }
            return null;
        }

        public Time getTime(int n) throws SQLException {
            return (Time)this.dataVals[n - 1][this.curRow - 1];
        }

        public Time getTime(String string, Calendar calendar) throws SQLException {
            return null;
        }

        public Time getTime(int n, Calendar calendar) throws SQLException {
            return null;
        }

        public Timestamp getTimestamp(String string) throws SQLException {
            int n = this.findColumn(string);
            if (n > 0) {
                return this.getTimestamp(n);
            }
            return null;
        }

        public Timestamp getTimestamp(int n) throws SQLException {
            return (Timestamp)this.dataVals[n - 1][this.curRow - 1];
        }

        public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
            return null;
        }

        public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
            return null;
        }

        public SQLWarning getWarnings() throws SQLException {
            return null;
        }

        public void insertRow() throws SQLException {
        }

        public boolean isAfterLast() throws SQLException {
            return this.curRow > this.lastRow;
        }

        public boolean isBeforeFirst() throws SQLException {
            return this.curRow == 0;
        }

        public boolean isFirst() throws SQLException {
            return this.curRow == 1;
        }

        public boolean isLast() throws SQLException {
            return this.curRow == this.lastRow;
        }

        public void moveToCurrentRow() throws SQLException {
        }

        public void moveToInsertRow() throws SQLException {
        }

        public boolean previous() throws SQLException {
            --this.curRow;
            if (this.curRow <= 0) {
                this.curRow = 0;
                return false;
            }
            return true;
        }

        public void refreshRow() throws SQLException {
        }

        public boolean relative(int n) throws SQLException {
            this.curRow += n;
            if (this.curRow <= 0) {
                this.curRow = 0;
                return false;
            }
            if (this.curRow > this.lastRow) {
                this.curRow = this.lastRow + 1;
                return false;
            }
            return true;
        }

        public boolean rowDeleted() throws SQLException {
            return false;
        }

        public boolean rowInserted() throws SQLException {
            return false;
        }

        public boolean rowUpdated() throws SQLException {
            return false;
        }

        public void updateArray(int n, Array array) throws SQLException {
        }

        public void updateArray(String string, Array array) throws SQLException {
        }

        public void updateClob(int n, Clob clob) throws SQLException {
        }

        public void updateClob(String string, Clob clob) throws SQLException {
        }

        public void updateBlob(int n, Blob blob) throws SQLException {
        }

        public void updateBlob(String string, Blob blob) throws SQLException {
        }

        public void updateRef(int n, Ref ref) throws SQLException {
        }

        public void updateRef(String string, Ref ref) throws SQLException {
        }

        public URL getURL(int n) {
            return null;
        }

        public URL getURL(String string) {
            return null;
        }

        public void setFetchDirection(int n) throws SQLException {
        }

        public void setFetchSize(int n) throws SQLException {
        }

        public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        }

        public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        }

        public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        }

        public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        }

        public void updateBoolean(String string, boolean bl) throws SQLException {
        }

        public void updateBoolean(int n, boolean bl) throws SQLException {
        }

        public void updateByte(String string, byte by) throws SQLException {
        }

        public void updateByte(int n, byte by) throws SQLException {
        }

        public void updateBytes(String string, byte[] byArray) throws SQLException {
        }

        public void updateBytes(int n, byte[] byArray) throws SQLException {
        }

        public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        }

        public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        }

        public void updateDate(String string, Date date) throws SQLException {
        }

        public void updateDate(int n, Date date) throws SQLException {
        }

        public void updateDouble(String string, double d) throws SQLException {
        }

        public void updateDouble(int n, double d) throws SQLException {
        }

        public void updateFloat(String string, float f) throws SQLException {
        }

        public void updateFloat(int n, float f) throws SQLException {
        }

        public void updateInt(String string, int n) throws SQLException {
        }

        public void updateInt(int n, int n2) throws SQLException {
        }

        public void updateLong(String string, long l) throws SQLException {
        }

        public void updateLong(int n, long l) throws SQLException {
        }

        public void updateNull(String string) throws SQLException {
        }

        public void updateNull(int n) throws SQLException {
        }

        public void updateObject(String string, Object object) throws SQLException {
        }

        public void updateObject(int n, Object object) throws SQLException {
        }

        public void updateObject(String string, Object object, int n) throws SQLException {
        }

        public void updateObject(int n, Object object, int n2) throws SQLException {
        }

        public void updateRow() throws SQLException {
        }

        public void updateShort(String string, short s) throws SQLException {
        }

        public void updateShort(int n, short s) throws SQLException {
        }

        public void updateString(String string, String string2) throws SQLException {
        }

        public void updateString(int n, String string) throws SQLException {
        }

        public void updateTime(String string, Time time) throws SQLException {
        }

        public void updateTime(int n, Time time) throws SQLException {
        }

        public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        }

        public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        }

        public boolean wasNull() throws SQLException {
            return false;
        }

        public BigDecimal getBigDecimal(String string, int n) throws SQLException {
            return null;
        }

        public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
            return null;
        }

        public InputStream getUnicodeStream(String string) throws SQLException {
            return null;
        }

        public InputStream getUnicodeStream(int n) throws SQLException {
            return null;
        }
    }
}

