/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.SplusErrorWarningHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class SplusDialog
extends Dialog
implements SplusErrorWarningHandler {
    private Shell m_shell = null;
    private String[] m_libraryList = null;
    private Listener m_stateChangeListener = new Listener(){

        public void handleEvent(Event event) {
            SplusDialog.this.updateDialogState();
        }
    };

    public SplusDialog(Shell shell, String string, String[] stringArray) {
        super(shell, 66800);
        this.setText(string);
        this.m_libraryList = stringArray;
    }

    protected int getInitialWidth() {
        return 400;
    }

    protected int getInitialHeight() {
        return 450;
    }

    protected boolean hasFocus() {
        return false;
    }

    protected abstract void createContents(Shell var1);

    protected abstract void createButtons(Shell var1);

    protected abstract void initializeContents();

    protected boolean initializeLibraryList() {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        boolean bl = true;
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            for (int i = 0; bl && i < this.m_libraryList.length; ++i) {
                SplusDataResult splusDataResult = defaultConnection.processDataQuery(UiProperties.getString("SplusDialog.SplusFunction_Library_Call") + this.m_libraryList[i] + UiProperties.getString("SplusDialog.SplusFunction_Library_Suffix"));
                if (!this.handleSplusDataResultIssues(splusDataResult, UiProperties.getString("SplusDialog.SplusLibraryErrorWarningPrefix"))) continue;
                bl = false;
            }
        }
        return bl;
    }

    protected void updateDialogState() {
    }

    protected void addDialogStateListener(Listener listener) {
    }

    public void handleSplusError(SplusDataResult splusDataResult) {
        this.handleSplusDataResultIssues(splusDataResult, UiProperties.getString("SplusDialog.SplusGeneralErrorWarningPrefix"));
    }

    public void handleSplusWarnings(SplusDataResult splusDataResult) {
        this.handleSplusDataResultIssues(splusDataResult, UiProperties.getString("SplusDialog.SplusGeneralErrorWarningPrefix"));
    }

    protected boolean handleSplusDataResultIssues(SplusDataResult splusDataResult, String string) {
        boolean bl = false;
        if (splusDataResult.hasError()) {
            MessageDialog.openError((Shell)this.getParent(), (String)(string + UiProperties.getString("SplusDialog.ErrorSuffix")), (String)splusDataResult.getError());
            bl = true;
        } else if (splusDataResult.hasWarning()) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = splusDataResult.getWarning();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(stringArray[i]);
            }
            MessageDialog.openWarning((Shell)this.getParent(), (String)(string + UiProperties.getString("SplusDialog.WarningSuffix")), (String)stringBuffer.toString());
        }
        return bl;
    }

    protected void handleException(Exception exception, String string, boolean bl) {
        MessageDialog.openError((Shell)this.getParent(), (String)string, (String)exception.getMessage());
        if (bl) {
            exception.printStackTrace();
        }
    }

    protected void setupDialogView() {
        Image[] imageArray;
        Shell shell = this.getParent();
        this.m_shell = new Shell(shell, this.getStyle());
        this.m_shell.setText(this.getText());
        Image image = shell.getImage();
        if (image != null) {
            this.m_shell.setImage(image);
        }
        if ((imageArray = DefaultDialog.getImages((Shell)shell)) != null) {
            this.m_shell.setImages(imageArray);
        }
        this.m_shell.setLayout((Layout)new GridLayout(1, true));
        this.createContents(this.m_shell);
        this.createButtons(this.m_shell);
        this.addDialogStateListener(this.m_stateChangeListener);
    }

    protected void doDialogOpen() {
        this.m_shell.pack();
        this.m_shell.setSize(this.getInitialWidth(), this.getInitialHeight());
        this.m_shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.m_shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            if (this.hasFocus()) continue;
            this.m_shell.setFocus();
        }
    }

    public void doVoidOpen() {
        this.setupDialogView();
        boolean bl = this.initializeLibraryList();
        if (bl) {
            this.initializeContents();
            this.doDialogOpen();
        }
    }
}

