/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util.dialogs;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.RemoteUtils;
import com.insightful.splus.eclipse.server.util.SplusDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class TransferFilesDialog
extends SplusDialog {
    private static String TRANSFER_DIALOG_TITLE = UiProperties.getString("TransferFilesDialog.DialogTitle");
    private static String DOWNLOAD_DIR = "com.insightful.splus.eclipse.server.download.dir";
    private String m_server;
    private String m_username;
    private String m_password;
    private String m_resultsDir;
    private Button m_ok = null;
    private Button m_cancel = null;
    private Button m_browse = null;
    private Button m_clearAll = null;
    private Button m_selectAll = null;
    private Text m_downloadDirectory = null;
    private Table m_fileList = null;
    private boolean m_didCancel;

    public TransferFilesDialog(Shell shell, String string, String string2, String string3, String string4) {
        super(shell, TRANSFER_DIALOG_TITLE, new String[]{UiProperties.getString("TransferFilesDialog.SplusServerLibrary")});
        this.m_server = string;
        this.m_username = string2;
        this.m_password = string3;
        this.m_resultsDir = string4;
        this.m_didCancel = true;
    }

    public void open() {
        this.doVoidOpen();
    }

    protected int getInitialWidth() {
        return 400;
    }

    protected int getInitialHeight() {
        return 250;
    }

    protected boolean hasFocus() {
        return this.m_ok.isFocusControl() || this.m_cancel.isFocusControl() || this.m_browse.isFocusControl() || this.m_downloadDirectory.isFocusControl() || this.m_fileList.isFocusControl() || this.m_clearAll.isFocusControl() || this.m_selectAll.isFocusControl();
    }

    protected void createButtons(final Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        this.m_ok = new Button(composite, 0);
        this.m_ok.setText(UiProperties.getString("TransferFilesDialog.OK"));
        this.m_cancel = new Button(composite, 0);
        this.m_cancel.setText(UiProperties.getString("TransferFilesDialog.Cacncel"));
        this.m_ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RemoteUtils.setDialogSetting(DOWNLOAD_DIR, TransferFilesDialog.this.m_downloadDirectory.getText());
                boolean bl = TransferFilesDialog.this.transferSelectedFiles();
                if (!bl) {
                    return;
                }
                File[] fileArray = TransferFilesDialog.this.getLocalTempSpjFiles();
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    SplusEditorPlugin.getDefault().displaySWTCanvas(fileArray[i]);
                }
                TransferFilesDialog.this.m_didCancel = false;
                shell.close();
            }
        });
        this.m_cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.close();
            }
        });
    }

    protected void createContents(Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 0);
        label.setText(UiProperties.getString("TransferFilesDialog.ServerFiles"));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(768));
        this.m_selectAll = new Button(composite, 0);
        this.m_selectAll.setText(UiProperties.getString("TransferFilesDialog.SelectAll"));
        this.m_clearAll = new Button(composite, 0);
        this.m_clearAll.setText(UiProperties.getString("TransferFilesDialog.ClearAll"));
        this.m_selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TransferFilesDialog.this.universallyCheckFiles(true);
            }
        });
        this.m_clearAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TransferFilesDialog.this.universallyCheckFiles(false);
            }
        });
        this.m_fileList = new Table(composite, 2082);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.m_fileList.setLayoutData((Object)gridData);
        Label label3 = new Label(composite, 0);
        label3.setText(UiProperties.getString("TransferFilesDialog.DownloadDirectory"));
        this.m_downloadDirectory = new Text(composite, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.m_downloadDirectory.setLayoutData((Object)gridData2);
        this.m_browse = new Button(composite, 0);
        this.m_browse.setText(UiProperties.getString("TransferFilesDialog.Browse"));
        this.m_browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TransferFilesDialog.this.m_browse.getShell());
                String string = directoryDialog.open();
                if (string != null) {
                    TransferFilesDialog.this.m_downloadDirectory.setText(string);
                }
            }
        });
    }

    protected void addDialogStateListener(Listener listener) {
        this.m_fileList.addListener(24, listener);
        this.m_downloadDirectory.addListener(24, listener);
    }

    protected void updateDialogState() {
        boolean bl = this.m_fileList.getSelectionCount() != 0;
        boolean bl2 = this.m_downloadDirectory.getText().length() != 0;
        this.m_ok.setEnabled(bl && bl2 || !bl);
    }

    protected void initializeContents() {
        String string = RemoteUtils.getDialogSetting(DOWNLOAD_DIR);
        if (string == null) {
            string = "";
        }
        this.m_downloadDirectory.setText(string);
        try {
            String[] stringArray = RemoteUtils.getFolderContents(this.m_server, this.m_username, this.m_password, this.m_resultsDir, this);
            for (int i = 0; i < stringArray.length; ++i) {
                TableItem tableItem = new TableItem(this.m_fileList, 32);
                tableItem.setText(stringArray[i]);
                tableItem.setChecked(true);
            }
        }
        catch (SplusBadDataException splusBadDataException) {
            this.handleException((Exception)((Object)splusBadDataException), UiProperties.getString("TransferFilesDialog.SplusError"), true);
        }
    }

    protected void doDialogOpen() {
        if (this.m_fileList.getItemCount() != 0) {
            super.doDialogOpen();
        } else {
            this.m_didCancel = false;
        }
    }

    private void universallyCheckFiles(boolean bl) {
        for (int i = 0; i < this.m_fileList.getItemCount(); ++i) {
            TableItem tableItem = this.m_fileList.getItem(i);
            tableItem.setChecked(bl);
        }
    }

    public boolean getCancel() {
        return this.m_didCancel;
    }

    public boolean transferSelectedFiles() {
        boolean bl = false;
        try {
            String string = new File(this.m_downloadDirectory.getText()).getCanonicalPath();
            for (int i = 0; i < this.m_fileList.getItemCount(); ++i) {
                TableItem tableItem = this.m_fileList.getItem(i);
                if (!tableItem.getChecked()) continue;
                String string2 = tableItem.getText();
                String string3 = this.m_resultsDir + '/' + string2;
                String string4 = string + '/' + string2;
                try {
                    if (RemoteUtils.downloadFile(this.m_server, this.m_username, this.m_password, string3, string4, this)) continue;
                    MessageDialog.openError((Shell)this.getParent(), (String)UiProperties.getString("TransferFilesDialog.TransferError"), (String)(UiProperties.getString("TransferFilesDialog.UnableToDownload") + string3 + UiProperties.getString("TransferFilesDialog.To") + string4 + UiProperties.getString("TransferFilesDialog.Period")));
                    continue;
                }
                catch (SplusBadDataException splusBadDataException) {
                    this.handleException((Exception)((Object)splusBadDataException), UiProperties.getString("TransferFilesDialog.SplusError"), true);
                }
            }
            bl = true;
        }
        catch (IOException iOException) {
            this.handleException(iOException, UiProperties.getString("TransferFilesDialog.BadDownloadDirectory"), true);
        }
        return bl;
    }

    public File[] getLocalTempSpjFiles() {
        File[] fileArray = null;
        try {
            int n;
            int n2 = 0;
            for (n = 0; n < this.m_fileList.getItemCount(); ++n) {
                TableItem tableItem = this.m_fileList.getItem(n);
                if (!tableItem.getText().endsWith(UiProperties.getString("TransferFilesDialog.SpjFileExtension"))) continue;
                ++n2;
            }
            fileArray = new File[n2];
            int n3 = 0;
            for (n = 0; n < this.m_fileList.getItemCount(); ++n) {
                String string;
                TableItem tableItem = this.m_fileList.getItem(n);
                String string2 = tableItem.getText();
                if (!string2.toLowerCase().endsWith(UiProperties.getString("TransferFilesDialog.SpjFileExtension"))) continue;
                boolean bl = false;
                if (tableItem.getChecked()) {
                    string = new File(this.m_downloadDirectory.getText()).getCanonicalPath();
                    fileArray[n3] = new File(string + '/' + string2);
                    bl = true;
                } else {
                    fileArray[n3] = File.createTempFile(UiProperties.getString("TransferFilesDialog.TempSpjFilePrefix"), UiProperties.getString("TransferFilesDialog.SpjFileEnding"));
                    fileArray[n3].deleteOnExit();
                }
                if (!bl) {
                    string = fileArray[n3].getCanonicalPath();
                    String string3 = this.m_resultsDir + '/' + string2;
                    try {
                        if (!RemoteUtils.downloadFile(this.m_server, this.m_username, this.m_password, string3, string, this)) {
                            MessageDialog.openError((Shell)this.getParent(), (String)UiProperties.getString("TransferFilesDialog.TransferError"), (String)(UiProperties.getString("TransferFilesDialog.UnableToDownload") + string3 + UiProperties.getString("TransferFilesDialog.To") + string + UiProperties.getString("TransferFilesDialog.Period")));
                        }
                    }
                    catch (SplusBadDataException splusBadDataException) {
                        this.handleException((Exception)((Object)splusBadDataException), UiProperties.getString("TransferFilesDialog.SplusError"), true);
                    }
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException, UiProperties.getString("TransferFilesDialog.BadDownloadDirectory"), true);
        }
        return fileArray;
    }
}

