/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public abstract class JGoObject
implements Serializable {
    public static final int NoSpot = -1;
    public static final int NoHandle = -1;
    public static final int Center = 0;
    public static final int TopLeft = 1;
    public static final int TopCenter = 2;
    public static final int TopMiddle = 2;
    public static final int Top = 2;
    public static final int TopRight = 3;
    public static final int RightCenter = 4;
    public static final int CenterRight = 4;
    public static final int SideRight = 4;
    public static final int Right = 4;
    public static final int BottomRight = 5;
    public static final int BottomCenter = 6;
    public static final int BottomMiddle = 6;
    public static final int Bottom = 6;
    public static final int BottomLeft = 7;
    public static final int LeftCenter = 8;
    public static final int CenterLeft = 8;
    public static final int SideLeft = 8;
    public static final int Left = 8;
    public static final int NumReservedHandles = 100;
    public static final int RepaintAll = 0;
    public static final int ChangedAll = 0;
    public static final int ChangedGeometry = 1;
    public static final int ChangedVisible = 2;
    public static final int ChangedSelectable = 3;
    public static final int ChangedDraggable = 4;
    public static final int ChangedResizable = 5;
    public static final int Changed4ResizeHandles = 6;
    public static final int ChangedSuspendUpdates = 0;
    public static final int ChangedGrabChildSelection = 9;
    public static final int ChangedZOrder = 10;
    public static final int ChangedPen = 11;
    public static final int ChangedBrush = 12;
    public static final int LastChangedHint = 65535;
    static final int \u0107 = 1;
    static final int \u0108 = 2;
    static final int \u0109 = 4;
    static final int \u010a = 8;
    static final int \u010b = 16;
    static final int \u010c = 32;
    static final int \u010d = 64;
    static final int \u010e = 128;
    static final int \u010f = 256;
    static final int \u0110 = 512;
    static final int \u0111 = 1024;
    static final int \u0112 = 2048;
    static final int \u0113 = 4096;
    static final int \u0114 = 8192;
    static final int \u0115 = 16384;
    static final int \u0116 = 32768;
    private JGoArea myParentArea = null;
    private JGoLayer myLayer = null;
    private transient JGoView myView = null;
    private Rectangle myBoundingRect = new Rectangle();
    private int myFlags = 0;
    private Rectangle myPrevRect = new Rectangle();

    public JGoObject() {
        this.\u00c0();
    }

    public JGoObject(Rectangle rectangle) {
        this.\u00c0();
        this.myBoundingRect.x = rectangle.x;
        this.myBoundingRect.y = rectangle.y;
        this.myBoundingRect.width = rectangle.width;
        this.myBoundingRect.height = rectangle.height;
    }

    public JGoObject(Point point, Dimension dimension) {
        this.\u00c0();
        this.myBoundingRect.x = point.x;
        this.myBoundingRect.y = point.y;
        this.myBoundingRect.width = dimension.width;
        this.myBoundingRect.height = dimension.height;
    }

    private final void \u00c0() {
        this.setFlags(30);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoObject jGoObject = (JGoObject)jGoCopyEnvironment.get(this);
        if (jGoObject != null) {
            return null;
        }
        try {
            Class<?> clazz = this.getClass();
            jGoObject = (JGoObject)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jGoObject != null) {
            jGoCopyEnvironment.put(this, jGoObject);
            jGoObject.myParentArea = null;
            jGoObject.myLayer = null;
            jGoObject.myView = null;
            jGoObject.myBoundingRect.x = this.myBoundingRect.x;
            jGoObject.myBoundingRect.y = this.myBoundingRect.y;
            jGoObject.myBoundingRect.width = this.myBoundingRect.width;
            jGoObject.myBoundingRect.height = this.myBoundingRect.height;
            jGoObject.myPrevRect.x = this.myPrevRect.x;
            jGoObject.myPrevRect.y = this.myPrevRect.y;
            jGoObject.myPrevRect.width = this.myPrevRect.width;
            jGoObject.myPrevRect.height = this.myPrevRect.height;
            jGoObject.myFlags = this.myFlags;
        }
        return jGoObject;
    }

    public Rectangle getBoundingRect() {
        return this.myBoundingRect;
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        if (!this.setBoundingRectForce(n, n2, n3, n4)) {
            return;
        }
        this.geometryChange(this.myPrevRect);
        JGoArea jGoArea = this.getParent();
        if (jGoArea != null) {
            jGoArea.geometryChangeChild(this, this.myPrevRect);
        }
        this.update(1, 0, this.myPrevRect);
        this.\u010c(false);
    }

    public final void setBoundingRect(Point point, Dimension dimension) {
        this.setBoundingRect(point.x, point.y, dimension.width, dimension.height);
    }

    public final void setBoundingRect(Rectangle rectangle) {
        this.setBoundingRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected final boolean setBoundingRectForce(int n, int n2, int n3, int n4) {
        if (this.myBoundingRect.x == n && this.myBoundingRect.y == n2 && this.myBoundingRect.width == n3 && this.myBoundingRect.height == n4) {
            return false;
        }
        this.myPrevRect.x = this.myBoundingRect.x;
        this.myPrevRect.y = this.myBoundingRect.y;
        this.myPrevRect.width = this.myBoundingRect.width;
        this.myPrevRect.height = this.myBoundingRect.height;
        this.\u010c(true);
        this.myBoundingRect.x = n;
        this.myBoundingRect.y = n2;
        this.myBoundingRect.width = Math.max(n3, 0);
        this.myBoundingRect.height = Math.max(n4, 0);
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            jGoDocument.updateDocumentSize(this);
        }
        return true;
    }

    public final boolean setBoundingRectForce(Rectangle rectangle) {
        return this.setBoundingRectForce(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final Dimension getSize() {
        return this.getSize(null);
    }

    public final Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.width = this.getWidth();
        dimension.height = this.getHeight();
        return dimension;
    }

    public final void setSize(Dimension dimension) {
        this.setBoundingRect(this.getLeft(), this.getTop(), dimension.width, dimension.height);
    }

    public final void setSize(int n, int n2) {
        this.setBoundingRect(this.getLeft(), this.getTop(), n, n2);
    }

    public final int getWidth() {
        return this.getBoundingRect().width;
    }

    public final void setWidth(int n) {
        this.setBoundingRect(this.getLeft(), this.getTop(), n, this.getHeight());
    }

    public final int getHeight() {
        return this.getBoundingRect().height;
    }

    public final void setHeight(int n) {
        this.setBoundingRect(this.getLeft(), this.getTop(), this.getWidth(), n);
    }

    public final int getLeft() {
        return this.getBoundingRect().x;
    }

    public final void setLeft(int n) {
        this.setBoundingRect(n, this.getTop(), this.getWidth(), this.getHeight());
    }

    public final int getTop() {
        return this.getBoundingRect().y;
    }

    public final void setTop(int n) {
        this.setBoundingRect(this.getLeft(), n, this.getWidth(), this.getHeight());
    }

    public final Point getTopLeft() {
        return this.getTopLeft(null);
    }

    public final Point getTopLeft(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.x = this.getLeft();
        point.y = this.getTop();
        return point;
    }

    public final void setTopLeft(Point point) {
        this.setBoundingRect(point.x, point.y, this.getWidth(), this.getHeight());
    }

    public final void setTopLeft(int n, int n2) {
        this.setBoundingRect(n, n2, this.getWidth(), this.getHeight());
    }

    public Point getLocation(Point point) {
        return this.getTopLeft(point);
    }

    public final Point getLocation() {
        return this.getLocation(null);
    }

    public void setLocation(int n, int n2) {
        this.setTopLeft(n, n2);
    }

    public final void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public final void setLocationOffset(int n, int n2, int n3, int n4) {
        this.setLocation(n + n3, n2 + n4);
    }

    public final void setLocationOffset(Point point, Point point2) {
        this.setLocation(point.x + point2.x, point.y + point2.y);
    }

    public static int spotOpposite(int n) {
        switch (n) {
            default: {
                return n;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
        }
        return 4;
    }

    public Point getSpotLocation(int n, Point point) {
        Rectangle rectangle = this.getBoundingRect();
        if (point == null) {
            point = new Point(rectangle.x, rectangle.y);
        } else {
            point.x = rectangle.x;
            point.y = rectangle.y;
        }
        switch (n) {
            case 0: {
                point.x += rectangle.width / 2;
                point.y += rectangle.height / 2;
                break;
            }
            default: {
                break;
            }
            case 2: {
                point.x += rectangle.width / 2;
                break;
            }
            case 3: {
                point.x += rectangle.width;
                break;
            }
            case 4: {
                point.x += rectangle.width;
                point.y += rectangle.height / 2;
                break;
            }
            case 5: {
                point.x += rectangle.width;
                point.y += rectangle.height;
                break;
            }
            case 6: {
                point.x += rectangle.width / 2;
                point.y += rectangle.height;
                break;
            }
            case 7: {
                point.y += rectangle.height;
                break;
            }
            case 8: {
                point.y += rectangle.height / 2;
            }
        }
        return point;
    }

    public final Point getSpotLocation(int n) {
        return this.getSpotLocation(n, null);
    }

    public void setSpotLocation(int n, int n2, int n3) {
        Point point = this.getSpotLocation(n);
        int n4 = n2 - (point.x - this.getLeft());
        int n5 = n3 - (point.y - this.getTop());
        this.setBoundingRect(n4, n5, this.getWidth(), this.getHeight());
    }

    public final void setSpotLocation(int n, Point point) {
        this.setSpotLocation(n, point.x, point.y);
    }

    public final void setSpotLocation(int n, JGoObject jGoObject, int n2) {
        Point point = jGoObject.getSpotLocation(n2);
        this.setSpotLocation(n, point.x, point.y);
    }

    public final void setSpotLocationOffset(int n, int n2, int n3, int n4, int n5) {
        this.setSpotLocation(n, n2 + n4, n3 + n5);
    }

    public final void update() {
        this.update(0, 0, null);
    }

    public final void update(int n) {
        this.update(n, 0, null);
    }

    public void update(int n, int n2, Object object) {
        if (this.isSuspendUpdates()) {
            return;
        }
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            jGoDocument.fireUpdate(3, n, this, n2, object);
        } else {
            JGoView jGoView = this.getView();
            if (jGoView != null) {
                jGoView.fireUpdate(3, n, this);
            }
        }
    }

    public void foredate(int n) {
        if (this.isSuspendUpdates()) {
            return;
        }
        JGoDocument jGoDocument = this.getDocument();
        if (jGoDocument != null) {
            jGoDocument.fireForedate(3, n, this);
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        JGoDrawable.drawRect(graphics2D, JGoPen.black, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        JGoDrawable.drawLine(graphics2D, JGoPen.black, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        JGoDrawable.drawLine(graphics2D, JGoPen.black, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
    }

    public final void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, null);
    }

    Rectangle \u0107() {
        return this.myPrevRect;
    }

    public boolean isPointInObj(Point point) {
        return this.getBoundingRect().contains(point.x, point.y);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
    }

    public boolean doMouseClick(int n, Point point, Point point2, JGoView jGoView) {
        return false;
    }

    public boolean doMouseDblClick(int n, Point point, Point point2, JGoView jGoView) {
        return false;
    }

    public boolean doUncapturedMouseMove(int n, Point point, Point point2, JGoView jGoView) {
        return false;
    }

    public String getToolTipText() {
        return null;
    }

    protected void ownerChange(Object object, Object object2) {
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        if (!this.isResizable()) {
            jGoSelection.createBoundingHandle(this);
            return;
        }
        Rectangle rectangle = this.getBoundingRect();
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y;
        int n5 = rectangle.y + rectangle.height / 2;
        int n6 = rectangle.y + rectangle.height;
        jGoSelection.createResizeHandle(this, n, n4, 1, true);
        jGoSelection.createResizeHandle(this, n3, n4, 3, true);
        jGoSelection.createResizeHandle(this, n, n6, 7, true);
        jGoSelection.createResizeHandle(this, n3, n6, 5, true);
        if (!this.is4ResizeHandles()) {
            jGoSelection.createResizeHandle(this, n2, n4, 2, true);
            jGoSelection.createResizeHandle(this, n3, n5, 4, true);
            jGoSelection.createResizeHandle(this, n2, n6, 6, true);
            jGoSelection.createResizeHandle(this, n, n5, 8, true);
        }
    }

    protected void lostSelection(JGoSelection jGoSelection) {
        jGoSelection.deleteHandles(this);
    }

    protected JGoObject redirectSelection() {
        return this;
    }

    protected Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        switch (n) {
            case 1: {
                rectangle2.x = Math.min(point.x, rectangle.x + rectangle.width - n3);
                rectangle2.y = Math.min(point.y, rectangle.y + rectangle.height - n4);
                rectangle2.width += rectangle.x - rectangle2.x;
                rectangle2.height += rectangle.y - rectangle2.y;
                break;
            }
            case 2: {
                rectangle2.y = Math.min(point.y, rectangle.y + rectangle.height - n4);
                rectangle2.height += rectangle.y - rectangle2.y;
                break;
            }
            case 8: {
                rectangle2.x = Math.min(point.x, rectangle.x + rectangle.width - n3);
                rectangle2.width += rectangle.x - rectangle2.x;
                break;
            }
            case 3: {
                rectangle2.y = Math.min(point.y, rectangle.y + rectangle.height - n4);
                rectangle2.width = Math.max(point.x - rectangle.x, n3);
                rectangle2.height += rectangle.y - rectangle2.y;
                break;
            }
            case 7: {
                rectangle2.x = Math.min(point.x, rectangle.x + rectangle.width - n3);
                rectangle2.width += rectangle.x - rectangle2.x;
                rectangle2.height = Math.max(point.y - rectangle.y, n4);
                break;
            }
            case 4: {
                rectangle2.width = Math.max(point.x - rectangle.x, n3);
                break;
            }
            case 6: {
                rectangle2.height = Math.max(point.y - rectangle.y, n4);
                break;
            }
            case 5: {
                rectangle2.width = Math.max(point.x - rectangle.x, n3);
                rectangle2.height = Math.max(point.y - rectangle.y, n4);
            }
        }
        if (n2 == 3) {
            this.setBoundingRect(rectangle2);
        }
        return rectangle2;
    }

    protected void geometryChange(Rectangle rectangle) {
    }

    protected boolean geometryChangeChild(JGoObject jGoObject, Rectangle rectangle) {
        return false;
    }

    public final void geometryChangeChild(JGoObject jGoObject) {
        this.geometryChangeChild(jGoObject, jGoObject.\u0107());
    }

    public JGoArea getParent() {
        return this.myParentArea;
    }

    protected void setParent(JGoArea jGoArea) {
        this.myParentArea = jGoArea;
    }

    public final boolean isTopLevel() {
        return this.getParent() == null;
    }

    public JGoObject getTopLevelObject() {
        JGoObject jGoObject = this;
        while (!jGoObject.isTopLevel()) {
            jGoObject = jGoObject.getParent();
        }
        return jGoObject;
    }

    public JGoDocument getDocument() {
        if (this.myLayer == null) {
            return null;
        }
        return this.myLayer.getDocument();
    }

    public JGoLayer getLayer() {
        return this.myLayer;
    }

    void \u0108(JGoLayer jGoLayer, int n, Object object) {
        JGoDocument jGoDocument = this.getDocument();
        if (jGoLayer != null) {
            this.myLayer = jGoLayer;
            JGoDocument jGoDocument2 = this.getDocument();
            if (jGoDocument != jGoDocument2) {
                this.ownerChange(jGoDocument, jGoDocument2);
                if (n >= 0) {
                    jGoDocument2.fireUpdate(2, 0, this, n, object);
                }
            }
        } else {
            if (jGoDocument != null) {
                this.ownerChange(jGoDocument, null);
                if (n >= 0) {
                    jGoDocument.fireUpdate(4, 0, this, n, object);
                }
            }
            this.myLayer = null;
        }
    }

    public JGoView getView() {
        return this.myView;
    }

    void \u0109(JGoView jGoView) {
        JGoView jGoView2 = this.getView();
        if (jGoView != null) {
            this.myView = jGoView;
            if (jGoView2 != this.myView) {
                this.ownerChange(jGoView2, this.myView);
                jGoView.fireUpdate(2, 0, this);
            }
        } else {
            if (jGoView2 != null) {
                this.ownerChange(jGoView2, null);
                jGoView2.fireUpdate(4, 0, this);
            }
            this.myView = null;
        }
    }

    public void showSelectionHandles(JGoSelection jGoSelection) {
        this.lostSelection(jGoSelection);
        this.gainedSelection(jGoSelection);
    }

    public void hideSelectionHandles(JGoSelection jGoSelection) {
        this.lostSelection(jGoSelection);
    }

    public JGoObject getPartner() {
        return null;
    }

    public void setPartner(JGoObject jGoObject) {
    }

    void \u010a(JGoListPosition jGoListPosition) {
    }

    JGoListPosition \u010b() {
        return null;
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                jGoDocumentChangedEdit.setOldValue(new Rectangle((Rectangle)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return;
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                jGoDocumentChangedEdit.setNewValue(new Rectangle(this.getBoundingRect()));
                return;
            }
            case 2: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isVisible());
                return;
            }
            case 3: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isSelectable());
                return;
            }
            case 4: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isDraggable());
                return;
            }
            case 5: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isResizable());
                return;
            }
            case 6: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.is4ResizeHandles());
                return;
            }
            case 9: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isGrabChildSelection());
                return;
            }
            case 10: {
                Serializable serializable = this.getParent();
                if (serializable == null) {
                    serializable = this.getLayer();
                }
                if (serializable != null) {
                    JGoListPosition jGoListPosition = serializable.findObject(this);
                    JGoListPosition jGoListPosition2 = serializable.getNextObjectPos(jGoListPosition);
                    JGoObject jGoObject = serializable.getObjectAtPos(jGoListPosition2);
                    if (jGoObject != null) {
                        jGoDocumentChangedEdit.setNewValueInt(1);
                        jGoDocumentChangedEdit.setNewValue(jGoObject);
                    } else {
                        jGoDocumentChangedEdit.setNewValueInt(0);
                        jGoDocumentChangedEdit.setNewValue(serializable);
                    }
                }
                return;
            }
            case 0: {
                return;
            }
        }
        throw new IllegalArgumentException("unknown CHANGED sub-hint: " + Integer.toString(jGoDocumentChangedEdit.getFlags()));
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                this.setBoundingRectForce((Rectangle)jGoDocumentChangedEdit.getValue(bl));
                this.update();
                return;
            }
            case 2: {
                this.setVisible(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 3: {
                this.setSelectable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 4: {
                this.setDraggable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 5: {
                this.setResizable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 6: {
                this.set4ResizeHandles(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 9: {
                this.setGrabChildSelection(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 10: {
                int n = jGoDocumentChangedEdit.getValueInt(bl);
                if (n == 1) {
                    JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getValue(bl);
                    if (jGoObject != null) {
                        Serializable serializable = jGoObject.getParent();
                        if (serializable == null) {
                            serializable = jGoObject.getLayer();
                        }
                        if (serializable != null) {
                            JGoListPosition jGoListPosition = serializable.findObject(jGoObject);
                            if (jGoListPosition == null) {
                                serializable.addObjectAtTail(this);
                            } else {
                                serializable.insertObjectBefore(jGoListPosition, this);
                            }
                        }
                    }
                } else {
                    JGoObjectCollection jGoObjectCollection = (JGoObjectCollection)jGoDocumentChangedEdit.getValue(bl);
                    jGoObjectCollection.addObjectAtTail(this);
                }
                return;
            }
            case 0: {
                return;
            }
        }
        throw new IllegalArgumentException("unknown CHANGED sub-hint: " + Integer.toString(jGoDocumentChangedEdit.getFlags()));
    }

    public final void setFlags(int n) {
        this.myFlags = n;
    }

    public final int getFlags() {
        return this.myFlags;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 2) : (this.myFlags &= 0xFFFFFFFD);
            this.update(2, bl2 ? 1 : 0, null);
        }
    }

    public boolean isVisible() {
        return (this.myFlags & 2) != 0;
    }

    public void setSelectable(boolean bl) {
        boolean bl2 = this.isSelectable();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 4) : (this.myFlags &= 0xFFFFFFFB);
            this.update(3, bl2 ? 1 : 0, null);
        }
    }

    public boolean isSelectable() {
        return (this.myFlags & 4) != 0;
    }

    public void setDraggable(boolean bl) {
        boolean bl2 = this.isDraggable();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 8) : (this.myFlags &= 0xFFFFFFF7);
            this.update(4, bl2 ? 1 : 0, null);
        }
    }

    public boolean isDraggable() {
        return (this.myFlags & 8) != 0;
    }

    public void setResizable(boolean bl) {
        boolean bl2 = this.isResizable();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
            this.update(5, bl2 ? 1 : 0, null);
        }
    }

    public boolean isResizable() {
        return (this.myFlags & 0x10) != 0;
    }

    public void set4ResizeHandles(boolean bl) {
        boolean bl2 = this.is4ResizeHandles();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 0x20) : (this.myFlags &= 0xFFFFFFDF);
            this.update(6, bl2 ? 1 : 0, null);
        }
    }

    public boolean is4ResizeHandles() {
        return (this.myFlags & 0x20) != 0;
    }

    public void setSuspendUpdates(boolean bl) {
        boolean bl2 = this.isSuspendUpdates();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 0x40) : (this.myFlags &= 0xFFFFFFBF);
            this.update(0, 1, null);
        }
    }

    public boolean isSuspendUpdates() {
        return (this.myFlags & 0x40) != 0;
    }

    public void setSuspendChildUpdates(boolean bl) {
        if (this.isSuspendChildUpdates() != bl) {
            this.myFlags = bl ? (this.myFlags |= 0x80) : (this.myFlags &= 0xFFFFFF7F);
        }
    }

    public boolean isSuspendChildUpdates() {
        return (this.myFlags & 0x80) != 0;
    }

    public void setGrabChildSelection(boolean bl) {
        boolean bl2 = this.isGrabChildSelection();
        if (bl2 != bl) {
            this.myFlags = bl ? (this.myFlags |= 0x200) : (this.myFlags &= 0xFFFFFDFF);
            this.update(9, bl2 ? 1 : 0, null);
        }
    }

    public boolean isGrabChildSelection() {
        return (this.myFlags & 0x200) != 0;
    }

    void \u010c(boolean bl) {
        this.myFlags = bl ? (this.myFlags |= 1) : (this.myFlags &= 0xFFFFFFFE);
    }

    boolean \u010d() {
        return (this.myFlags & 1) != 0;
    }

    void \u010e(boolean bl) {
        this.myFlags = bl ? (this.myFlags |= 0x100) : (this.myFlags &= 0xFFFFFEFF);
    }

    boolean \u010f() {
        return (this.myFlags & 0x100) != 0;
    }
}

