/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusLabelBox;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class SplusComboBox
extends SplusLabelBox
implements SplusControlMethods {
    JComboBox comboBox;
    private InnerComboBoxModel dataModel;
    private String[] prependString = null;
    private String[] appendString = null;

    public SplusComboBox() {
        this("", new String[]{""});
    }

    public SplusComboBox(String string) {
        this(string, new String[]{""});
    }

    public SplusComboBox(String string, char c) {
        this(string, new String[]{""});
        this.setMnemonic(c);
    }

    public SplusComboBox(String string, int n) {
        this(string, new String[]{""});
        this.setMnemonic(n);
    }

    public SplusComboBox(String string, char c, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(c);
    }

    public SplusComboBox(String string, int n, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(n);
    }

    public SplusComboBox(String string, String[] stringArray) {
        super(string);
        this.dataModel = new InnerComboBoxModel(stringArray);
        this.comboBox = System.getProperty("os.name").equals("AIX") ? new AIXComboBox(this.dataModel) : new JComboBox(this.dataModel);
        this.comboBox.setPreferredSize(labelDimension);
        this.comboBox.setMinimumSize(labelDimension);
        this.comboBox.setMaximumSize(labelDimension);
        this.comboBox.setEditable(true);
        this.comboBox.setMaximumRowCount(7);
        this.setActionControl(this.comboBox);
    }

    public synchronized String getValue() {
        String string = "";
        Object object = this.comboBox.getSelectedItem();
        if (object != null) {
            string = object.toString();
        }
        if (string.endsWith("\\") && !string.endsWith("\\\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public synchronized void setValue(String string) {
        this.comboBox.setSelectedItem(string);
    }

    public synchronized int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public synchronized void setSelectedIndex(int n) {
        this.comboBox.setSelectedIndex(n);
    }

    public synchronized String[] getOptionList() {
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        int n = comboBoxModel.getSize();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)comboBoxModel.getElementAt(i);
        }
        return stringArray;
    }

    public synchronized void setOptionList(String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        if (this.prependString != null) {
            for (n = 0; n < this.prependString.length; ++n) {
                vector.add(this.prependString[n]);
            }
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        if (this.appendString != null) {
            for (n = 0; n < this.appendString.length; ++n) {
                vector.add(this.appendString[n]);
            }
        }
        this.dataModel.setListData(vector);
    }

    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
        this.setLabelEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.comboBox.addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.comboBox.addItemListener(itemListener);
    }

    public String getActionCommand() {
        return this.comboBox.getActionCommand();
    }

    public void setActionCommand(String string) {
        this.comboBox.setActionCommand(string);
    }

    public void setPrepend(String[] stringArray) {
        this.prependString = stringArray;
        this.setOptionList(this.getOptionList());
    }

    public String[] getPrepend() {
        return this.prependString;
    }

    public void setAppend(String[] stringArray) {
        this.appendString = stringArray;
        this.setOptionList(this.getOptionList());
    }

    public String[] getAppend() {
        return this.appendString;
    }

    public boolean isEditable() {
        return this.comboBox.isEditable();
    }

    public void setEditable(boolean bl) {
        this.comboBox.setEditable(bl);
    }

    private class InnerComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector objects;
        private Object selectedObject;

        InnerComboBoxModel() {
            this.objects = new Vector();
        }

        InnerComboBoxModel(Object[] objectArray) {
            this.objects = new Vector();
            this.objects.ensureCapacity(objectArray.length);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.objects.addElement(objectArray[i]);
            }
            if (this.getSize() > 0) {
                this.selectedObject = this.getElementAt(0);
            }
        }

        InnerComboBoxModel(Vector vector) {
            this.objects = vector;
            if (this.getSize() > 0) {
                this.selectedObject = this.getElementAt(0);
            }
        }

        public void setSelectedItem(Object object) {
            if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
                this.selectedObject = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            return this.objects.size();
        }

        public Object getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.elementAt(n);
            }
            return null;
        }

        public void setListData(Vector vector) {
            this.objects = vector;
            if (!this.objects.contains(this.selectedObject)) {
                this.selectedObject = null;
            }
        }
    }

    private class AIXComboBox
    extends JComboBox {
        public AIXComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
            this.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    this.handleKeyEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.handleKeyEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    this.handleKeyEvent(keyEvent);
                }

                private void handleKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        keyEvent.consume();
                        AIXComboBox.this.actionPerformed(null);
                    }
                }
            });
        }
    }
}

