/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusSessionFactoryLog;
import com.insightful.splus.TelStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class TelClient {
    Socket client;
    int port;
    String host;
    PrintStream netOut;
    TelStream netIn;
    PipedOutputStream outPipe;
    PipedInputStream inPipe;
    MyTelMon telmon;
    BufferedReader in;
    SplusSessionFactoryLog log;
    boolean wasClosed = false;

    public TelClient(String string, int n, SplusSessionFactoryLog splusSessionFactoryLog) {
        this(string, n);
        this.log = splusSessionFactoryLog;
    }

    public TelClient(String string, SplusSessionFactoryLog splusSessionFactoryLog) {
        this(string, 23, splusSessionFactoryLog);
    }

    public TelClient(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public TelClient(String string) {
        this(string, 23);
    }

    public void close() {
        try {
            this.netOut.close();
            this.netIn.close();
            this.wasClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String connect() {
        try {
            this.client = new Socket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            return "Host, " + this.host + ", is unknown";
        }
        catch (IOException iOException) {
            return "Socket I/O error contacting host, " + this.host + ", on port, " + this.port;
        }
        try {
            this.netOut = new PrintStream(this.client.getOutputStream());
            this.netIn = new TelStream(this.client.getInputStream(), this.netOut);
        }
        catch (IOException iOException) {
            return "I/O error contacting host, " + this.host;
        }
        try {
            this.outPipe = new PipedOutputStream();
            this.inPipe = new PipedInputStream(this.outPipe);
            this.telmon = new MyTelMon(this.netIn, new PrintStream(this.outPipe));
            this.telmon.start();
            this.in = new BufferedReader(new InputStreamReader(this.inPipe));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public void send(String string) {
        if (string != null && string.length() > 0) {
            this.netOut.println(string);
        }
    }

    public synchronized String listen(int n) {
        char[] cArray = new char[1024];
        String string = "";
        int n2 = 1024;
        while (n2-- > 0) {
            cArray[n2] = '\u0000';
        }
        while (string.length() < 1 && n > 0) {
            n2 = 0;
            try {
                if (this.in.ready()) {
                    n2 = this.in.read(cArray, 0, 512);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (n2 > 0) {
                string = string + new String(cArray, 0, n2);
                while (n2-- > 0) {
                    cArray[n2] = '\u0000';
                }
            }
            n -= 10;
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String listen() {
        return this.listen(100);
    }

    public int waitFor(String string, int n) {
        int n2 = n;
        this.report("Waiting " + n2 + " seconds for: \"" + string + "\"");
        String string2 = "";
        while (n > 0) {
            String string3 = this.listen();
            while (string3.length() > 0) {
                string2 = string2 + string3;
                string3 = this.listen();
            }
            if (string2.indexOf("Terminal type") >= 0) {
                this.send("ansi");
            }
            if (string2.indexOf(string) >= 0 || string.length() == 0 && string2.length() > 0) {
                this.report("Received (after " + (n2 - n) + " seconds): \"" + string2 + "\"");
                return 0;
            }
            --n;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        this.report("Timeout (" + n2 + " seconds) with output:" + string2);
        return -1;
    }

    public int waitFor(String string) {
        return this.waitFor(string, 7);
    }

    public int transact(String string, String string2, int n) {
        if (0 == this.waitFor(string, n)) {
            if (!string.equals("ssword:")) {
                this.report("Sending: \"" + string2 + "\"");
            } else {
                this.report("Sending: password");
            }
            this.send(string2);
            return 0;
        }
        return -1;
    }

    public int transact(String string, String string2) {
        return this.transact(string, string2, 7);
    }

    private void report(String string) {
        if (this.log == null) {
            System.out.println(string);
        } else {
            this.log.append(string);
        }
    }

    class MyTelMon
    extends Thread {
        TelStream in;
        PrintStream out;

        public MyTelMon(TelStream telStream, PrintStream printStream) {
            this.in = telStream;
            this.out = printStream;
        }

        public void run() {
            this.monitor();
        }

        public synchronized void monitor() {
            block4: {
                boolean bl = false;
                try {
                    while (!bl) {
                        int n = this.in.read();
                        if (n == -1) {
                            bl = true;
                            continue;
                        }
                        this.out.print((char)n);
                        this.out.flush();
                        MyTelMon.yield();
                    }
                }
                catch (Exception exception) {
                    if (TelClient.this.wasClosed) break block4;
                    exception.printStackTrace();
                }
            }
        }
    }
}

