/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.XML;
import com.insightful.splus.ActiveDocument;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.CanvasTabbedPane;
import com.insightful.splus.graph.ExportGraphDialog;
import com.insightful.splus.graph.GraphWindow;
import com.insightful.splus.util.FileUtilities;
import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class ExportGraphCommand {
    public static final int IMAGE_TYPE_JPEG = 0;
    public static final int IMAGE_TYPE_TIFF = 1;
    public static final int IMAGE_TYPE_PNG = 2;
    public static final int IMAGE_TYPE_PNM = 3;
    public static final int IMAGE_TYPE_BMP = 4;
    public static final int IMAGE_TYPE_SPJ = 5;
    public static final int IMAGE_TYPE_PDF = 6;
    public static final int IMAGE_TYPE_EPS = 7;
    public static final int IMAGE_TYPE_WMF = 8;
    private static final int FIRST_IMAGE_TYPE = 0;
    private static final int LAST_IMAGE_TYPE = 5;
    private String m_encoding = "UTF-8";
    static final int INIT_IMAGE_TYPE = 0;
    static final int INIT_IMAGE_WIDTH = -1;
    static final int INIT_IMAGE_HEIGHT = -1;
    static final int INIT_IMAGE_BIT_DEPTH = 8;
    static final boolean INIT_IMAGE_IS_COLOR = true;
    static final double INIT_IMAGE_QUALITY = 1.0;
    int m_imageType = 0;
    int m_imageWidth = -1;
    int m_imageHeight = -1;
    int m_imageBitDepth = 8;
    boolean m_imageIsColor = true;
    double m_imageQuality = 1.0;
    String m_imageFilename = "temp.jpeg";
    Frame m_frameParent = null;
    SCanvas m_canvas = null;
    CanvasTabbedPane m_canvasPane = null;
    static int sav_imageType = 0;
    static int sav_imageWidth = -1;
    static int sav_imageHeight = -1;
    static int sav_imageBitDepth = 8;
    static boolean sav_imageIsColor = true;
    static double sav_imageQuality = 1.0;

    public int getFirstImageType() {
        return 0;
    }

    public int getLastImageType() {
        return 5;
    }

    public boolean canEncodeSPJ() {
        return true;
    }

    public boolean canEncodeType(int n) {
        if (n == 5) {
            return this.canEncodeSPJ();
        }
        if (n < this.getFirstImageType()) {
            return false;
        }
        return n <= this.getLastImageType();
    }

    public boolean canJAIEncode(int n) {
        return n >= 0 && n <= 4;
    }

    public static String getImageTypeString(int n) {
        switch (n) {
            case 1: {
                return "TIFF";
            }
            case 2: {
                return "PNG";
            }
            case 3: {
                return "PNM";
            }
            case 4: {
                return "BMP";
            }
            case 5: {
                return "SPJ";
            }
            case 6: {
                return "PDF";
            }
            case 7: {
                return "EPS";
            }
            case 8: {
                return "WMF";
            }
        }
        return "JPEG";
    }

    public static String getImageTypeDescription(int n) {
        switch (n) {
            case 1: {
                return "Tagged Image File Format (TIFF)";
            }
            case 2: {
                return "Portable Network Graphics (PNG)";
            }
            case 3: {
                return "Portable Any Map (PNM)";
            }
            case 4: {
                return "Windows Bitmap (BMP)";
            }
            case 6: {
                return "PDF File (PDF)";
            }
            case 7: {
                return "Embedded Postscript File (EPS)";
            }
            case 8: {
                return "Windows Metafile (WMF)";
            }
            case 0: {
                return "JPEG Image (JPEG)";
            }
            case 5: {
                return "S-PLUS Graphlet (SPJ)";
            }
        }
        return "unknown";
    }

    public static int parseTypeString(String string) {
        if (string == null || string.length() == 0) {
            string = "JPEG";
        }
        string = string.toUpperCase();
        for (int i = 0; i <= 5; ++i) {
            if (!string.equals(ExportGraphCommand.getImageTypeString(i))) continue;
            return i;
        }
        return 0;
    }

    public ImageEncodeParam getImageEncoder() {
        Object object = null;
        switch (this.m_imageType) {
            case 1: {
                object = new TIFFEncodeParam();
                break;
            }
            case 2: {
                object = this.m_imageIsColor ? new PNGEncodeParam.RGB() : new PNGEncodeParam.Gray();
                ((PNGEncodeParam)object).setBitDepth(this.m_imageBitDepth);
                ((PNGEncodeParam)object).setPhysicalDimension(3816, 3816, 1);
                break;
            }
            case 3: {
                object = new PNMEncodeParam();
                break;
            }
            case 4: {
                object = new BMPEncodeParam();
                break;
            }
            default: {
                object = new JPEGEncodeParam();
                ((JPEGEncodeParam)object).setQuality((float)this.m_imageQuality);
            }
        }
        return object;
    }

    protected Frame getParentFrame() {
        return this.m_frameParent;
    }

    protected SCanvas getCanvas() {
        return this.m_canvas;
    }

    protected int getImageWidth() {
        return this.m_imageWidth;
    }

    protected int getImageHeight() {
        return this.m_imageHeight;
    }

    public void setImageType(int n) {
        this.m_imageType = n;
    }

    public int getImageType() {
        return this.m_imageType;
    }

    public void setImageSize(int n, int n2) {
        this.m_imageWidth = n;
        this.m_imageHeight = n2;
    }

    public Dimension getImageSize() {
        return new Dimension(this.m_imageWidth, this.m_imageHeight);
    }

    public void setImageBitDepth(int n) {
        this.m_imageBitDepth = n;
    }

    public int getImageBitDepth() {
        return this.m_imageBitDepth;
    }

    public void setImageIsColor(boolean bl) {
        this.m_imageIsColor = bl;
    }

    public boolean getImageIsColor() {
        return this.m_imageIsColor;
    }

    public void setImagePNGColor(String string) {
        if (string == null) {
            string = "color";
        }
        string = string.toLowerCase();
        boolean bl = true;
        int n = 16;
        if (string.equals("gray1") || string.equals("grey1")) {
            bl = false;
            n = 1;
        } else if (string.equals("gray2") || string.equals("grey2")) {
            bl = false;
            n = 2;
        } else if (string.equals("gray4") || string.equals("grey4")) {
            bl = false;
            n = 4;
        } else if (string.equals("gray8") || string.equals("grey8")) {
            bl = false;
            n = 8;
        } else if (string.equals("color") || string.equals("colour")) {
            bl = true;
            n = 8;
        }
        this.setImageIsColor(bl);
        this.setImageBitDepth(n);
    }

    public void setImageQuality(double d) {
        this.m_imageQuality = Math.max(0.0, Math.min(1.0, d));
    }

    public double getImageQuality() {
        return this.m_imageQuality;
    }

    public String getImageFilename() {
        return this.m_imageFilename;
    }

    public void setImageFilename(String string) {
        this.m_imageFilename = string;
    }

    public ExportGraphCommand() {
        this.m_frameParent = SplusSystem.getDefaultFrame();
    }

    public ExportGraphCommand(Frame frame) {
        this.m_frameParent = frame;
    }

    public ExportGraphCommand(Frame frame, CanvasTabbedPane canvasTabbedPane) {
        this.m_frameParent = frame;
        this.m_canvasPane = canvasTabbedPane;
    }

    public ExportGraphCommand(Frame frame, SCanvas sCanvas) {
        this.m_frameParent = frame;
        this.m_canvas = sCanvas;
    }

    public boolean doExecute() {
        JInternalFrame jInternalFrame;
        this.setImageType(sav_imageType);
        this.setImageSize(sav_imageWidth, sav_imageHeight);
        this.setImageBitDepth(sav_imageBitDepth);
        this.setImageIsColor(sav_imageIsColor);
        this.setImageQuality(sav_imageQuality);
        if (this.m_canvasPane == null && (jInternalFrame = ActiveDocument.get()) != null && jInternalFrame instanceof GraphWindow) {
            GraphWindow graphWindow = (GraphWindow)jInternalFrame;
            this.m_canvasPane = graphWindow.getCanvasTabbedPane();
        }
        if (this.m_canvas == null && this.m_canvasPane != null) {
            this.m_canvas = this.m_canvasPane.getCanvas();
        }
        if (this.m_canvas == null) {
            System.out.println("ExportGraphCommand: null canvas");
            return false;
        }
        if (this.showExportGraphDialog()) {
            sav_imageType = this.getImageType();
            sav_imageWidth = this.getImageSize().width;
            sav_imageHeight = this.getImageSize().height;
            sav_imageBitDepth = this.getImageBitDepth();
            sav_imageIsColor = this.getImageIsColor();
            sav_imageQuality = this.getImageQuality();
            boolean bl = this.confirmSaveAs(this.getImageFilename());
            if (!bl) {
                return true;
            }
            try {
                this.writeBitmapFile();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.out.flush();
                this.handleError("S-PLUS", exception.toString());
            }
        }
        return true;
    }

    protected boolean showExportGraphDialog() {
        ExportGraphDialog exportGraphDialog = new ExportGraphDialog(this, this.getParentFrame());
        exportGraphDialog.show();
        return exportGraphDialog.m_ok;
    }

    protected boolean confirmSaveAs(String string) {
        return FileUtilities.confirmSaveAs(this.getParentFrame(), string);
    }

    protected void handleError(String string, String string2) {
        JOptionPane.showMessageDialog(this.getParentFrame(), string2, string, 0);
    }

    public void writeBitmapFile() {
        if (this.getImageFilename() == null || this.getImageFilename().length() < 1) {
            return;
        }
        int n = this.getImageWidth();
        int n2 = this.getImageHeight();
        if (n <= 0 && n2 <= 0) {
            n = 576;
        }
        if (n2 <= 0) {
            n2 = Math.max(1, (int)((double)n / 1.33333));
        } else if (n <= 0) {
            n = Math.max(1, (int)((double)n2 * 1.33333));
        }
        if (this.getImageType() == 5) {
            if (this.m_canvasPane != null) {
                this.writeMultiCanvas(this.m_canvasPane.getAllCanvases());
            } else if (this.m_canvas != null) {
                Vector<SCanvas> vector = new Vector<SCanvas>();
                vector.addElement(this.m_canvas);
                this.writeMultiCanvas(vector);
            }
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (this.canEncodeType(this.m_imageType)) {
                fileOutputStream = System.getProperty("splus.client.mode", "").equals("true") ? SplusSystem.getServerFileHandler().getServerFileOutputStream(this.getImageFilename()) : new FileOutputStream(this.getImageFilename());
                if (this.canJAIEncode(this.m_imageType)) {
                    this.createJaiBitmapFile(fileOutputStream, n, n2);
                }
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGraphics2DWork(Graphics2D graphics2D, int n, int n2) {
        Dimension dimension = this.m_canvas.getBestFitSize(new Dimension(n, n2));
        int n3 = this.m_canvas.getWidth();
        int n4 = this.m_canvas.getHeight();
        try {
            graphics2D.setColor(this.m_canvas.getBackgroundColor());
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.translate((n - dimension.width) / 2, (n2 - dimension.height) / 2);
            this.m_canvas.setSize(dimension.width, dimension.height);
            this.m_canvas.paint(graphics2D);
            graphics2D.dispose();
        }
        finally {
            this.m_canvas.setSize(n3, n4);
        }
    }

    private void createJaiBitmapFile(OutputStream outputStream, int n, int n2) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        this.doGraphics2DWork(bufferedImage.createGraphics(), n, n2);
        BufferedImage bufferedImage2 = bufferedImage;
        RenderedOp renderedOp = JAI.create((String)"awtimage", (Object)bufferedImage2);
        if (this.getImageType() == 2 && !this.getImageIsColor()) {
            object = new ParameterBlock();
            ((ParameterBlock)object).addSource(renderedOp);
            double d = 1.0;
            switch (this.getImageBitDepth()) {
                case 1: {
                    d = 128.0;
                    break;
                }
                case 2: {
                    d = 64.0;
                    break;
                }
                case 4: {
                    d = 16.0;
                }
            }
            ((ParameterBlock)object).add(new double[][]{{0.333 / d, 0.333 / d, 0.333 / d, 0.0}});
            renderedOp = JAI.create((String)"bandcombine", (ParameterBlock)object, null);
        }
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            try {
                object = SplusSystem.getServerFileHandler().getServerFileOutputStream(this.getImageFilename());
                JAI.create((String)"encode", (RenderedImage)renderedOp, (Object)object, (Object)ExportGraphCommand.getImageTypeString(this.m_imageType), (Object)this.getImageEncoder());
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.out.flush();
            }
        } else {
            object = JAI.create((String)"filestore", (RenderedImage)renderedOp, (Object)this.getImageFilename(), (Object)ExportGraphCommand.getImageTypeString(this.m_imageType), (Object)this.getImageEncoder());
        }
    }

    public void loadProperties(Properties properties) {
        String string = properties.getProperty("file", "");
        String string2 = properties.getProperty("format", "jpeg");
        int n = -1;
        int n2 = -1;
        String string3 = "color";
        double d = 1.0;
        try {
            n = Integer.parseInt(properties.getProperty("width", "-1"));
            n2 = Integer.parseInt(properties.getProperty("height", "-1"));
            string3 = properties.getProperty("png.color", "color");
            d = Double.parseDouble(properties.getProperty("jpeg.quality", "1.0"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setImageType(ExportGraphCommand.parseTypeString(string2));
        this.setImageSize(n, n2);
        this.setImagePNGColor(string3);
        this.setImageQuality(d);
        this.setImageFilename(string);
    }

    public static void saveCanvasBitmap(SCanvas sCanvas, Properties properties) {
        try {
            ExportGraphCommand exportGraphCommand = new ExportGraphCommand(SplusSystem.getDefaultFrame(), sCanvas);
            exportGraphCommand.loadProperties(properties);
            exportGraphCommand.writeBitmapFile();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.flush();
        }
    }

    public static boolean multiCanvasSupported(Properties properties) {
        String string = properties.getProperty("format", "jpeg");
        return ExportGraphCommand.parseTypeString(string) == 5;
    }

    public static void saveMultiCanvas(Vector vector, Properties properties) {
        ExportGraphCommand exportGraphCommand = new ExportGraphCommand(SplusSystem.getDefaultFrame());
        exportGraphCommand.loadProperties(properties);
        exportGraphCommand.writeMultiCanvas(vector);
    }

    public void writeMultiCanvas(Vector vector) {
        if (this.getImageFilename() == null || this.getImageFilename().length() < 1) {
            return;
        }
        try {
            String string = this.getImageFilename();
            FileOutputStream fileOutputStream = null;
            fileOutputStream = System.getProperty("splus.client.mode", "").equals("true") ? SplusSystem.getServerFileHandler().getServerFileOutputStream(string) : new FileOutputStream(string);
            XML.writeCanvasVectorToFile(fileOutputStream, vector);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

