/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GeneralizedLinearModelDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusCheckBox longOutput;
    SplusCheckBox correlationMatrix;
    SplusCheckBox plotPartialResid;
    SplusCheckBox includeFitPartialResid;
    SplusCheckBox rugplotPartialResid;
    SplusCheckBox scalePartialResid;
    SplusComboBox familyType;
    SplusComboBox linkType;
    SplusComboBox varianceType;
    static final String[] familyOptionList = new String[]{"gaussian", "binomial", "poisson", "Gamma", "inverse.gaussian", "quasi"};
    static final String[] linkDefaultValue = new String[]{"identity", "logit", "log", "inverse", "1/mu^2", "identity"};
    static final String[][] linkOptionList = new String[][]{{"identity"}, {"logit", "probit", "cloglog"}, {"log", "sqrt", "identity"}, {"identity", "inverse", "log"}, {"1/mu^2"}, {"identity", "log", "sqrt", "logit", "probit", "cloglog", "inverse", "1/mu^2"}};

    public GeneralizedLinearModelDialog() {
        super("Generalized Linear Models");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuGlm");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Model");
        box4.add(splusGroupPanel2);
        this.familyType = new SplusComboBox("Family", 'I', familyOptionList);
        this.familyType.setValue("gaussian");
        this.familyType.setEditable(false);
        splusGroupPanel2.add(this.familyType);
        splusFunctionInfo.add(this.familyType, "family");
        this.linkType = new SplusComboBox("Link", 'L', new String[]{"log", "sqrt", "identity"});
        this.linkType.setValue("log");
        this.linkType.setEditable(false);
        splusGroupPanel2.add(this.linkType);
        splusFunctionInfo.add(this.linkType, "link");
        this.varianceType = new SplusComboBox("Variance Function", 'V', new String[]{"constant", "mu(1-mu)", "mu", "mu^2", "mu^3"});
        this.varianceType.setValue("constant");
        this.varianceType.setEditable(false);
        this.varianceType.setEnabled(false);
        splusGroupPanel2.add(this.varianceType);
        splusFunctionInfo.add(this.varianceType, "variance", true);
        this.familyType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = GeneralizedLinearModelDialog.this.familyType.getValue();
                int n = 0;
                for (int i = 0; i < familyOptionList.length; ++i) {
                    if (!string.equals(familyOptionList[i])) continue;
                    n = i;
                    break;
                }
                GeneralizedLinearModelDialog.this.linkType.setOptionList(linkOptionList[n]);
                GeneralizedLinearModelDialog.this.linkType.setValue(linkDefaultValue[n]);
                GeneralizedLinearModelDialog.this.varianceType.setEnabled(string.equals("quasi"));
            }
        });
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel3);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel3.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel4);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel4.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel4.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel4.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedLinearModelDialog.this.formulaField.setDependentValue(GeneralizedLinearModelDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GeneralizedLinearModelDialog.this.formulaField.setIndependentValue(GeneralizedLinearModelDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(GeneralizedLinearModelDialog.this.formulaField, GeneralizedLinearModelDialog.this.dataSet, 5).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        splusGroupPanel4.add(box5);
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Optimization Parameters");
        box6.add(splusGroupPanel5);
        SplusTextField splusTextField2 = new SplusTextField("Max Iterations", 'I');
        splusTextField2.setValue("50");
        splusGroupPanel5.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "maxit");
        SplusTextField splusTextField3 = new SplusTextField("Convergence Tolerance", 'T');
        splusTextField3.setValue("0.0001");
        splusGroupPanel5.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "epsilon");
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Print Iteration Trace", 'P');
        splusGroupPanel5.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "trace");
        box6.add(new SplusBoxFiller());
        box7.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box8);
        jPanel3.add(box9);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Printed Results");
        box8.add(splusGroupPanel6);
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel6.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.short.p");
        this.longOutput = new SplusCheckBox("Long Output", 'L');
        this.longOutput.setValue("T");
        splusGroupPanel6.add(this.longOutput);
        splusFunctionInfo.add(this.longOutput, "print.long.p");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("ANOVA Table", 'A');
        splusGroupPanel6.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "print.anova.p");
        this.correlationMatrix = new SplusCheckBox("Correlation Matrix of Estimates", 'C');
        splusGroupPanel6.add(this.correlationMatrix);
        splusFunctionInfo.add(this.correlationMatrix, "print.correlation.p");
        this.longOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralizedLinearModelDialog.this.correlationMatrix.setEnabled(GeneralizedLinearModelDialog.this.longOutput.getValue().equals("T"));
            }
        });
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Saved Results");
        box9.add(splusGroupPanel7);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel7.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel7.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "save.fit.p");
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Working Residuals", 'W');
        splusGroupPanel7.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.resid.working.p");
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Pearson Residuals", 'P');
        splusGroupPanel7.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "save.resid.pearson.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Deviance Residuals", 'D');
        splusGroupPanel7.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "save.resid.deviance.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Response Residuals", 'R');
        splusGroupPanel7.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "save.resid.response.p");
        box9.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box10);
        jPanel4.add(box11);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Plots");
        box10.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel8.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel8.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel8.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel8.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "plotQQ.p");
        this.plotPartialResid = new SplusCheckBox("Partial Residuals", 'P');
        splusGroupPanel8.add(this.plotPartialResid);
        splusFunctionInfo.add(this.plotPartialResid, "plotPartialResid.p");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Options");
        box11.add(splusGroupPanel9);
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Include Smooth", 'M');
        splusCheckBox14.setValue("T");
        splusGroupPanel9.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "smooths.p");
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Include Rugplot", 'G');
        splusGroupPanel9.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "rugplot.p");
        SplusTextField splusTextField4 = new SplusTextField("Number of Extreme Points to Identify:", 'X');
        splusTextField4.setValue("3");
        splusGroupPanel9.add(splusTextField4);
        splusFunctionInfo.add(splusTextField4, "id.n");
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Partial Residual Plot Options");
        box11.add(splusGroupPanel10);
        this.includeFitPartialResid = new SplusCheckBox("Include Partial Fit", 'F');
        this.includeFitPartialResid.setEnabled(false);
        splusGroupPanel10.add(this.includeFitPartialResid);
        splusFunctionInfo.add(this.includeFitPartialResid, "plotPartialFit.p");
        this.rugplotPartialResid = new SplusCheckBox("Include Rugplot", 'T');
        this.rugplotPartialResid.setEnabled(false);
        splusGroupPanel10.add(this.rugplotPartialResid);
        splusFunctionInfo.add(this.rugplotPartialResid, "rugplotPartialResid.p");
        this.scalePartialResid = new SplusCheckBox("Common Y-axis Scale");
        this.scalePartialResid.setValue("T");
        this.scalePartialResid.setEnabled(false);
        splusGroupPanel10.add(this.scalePartialResid);
        splusFunctionInfo.add(this.scalePartialResid, "scalePartialResid.p");
        this.plotPartialResid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GeneralizedLinearModelDialog.this.plotPartialResid.getValue().equals("T");
                GeneralizedLinearModelDialog.this.includeFitPartialResid.setEnabled(bl);
                GeneralizedLinearModelDialog.this.rugplotPartialResid.setEnabled(bl);
                GeneralizedLinearModelDialog.this.scalePartialResid.setEnabled(bl);
            }
        });
        box11.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box12 = new Box(1);
        Box box13 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box12);
        jPanel5.add(box13);
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("");
        box12.add(splusGroupPanel11);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("New Data", 'N');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel11.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "newdata");
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Save");
        box12.add(splusGroupPanel12);
        SplusDataSetComboBox splusDataSetComboBox3 = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox3.setValue("");
        splusGroupPanel12.add(splusDataSetComboBox3);
        splusFunctionInfo.add(splusDataSetComboBox3, "predobj.name", true);
        SplusCheckBox splusCheckBox16 = new SplusCheckBox("Predictions", 'P');
        splusGroupPanel12.add(splusCheckBox16);
        splusFunctionInfo.add(splusCheckBox16, "predict.p");
        SplusCheckBox splusCheckBox17 = new SplusCheckBox("Standard Errors", 'S');
        splusGroupPanel12.add(splusCheckBox17);
        splusFunctionInfo.add(splusCheckBox17, "se.p");
        box12.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel13 = new SplusGroupPanel("Options");
        box13.add(splusGroupPanel13);
        SplusComboBox splusComboBox = new SplusComboBox("Prediction Type", 'T', new String[]{"link", "response", "terms"});
        splusComboBox.setValue("link");
        splusComboBox.setEditable(false);
        splusGroupPanel13.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "predict.type", true);
        box13.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

