/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;

public class ResultSetUtilities {
    private static final ResultSetUtilities g_anInstance = new ResultSetUtilities();
    private static final Hashtable g_rsTable = new Hashtable();
    private static int g_defaultNumRows = 100;

    private ResultSetUtilities() {
    }

    public static void register(String string, ResultSet resultSet) {
        g_rsTable.put(string, resultSet);
    }

    public static void unregister(String string) {
        g_rsTable.remove(string);
    }

    public static void setDefaultNumberOfRows(int n) {
        g_defaultNumRows = n;
    }

    public static int getDefaultNumberOfRows() {
        return g_defaultNumRows;
    }

    public static Object[] getData(String string) throws SQLException {
        int n;
        int n2;
        int n3;
        ResultSet resultSet = (ResultSet)g_rsTable.get(string);
        if (resultSet == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        int[] nArray = new int[n4];
        Object[] objectArray = new Object[n4];
        int[] nArray2 = new int[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            stringArray[n3] = resultSetMetaData.getColumnName(n3 + 1);
            stringArray2[n3] = resultSetMetaData.getColumnTypeName(n3 + 1);
            nArray[n3] = resultSetMetaData.getColumnType(n3 + 1);
            switch (nArray[n3]) {
                case -5: 
                case 2: 
                case 3: 
                case 8: {
                    n5 = 8;
                    break;
                }
                case 6: 
                case 7: {
                    n5 = 6;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    n5 = 91;
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    n5 = 4;
                    break;
                }
                case -7: 
                case 16: {
                    n5 = -7;
                    break;
                }
                default: {
                    n5 = 1111;
                }
            }
            nArray2[n3] = n5;
        }
        n3 = g_defaultNumRows;
        if (resultSet.getType() != 1003) {
            resultSet.last();
            n3 = resultSet.getRow();
            resultSet.beforeFirst();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray[n2] = ResultSetUtilities.newArrayOfType(nArray2[n2], n3);
        }
        n2 = 0;
        String string2 = "";
        while (resultSet.next()) {
            if (n2 == n3) {
                n3 = 2 * n3;
                for (n = 0; n < n4; ++n) {
                    objectArray[n] = ResultSetUtilities.newArrayOfType(nArray2[n], n3, objectArray[n]);
                }
            }
            block18: for (n = 0; n < n4; ++n) {
                switch (nArray2[n]) {
                    case 8: {
                        ((double[])objectArray[n])[n2] = resultSet.getDouble(n + 1);
                        continue block18;
                    }
                    case 6: {
                        ((float[])objectArray[n])[n2] = resultSet.getFloat(n + 1);
                        continue block18;
                    }
                    case 91: {
                        Date date;
                        if (nArray[n] == 92) {
                            date = resultSet.getDate(n + 1);
                            if (date != null) {
                                ((double[])objectArray[n])[n2] = date.getTime();
                                continue block18;
                            }
                            ((double[])objectArray[n])[n2] = Double.NaN;
                            continue block18;
                        }
                        if (nArray[n] == 91) {
                            date = resultSet.getTimestamp(n + 1);
                            if (date != null) {
                                ((double[])objectArray[n])[n2] = (double)((Timestamp)date).getTime() + (double)(((Timestamp)date).getNanos() / 1000000);
                                continue block18;
                            }
                            ((double[])objectArray[n])[n2] = Double.NaN;
                            continue block18;
                        }
                        if (nArray[n] != 93) continue block18;
                        date = resultSet.getTimestamp(n + 1);
                        if (date != null) {
                            ((double[])objectArray[n])[n2] = (double)((Timestamp)date).getTime() + (double)(((Timestamp)date).getNanos() / 1000000);
                            continue block18;
                        }
                        ((double[])objectArray[n])[n2] = Double.NaN;
                        continue block18;
                    }
                    case 4: {
                        ((int[])objectArray[n])[n2] = resultSet.getInt(n + 1);
                        continue block18;
                    }
                    case -7: {
                        ((boolean[])objectArray[n])[n2] = resultSet.getBoolean(n + 1);
                        continue block18;
                    }
                    default: {
                        string2 = resultSet.getString(n + 1);
                        if (string2 == null) {
                            string2 = "";
                        }
                        ((String[])objectArray[n])[n2] = string2;
                    }
                }
            }
            ++n2;
        }
        for (n = 0; n < n4; ++n) {
            objectArray[n] = ResultSetUtilities.newArrayOfType(nArray2[n], n2, objectArray[n]);
        }
        Object[] objectArray2 = new Object[]{stringArray, stringArray2, nArray, objectArray};
        return objectArray2;
    }

    private static Object newArrayOfType(int n, int n2) {
        return ResultSetUtilities.newArrayOfType(n, n2, null);
    }

    private static Object newArrayOfType(int n, int n2, Object object) {
        Object[] objectArray = null;
        switch (n) {
            case 8: 
            case 91: {
                double[] dArray = new double[n2];
                if (object != null) {
                    double[] dArray2 = (double[])object;
                    for (int i = 0; i < Math.min(dArray2.length, n2); ++i) {
                        dArray[i] = dArray2[i];
                    }
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n2];
                if (object != null) {
                    float[] fArray2 = (float[])object;
                    for (int i = 0; i < Math.min(fArray2.length, n2); ++i) {
                        fArray[i] = fArray2[i];
                    }
                }
                objectArray = fArray;
                break;
            }
            case 4: {
                int[] nArray = new int[n2];
                if (object != null) {
                    int[] nArray2 = (int[])object;
                    for (int i = 0; i < Math.min(nArray2.length, n2); ++i) {
                        nArray[i] = nArray2[i];
                    }
                }
                objectArray = nArray;
                break;
            }
            case -7: {
                boolean[] blArray = new boolean[n2];
                if (object != null) {
                    boolean[] blArray2 = (boolean[])object;
                    for (int i = 0; i < Math.min(blArray2.length, n2); ++i) {
                        blArray[i] = blArray2[i];
                    }
                }
                objectArray = blArray;
                break;
            }
            default: {
                String[] stringArray = new String[n2];
                if (object != null) {
                    String[] stringArray2 = (String[])object;
                    for (int i = 0; i < Math.min(stringArray2.length, n2); ++i) {
                        stringArray[i] = stringArray2[i];
                    }
                }
                objectArray = stringArray;
            }
        }
        return objectArray;
    }
}

