/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchConfigurationWorkingCopy
extends LaunchConfiguration
implements ILaunchConfigurationWorkingCopy {
    private LaunchConfiguration fOriginal;
    private LaunchConfigurationWorkingCopy fParent = null;
    private LaunchConfigurationInfo fInfo;
    private boolean fDirty = false;
    private String fName;
    private boolean fRenamed = false;
    private boolean fSuppressChange = true;
    private IContainer fContainer;

    protected LaunchConfigurationWorkingCopy(LaunchConfiguration original) throws CoreException {
        super(original.getLocation());
        this.setName(original.getName());
        this.copyFrom(original);
        this.setOriginal(original);
        this.fSuppressChange = false;
    }

    protected LaunchConfigurationWorkingCopy(LaunchConfigurationWorkingCopy parent) throws CoreException {
        super(parent.getLocation());
        this.setName(parent.getName());
        this.copyFrom(parent);
        this.setOriginal((LaunchConfiguration)parent.getOriginal());
        this.fParent = parent;
        this.fSuppressChange = false;
    }

    protected LaunchConfigurationWorkingCopy(LaunchConfiguration original, String name) throws CoreException {
        super(original.getLocation());
        this.copyFrom(original);
        this.setName(name);
        this.fSuppressChange = false;
    }

    protected LaunchConfigurationWorkingCopy(IContainer container, String name, ILaunchConfigurationType type) {
        super((IPath)null);
        this.setName(name);
        this.setInfo(new LaunchConfigurationInfo());
        this.getInfo().setType(type);
        this.setContainer(container);
        this.fSuppressChange = false;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public synchronized ILaunchConfiguration doSave() throws CoreException {
        return this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized ILaunchConfiguration doSave(IProgressMonitor monitor) throws CoreException {
        if (this.getParent() != null) {
            LaunchConfigurationWorkingCopy wc = (LaunchConfigurationWorkingCopy)this.getParent();
            if (this.isMoved()) {
                wc.rename(this.getName());
                wc.setContainer(this.getContainer());
            }
            wc.setAttributes(this.getInfo().getAttributes());
            return wc;
        }
        boolean useRunnable = true;
        if (this.isLocal()) {
            useRunnable = this.isMoved() ? !this.isNew() && !this.getOriginal().isLocal() : false;
        }
        if (useRunnable) {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    LaunchConfigurationWorkingCopy.this.doSave0(pm);
                }
            };
            ResourcesPlugin.getWorkspace().run(wr, null, 0, monitor);
        } else {
            this.doSave0(monitor);
        }
        this.getLaunchManager().setMovedFromTo(null, null);
        return new LaunchConfiguration(this.getLocation());
    }

    private void doSave0(IProgressMonitor monitor) throws CoreException {
        boolean moved;
        boolean bl = moved = !this.isNew() && this.isMoved();
        if (moved) {
            LaunchConfiguration to = new LaunchConfiguration(this.getLocation());
            ILaunchConfiguration from = this.getOriginal();
            this.getLaunchManager().setMovedFromTo(from, to);
        }
        if (moved) {
            this.getOriginal().delete();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationWorkingCopy_0, (Object[])new String[]{this.getName()}), 2);
        this.writeNewFile(monitor);
        monitor.done();
        this.fDirty = false;
    }

    protected void writeNewFile(IProgressMonitor monitor) throws CoreException {
        String xml = null;
        Exception e = null;
        try {
            xml = this.getInfo().getAsXML();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (ParserConfigurationException pce) {
            e = pce;
        }
        catch (TransformerException te) {
            e = te;
        }
        if (e != null) {
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationWorkingCopy__0__occurred_generating_launch_configuration_XML__1, (Object[])new String[]{e.toString()}), null));
        }
        if (this.isLocal()) {
            try {
                boolean added = false;
                monitor.subTask(DebugCoreMessages.LaunchConfigurationWorkingCopy_1);
                File file = this.getLocation().toFile();
                File dir = this.getLocation().removeLastSegments(1).toFile();
                dir.mkdirs();
                if (!file.exists()) {
                    added = true;
                    file.createNewFile();
                    monitor.worked(1);
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(xml.getBytes("UTF8"));
                stream.close();
                if (added) {
                    this.getLaunchManager().launchConfigurationAdded(new LaunchConfiguration(this.getLocation()));
                } else {
                    this.getLaunchManager().launchConfigurationChanged(new LaunchConfiguration(this.getLocation()));
                }
                monitor.worked(1);
            }
            catch (IOException ie) {
                monitor.setCanceled(true);
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationWorkingCopy__0__occurred_generating_launch_configuration_XML__1, (Object[])new String[]{ie.toString()}), null));
            }
        }
        IFile file = this.getFile();
        if (file == null) {
            monitor.setCanceled(true);
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationWorkingCopy_5, null));
        }
        IContainer dir = file.getParent();
        if (!dir.exists()) {
            monitor.setCanceled(true);
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationWorkingCopy_Specified_container_for_launch_configuration_does_not_exist_2, null));
        }
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(xml.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ue) {
            monitor.setCanceled(true);
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationWorkingCopy_5, (Throwable)ue));
        }
        SubProgressMonitor spm = null;
        if (!file.exists()) {
            spm = new SubProgressMonitor(monitor, 1);
            spm.setTaskName(MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationWorkingCopy_2, (Object[])new String[]{this.getName()}));
            file.create((InputStream)stream, false, (IProgressMonitor)spm);
        } else {
            IStatus status;
            if (file.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                monitor.setCanceled(true);
                throw new CoreException(status);
            }
            spm = new SubProgressMonitor(monitor, 1);
            spm.setTaskName(MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationWorkingCopy_3, (Object[])new String[]{this.getName()}));
            file.setContents((InputStream)stream, true, false, (IProgressMonitor)spm);
        }
        if (monitor.isCanceled()) {
            return;
        }
    }

    public void setAttribute(String attributeName, int value) {
        this.getInfo().setAttribute(attributeName, new Integer(value));
        this.setDirty();
    }

    public void setAttribute(String attributeName, String value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, boolean value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, List value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, Map value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public ILaunchConfiguration getOriginal() {
        ILaunchConfiguration config = this.fOriginal;
        ILaunchConfigurationWorkingCopy parent = this.fParent;
        while (parent != null) {
            config = parent.getOriginal();
            parent = parent.getParent();
        }
        return config;
    }

    public ILaunchConfigurationWorkingCopy getParent() {
        return this.fParent;
    }

    private void copyFrom(LaunchConfiguration original) throws CoreException {
        LaunchConfigurationInfo info = original.getInfo();
        this.setInfo(info.getCopy());
        this.setContainer(original.getContainer());
        this.fDirty = false;
    }

    private void setOriginal(LaunchConfiguration original) {
        this.fOriginal = original;
    }

    protected void setInfo(LaunchConfigurationInfo info) {
        this.fInfo = info;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    protected LaunchConfigurationInfo getInfo() {
        return this.fInfo;
    }

    private void setDirty() {
        this.fDirty = true;
        if (!this.suppressChangeNotification()) {
            this.getLaunchManager().getConfigurationNotifier().notify(this, 2);
        }
    }

    public void setModes(Set modes) {
        this.getInfo().setAttribute(ATTR_LAUNCH_MODES, modes.size() > 0 ? modes : null);
        this.setDirty();
    }

    public void addModes(Set modes) {
        try {
            Set opts = this.getModes();
            if (opts.addAll(modes)) {
                this.getInfo().setAttribute(ATTR_LAUNCH_MODES, opts);
                this.setDirty();
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    public void removeModes(Set options) {
        try {
            Set opts = this.getModes();
            if (opts.removeAll(options)) {
                this.getInfo().setAttribute(ATTR_LAUNCH_MODES, opts.size() < 1 ? null : opts);
                this.setDirty();
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    public void rename(String name) {
        if (!this.getName().equals(name)) {
            this.setName(name);
            this.fRenamed = this.isNew() || !this.getOriginal().getName().equals(name);
        }
    }

    private void setName(String name) {
        this.fName = name;
        this.setDirty();
    }

    public String getName() {
        return this.fName;
    }

    public boolean isLocal() {
        return this.getContainer() == null;
    }

    public IPath getLocation() {
        if (this.isMoved()) {
            IPath path = null;
            path = this.isLocal() ? LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH : this.getContainer().getLocation();
            path = path.append(String.valueOf(this.getName()) + "." + "launch");
            return path;
        }
        return this.getOriginal().getLocation();
    }

    protected boolean isNew() {
        return this.getOriginal() == null;
    }

    protected boolean isMoved() {
        IContainer originalContainer;
        if (this.isNew() || this.fRenamed) {
            return true;
        }
        IContainer newContainer = this.getContainer();
        if (newContainer == (originalContainer = ((LaunchConfiguration)this.getOriginal()).getContainer())) {
            return false;
        }
        if (newContainer == null) {
            return !originalContainer.equals((Object)newContainer);
        }
        return !newContainer.equals((Object)originalContainer);
    }

    public String getMemento() {
        return null;
    }

    protected boolean suppressChangeNotification() {
        return this.fSuppressChange;
    }

    public void setContainer(IContainer container) {
        if (container == this.fContainer) {
            return;
        }
        if (container != null ? container.equals((Object)this.fContainer) : this.fContainer.equals((Object)container)) {
            return;
        }
        this.fContainer = container;
        this.setDirty();
    }

    protected IContainer getContainer() {
        return this.fContainer;
    }

    public void setAttributes(Map attributes) {
        this.getInfo().setAttributes(attributes);
        this.setDirty();
    }

    public void setMappedResources(IResource[] resources) {
        ArrayList<String> paths = null;
        ArrayList<String> types = null;
        if (resources != null && resources.length > 0) {
            paths = new ArrayList<String>(resources.length);
            types = new ArrayList<String>(resources.length);
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource != null) {
                    paths.add(resource.getFullPath().toPortableString());
                    types.add(new Integer(resource.getType()).toString());
                }
                ++i;
            }
        }
        this.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, paths);
        this.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, types);
    }

    public void setPreferredLaunchDelegate(Set modes, String delegateId) {
        if (modes != null) {
            try {
                Map delegates = this.getAttribute(LaunchConfiguration.ATTR_PREFERRED_LAUNCHERS, (Map)null);
                HashMap<String, String> map = new HashMap<String, String>();
                if (delegates != null) {
                    map.putAll(delegates);
                }
                if (delegateId == null) {
                    map.remove(modes.toString());
                } else {
                    map.put(modes.toString(), delegateId);
                }
                this.setAttribute(LaunchConfiguration.ATTR_PREFERRED_LAUNCHERS, map);
            }
            catch (CoreException ce) {
                DebugPlugin.log(ce);
            }
        }
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return new LaunchConfigurationWorkingCopy(this);
    }

    public Object removeAttribute(String attributeName) {
        return this.getInfo().removeAttribute(attributeName);
    }
}

