#! /bin/sh

# This relies on having a 'uname' command under DOS, which MKS sh does, I
# think (I found usage of that in $A/LOCALOS.cpp).
uname=`uname 2>/dev/null || echo idunno`

case "$uname" in
  DOS)
	SEP=";"
	ECHO="print -R"
  ;;
  UWIN-NT)
	SEP=";"
	ECHO="echo"
	;;
  *)
	SEP=":"
	ECHO="echo"
  ;;
esac

FRONTPATH=""
ENDPATH=""
WHERE=front
while [ $# -gt 0 ]
do
	case $1 in
	-e)	WHERE=end;;
	-f)	WHERE=front;;
	-*)	echo "Usage: $0 [[-f|-e] <dir> ... [-f|-e <dir> ... ]]" >&2;;
	*)	if [ "$1" = "." ] || echo $1 | grep '\./' >/dev/null
		then
			DIR=`cd $1; pwd`
		else
			DIR=$1
		fi
		if [ $WHERE = front ]
		then
			FRONTPATH="$FRONTPATH$DIR$SEP"
		else
			ENDPATH="$ENDPATH$SEP$DIR"
		fi;;
	esac
	shift
done
$ECHO "$FRONTPATH$PATH$ENDPATH"
exit 0
